/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.JdbcGridColumn;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.ColumnSynonym;
import com.intellij.database.util.ColumnWithDasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.SearchPath;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0001?B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015J$\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00152\u0006\u0010\"\u001a\u00020\u0013H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010\u00182\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0002J<\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180-2\u000e\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00152\f\u0010/\u001a\b\u0012\u0004\u0012\u00020!0\u0015H\u0002J(\u00100\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u00103\u001a\u00020\u0011H\u0002J$\u00104\u001a\u0002012\b\u00105\u001a\u0004\u0018\u00010\u00112\b\u00106\u001a\u0004\u0018\u00010\u00112\u0006\u00107\u001a\u000201H\u0002J \u00108\u001a\u0002012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u00109\u001a\u00020\u00052\b\b\u0001\u0010:\u001a\u00020\u0011H\u0002J\u0010\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u001fH\u0002J\u0014\u0010=\u001a\u00020\u00052\f\u0010>\u001a\b\u0012\u0004\u0012\u00020!0\u0015\u00a8\u0006@"}, d2={"Lcom/intellij/database/datagrid/GridTablesModelBuilder;", "", "<init>", "()V", "build", "Lcom/intellij/database/util/GridTablesModel;", "dbms", "Lcom/intellij/database/Dbms;", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "queryText", "", "resultType", "Lcom/intellij/sql/psi/SqlTableType;", "columns", "", "Lcom/intellij/database/datagrid/GridColumn;", "builtFakeTable", "Lcom/intellij/database/model/DasTable;", "ref", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "tableColumn", "Lcom/intellij/database/datagrid/JdbcGridColumn;", "buildForSingleTable", "table", "Lcom/intellij/database/model/DasObject;", "getDasTablesForColumns", "Lcom/intellij/database/util/ColumnWithDasTable;", "type", "resolveDasTable", "sqlExpression", "Lcom/intellij/sql/psi/SqlExpression;", "getColumnSynonym", "Lcom/intellij/database/util/ColumnSynonym;", "columnElement", "Lcom/intellij/sql/psi/SqlAsExpression;", "checkMetadata", "Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult;", "tables", "", "jdbcColumns", "columnsFromModel", "checkColumnMatches", "", "jdbcColumn", "columnName", "matches", "jdbcName", "modelName", "metadataMayReturnDifferentCase", "expressionHasSqlUnion", "notEditableGridTableModel", "reason", "gridTableModelForSingleTable", "dasObject", "gridTablesModelForTables", "columnsWithDasTable", "MetadataCheckResult", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nGridTablesModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridTablesModelBuilder.kt\ncom/intellij/database/datagrid/GridTablesModelBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,281:1\n1740#2,2:282\n1742#2:285\n1#3:284\n666#4:286\n747#4,4:287\n682#4:291\n712#4,4:292\n666#4:296\n747#4,4:297\n*S KotlinDebug\n*F\n+ 1 GridTablesModelBuilder.kt\ncom/intellij/database/datagrid/GridTablesModelBuilder\n*L\n194#1:282,2\n194#1:285\n268#1:286\n268#1:287,4\n272#1:291\n272#1:292,4\n276#1:296\n276#1:297,4\n*E\n"})
public final class GridTablesModelBuilder {
    @NotNull
    public final GridTablesModel build(@NotNull Dbms dbms, @NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable String queryText, @Nullable SqlTableType resultType, @NotNull List<? extends GridColumn> columns) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (!Registry.Companion.is("database.editor.smartMode", false)) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.smart.mode.off", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        if (queryText == null) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.query.is.empty", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        if (this.expressionHasSqlUnion(project, language, queryText)) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.query.has.union", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        SqlTableType type = DbSqlUtil.parseQueryTableType(project, language, dataSource, searchPath, queryText, null);
        if (type == null) {
            if (resultType != null) {
                type = resultType;
            } else {
                String string = DatabaseBundle.message((String)"grid.tables.model.builder.no.metadata.for.query", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return this.notEditableGridTableModel(string);
            }
        }
        List<ColumnWithDasTable> columnsWithDasTables = this.getDasTablesForColumns(type);
        HashSet<DasTable> tablesSet = new HashSet<DasTable>();
        if (columnsWithDasTables.isEmpty()) {
            PsiElement ref2 = type.getTypeElement();
            if (!(ref2 instanceof SqlReferenceExpression)) {
                String string = DatabaseBundle.message((String)"grid.tables.model.builder.no.metadata.for.column", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return this.notEditableGridTableModel(string);
            }
            GridColumn gridColumn = (GridColumn)CollectionsKt.firstOrNull(columns);
            if (gridColumn != null) {
                GridColumn column2 = gridColumn;
                boolean bl = false;
                if (column2 instanceof JdbcGridColumn) {
                    DasTable dasTable = this.builtFakeTable(dbms, (SqlReferenceExpression)ref2, (JdbcGridColumn)column2);
                    if (dasTable != null) {
                        object = dasTable;
                        DasTable fakeTable = object;
                        boolean bl2 = false;
                        tablesSet.add(fakeTable);
                    }
                }
            }
        }
        Map columnNameToDasTablesMap = new LinkedHashMap();
        for (ColumnWithDasTable columnWithDasTable : columnsWithDasTables) {
            Object object2 = columnWithDasTable.getColumnAlias();
            if ((object2 == null || (object2 = object2.getRealName()) == null) && (object2 = columnWithDasTable.getColumnName()) == null) continue;
            Object columnName = object2;
            DasTable dasTable = columnWithDasTable.getDasTable();
            if (dasTable == null) {
                String string = DatabaseBundle.message((String)"grid.tables.model.builder.has.column.without.table", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return this.notEditableGridTableModel(string);
            }
            if (columnNameToDasTablesMap.containsKey(columnName)) {
                Object v = columnNameToDasTablesMap.get(columnName);
                Intrinsics.checkNotNull(v);
                Set tablesWithSameName = (Set)v;
                if (tablesWithSameName.contains(dasTable)) {
                    Object[] objectArray = new Object[]{columnName, columnWithDasTable.getColumnName(), dasTable.getName()};
                    String string = DatabaseBundle.message((String)"grid.tables.model.builder.has.identical.columns", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return this.notEditableGridTableModel(string);
                }
                tablesWithSameName.add(dasTable);
            } else {
                object = columnNameToDasTablesMap;
                Object object3 = new DasTable[]{dasTable};
                object3 = SetsKt.mutableSetOf((Object[])object3);
                object.put(columnName, object3);
            }
            tablesSet.add(dasTable);
        }
        MetadataCheckResult metadataCheckResult = this.checkMetadata(dbms, (Set<? extends DasTable>)tablesSet, columns, columnsWithDasTables);
        if (metadataCheckResult instanceof MetadataCheckResult.Mismatch) {
            String string = DatabaseBundle.message((String)"grid.tables.model.builder.metadata.mismatch", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return this.notEditableGridTableModel(string);
        }
        if (metadataCheckResult instanceof MetadataCheckResult.CanFallback) {
            return this.gridTableModelForSingleTable((DasObject)CollectionsKt.first((Iterable)tablesSet));
        }
        if (metadataCheckResult instanceof MetadataCheckResult.Match) {
            if (!DatabaseSettings.getSettings().isEnableEditSqlJoins() && tablesSet.size() > 1) {
                String string = DatabaseBundle.message((String)"grid.tables.model.builder.switched.for.multiple.tables", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return this.notEditableGridTableModel(string);
            }
            return this.gridTablesModelForTables(columnsWithDasTables);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final DasTable builtFakeTable(Dbms dbms, SqlReferenceExpression ref2, JdbcGridColumn tableColumn) {
        String string = ref2.getReferencePart(ObjectKind.TABLE);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReferencePart(...)");
        String name2 = string;
        String string2 = ref2.getReferencePart(ObjectKind.SCHEMA);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getReferencePart(...)");
        String refSchema = string2;
        String string3 = ref2.getReferencePart(ObjectKind.DATABASE);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getReferencePart(...)");
        String refCatalog = string3;
        String schema = ((CharSequence)refSchema).length() == 0 && tableColumn != null && tableColumn.getSchema() != null ? tableColumn.getSchema() : refSchema;
        String catalog = ((CharSequence)refCatalog).length() == 0 && tableColumn != null && tableColumn.getCatalog() != null ? tableColumn.getCatalog() : refCatalog;
        return (DasTable)DbSqlUtil.sqlCreateFakeTable(dbms, catalog, schema, name2);
    }

    @NotNull
    public final GridTablesModel buildForSingleTable(@NotNull DasObject table) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return this.gridTableModelForSingleTable(table);
    }

    private final List<ColumnWithDasTable> getDasTablesForColumns(SqlTableType type) {
        int columnCount = type.getColumnCount();
        List columnDasTables = new ArrayList();
        for (int i = 0; i < columnCount; ++i) {
            PsiElement dasTable;
            PsiElement columnElement = type.getSourceColumnElement(i);
            DasTable table = null;
            String columnName = "";
            ColumnSynonym columnSynonym = null;
            PsiElement psiElement = columnElement;
            Object object = dasTable = psiElement != null ? psiElement.getParent() : null;
            if (columnElement != null && dasTable instanceof DasTable && columnElement instanceof DasColumn) {
                columnName = ((DasNamed)columnElement).getName();
                table = (DasTable)dasTable;
            } else if (columnElement instanceof SqlAsExpression) {
                table = this.resolveDasTable((SqlExpression)columnElement);
                columnName = ((SqlAsExpression)columnElement).getName();
                columnSynonym = this.getColumnSynonym((SqlAsExpression)columnElement);
            }
            columnDasTables.add(new ColumnWithDasTable(table, i, columnName, columnSynonym));
        }
        return columnDasTables;
    }

    private final DasTable resolveDasTable(SqlExpression sqlExpression) {
        if (sqlExpression == null) {
            return null;
        }
        if (sqlExpression instanceof SqlAsExpression) {
            SqlExpression expression;
            SqlExpression sqlExpression2 = expression = ((SqlAsExpression)sqlExpression).getExpression();
            return sqlExpression2 != null ? this.resolveDasTable(sqlExpression2) : null;
        }
        if (sqlExpression instanceof SqlReferenceExpression) {
            PsiElement resolved = ((SqlReferenceExpression)sqlExpression).resolve();
            if (resolved == null) {
                return null;
            }
            if (resolved instanceof DasTable) {
                return (DasTable)resolved;
            }
            PsiElement parent = resolved.getParent();
            if (parent instanceof DasTable) {
                return (DasTable)parent;
            }
        }
        return null;
    }

    private final ColumnSynonym getColumnSynonym(SqlAsExpression columnElement) {
        SqlExpression childExpression = columnElement.getExpression();
        if (childExpression instanceof SqlReferenceExpression) {
            PsiElement sqlIdentifier;
            SqlExpression sqlExpression = columnElement.getExpression();
            Object object = sqlIdentifier = sqlExpression != null ? sqlExpression.getLastChild() : null;
            if (columnElement.getExpression() != null && sqlIdentifier instanceof SqlIdentifier) {
                String string = columnElement.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String alias = string;
                String string2 = ((SqlIdentifier)sqlIdentifier).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String realName = string2;
                boolean isQuoted = ((SqlReferenceExpression)childExpression).isQuoted();
                return new ColumnSynonym(alias, realName, isQuoted);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final MetadataCheckResult checkMetadata(Dbms dbms, Set<? extends DasTable> tables, List<? extends GridColumn> jdbcColumns, List<ColumnWithDasTable> columnsFromModel) {
        MetadataCheckResult metadataCheckResult;
        boolean bl;
        boolean singleTableResultSet;
        block10: {
            boolean bl2;
            Iterable $this$all$iv;
            block12: {
                boolean bl3 = singleTableResultSet = tables.size() == 1;
                if (!singleTableResultSet && jdbcColumns.size() != columnsFromModel.size()) {
                    return MetadataCheckResult.Mismatch.INSTANCE;
                }
                $this$all$iv = jdbcColumns;
                boolean $i$f$all = false;
                if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block12;
                bl = true;
                break block10;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                block14: {
                    boolean bl4;
                    Object v2;
                    GridColumn jdbcColumn;
                    block11: {
                        Iterator iterator2;
                        block15: {
                            block13: {
                                if (!iterator.hasNext()) break block13;
                                Object element$iv = iterator.next();
                                jdbcColumn = (GridColumn)element$iv;
                                boolean bl5 = false;
                                if (jdbcColumn == null || !(jdbcColumn instanceof JdbcGridColumn)) break block14;
                                Iterable iterable = columnsFromModel;
                                iterator2 = iterable.iterator();
                                break block15;
                            }
                            bl = true;
                            break block10;
                        }
                        while (iterator2.hasNext()) {
                            Object t = iterator2.next();
                            ColumnWithDasTable it = (ColumnWithDasTable)t;
                            boolean bl6 = false;
                            if (!(it.getColumnNumber() == ((JdbcGridColumn)jdbcColumn).getColumnNumber())) continue;
                            v2 = t;
                            break block11;
                        }
                        v2 = null;
                    }
                    if ((ColumnWithDasTable)v2 != null) {
                        String columnName;
                        DasTable table;
                        ColumnWithDasTable columnWithDasTable;
                        boolean bl7 = false;
                        if (columnWithDasTable.getDasTable() == null) {
                            bl2 = false;
                            continue;
                        }
                        if (columnWithDasTable.getColumnName() == null) {
                            bl2 = false;
                            continue;
                        }
                        bl4 = this.checkColumnMatches(dbms, (JdbcGridColumn)jdbcColumn, table, columnName);
                    } else {
                        bl4 = false;
                    }
                    if (bl4) {
                        bl2 = true;
                        continue;
                    }
                }
                bl2 = false;
            } while (bl2);
            bl = false;
        }
        if (bl) {
            metadataCheckResult = MetadataCheckResult.Match.INSTANCE;
            return metadataCheckResult;
        }
        if (singleTableResultSet) {
            metadataCheckResult = MetadataCheckResult.CanFallback.INSTANCE;
            return metadataCheckResult;
        }
        metadataCheckResult = MetadataCheckResult.Mismatch.INSTANCE;
        return metadataCheckResult;
    }

    private final boolean checkColumnMatches(Dbms dbms, JdbcGridColumn jdbcColumn, DasTable table, String columnName) {
        boolean checkTableName = !dbms.is(Dbms.GREENPLUM) && !dbms.is(Dbms.SQLITE) && !dbms.is(Dbms.MEMSQL);
        boolean metadataMayReturnDifferentCase = dbms.in(Dbms.MYSQL_LIKE);
        String string = DasUtil.getSchema((DasObject)((DasObject)table));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSchema(...)");
        String schema = string;
        String string2 = DasUtil.getCatalog((DasObject)((DasObject)table));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCatalog(...)");
        String catalog = string2;
        return !(checkTableName && !Intrinsics.areEqual((Object)table.getKind(), (Object)ObjectKind.VIEW) && !this.matches(jdbcColumn.getName(), columnName, metadataMayReturnDifferentCase) || !this.matches(jdbcColumn.getTable(), table.getName(), metadataMayReturnDifferentCase) || !this.matches(jdbcColumn.getSchema(), schema, metadataMayReturnDifferentCase) || !(((CharSequence)catalog).length() == 0) && !this.matches(jdbcColumn.getCatalog(), catalog, metadataMayReturnDifferentCase));
    }

    private final boolean matches(String jdbcName, String modelName, boolean metadataMayReturnDifferentCase) {
        return StringUtil.isEmpty((String)jdbcName) || StringUtilRt.equal((CharSequence)modelName, (CharSequence)jdbcName, (!metadataMayReturnDifferentCase ? 1 : 0) != 0);
    }

    private final boolean expressionHasSqlUnion(Project project, Language language, String queryText) {
        Boolean bl = ((EvaluationHelper)EvaluationHelper.EP.forLanguage(language)).expressionHasSqlUnion(project, language, queryText, null);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"expressionHasSqlUnion(...)");
        return bl;
    }

    private final GridTablesModel notEditableGridTableModel(@NlsContexts.HintText String reason) {
        return new GridTablesModel(MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), false, true, reason);
    }

    private final GridTablesModel gridTableModelForSingleTable(DasObject dasObject) {
        return new GridTablesModel(MapsKt.emptyMap(), MapsKt.mapOf((Pair)TuplesKt.to((Object)dasObject.getName(), (Object)dasObject)), MapsKt.emptyMap(), true, false, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GridTablesModel gridTablesModelForTables(@NotNull List<ColumnWithDasTable> columnsWithDasTable) {
        Map map2;
        Sequence $this$associateByTo$iv$iv;
        Sequence $this$associateBy$iv;
        Map map3;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(columnsWithDasTable, (String)"columnsWithDasTable");
        Sequence $this$associate$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)columnsWithDasTable), GridTablesModelBuilder::gridTablesModelForTables$lambda$5);
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map3 = destination$iv$iv;
            ColumnWithDasTable it = (ColumnWithDasTable)element$iv$iv;
            boolean bl = false;
            Integer n = it.getColumnNumber();
            DasTable dasTable = it.getDasTable();
            Intrinsics.checkNotNull((Object)dasTable);
            it = TuplesKt.to((Object)n, (Object)dasTable);
            map3.put(it.getFirst(), it.getSecond());
        }
        $this$associate$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)columnsWithDasTable), GridTablesModelBuilder::gridTablesModelForTables$lambda$7);
        Map map4 = destination$iv$iv;
        boolean $i$f$associateBy = false;
        $this$associateTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            map3 = (DasTable)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            map2.put(string, element$iv$iv);
        }
        $this$associateBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)columnsWithDasTable), GridTablesModelBuilder::gridTablesModelForTables$lambda$9);
        map2 = destination$iv$iv;
        $i$f$associate = false;
        $this$associateByTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map3 = destination$iv$iv;
            ColumnWithDasTable it = (ColumnWithDasTable)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getColumnNumber(), (Object)it.getColumnAlias());
            map3.put(pair.getFirst(), pair.getSecond());
        }
        Map map5 = destination$iv$iv;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        Map map6 = map5;
        Map map7 = map2;
        Map map8 = map4;
        return new GridTablesModel(map8, map7, map6, bl2, bl, string);
    }

    private static final boolean gridTablesModelForTables$lambda$5(ColumnWithDasTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDasTable() != null;
    }

    private static final DasTable gridTablesModelForTables$lambda$7(ColumnWithDasTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDasTable();
    }

    private static final boolean gridTablesModelForTables$lambda$9(ColumnWithDasTable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getColumnAlias() != null;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult;", "", "Match", "CanFallback", "Mismatch", "Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult$CanFallback;", "Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult$Match;", "Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult$Mismatch;", "intellij.database.connectivity"})
    public static interface MetadataCheckResult {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult$CanFallback;", "Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult;", "<init>", "()V", "intellij.database.connectivity"})
        public static final class CanFallback
        implements MetadataCheckResult {
            @NotNull
            public static final CanFallback INSTANCE = new CanFallback();

            private CanFallback() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult$Match;", "Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult;", "<init>", "()V", "intellij.database.connectivity"})
        public static final class Match
        implements MetadataCheckResult {
            @NotNull
            public static final Match INSTANCE = new Match();

            private Match() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult$Mismatch;", "Lcom/intellij/database/datagrid/GridTablesModelBuilder$MetadataCheckResult;", "<init>", "()V", "intellij.database.connectivity"})
        public static final class Mismatch
        implements MetadataCheckResult {
            @NotNull
            public static final Mismatch INSTANCE = new Mismatch();

            private Mismatch() {
            }
        }
    }
}

