/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 110493423201375L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1094565570 - -23270, -1094565570 - -28540, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1094565570 - -23271, -1094565570 - -((char)-20007), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 97884928844084L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.w();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1670749290 + (char)-19229, 1670749290 + 26511, (int)l2) + string + WindowsNamedPipeAgentIpc.b(1670749290 + (char)-19230, 1670749290 + (char)-28898, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1670749290 + (char)-19231, -1670749290 + -((char)-14136), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 58523846727572L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.r();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-622320360 + -32046, -622320360 + -11041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-622320360 + -32047, 622320360 + 15993, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-622320360 + -32048, -622320360 + -14914, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-622320360 + -32049, -622320360 + -10877, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-622320360 + -32050, 622320360 + 24892, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-622320360 + -32051, -622320360 + -10393, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-622320360 + -32049, -622320360 + -10877, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-622320360 + -32052, 622320360 + (char)-32187, (int)l2));
            if (ActionTimestamp.r() == null) {
                SshAgentIpcService.r(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 66221419955370L;
                    n3 = SshAgentIpcService.r();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 55625722240165L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                n2 = SshAgentIpcService.r();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 != 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1600757910 + -29336, -1600757910 + -26533, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1600757910 + -29332, -1600757910 + -((char)-21056), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1600757910 + -29335, -1600757910 + -((char)-30918), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1600757910 + -29332, -1600757910 + -((char)-21056), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1600757910 + -29338, 1600757910 + (char)-14674, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1600757910 + -29336, -1600757910 + -26533, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1600757910 + -29332, -1600757910 + -((char)-21056), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1600757910 + -29337, 1600757910 + (char)-16985, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 != 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n3 = Kernel32.INSTANCE.GetLastError();
                if (n3 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1600757910 + -29336, -1600757910 + -26533, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1600757910 + -29332, -1600757910 + -((char)-21056), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1600757910 + -29340, 1600757910 + 27993, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1600757910 + -29332, -1600757910 + -((char)-21056), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1600757910 + -29339, -1600757910 + -((char)-13698), (int)l2) + ErrorToolsKt.prettyHRESULT(n3)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 != 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1600757910 + -29332, -1600757910 + -((char)-21056), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1600757910 + -29338, 1600757910 + (char)-14674, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1600757910 + -29336, -1600757910 + -26533, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1600757910 + -29332, -1600757910 + -((char)-21056), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1600757910 + -29342, -1600757910 + -((char)-15516), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 108940159186309L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1686346620 - (char)-3899, -1686346620 - -((char)-23913), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 40825982914051L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1976142390 + (char)-14598, -1976142390 + -((char)-8167), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00a5\u00ca1\u00af\u0088%\u0080|\u009eP\u00ee\u00cc@z\u00bf\u00a7\u00a5G/\u0014\u009c.\u00165w\u00b4\u0002\u00cbL\u00a0q\u0006q\u00daX8\u00b4r\nL";
                        var4_3 = "\u00a5\u00ca1\u00af\u0088%\u0080|\u009eP\u00ee\u00cc@z\u00bf\u00a7\u00a5G/\u0014\u009c.\u00165w\u00b4\u0002\u00cbL\u00a0q\u0006q\u00daX8\u00b4r\nL".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 110;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 108;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 125;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 88;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 85;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 104;
                                        break;
                                    }
                                    default: {
                                        v11 = 78;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFDF32) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 96;
                            case 1 -> 183;
                            case 2 -> 180;
                            case 3 -> 22;
                            case 4 -> 118;
                            case 5 -> 39;
                            case 6 -> 35;
                            case 7 -> 249;
                            case 8 -> 12;
                            case 9 -> 132;
                            case 10 -> 157;
                            case 11 -> 127;
                            case 12 -> 227;
                            case 13 -> 138;
                            case 14 -> 32;
                            case 15 -> 243;
                            case 16 -> 19;
                            case 17 -> 229;
                            case 18 -> 4;
                            case 19 -> 214;
                            case 20 -> 225;
                            case 21 -> 56;
                            case 22 -> 71;
                            case 23 -> 152;
                            case 24 -> 101;
                            case 25 -> 146;
                            case 26 -> 34;
                            case 27 -> 161;
                            case 28 -> 105;
                            case 29 -> 195;
                            case 30 -> 70;
                            case 31 -> 18;
                            case 32 -> 29;
                            case 33 -> 83;
                            case 34 -> 21;
                            case 35 -> 27;
                            case 36 -> 75;
                            case 37 -> 135;
                            case 38 -> 141;
                            case 39 -> 137;
                            case 40 -> 228;
                            case 41 -> 139;
                            case 42 -> 244;
                            case 43 -> 7;
                            case 44 -> 213;
                            case 45 -> 129;
                            case 46 -> 66;
                            case 47 -> 136;
                            case 48 -> 46;
                            case 49 -> 255;
                            case 50 -> 143;
                            case 51 -> 115;
                            case 52 -> 44;
                            case 53 -> 182;
                            case 54 -> 208;
                            case 55 -> 179;
                            case 56 -> 126;
                            case 57 -> 204;
                            case 58 -> 174;
                            case 59 -> 122;
                            case 60 -> 201;
                            case 61 -> 91;
                            case 62 -> 92;
                            case 63 -> 73;
                            case 64 -> 50;
                            case 65 -> 239;
                            case 66 -> 84;
                            case 67 -> 88;
                            case 68 -> 215;
                            case 69 -> 89;
                            case 70 -> 217;
                            case 71 -> 238;
                            case 72 -> 16;
                            case 73 -> 90;
                            case 74 -> 151;
                            case 75 -> 26;
                            case 76 -> 205;
                            case 77 -> 42;
                            case 78 -> 206;
                            case 79 -> 192;
                            case 80 -> 60;
                            case 81 -> 186;
                            case 82 -> 242;
                            case 83 -> 191;
                            case 84 -> 41;
                            case 85 -> 253;
                            case 86 -> 103;
                            case 87 -> 216;
                            case 88 -> 72;
                            case 89 -> 109;
                            case 90 -> 77;
                            case 91 -> 8;
                            case 92 -> 245;
                            case 93 -> 198;
                            case 94 -> 164;
                            case 95 -> 3;
                            case 96 -> 78;
                            case 97 -> 76;
                            case 98 -> 36;
                            case 99 -> 171;
                            case 100 -> 121;
                            case 101 -> 252;
                            case 102 -> 170;
                            case 103 -> 230;
                            case 104 -> 81;
                            case 105 -> 64;
                            case 106 -> 45;
                            case 107 -> 130;
                            case 108 -> 52;
                            case 109 -> 181;
                            case 110 -> 148;
                            case 111 -> 95;
                            case 112 -> 106;
                            case 113 -> 85;
                            case 114 -> 128;
                            case 115 -> 13;
                            case 116 -> 49;
                            case 117 -> 202;
                            case 118 -> 9;
                            case 119 -> 160;
                            case 120 -> 190;
                            case 121 -> 110;
                            case 122 -> 98;
                            case 123 -> 162;
                            case 124 -> 28;
                            case 125 -> 112;
                            case 126 -> 231;
                            case 127 -> 145;
                            case 128 -> 68;
                            case 129 -> 107;
                            case 130 -> 6;
                            case 131 -> 237;
                            case 132 -> 251;
                            case 133 -> 10;
                            case 134 -> 187;
                            case 135 -> 134;
                            case 136 -> 30;
                            case 137 -> 236;
                            case 138 -> 158;
                            case 139 -> 113;
                            case 140 -> 25;
                            case 141 -> 147;
                            case 142 -> 210;
                            case 143 -> 199;
                            case 144 -> 223;
                            case 145 -> 17;
                            case 146 -> 124;
                            case 147 -> 142;
                            case 148 -> 55;
                            case 149 -> 173;
                            case 150 -> 235;
                            case 151 -> 188;
                            case 152 -> 48;
                            case 153 -> 57;
                            case 154 -> 120;
                            case 155 -> 240;
                            case 156 -> 100;
                            case 157 -> 133;
                            case 158 -> 82;
                            case 159 -> 43;
                            case 160 -> 15;
                            case 161 -> 79;
                            case 162 -> 185;
                            case 163 -> 150;
                            case 164 -> 131;
                            case 165 -> 5;
                            case 166 -> 108;
                            case 167 -> 178;
                            case 168 -> 219;
                            case 169 -> 184;
                            case 170 -> 218;
                            case 171 -> 169;
                            case 172 -> 212;
                            case 173 -> 153;
                            case 174 -> 40;
                            case 175 -> 117;
                            case 176 -> 155;
                            case 177 -> 167;
                            case 178 -> 211;
                            case 179 -> 0;
                            case 180 -> 14;
                            case 181 -> 11;
                            case 182 -> 80;
                            case 183 -> 197;
                            case 184 -> 149;
                            case 185 -> 24;
                            case 186 -> 226;
                            case 187 -> 51;
                            case 188 -> 33;
                            case 189 -> 111;
                            case 190 -> 254;
                            case 191 -> 65;
                            case 192 -> 20;
                            case 193 -> 156;
                            case 194 -> 54;
                            case 195 -> 47;
                            case 196 -> 232;
                            case 197 -> 87;
                            case 198 -> 193;
                            case 199 -> 177;
                            case 200 -> 62;
                            case 201 -> 23;
                            case 202 -> 38;
                            case 203 -> 203;
                            case 204 -> 241;
                            case 205 -> 144;
                            case 206 -> 86;
                            case 207 -> 104;
                            case 208 -> 63;
                            case 209 -> 53;
                            case 210 -> 59;
                            case 211 -> 220;
                            case 212 -> 74;
                            case 213 -> 123;
                            case 214 -> 172;
                            case 215 -> 93;
                            case 216 -> 209;
                            case 217 -> 200;
                            case 218 -> 99;
                            case 219 -> 114;
                            case 220 -> 222;
                            case 221 -> 234;
                            case 222 -> 233;
                            case 223 -> 31;
                            case 224 -> 159;
                            case 225 -> 140;
                            case 226 -> 250;
                            case 227 -> 175;
                            case 228 -> 69;
                            case 229 -> 248;
                            case 230 -> 196;
                            case 231 -> 67;
                            case 232 -> 166;
                            case 233 -> 224;
                            case 234 -> 207;
                            case 235 -> 94;
                            case 236 -> 2;
                            case 237 -> 221;
                            case 238 -> 168;
                            case 239 -> 247;
                            case 240 -> 116;
                            case 241 -> 97;
                            case 242 -> 125;
                            case 243 -> 154;
                            case 244 -> 58;
                            case 245 -> 1;
                            case 246 -> 102;
                            case 247 -> 176;
                            case 248 -> 37;
                            case 249 -> 165;
                            case 250 -> 163;
                            case 251 -> 189;
                            case 252 -> 61;
                            case 253 -> 194;
                            case 254 -> 119;
                            default -> 246;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 != 0) {
                ActionTimestamp.r(new ActionTimestamp[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 56394349793077L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.r();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1429187280 + -5614, -1429187280 + -12507, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1429187280 + -5610, -1429187280 - -3338, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1429187280 + -5587, -1429187280 + -15019, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1429187280 + -5614, -1429187280 + -12507, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1429187280 + -5610, -1429187280 - -3338, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1429187280 + -5590, 1429187280 - 2120, (int)l3) + ErrorToolsKt.prettyHRESULT(n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 30828704761407L;
                        int n3 = SshAgentIpcService.r();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(570547710 - (char)-6227, -570416640 + -((char)-13583), (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 != 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 != 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(570547710 - (char)-6228, -570416640 + -((char)-23034), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 != 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 107229635894044L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = SshAgentIpcService.r();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482401700 - -21263, -1482401700 - -22560, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1482401700 - -21267, -1482401700 - -((char)-25161), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482401700 - -21268, 1482401700 - 24403, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1482401700 - -21267, -1482401700 - -((char)-25161), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482401700 - -21261, 1482401700 - (char)-31065, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482401700 - -21263, -1482401700 - -22560, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1482401700 - -21267, -1482401700 - -((char)-25161), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482401700 - -21283, 1482401700 - 19672, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482401700 - -21263, -1482401700 - -22560, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1482401700 - -21267, -1482401700 - -((char)-25161), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482401700 - -21282, -1482401700 - -((char)-30057), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1482401700 - -21263, -1482401700 - -22560, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1482401700 - -21267, -1482401700 - -((char)-25161), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1482401700 - -21281, 1482401700 - (char)-32254, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 29185765637719L;
                    Object object = this.lock;
                    n3 = SshAgentIpcService.w();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1462872270 - -14062, -1462872270 - -15877, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1462872270 - -14066, -1462872270 - -31782, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1462872270 - -14085, -1462872270 - -11633, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1462872270 - -14078, -1462872270 - -((char)-28425), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1462872270 - -14062, -1462872270 - -15877, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1462872270 - -14066, -1462872270 - -31782, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1462872270 - -14079, 1462872270 - (char)-28045, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1462872270 - -14062, -1462872270 - -15877, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1462872270 - -14066, -1462872270 - -31782, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1462872270 - -14080, -1462872270 - -((char)-29321), (int)l2) + ErrorToolsKt.prettyHRESULT(n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1462872270 - -14062, -1462872270 - -15877, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1462872270 - -14066, -1462872270 - -31782, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1462872270 - -14081, -1462872270 - -15881, (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1462872270 - -14062, -1462872270 - -15877, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1462872270 - -14066, -1462872270 - -31782, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1462872270 - -14042, -1462872270 - -26243, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1462872270 - -14043, 1462872270 - 14103, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00f4\u00be!\u00c7\u00a9\u00ee\u00b0\u00e7\u0014\u00c0*\u009f\u00b2\u0080\u00c8:9\u00d3cD\u00e2\u00fd~:d\u0003m\u00ff\u0093\u0006u\u001f\u0011\u00f3\u00c5)\u0018\u00ea\u00cb\u00ba\u00be\u00a6\u008c\u00fcq\u00c3\u0017I\u001c:^\u0090\u00e2\u00ff\u00d4N9\u00dfRu\u000f\t\u00bc\u00b5\u00ee\u00c0G\u00dc\u00d83{\u0005r\u0098\u00f1\u0003\u00c3\b\u008b\u008e\u00ce\u00b0\u0006&C\u001c\u0014\u00f5\u00ffA\u00936\u00e4\u00d9+\u00c1\u00fc\u00ad\u00a5\u008a5o\u00e0\u00bb.\u0011\u00b9\u0005l\u00df2\u00eb\u00bb\u001eqj\u00849\u00f0\u00b8\u0094\u008dk\u009c\u0017\u00ea\u00bd\u00a0\u00c2YT2\u00e9\u0011\u0087xr\u0087'\u00db\u00c5\u0083\u00e9\u00df\u0010\u009b\u009d=\u0002\u0090\u00edn\u00deID\u00de\f\u0082)\u008a\u00f7\t\u0006\toF$+\u0092R\u00dc\u0010\u0085t\u00fe?\u00e8Ja*\u00a8\u00da\u00e2\u00df\u0005Sz\u00b8?)\u0006\u0087\u00b4\u009d\u0000\u00bc\u00f6\u001f\"\u00dc\u00c6{\u00d3'\u000e-\u00bd\u00bb%C\u00ac\u0091{K\u00acE\u00d9\u00ce\u00c2\u00ef?\u00fc\u0006|\u00bf\r\u00ad\u00e35M\u00a6|\u0081_\"\u0084-\u0099!d\u00bb\u00d7\u00ab\u00f9\u008e\u00faY\u00bef\u00faZ3\bA\u00b9\u0097V-\u00fa&\u0087\f\u00ec\u00dc2\u00e1\u0084n\u00fd\u0012\u0012\u0095\u00e72F\u008e\u0017~\u0098\rA\u00cc\u00f74%)\u00e0S\u001f=\u00b1\u0092-L\u0098\u00afI\u000f\u00f5\u00aeV\n\u008d\u0098a\u001fw\u00de\u00b9\u00fai\u0007:\t\u0003\u0083u.\u0000\u00cb\u0097B\u00e6\u00a6\u00a0\u00e5!\bn\u0014-\u00d8Yl\u00da\u0093\u00a4Bap9\u00a6\u0005@*\u001f\u00ce\u00afs\u0081\u000e\u00afKo\u0090\u00c0haR\u00cc4e\u00f1] 6u\u001c\u00fb\u00a0w\u00ef\u00d8\u00c9Wg\u00e4\u000bm\u0010\u0002x\u0082]=t\nU\u00ee\u0015q\u00f4\u0081\u00e7\u00f5\u00c6?ztt\u00e9<\u00dc\u00cb\u00f8\u00d3\u0093\u001f\u00b1\u0007q) \u008e\u00ae\u00a5\u00b5+<\u00ff~\u00d2\u00b5#\u00ed\u008e](\u0083|\u00b5\u00b57\u0014u\u00b9\u00c9\u0085\u00d8\u00fcx5\u0083\u00c3\u00b3\u008a1\u0082`Zn\u00a6\u00cc\u0007\u00e8\u00cf\u00bd\u0097\u00f30o\u0007\u00f6j\u001aO\u00e0\u00c4\u001b(\"\u00e5\u00a2\u00e9\u0084\u00c8\u00ec\u00a4\u0014n\u00d2\u0082\";\u00e6\u001d\u00f3w\u0015\u0097Bn\u00b4=a\u00a9{\u0002;\u008a0-><\u001e\u00f9?H\u0016\u0017\u000f\u001f\u0012K>Q^\u00f3\u00b5\u0082\u00c1\u00a1&\u00ec\u00fb\u00a1\"\u00c5\u00c5\u0012\u00cc\"\u0006\u00ceZ f~\u00b5\u0097Pv=\r\u00f7\u00ee\u0086\u00b6r\u00e5%HB%\u00da\u00e3\u00c3R\u001a\u00a7B\u000e\u00d3\u00cd\u00d2\u00c5b!\u0095ZN<8\u0099\u00d3\u0006\u001b\u00e6\u00bes\u00ae\u00ad\u00f9\u00f9\u001d\u0094S\u00eeuY\u00ad\u0089\u0094Zh\u00b9\u00e9g\u00ab\u00ac\u00b8*\u009c<\nG'\u0083\u009a\u00a7\u009bk{m\u00fd\u0018e\u0097\u0003\u0086\u00a2@9t\u0092\u00b7\u00ecv\u00a0\u009eJ\u00d3U\u0081\u008f\u00ad\u00d9h \u0093)\u00d7%P\u00d0j\u0085\u00c7*\u0001hZt\u0014m\u00fd/\u00e9\u00e9'\u00c2_\u00ea1j4m\u00fa\roW\u00da\u001e\u00bd\u00ef%\u00ba<y\u00e5\u00c2\u00bd\t\u00b7hYt\u00e8\u00a2]8\u0098";
                var4_3 = "\u00f4\u00be!\u00c7\u00a9\u00ee\u00b0\u00e7\u0014\u00c0*\u009f\u00b2\u0080\u00c8:9\u00d3cD\u00e2\u00fd~:d\u0003m\u00ff\u0093\u0006u\u001f\u0011\u00f3\u00c5)\u0018\u00ea\u00cb\u00ba\u00be\u00a6\u008c\u00fcq\u00c3\u0017I\u001c:^\u0090\u00e2\u00ff\u00d4N9\u00dfRu\u000f\t\u00bc\u00b5\u00ee\u00c0G\u00dc\u00d83{\u0005r\u0098\u00f1\u0003\u00c3\b\u008b\u008e\u00ce\u00b0\u0006&C\u001c\u0014\u00f5\u00ffA\u00936\u00e4\u00d9+\u00c1\u00fc\u00ad\u00a5\u008a5o\u00e0\u00bb.\u0011\u00b9\u0005l\u00df2\u00eb\u00bb\u001eqj\u00849\u00f0\u00b8\u0094\u008dk\u009c\u0017\u00ea\u00bd\u00a0\u00c2YT2\u00e9\u0011\u0087xr\u0087'\u00db\u00c5\u0083\u00e9\u00df\u0010\u009b\u009d=\u0002\u0090\u00edn\u00deID\u00de\f\u0082)\u008a\u00f7\t\u0006\toF$+\u0092R\u00dc\u0010\u0085t\u00fe?\u00e8Ja*\u00a8\u00da\u00e2\u00df\u0005Sz\u00b8?)\u0006\u0087\u00b4\u009d\u0000\u00bc\u00f6\u001f\"\u00dc\u00c6{\u00d3'\u000e-\u00bd\u00bb%C\u00ac\u0091{K\u00acE\u00d9\u00ce\u00c2\u00ef?\u00fc\u0006|\u00bf\r\u00ad\u00e35M\u00a6|\u0081_\"\u0084-\u0099!d\u00bb\u00d7\u00ab\u00f9\u008e\u00faY\u00bef\u00faZ3\bA\u00b9\u0097V-\u00fa&\u0087\f\u00ec\u00dc2\u00e1\u0084n\u00fd\u0012\u0012\u0095\u00e72F\u008e\u0017~\u0098\rA\u00cc\u00f74%)\u00e0S\u001f=\u00b1\u0092-L\u0098\u00afI\u000f\u00f5\u00aeV\n\u008d\u0098a\u001fw\u00de\u00b9\u00fai\u0007:\t\u0003\u0083u.\u0000\u00cb\u0097B\u00e6\u00a6\u00a0\u00e5!\bn\u0014-\u00d8Yl\u00da\u0093\u00a4Bap9\u00a6\u0005@*\u001f\u00ce\u00afs\u0081\u000e\u00afKo\u0090\u00c0haR\u00cc4e\u00f1] 6u\u001c\u00fb\u00a0w\u00ef\u00d8\u00c9Wg\u00e4\u000bm\u0010\u0002x\u0082]=t\nU\u00ee\u0015q\u00f4\u0081\u00e7\u00f5\u00c6?ztt\u00e9<\u00dc\u00cb\u00f8\u00d3\u0093\u001f\u00b1\u0007q) \u008e\u00ae\u00a5\u00b5+<\u00ff~\u00d2\u00b5#\u00ed\u008e](\u0083|\u00b5\u00b57\u0014u\u00b9\u00c9\u0085\u00d8\u00fcx5\u0083\u00c3\u00b3\u008a1\u0082`Zn\u00a6\u00cc\u0007\u00e8\u00cf\u00bd\u0097\u00f30o\u0007\u00f6j\u001aO\u00e0\u00c4\u001b(\"\u00e5\u00a2\u00e9\u0084\u00c8\u00ec\u00a4\u0014n\u00d2\u0082\";\u00e6\u001d\u00f3w\u0015\u0097Bn\u00b4=a\u00a9{\u0002;\u008a0-><\u001e\u00f9?H\u0016\u0017\u000f\u001f\u0012K>Q^\u00f3\u00b5\u0082\u00c1\u00a1&\u00ec\u00fb\u00a1\"\u00c5\u00c5\u0012\u00cc\"\u0006\u00ceZ f~\u00b5\u0097Pv=\r\u00f7\u00ee\u0086\u00b6r\u00e5%HB%\u00da\u00e3\u00c3R\u001a\u00a7B\u000e\u00d3\u00cd\u00d2\u00c5b!\u0095ZN<8\u0099\u00d3\u0006\u001b\u00e6\u00bes\u00ae\u00ad\u00f9\u00f9\u001d\u0094S\u00eeuY\u00ad\u0089\u0094Zh\u00b9\u00e9g\u00ab\u00ac\u00b8*\u009c<\nG'\u0083\u009a\u00a7\u009bk{m\u00fd\u0018e\u0097\u0003\u0086\u00a2@9t\u0092\u00b7\u00ecv\u00a0\u009eJ\u00d3U\u0081\u008f\u00ad\u00d9h \u0093)\u00d7%P\u00d0j\u0085\u00c7*\u0001hZt\u0014m\u00fd/\u00e9\u00e9'\u00c2_\u00ea1j4m\u00fa\roW\u00da\u001e\u00bd\u00ef%\u00ba<y\u00e5\u00c2\u00bd\t\u00b7hYt\u00e8\u00a2]8\u0098".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 13;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00dcc\u00fd\u00d4\u0013\u00c9$o\u00b1\f\u00804\u0083\u00a9\u00c3{\u00e2\u00a3\u00da\u00c3y9\u00ca\u0002,\u00b0\u00a4?\u00f8\u0014\u00a3\u00b3?MX\u00fb\u00ed\u0093\u00e5\u00faN\u001dpMG\u00ce`\u00f4_l";
                    var4_3 = "\u00dcc\u00fd\u00d4\u0013\u00c9$o\u00b1\f\u00804\u0083\u00a9\u00c3{\u00e2\u00a3\u00da\u00c3y9\u00ca\u0002,\u00b0\u00a4?\u00f8\u0014\u00a3\u00b3?MX\u00fb\u00ed\u0093\u00e5\u00faN\u001dpMG\u00ce`\u00f4_l".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 73;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 57;
                            break;
                        }
                        case 1: {
                            v15 = 125;
                            break;
                        }
                        case 2: {
                            v15 = 58;
                            break;
                        }
                        case 3: {
                            v15 = 50;
                            break;
                        }
                        case 4: {
                            v15 = 72;
                            break;
                        }
                        case 5: {
                            v15 = 84;
                            break;
                        }
                        default: {
                            v15 = 14;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFF07B) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 239;
                case 1 -> 184;
                case 2 -> 142;
                case 3 -> 198;
                case 4 -> 3;
                case 5 -> 51;
                case 6 -> 160;
                case 7 -> 188;
                case 8 -> 255;
                case 9 -> 189;
                case 10 -> 107;
                case 11 -> 250;
                case 12 -> 88;
                case 13 -> 8;
                case 14 -> 254;
                case 15 -> 187;
                case 16 -> 69;
                case 17 -> 85;
                case 18 -> 176;
                case 19 -> 204;
                case 20 -> 143;
                case 21 -> 173;
                case 22 -> 23;
                case 23 -> 130;
                case 24 -> 175;
                case 25 -> 145;
                case 26 -> 61;
                case 27 -> 154;
                case 28 -> 60;
                case 29 -> 110;
                case 30 -> 21;
                case 31 -> 185;
                case 32 -> 1;
                case 33 -> 113;
                case 34 -> 66;
                case 35 -> 10;
                case 36 -> 46;
                case 37 -> 80;
                case 38 -> 87;
                case 39 -> 212;
                case 40 -> 127;
                case 41 -> 108;
                case 42 -> 237;
                case 43 -> 191;
                case 44 -> 81;
                case 45 -> 56;
                case 46 -> 109;
                case 47 -> 199;
                case 48 -> 111;
                case 49 -> 67;
                case 50 -> 177;
                case 51 -> 94;
                case 52 -> 243;
                case 53 -> 50;
                case 54 -> 183;
                case 55 -> 79;
                case 56 -> 220;
                case 57 -> 95;
                case 58 -> 133;
                case 59 -> 157;
                case 60 -> 213;
                case 61 -> 148;
                case 62 -> 22;
                case 63 -> 167;
                case 64 -> 40;
                case 65 -> 156;
                case 66 -> 43;
                case 67 -> 207;
                case 68 -> 193;
                case 69 -> 49;
                case 70 -> 45;
                case 71 -> 83;
                case 72 -> 217;
                case 73 -> 121;
                case 74 -> 186;
                case 75 -> 150;
                case 76 -> 63;
                case 77 -> 48;
                case 78 -> 222;
                case 79 -> 4;
                case 80 -> 82;
                case 81 -> 161;
                case 82 -> 140;
                case 83 -> 211;
                case 84 -> 166;
                case 85 -> 134;
                case 86 -> 59;
                case 87 -> 149;
                case 88 -> 231;
                case 89 -> 64;
                case 90 -> 39;
                case 91 -> 57;
                case 92 -> 106;
                case 93 -> 232;
                case 94 -> 206;
                case 95 -> 151;
                case 96 -> 96;
                case 97 -> 152;
                case 98 -> 97;
                case 99 -> 170;
                case 100 -> 2;
                case 101 -> 26;
                case 102 -> 92;
                case 103 -> 47;
                case 104 -> 6;
                case 105 -> 153;
                case 106 -> 221;
                case 107 -> 17;
                case 108 -> 118;
                case 109 -> 7;
                case 110 -> 0;
                case 111 -> 180;
                case 112 -> 233;
                case 113 -> 164;
                case 114 -> 158;
                case 115 -> 31;
                case 116 -> 44;
                case 117 -> 146;
                case 118 -> 99;
                case 119 -> 219;
                case 120 -> 144;
                case 121 -> 224;
                case 122 -> 200;
                case 123 -> 116;
                case 124 -> 91;
                case 125 -> 147;
                case 126 -> 162;
                case 127 -> 174;
                case 128 -> 245;
                case 129 -> 16;
                case 130 -> 165;
                case 131 -> 179;
                case 132 -> 54;
                case 133 -> 218;
                case 134 -> 5;
                case 135 -> 168;
                case 136 -> 86;
                case 137 -> 124;
                case 138 -> 15;
                case 139 -> 104;
                case 140 -> 197;
                case 141 -> 129;
                case 142 -> 155;
                case 143 -> 101;
                case 144 -> 78;
                case 145 -> 251;
                case 146 -> 241;
                case 147 -> 119;
                case 148 -> 33;
                case 149 -> 125;
                case 150 -> 208;
                case 151 -> 131;
                case 152 -> 235;
                case 153 -> 228;
                case 154 -> 52;
                case 155 -> 13;
                case 156 -> 41;
                case 157 -> 126;
                case 158 -> 214;
                case 159 -> 89;
                case 160 -> 163;
                case 161 -> 115;
                case 162 -> 25;
                case 163 -> 253;
                case 164 -> 77;
                case 165 -> 136;
                case 166 -> 240;
                case 167 -> 226;
                case 168 -> 123;
                case 169 -> 73;
                case 170 -> 68;
                case 171 -> 135;
                case 172 -> 76;
                case 173 -> 14;
                case 174 -> 11;
                case 175 -> 35;
                case 176 -> 42;
                case 177 -> 138;
                case 178 -> 27;
                case 179 -> 71;
                case 180 -> 249;
                case 181 -> 29;
                case 182 -> 196;
                case 183 -> 195;
                case 184 -> 28;
                case 185 -> 247;
                case 186 -> 202;
                case 187 -> 65;
                case 188 -> 172;
                case 189 -> 75;
                case 190 -> 209;
                case 191 -> 112;
                case 192 -> 53;
                case 193 -> 192;
                case 194 -> 20;
                case 195 -> 215;
                case 196 -> 234;
                case 197 -> 9;
                case 198 -> 93;
                case 199 -> 84;
                case 200 -> 178;
                case 201 -> 242;
                case 202 -> 171;
                case 203 -> 216;
                case 204 -> 128;
                case 205 -> 236;
                case 206 -> 246;
                case 207 -> 30;
                case 208 -> 238;
                case 209 -> 34;
                case 210 -> 12;
                case 211 -> 70;
                case 212 -> 102;
                case 213 -> 201;
                case 214 -> 229;
                case 215 -> 18;
                case 216 -> 182;
                case 217 -> 100;
                case 218 -> 55;
                case 219 -> 252;
                case 220 -> 132;
                case 221 -> 98;
                case 222 -> 190;
                case 223 -> 244;
                case 224 -> 205;
                case 225 -> 203;
                case 226 -> 62;
                case 227 -> 37;
                case 228 -> 74;
                case 229 -> 141;
                case 230 -> 58;
                case 231 -> 225;
                case 232 -> 72;
                case 233 -> 223;
                case 234 -> 105;
                case 235 -> 194;
                case 236 -> 117;
                case 237 -> 210;
                case 238 -> 122;
                case 239 -> 19;
                case 240 -> 24;
                case 241 -> 36;
                case 242 -> 181;
                case 243 -> 169;
                case 244 -> 139;
                case 245 -> 120;
                case 246 -> 114;
                case 247 -> 230;
                case 248 -> 32;
                case 249 -> 90;
                case 250 -> 137;
                case 251 -> 227;
                case 252 -> 159;
                case 253 -> 248;
                case 254 -> 38;
                default -> 103;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 47201454905787L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(235663860 + 8725, -235663860 + -10706, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 83139233049047L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.r();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 != 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 != 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1551082380 + -14352, -1551082380 - -6409, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1551082380 + -14349, -1551082380 - -75, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1551082380 + -14350, -1551082380 - -8488, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "mi&\u009b\u00e2\u00d9\u00bb{\u0010Fw\u00b2\u00f9\u00ca.G\u00dc]0\u00fa)\u00ba\u00ef\u00f7\u001e";
                    var4_3 = "mi&\u009b\u00e2\u00d9\u00bb{\u0010Fw\u00b2\u00f9\u00ca.G\u00dc]0\u00fa)\u00ba\u00ef\u00f7\u001e".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 88;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = ">+m\u00f2\u00da5\u00bd9\n\u00dc\u00e4\u0092\u00bb\u00c1\u0094\tp\u00ef=\u00fc#\u00d7\u00a6\u00c8\u00d7\u0087\u0091&wkq\u008b\u0080T\u00bdSE\u00cd\u00dfy_J\u00bc,\u0016\u00e4\u00de\u00f0\u00c2\u00b3\u00c8\b\u000eg?\u00c5\u00b3\u0017\u00ef";
                        var4_3 = ">+m\u00f2\u00da5\u00bd9\n\u00dc\u00e4\u0092\u00bb\u00c1\u0094\tp\u00ef=\u00fc#\u00d7\u00a6\u00c8\u00d7\u0087\u0091&wkq\u008b\u0080T\u00bdSE\u00cd\u00dfy_J\u00bc,\u0016\u00e4\u00de\u00f0\u00c2\u00b3\u00c8\b\u000eg?\u00c5\u00b3\u0017\u00ef".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 89;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 53;
                                break;
                            }
                            case 1: {
                                v15 = 116;
                                break;
                            }
                            case 2: {
                                v15 = 112;
                                break;
                            }
                            case 3: {
                                v15 = 74;
                                break;
                            }
                            case 4: {
                                v15 = 85;
                                break;
                            }
                            case 5: {
                                v15 = 24;
                                break;
                            }
                            default: {
                                v15 = 48;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCDB2) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 17;
                    case 1 -> 23;
                    case 2 -> 208;
                    case 3 -> 255;
                    case 4 -> 181;
                    case 5 -> 158;
                    case 6 -> 99;
                    case 7 -> 251;
                    case 8 -> 12;
                    case 9 -> 18;
                    case 10 -> 98;
                    case 11 -> 120;
                    case 12 -> 188;
                    case 13 -> 21;
                    case 14 -> 72;
                    case 15 -> 157;
                    case 16 -> 5;
                    case 17 -> 226;
                    case 18 -> 233;
                    case 19 -> 224;
                    case 20 -> 16;
                    case 21 -> 214;
                    case 22 -> 125;
                    case 23 -> 46;
                    case 24 -> 139;
                    case 25 -> 79;
                    case 26 -> 205;
                    case 27 -> 35;
                    case 28 -> 162;
                    case 29 -> 219;
                    case 30 -> 7;
                    case 31 -> 118;
                    case 32 -> 15;
                    case 33 -> 117;
                    case 34 -> 82;
                    case 35 -> 146;
                    case 36 -> 235;
                    case 37 -> 153;
                    case 38 -> 4;
                    case 39 -> 108;
                    case 40 -> 101;
                    case 41 -> 194;
                    case 42 -> 39;
                    case 43 -> 94;
                    case 44 -> 95;
                    case 45 -> 121;
                    case 46 -> 230;
                    case 47 -> 107;
                    case 48 -> 68;
                    case 49 -> 176;
                    case 50 -> 129;
                    case 51 -> 180;
                    case 52 -> 28;
                    case 53 -> 132;
                    case 54 -> 175;
                    case 55 -> 165;
                    case 56 -> 241;
                    case 57 -> 50;
                    case 58 -> 38;
                    case 59 -> 245;
                    case 60 -> 22;
                    case 61 -> 29;
                    case 62 -> 89;
                    case 63 -> 147;
                    case 64 -> 75;
                    case 65 -> 45;
                    case 66 -> 115;
                    case 67 -> 150;
                    case 68 -> 113;
                    case 69 -> 199;
                    case 70 -> 14;
                    case 71 -> 135;
                    case 72 -> 123;
                    case 73 -> 77;
                    case 74 -> 76;
                    case 75 -> 10;
                    case 76 -> 178;
                    case 77 -> 203;
                    case 78 -> 97;
                    case 79 -> 73;
                    case 80 -> 253;
                    case 81 -> 92;
                    case 82 -> 70;
                    case 83 -> 41;
                    case 84 -> 152;
                    case 85 -> 87;
                    case 86 -> 138;
                    case 87 -> 48;
                    case 88 -> 134;
                    case 89 -> 238;
                    case 90 -> 128;
                    case 91 -> 222;
                    case 92 -> 144;
                    case 93 -> 44;
                    case 94 -> 13;
                    case 95 -> 137;
                    case 96 -> 32;
                    case 97 -> 20;
                    case 98 -> 242;
                    case 99 -> 93;
                    case 100 -> 229;
                    case 101 -> 112;
                    case 102 -> 185;
                    case 103 -> 202;
                    case 104 -> 200;
                    case 105 -> 191;
                    case 106 -> 6;
                    case 107 -> 151;
                    case 108 -> 86;
                    case 109 -> 232;
                    case 110 -> 218;
                    case 111 -> 84;
                    case 112 -> 173;
                    case 113 -> 3;
                    case 114 -> 47;
                    case 115 -> 197;
                    case 116 -> 221;
                    case 117 -> 227;
                    case 118 -> 142;
                    case 119 -> 252;
                    case 120 -> 122;
                    case 121 -> 64;
                    case 122 -> 104;
                    case 123 -> 119;
                    case 124 -> 0;
                    case 125 -> 198;
                    case 126 -> 110;
                    case 127 -> 91;
                    case 128 -> 246;
                    case 129 -> 8;
                    case 130 -> 24;
                    case 131 -> 63;
                    case 132 -> 248;
                    case 133 -> 131;
                    case 134 -> 239;
                    case 135 -> 80;
                    case 136 -> 149;
                    case 137 -> 217;
                    case 138 -> 66;
                    case 139 -> 26;
                    case 140 -> 243;
                    case 141 -> 189;
                    case 142 -> 247;
                    case 143 -> 206;
                    case 144 -> 52;
                    case 145 -> 78;
                    case 146 -> 103;
                    case 147 -> 210;
                    case 148 -> 166;
                    case 149 -> 83;
                    case 150 -> 159;
                    case 151 -> 193;
                    case 152 -> 65;
                    case 153 -> 179;
                    case 154 -> 27;
                    case 155 -> 249;
                    case 156 -> 100;
                    case 157 -> 106;
                    case 158 -> 55;
                    case 159 -> 60;
                    case 160 -> 161;
                    case 161 -> 160;
                    case 162 -> 127;
                    case 163 -> 167;
                    case 164 -> 156;
                    case 165 -> 164;
                    case 166 -> 54;
                    case 167 -> 141;
                    case 168 -> 195;
                    case 169 -> 171;
                    case 170 -> 59;
                    case 171 -> 74;
                    case 172 -> 212;
                    case 173 -> 192;
                    case 174 -> 237;
                    case 175 -> 51;
                    case 176 -> 163;
                    case 177 -> 49;
                    case 178 -> 148;
                    case 179 -> 57;
                    case 180 -> 204;
                    case 181 -> 250;
                    case 182 -> 155;
                    case 183 -> 61;
                    case 184 -> 116;
                    case 185 -> 88;
                    case 186 -> 236;
                    case 187 -> 190;
                    case 188 -> 154;
                    case 189 -> 109;
                    case 190 -> 216;
                    case 191 -> 69;
                    case 192 -> 19;
                    case 193 -> 42;
                    case 194 -> 40;
                    case 195 -> 9;
                    case 196 -> 130;
                    case 197 -> 225;
                    case 198 -> 207;
                    case 199 -> 177;
                    case 200 -> 215;
                    case 201 -> 140;
                    case 202 -> 53;
                    case 203 -> 105;
                    case 204 -> 201;
                    case 205 -> 85;
                    case 206 -> 25;
                    case 207 -> 126;
                    case 208 -> 43;
                    case 209 -> 96;
                    case 210 -> 184;
                    case 211 -> 1;
                    case 212 -> 114;
                    case 213 -> 254;
                    case 214 -> 169;
                    case 215 -> 234;
                    case 216 -> 211;
                    case 217 -> 228;
                    case 218 -> 187;
                    case 219 -> 143;
                    case 220 -> 174;
                    case 221 -> 220;
                    case 222 -> 186;
                    case 223 -> 133;
                    case 224 -> 240;
                    case 225 -> 37;
                    case 226 -> 81;
                    case 227 -> 145;
                    case 228 -> 124;
                    case 229 -> 62;
                    case 230 -> 30;
                    case 231 -> 223;
                    case 232 -> 33;
                    case 233 -> 183;
                    case 234 -> 172;
                    case 235 -> 196;
                    case 236 -> 213;
                    case 237 -> 11;
                    case 238 -> 136;
                    case 239 -> 102;
                    case 240 -> 168;
                    case 241 -> 34;
                    case 242 -> 90;
                    case 243 -> 36;
                    case 244 -> 58;
                    case 245 -> 209;
                    case 246 -> 170;
                    case 247 -> 67;
                    case 248 -> 31;
                    case 249 -> 231;
                    case 250 -> 56;
                    case 251 -> 2;
                    case 252 -> 111;
                    case 253 -> 182;
                    case 254 -> 244;
                    default -> 71;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 118187519506135L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0013]A\u0006\u000eZ4J\t\u0014WR\fC\u0018)V\u0011";
                    var5_4 = "\u0013]A\u0006\u000eZ4J\t\u0014WR\fC\u0018)V\u0011".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 84;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 44;
                                    break;
                                }
                                case 1: {
                                    v11 = 108;
                                    break;
                                }
                                case 2: {
                                    v11 = 103;
                                    break;
                                }
                                case 3: {
                                    v11 = 60;
                                    break;
                                }
                                case 4: {
                                    v11 = 63;
                                    break;
                                }
                                case 5: {
                                    v11 = 98;
                                    break;
                                }
                                default: {
                                    v11 = 83;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 130445325565554L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "DX\u001aNPG1\u0004BF\u0016T\nNY\u001dT\\E)dX\u0014\tNY\u001dT\\E)hR\rI_\u0000YVH3hU\u0007SWA";
                    var5_4 = "DX\u001aNPG1\u0004BF\u0016T\nNY\u001dT\\E)dX\u0014\tNY\u001dT\\E)hR\rI_\u0000YVH3hU\u0007SWA".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 29;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "zn(}d|\u000e\u0006zn(}hv";
                        var5_4 = "zn(}d|\u000e\u0006zn(}hv".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 41;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 16;
                                break;
                            }
                            case 1: {
                                v15 = 43;
                                break;
                            }
                            case 2: {
                                v15 = 110;
                                break;
                            }
                            case 3: {
                                v15 = 39;
                                break;
                            }
                            case 4: {
                                v15 = 36;
                                break;
                            }
                            case 5: {
                                v15 = 59;
                                break;
                            }
                            default: {
                                v15 = 64;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 44782109334119L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1514644920 + -15573, 1514644920 + 9020, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 65873971995632L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00a6)\u00b4\u00fc\u00fc\u0003\u0098\u00a0\u00c7\u0005\u00dc\u00da\u00ddF2\r+\u00e0\u0015K\u00de\u008d\u00ae@\u00b9\u00ea.\u00e0\u00a6\u0010B\u0006\u00ff|\u00bc\u00fe\u00c9\u0013\u009c\u0004ip\u00a8\u0084`c\u0005\u00ba\u0094\u0011\u008f\u00ab3S\u00a3=\u001e1\u00f6H\u0006\u00d1[K\u00b2*\u008d\u001c]\u009d\b9\u00de\u008a\u00ffC4\u00b6\u0001\u00d02\u00fd\u001a\u009e3\u009bAV\u00d2V\u0091q\u00a7\u00ee\u00a3!\u00da)\u00dd\u00a2\u00b6B;\u00dd";
                    var4_3 = "\u00a6)\u00b4\u00fc\u00fc\u0003\u0098\u00a0\u00c7\u0005\u00dc\u00da\u00ddF2\r+\u00e0\u0015K\u00de\u008d\u00ae@\u00b9\u00ea.\u00e0\u00a6\u0010B\u0006\u00ff|\u00bc\u00fe\u00c9\u0013\u009c\u0004ip\u00a8\u0084`c\u0005\u00ba\u0094\u0011\u008f\u00ab3S\u00a3=\u001e1\u00f6H\u0006\u00d1[K\u00b2*\u008d\u001c]\u009d\b9\u00de\u008a\u00ffC4\u00b6\u0001\u00d02\u00fd\u001a\u009e3\u009bAV\u00d2V\u0091q\u00a7\u00ee\u00a3!\u00da)\u00dd\u00a2\u00b6B;\u00dd".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 119;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "$\\\u0082\u0086\u00a2\u0010\u00bb\u007fc8'F\u00d0\u00f3\u00de<L\u00c7\u0003\t\u00a7\u00f9\u00fc\u00be\u008cJ\u00d5\u00aeB\u00ef\u00fd\u00aa\u0084\u00ffS;\u00f2\u0013\u00af\u00eb-1x\u00b4j:\u00e98\u0093\u00ee\n8\u0016\u0018f3\u008e!\u00ca\u00a6;}\u008eRU\u001f\u00c2/>-\u00074zY\u0083M\u00b8u\u0094\u00f9\f\u00e2\u00dc\u00b2\u001d\u0006\u00ed\u00c1V}6f\u00c9";
                        var4_3 = "$\\\u0082\u0086\u00a2\u0010\u00bb\u007fc8'F\u00d0\u00f3\u00de<L\u00c7\u0003\t\u00a7\u00f9\u00fc\u00be\u008cJ\u00d5\u00aeB\u00ef\u00fd\u00aa\u0084\u00ffS;\u00f2\u0013\u00af\u00eb-1x\u00b4j:\u00e98\u0093\u00ee\n8\u0016\u0018f3\u008e!\u00ca\u00a6;}\u008eRU\u001f\u00c2/>-\u00074zY\u0083M\u00b8u\u0094\u00f9\f\u00e2\u00dc\u00b2\u001d\u0006\u00ed\u00c1V}6f\u00c9".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 9;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 71;
                                break;
                            }
                            case 1: {
                                v15 = 15;
                                break;
                            }
                            case 2: {
                                v15 = 57;
                                break;
                            }
                            case 3: {
                                v15 = 68;
                                break;
                            }
                            case 4: {
                                v15 = 105;
                                break;
                            }
                            case 5: {
                                v15 = 115;
                                break;
                            }
                            default: {
                                v15 = 61;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x714) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 67;
                    case 1 -> 68;
                    case 2 -> 255;
                    case 3 -> 96;
                    case 4 -> 191;
                    case 5 -> 137;
                    case 6 -> 229;
                    case 7 -> 153;
                    case 8 -> 200;
                    case 9 -> 221;
                    case 10 -> 173;
                    case 11 -> 61;
                    case 12 -> 76;
                    case 13 -> 6;
                    case 14 -> 168;
                    case 15 -> 42;
                    case 16 -> 69;
                    case 17 -> 83;
                    case 18 -> 44;
                    case 19 -> 77;
                    case 20 -> 176;
                    case 21 -> 222;
                    case 22 -> 185;
                    case 23 -> 34;
                    case 24 -> 182;
                    case 25 -> 62;
                    case 26 -> 119;
                    case 27 -> 139;
                    case 28 -> 122;
                    case 29 -> 36;
                    case 30 -> 164;
                    case 31 -> 181;
                    case 32 -> 56;
                    case 33 -> 52;
                    case 34 -> 142;
                    case 35 -> 145;
                    case 36 -> 190;
                    case 37 -> 27;
                    case 38 -> 141;
                    case 39 -> 59;
                    case 40 -> 11;
                    case 41 -> 35;
                    case 42 -> 71;
                    case 43 -> 10;
                    case 44 -> 208;
                    case 45 -> 159;
                    case 46 -> 73;
                    case 47 -> 134;
                    case 48 -> 84;
                    case 49 -> 130;
                    case 50 -> 78;
                    case 51 -> 43;
                    case 52 -> 13;
                    case 53 -> 243;
                    case 54 -> 8;
                    case 55 -> 70;
                    case 56 -> 102;
                    case 57 -> 148;
                    case 58 -> 90;
                    case 59 -> 110;
                    case 60 -> 179;
                    case 61 -> 30;
                    case 62 -> 23;
                    case 63 -> 178;
                    case 64 -> 106;
                    case 65 -> 186;
                    case 66 -> 87;
                    case 67 -> 187;
                    case 68 -> 238;
                    case 69 -> 46;
                    case 70 -> 189;
                    case 71 -> 115;
                    case 72 -> 89;
                    case 73 -> 127;
                    case 74 -> 252;
                    case 75 -> 45;
                    case 76 -> 169;
                    case 77 -> 94;
                    case 78 -> 198;
                    case 79 -> 99;
                    case 80 -> 19;
                    case 81 -> 5;
                    case 82 -> 66;
                    case 83 -> 53;
                    case 84 -> 219;
                    case 85 -> 235;
                    case 86 -> 54;
                    case 87 -> 240;
                    case 88 -> 65;
                    case 89 -> 218;
                    case 90 -> 215;
                    case 91 -> 158;
                    case 92 -> 253;
                    case 93 -> 26;
                    case 94 -> 194;
                    case 95 -> 203;
                    case 96 -> 228;
                    case 97 -> 216;
                    case 98 -> 105;
                    case 99 -> 202;
                    case 100 -> 124;
                    case 101 -> 146;
                    case 102 -> 116;
                    case 103 -> 209;
                    case 104 -> 95;
                    case 105 -> 223;
                    case 106 -> 188;
                    case 107 -> 152;
                    case 108 -> 93;
                    case 109 -> 246;
                    case 110 -> 217;
                    case 111 -> 170;
                    case 112 -> 60;
                    case 113 -> 128;
                    case 114 -> 3;
                    case 115 -> 227;
                    case 116 -> 79;
                    case 117 -> 37;
                    case 118 -> 33;
                    case 119 -> 155;
                    case 120 -> 157;
                    case 121 -> 39;
                    case 122 -> 9;
                    case 123 -> 172;
                    case 124 -> 167;
                    case 125 -> 237;
                    case 126 -> 31;
                    case 127 -> 75;
                    case 128 -> 151;
                    case 129 -> 16;
                    case 130 -> 166;
                    case 131 -> 40;
                    case 132 -> 57;
                    case 133 -> 214;
                    case 134 -> 196;
                    case 135 -> 177;
                    case 136 -> 109;
                    case 137 -> 38;
                    case 138 -> 80;
                    case 139 -> 41;
                    case 140 -> 254;
                    case 141 -> 231;
                    case 142 -> 234;
                    case 143 -> 132;
                    case 144 -> 112;
                    case 145 -> 21;
                    case 146 -> 239;
                    case 147 -> 7;
                    case 148 -> 184;
                    case 149 -> 47;
                    case 150 -> 156;
                    case 151 -> 12;
                    case 152 -> 15;
                    case 153 -> 108;
                    case 154 -> 226;
                    case 155 -> 49;
                    case 156 -> 55;
                    case 157 -> 2;
                    case 158 -> 212;
                    case 159 -> 175;
                    case 160 -> 81;
                    case 161 -> 195;
                    case 162 -> 192;
                    case 163 -> 123;
                    case 164 -> 232;
                    case 165 -> 165;
                    case 166 -> 174;
                    case 167 -> 136;
                    case 168 -> 193;
                    case 169 -> 230;
                    case 170 -> 91;
                    case 171 -> 17;
                    case 172 -> 205;
                    case 173 -> 183;
                    case 174 -> 163;
                    case 175 -> 233;
                    case 176 -> 29;
                    case 177 -> 161;
                    case 178 -> 25;
                    case 179 -> 98;
                    case 180 -> 51;
                    case 181 -> 220;
                    case 182 -> 121;
                    case 183 -> 143;
                    case 184 -> 207;
                    case 185 -> 144;
                    case 186 -> 140;
                    case 187 -> 171;
                    case 188 -> 50;
                    case 189 -> 118;
                    case 190 -> 199;
                    case 191 -> 107;
                    case 192 -> 4;
                    case 193 -> 24;
                    case 194 -> 131;
                    case 195 -> 154;
                    case 196 -> 204;
                    case 197 -> 213;
                    case 198 -> 160;
                    case 199 -> 244;
                    case 200 -> 225;
                    case 201 -> 22;
                    case 202 -> 162;
                    case 203 -> 92;
                    case 204 -> 250;
                    case 205 -> 111;
                    case 206 -> 74;
                    case 207 -> 149;
                    case 208 -> 117;
                    case 209 -> 135;
                    case 210 -> 120;
                    case 211 -> 0;
                    case 212 -> 180;
                    case 213 -> 236;
                    case 214 -> 113;
                    case 215 -> 85;
                    case 216 -> 20;
                    case 217 -> 48;
                    case 218 -> 251;
                    case 219 -> 114;
                    case 220 -> 248;
                    case 221 -> 86;
                    case 222 -> 147;
                    case 223 -> 125;
                    case 224 -> 104;
                    case 225 -> 206;
                    case 226 -> 201;
                    case 227 -> 133;
                    case 228 -> 224;
                    case 229 -> 126;
                    case 230 -> 100;
                    case 231 -> 63;
                    case 232 -> 72;
                    case 233 -> 88;
                    case 234 -> 97;
                    case 235 -> 58;
                    case 236 -> 18;
                    case 237 -> 28;
                    case 238 -> 150;
                    case 239 -> 245;
                    case 240 -> 1;
                    case 241 -> 241;
                    case 242 -> 32;
                    case 243 -> 211;
                    case 244 -> 14;
                    case 245 -> 249;
                    case 246 -> 210;
                    case 247 -> 242;
                    case 248 -> 82;
                    case 249 -> 103;
                    case 250 -> 247;
                    case 251 -> 101;
                    case 252 -> 197;
                    case 253 -> 138;
                    case 254 -> 64;
                    default -> 129;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 53180337467890L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(52428000 - 12594, 52428000 - 27774, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 26764037462196L;
                    int n3 = SshAgentIpcService.w();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(2096202510 + (char)-8229, 2096202510 + (char)-5052, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 12212094405576L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "e\u008ey\u0006A\u0003\u0084N\u0013";
                var4_3 = "e\u008ey\u0006A\u0003\u0084N\u0013".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 84;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 64;
                                break;
                            }
                            case 1: {
                                v11 = 28;
                                break;
                            }
                            case 2: {
                                v11 = 43;
                                break;
                            }
                            case 3: {
                                v11 = 111;
                                break;
                            }
                            case 4: {
                                v11 = 104;
                                break;
                            }
                            case 5: {
                                v11 = 54;
                                break;
                            }
                            default: {
                                v11 = 22;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x7A5C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 99;
                    case 1 -> 224;
                    case 2 -> 165;
                    case 3 -> 71;
                    case 4 -> 195;
                    case 5 -> 183;
                    case 6 -> 91;
                    case 7 -> 87;
                    case 8 -> 36;
                    case 9 -> 125;
                    case 10 -> 239;
                    case 11 -> 143;
                    case 12 -> 243;
                    case 13 -> 10;
                    case 14 -> 238;
                    case 15 -> 88;
                    case 16 -> 201;
                    case 17 -> 200;
                    case 18 -> 176;
                    case 19 -> 221;
                    case 20 -> 138;
                    case 21 -> 194;
                    case 22 -> 40;
                    case 23 -> 34;
                    case 24 -> 250;
                    case 25 -> 17;
                    case 26 -> 27;
                    case 27 -> 161;
                    case 28 -> 56;
                    case 29 -> 219;
                    case 30 -> 182;
                    case 31 -> 75;
                    case 32 -> 235;
                    case 33 -> 43;
                    case 34 -> 108;
                    case 35 -> 86;
                    case 36 -> 237;
                    case 37 -> 79;
                    case 38 -> 124;
                    case 39 -> 22;
                    case 40 -> 197;
                    case 41 -> 67;
                    case 42 -> 214;
                    case 43 -> 189;
                    case 44 -> 73;
                    case 45 -> 193;
                    case 46 -> 212;
                    case 47 -> 51;
                    case 48 -> 30;
                    case 49 -> 129;
                    case 50 -> 101;
                    case 51 -> 178;
                    case 52 -> 159;
                    case 53 -> 190;
                    case 54 -> 57;
                    case 55 -> 140;
                    case 56 -> 168;
                    case 57 -> 220;
                    case 58 -> 158;
                    case 59 -> 242;
                    case 60 -> 231;
                    case 61 -> 171;
                    case 62 -> 136;
                    case 63 -> 89;
                    case 64 -> 139;
                    case 65 -> 196;
                    case 66 -> 83;
                    case 67 -> 107;
                    case 68 -> 222;
                    case 69 -> 32;
                    case 70 -> 33;
                    case 71 -> 120;
                    case 72 -> 85;
                    case 73 -> 225;
                    case 74 -> 166;
                    case 75 -> 96;
                    case 76 -> 63;
                    case 77 -> 207;
                    case 78 -> 185;
                    case 79 -> 123;
                    case 80 -> 179;
                    case 81 -> 202;
                    case 82 -> 167;
                    case 83 -> 126;
                    case 84 -> 11;
                    case 85 -> 209;
                    case 86 -> 0;
                    case 87 -> 121;
                    case 88 -> 206;
                    case 89 -> 215;
                    case 90 -> 29;
                    case 91 -> 252;
                    case 92 -> 80;
                    case 93 -> 28;
                    case 94 -> 130;
                    case 95 -> 249;
                    case 96 -> 145;
                    case 97 -> 234;
                    case 98 -> 141;
                    case 99 -> 255;
                    case 100 -> 151;
                    case 101 -> 31;
                    case 102 -> 35;
                    case 103 -> 186;
                    case 104 -> 213;
                    case 105 -> 81;
                    case 106 -> 204;
                    case 107 -> 64;
                    case 108 -> 113;
                    case 109 -> 24;
                    case 110 -> 119;
                    case 111 -> 244;
                    case 112 -> 153;
                    case 113 -> 128;
                    case 114 -> 245;
                    case 115 -> 163;
                    case 116 -> 146;
                    case 117 -> 198;
                    case 118 -> 98;
                    case 119 -> 78;
                    case 120 -> 117;
                    case 121 -> 58;
                    case 122 -> 54;
                    case 123 -> 230;
                    case 124 -> 127;
                    case 125 -> 241;
                    case 126 -> 174;
                    case 127 -> 227;
                    case 128 -> 208;
                    case 129 -> 169;
                    case 130 -> 8;
                    case 131 -> 229;
                    case 132 -> 5;
                    case 133 -> 21;
                    case 134 -> 150;
                    case 135 -> 18;
                    case 136 -> 247;
                    case 137 -> 232;
                    case 138 -> 149;
                    case 139 -> 61;
                    case 140 -> 42;
                    case 141 -> 62;
                    case 142 -> 92;
                    case 143 -> 188;
                    case 144 -> 3;
                    case 145 -> 20;
                    case 146 -> 172;
                    case 147 -> 90;
                    case 148 -> 137;
                    case 149 -> 69;
                    case 150 -> 216;
                    case 151 -> 19;
                    case 152 -> 210;
                    case 153 -> 66;
                    case 154 -> 45;
                    case 155 -> 118;
                    case 156 -> 60;
                    case 157 -> 155;
                    case 158 -> 148;
                    case 159 -> 74;
                    case 160 -> 228;
                    case 161 -> 175;
                    case 162 -> 251;
                    case 163 -> 162;
                    case 164 -> 94;
                    case 165 -> 223;
                    case 166 -> 93;
                    case 167 -> 253;
                    case 168 -> 177;
                    case 169 -> 53;
                    case 170 -> 233;
                    case 171 -> 191;
                    case 172 -> 65;
                    case 173 -> 72;
                    case 174 -> 203;
                    case 175 -> 49;
                    case 176 -> 152;
                    case 177 -> 184;
                    case 178 -> 115;
                    case 179 -> 38;
                    case 180 -> 111;
                    case 181 -> 59;
                    case 182 -> 211;
                    case 183 -> 133;
                    case 184 -> 156;
                    case 185 -> 226;
                    case 186 -> 39;
                    case 187 -> 112;
                    case 188 -> 55;
                    case 189 -> 16;
                    case 190 -> 109;
                    case 191 -> 106;
                    case 192 -> 4;
                    case 193 -> 26;
                    case 194 -> 2;
                    case 195 -> 160;
                    case 196 -> 102;
                    case 197 -> 205;
                    case 198 -> 104;
                    case 199 -> 41;
                    case 200 -> 15;
                    case 201 -> 105;
                    case 202 -> 37;
                    case 203 -> 199;
                    case 204 -> 246;
                    case 205 -> 240;
                    case 206 -> 1;
                    case 207 -> 218;
                    case 208 -> 50;
                    case 209 -> 170;
                    case 210 -> 131;
                    case 211 -> 142;
                    case 212 -> 77;
                    case 213 -> 23;
                    case 214 -> 217;
                    case 215 -> 135;
                    case 216 -> 97;
                    case 217 -> 132;
                    case 218 -> 114;
                    case 219 -> 68;
                    case 220 -> 6;
                    case 221 -> 25;
                    case 222 -> 70;
                    case 223 -> 134;
                    case 224 -> 180;
                    case 225 -> 147;
                    case 226 -> 44;
                    case 227 -> 76;
                    case 228 -> 13;
                    case 229 -> 14;
                    case 230 -> 254;
                    case 231 -> 181;
                    case 232 -> 100;
                    case 233 -> 52;
                    case 234 -> 103;
                    case 235 -> 9;
                    case 236 -> 192;
                    case 237 -> 173;
                    case 238 -> 12;
                    case 239 -> 84;
                    case 240 -> 154;
                    case 241 -> 48;
                    case 242 -> 236;
                    case 243 -> 248;
                    case 244 -> 122;
                    case 245 -> 187;
                    case 246 -> 95;
                    case 247 -> 7;
                    case 248 -> 164;
                    case 249 -> 110;
                    case 250 -> 47;
                    case 251 -> 82;
                    case 252 -> 46;
                    case 253 -> 116;
                    case 254 -> 144;
                    default -> 157;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

