/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.DebuggableRunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.debugger.DebugPortConfigurator;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.nodejs.debug.NodeDebuggableRunProfileState;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u0017\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J \u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00190\u00102\u0006\u0010#\u001a\u00020$2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0004J\u001a\u0010'\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u001e\u001a\u00020\u001f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lcom/intellij/javascript/debugger/execution/DebuggableProcessState;", "T", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/execution/runners/DebuggableRunProfileState;", "Lcom/intellij/javascript/nodejs/debug/NodeDebuggableRunProfileState;", "configuration", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "<init>", "(Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "getConfiguration", "()Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "Lcom/intellij/javascript/debugger/execution/DebuggableProcessRunConfiguration;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ExecutionResult;", "configurator", "Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;", "debugPort", "", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "addConsoleFilters", "", "builder", "Lcom/intellij/execution/filters/TextConsoleBuilder;", "inputPath", "", "getInputPath", "()Ljava/lang/String;", "startProcess", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "configureEnvironment", "addInputPathArg", "createProcessHandler", "configureCommandLine", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nDebuggableProcessState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggableProcessState.kt\ncom/intellij/javascript/debugger/execution/DebuggableProcessState\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n14#2:114\n*S KotlinDebug\n*F\n+ 1 DebuggableProcessState.kt\ncom/intellij/javascript/debugger/execution/DebuggableProcessState\n*L\n42#1:114\n*E\n"})
public abstract class DebuggableProcessState<T extends DebuggableProcessRunConfiguration>
implements DebuggableRunProfileState,
NodeDebuggableRunProfileState {
    @NotNull
    private final T configuration;
    @NotNull
    private final ExecutionEnvironment environment;

    public DebuggableProcessState(@NotNull T configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
    }

    @NotNull
    protected final T getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public Promise<ExecutionResult> execute(@Nullable CommandLineDebugConfigurator configurator) {
        Promise promise2 = this.startProcess(new GeneralCommandLine(), configurator).then(arg_0 -> DebuggableProcessState.execute$lambda$1(arg_0 -> DebuggableProcessState.execute$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
        return promise2;
    }

    @NotNull
    public Promise<ExecutionResult> execute(int debugPort) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodeDebuggableRunProfileState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("Please call execute(CommandLineDebugConfigurator) instead: " + this.getClass());
        return this.execute((CommandLineDebugConfigurator)DebugPortConfigurator.Companion.new(debugPort));
    }

    private final ConsoleView createConsole(ProcessHandler processHandler) {
        Project project = this.environment.getProject();
        TextConsoleBuilderImpl consoleBuilder2 = new TextConsoleBuilderImpl(this, project){
            final /* synthetic */ DebuggableProcessState<T> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected ConsoleView createConsole() {
                Project project = this.this$0.getEnvironment().getProject();
                GlobalSearchScope globalSearchScope = this.getScope();
                boolean bl = this.isViewer();
                return (ConsoleView)new ConsoleViewImpl(this.this$0, project, globalSearchScope, bl){
                    final /* synthetic */ DebuggableProcessState<T> this$0;
                    {
                        this.this$0 = $receiver;
                        Intrinsics.checkNotNull((Object)$super_call_param$1);
                        Intrinsics.checkNotNull((Object)$super_call_param$2);
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3, true);
                    }

                    public void uiDataSnapshot(DataSink sink) {
                        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                        super.uiDataSnapshot(sink);
                        DataKey dataKey = LangDataKeys.RUN_PROFILE;
                        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"RUN_PROFILE");
                        sink.set(dataKey, (Object)this.this$0.getEnvironment().getRunProfile());
                    }
                };
            }
        };
        this.addConsoleFilters((TextConsoleBuilder)consoleBuilder2);
        ConsoleView consoleView = consoleBuilder2.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        ConsoleView console = consoleView;
        console.attachToProcess(processHandler);
        return console;
    }

    protected void addConsoleFilters(@NotNull TextConsoleBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    @NotNull
    protected String getInputPath() {
        String string = this.configuration.getInputPath();
        if (string == null) {
            throw new ExecutionException(JSDebuggerBundle.message("error.message.input.path.not.specified", new Object[0]));
        }
        String inputPath = string;
        if (ScriptFileUtil.isMemoryScriptPath((String)inputPath)) {
            return inputPath;
        }
        String string2 = FileUtilRt.toSystemDependentName((String)PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.environment.getProject())).expandPath(inputPath));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
        return string2;
    }

    @NotNull
    protected Promise<ProcessHandler> startProcess(@NotNull GeneralCommandLine commandLine, int debugPort) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return this.startProcess(commandLine, (CommandLineDebugConfigurator)DebugPortConfigurator.Companion.new(debugPort));
    }

    @NotNull
    protected Promise<ProcessHandler> startProcess(@NotNull GeneralCommandLine commandLine, @Nullable CommandLineDebugConfigurator configurator) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        DebugPortConfigurator debugPortConfigurator = configurator instanceof DebugPortConfigurator ? (DebugPortConfigurator)configurator : null;
        int debugPort = debugPortConfigurator != null ? debugPortConfigurator.getDebugPort() : -1;
        this.configureCommandLine(commandLine, debugPort);
        this.configureEnvironment(commandLine);
        CommandLineDebugConfigurator commandLineDebugConfigurator = configurator;
        if (commandLineDebugConfigurator != null) {
            commandLineDebugConfigurator.afterBaseConfiguring(commandLine);
        }
        ProcessHandler processHandler = this.createProcessHandler(commandLine, configurator);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)this.environment.getProject());
        return Promises.resolvedPromise((Object)processHandler);
    }

    protected void configureEnvironment(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        commandLine.withEnvironment(((CommonProgramRunConfigurationParameters)this.configuration).getEnvs());
        commandLine.withParentEnvironmentType(((CommonProgramRunConfigurationParameters)this.configuration).isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
    }

    protected final void addInputPathArg(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        String[] stringArray = new String[]{this.getInputPath()};
        commandLine.addParameters(stringArray);
    }

    @NotNull
    protected ProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine, @Nullable CommandLineDebugConfigurator configurator) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        return (ProcessHandler)new OSProcessHandler(commandLine);
    }

    protected void configureCommandLine(@NotNull GeneralCommandLine commandLine, int debugPort) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            String string = this.configuration.getEffectiveExePath();
            if (string == null) {
                throw new ExecutionException(JSDebuggerBundle.message("error.message.exe.path.not.specified", new Object[0]));
            }
            String exePath = string;
            commandLine.setExePath(this.configuration.correctExePath(exePath));
            String string2 = this.configuration.getEffectiveWorkingDirectory();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            commandLine.withWorkDirectory(it);
        }
    }

    private static final ExecutionResult execute$lambda$0(DebuggableProcessState this$0, ProcessHandler it) {
        Intrinsics.checkNotNull((Object)it);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)this$0.createConsole(it), it);
    }

    private static final ExecutionResult execute$lambda$1(Function1 $tmp0, Object p0) {
        return (ExecutionResult)$tmp0.invoke(p0);
    }
}

