/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.intelliLang.inject;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.injections.JSInjectionUtil;
import com.intellij.lang.javascript.patterns.JSPatterns;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.XmlPatterns;
import com.intellij.plugins.intelliLang.inject.JSInjection;
import com.intellij.plugins.intelliLang.inject.JSTaggedLiteralInjection;
import com.intellij.plugins.intelliLang.inject.JSTaggedLiteralPanel;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectLanguageAction;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLanguageInjectionSupport
extends AbstractLanguageInjectionSupport {
    public static final String SUPPORT_ID = "js";

    @NotNull
    public static JSLanguageInjectionSupport getInstance() {
        JSLanguageInjectionSupport jSLanguageInjectionSupport = (JSLanguageInjectionSupport)Objects.requireNonNull(InjectorUtils.findInjectionSupport((String)SUPPORT_ID));
        if (jSLanguageInjectionSupport == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(0);
        }
        return jSLanguageInjectionSupport;
    }

    @NotNull
    public String getId() {
        return SUPPORT_ID;
    }

    public Class<?> @NotNull [] getPatternClasses() {
        Class[] classArray = new Class[]{JSPatterns.class, XmlPatterns.class};
        if (classArray == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(1);
        }
        return classArray;
    }

    public boolean isApplicableTo(PsiLanguageInjectionHost host) {
        Language language = host.getLanguage();
        return language instanceof JSLanguageDialect;
    }

    public String getHelpId() {
        return "reference.settings.language.injection.generic.javascript";
    }

    public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost psiElement) {
        if (!psiElement.isValidHost()) {
            return false;
        }
        if (JSLanguageInjectionSupport.findCommentOwner(psiElement) == null) {
            return false;
        }
        InjectLanguageAction.addFixer((PsiLanguageInjectionHost)psiElement, host -> {
            Runnable addCommentAction = JSLanguageInjectionSupport.getAddCommentAction(host, language.getID());
            if (addCommentAction == null) {
                return false;
            }
            addCommentAction.run();
            return true;
        }, (String)IntelliLangBundle.message((String)"intelliLang.suggest.insert.comment", (Object[])new Object[0]));
        return false;
    }

    public AnAction[] createAddActions(final Project project, final Consumer<? super BaseInjection> consumer) {
        AnAction taggedLiteralAction = new AnAction(JavaScriptBundle.messagePointer("action.js.tagged.literal.injection.text", new Object[0]), AllIcons.FileTypes.JavaScript){

            public void actionPerformed(@NotNull AnActionEvent e) {
                JSTaggedLiteralInjection taggedLiteralInjection;
                JSTaggedLiteralInjection newInjection;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((newInjection = JSLanguageInjectionSupport.editTaggedLiteralInjection(taggedLiteralInjection = new JSTaggedLiteralInjection(), project)) != null) {
                    consumer.consume((Object)newInjection);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport$1", "actionPerformed"));
            }
        };
        return (AnAction[])ArrayUtil.append((Object[])super.createAddActions(project, consumer), (Object)taggedLiteralAction);
    }

    public AnAction createEditAction(final Project project, final Factory<? extends BaseInjection> producer) {
        return new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                BaseInjection originalInjection;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((originalInjection = (BaseInjection)producer.create()) instanceof JSTaggedLiteralInjection) {
                    JSTaggedLiteralInjection newInjection = JSLanguageInjectionSupport.editTaggedLiteralInjection((JSTaggedLiteralInjection)originalInjection.copy(), project);
                    if (newInjection != null) {
                        originalInjection.copyFrom((BaseInjection)newInjection);
                    }
                } else {
                    JSLanguageInjectionSupport.perform((Project)project, (Factory)producer);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport$2", "actionPerformed"));
            }
        };
    }

    @Nullable
    static Runnable getAddCommentAction(@NotNull PsiLanguageInjectionHost host, @NotNull String languageID) {
        if (host == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(2);
        }
        if (languageID == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(3);
        }
        if (!host.isValidHost()) {
            return null;
        }
        List<JSLiteralExpression> parts = JSInjectionUtil.getConcatenationParts(JSInjectionUtil.getTopElement(host));
        LanguageInjectionSupport tempInjectionSupport = TemporaryPlacesRegistry.getInstance((Project)host.getProject()).getLanguageInjectionSupport();
        return () -> WriteCommandAction.writeCommandAction((Project)host.getProject(), (PsiFile[])new PsiFile[]{host.getContainingFile()}).run(() -> {
            String commentText = "//" + JSCodeStyleSettings.getLineCommentPrefix((PsiElement)host) + "language=" + languageID;
            JSLanguageInjectionSupport.addCommentBeforeHost(host, commentText);
            for (JSLiteralExpression part : parts) {
                tempInjectionSupport.removeInjection((PsiElement)part);
            }
        });
    }

    static void addCommentBeforeHost(@NotNull PsiLanguageInjectionHost host, @NotNull String commentText) {
        boolean startsOnNewLine;
        PsiElement commentOwner;
        if (host == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(4);
        }
        if (commentText == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(5);
        }
        if ((commentOwner = JSLanguageInjectionSupport.findCommentOwner(host)) == null) {
            return;
        }
        PsiElement sibling = commentOwner.getPrevSibling();
        boolean bl = startsOnNewLine = sibling == null || sibling instanceof PsiWhiteSpace && sibling.textContains('\n');
        if (!startsOnNewLine) {
            JSChangeUtil.addWs(commentOwner.getParent().getNode(), commentOwner.getNode(), "\n");
        }
        PsiComment commentPsi = JSPsiElementFactory.createPsiComment(commentText, (PsiElement)host);
        commentOwner.getParent().addBefore((PsiElement)commentPsi, commentOwner);
    }

    public boolean useDefaultCommentInjector() {
        return false;
    }

    @Nullable
    public JSInjection findCommentInjection(@NotNull PsiElement host, @Nullable Ref<? super PsiElement> commentRef) {
        if (host == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(6);
        }
        commentRef = (Ref)ObjectUtils.coalesce(commentRef, (Object)new Ref());
        if (PsiTreeUtil.getParentOfType((PsiElement)host, PsiLanguageInjectionHost.class) != null) {
            return null;
        }
        InjectorUtils.CommentInjectionData injectionData = InjectorUtils.findCommentInjectionData((PsiElement)host, (boolean)false, (Ref)commentRef);
        if (injectionData == null) {
            return null;
        }
        JSInjection injection = new JSInjection("comment");
        injection.setPrefix(injectionData.getPrefix());
        injection.setSuffix(injectionData.getSuffix());
        injection.setInjectedLanguageId(injectionData.getInjectedLanguageId());
        injection.setDisplayName(injectionData.getDisplayName());
        injection.setSupportsConcatenation(true);
        injection.setCanReformat(Boolean.parseBoolean(injectionData.getValues().getOrDefault("format", "true")));
        return injection;
    }

    public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
        Configuration configuration = Configuration.getProjectInstance((Project)psiElement.getProject());
        Ref commentRef = new Ref();
        BaseInjection injection = this.findCommentInjection((PsiElement)psiElement, commentRef);
        if (injection == null) {
            return false;
        }
        configuration.replaceInjectionsWithUndo(psiElement.getProject(), psiElement.getContainingFile(), ContainerUtil.emptyList(), Collections.singletonList(injection), ContainerUtil.createMaybeSingletonList((Object)((PsiElement)commentRef.get())));
        return true;
    }

    @Nullable
    private static JSTaggedLiteralInjection editTaggedLiteralInjection(@NotNull JSTaggedLiteralInjection taggedLiteralInjection, @NotNull Project project) {
        if (taggedLiteralInjection == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(8);
        }
        JSTaggedLiteralPanel panel = new JSTaggedLiteralPanel(taggedLiteralInjection, project);
        panel.reset();
        return JSLanguageInjectionSupport.showEditInjectionDialog((Project)project, (AbstractInjectionPanel)panel, null, (String)"reference.settings.language.injection.jstagged.template") ? taggedLiteralInjection : null;
    }

    public BaseInjection createInjection(Element element2) {
        if (!element2.getChildren("templateTag").isEmpty()) {
            return new JSTaggedLiteralInjection();
        }
        return new JSInjection(this.getId());
    }

    @Nullable
    private static PsiElement findCommentOwner(@NotNull PsiLanguageInjectionHost injectionHost) {
        if (injectionHost == null) {
            JSLanguageInjectionSupport.$$$reportNull$$$0(9);
        }
        PsiElement topElement = JSInjectionUtil.getTopElement(injectionHost);
        return PsiTreeUtil.getParentOfType((PsiElement)topElement, (Class[])new Class[]{JSSourceElement.class, JSProperty.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageID";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taggedLiteralInjection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternClasses";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/intelliLang/inject/JSLanguageInjectionSupport";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAddCommentAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCommentBeforeHost";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findCommentInjection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "editTaggedLiteralInjection";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findCommentOwner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

