/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamesValidator
implements NamesValidator {
    protected final Lexer myLexer;
    private final DialectOptionHolder myDialect;

    protected JSNamesValidator(DialectOptionHolder optionHolder) {
        this.myLexer = new JSFlexAdapter(optionHolder);
        this.myDialect = optionHolder;
    }

    public boolean isKeyword(@NotNull String name, Project project) {
        if (name == null) {
            JSNamesValidator.$$$reportNull$$$0(0);
        }
        return this.isToken(name, JSNamesValidator.getKeywords(this.myDialect));
    }

    public boolean isIdentifier(@NotNull String name, Project project) {
        if (name == null) {
            JSNamesValidator.$$$reportNull$$$0(1);
        }
        return this.isToken(name, JSPsiImplUtils.getIdentifiers(this.myDialect));
    }

    protected synchronized boolean isToken(@NotNull CharSequence name, TokenSet tokenSet) {
        if (name == null) {
            JSNamesValidator.$$$reportNull$$$0(2);
        }
        this.myLexer.start(name);
        return tokenSet.contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    @NotNull
    private static TokenSet getKeywords(@Nullable DialectOptionHolder dialect) {
        if (dialect != null) {
            if (dialect.isECMA4) {
                TokenSet tokenSet = JSKeywordSets.AS_KEYWORDS;
                if (tokenSet == null) {
                    JSNamesValidator.$$$reportNull$$$0(3);
                }
                return tokenSet;
            }
            if (dialect.isECMA6) {
                TokenSet tokenSet = JSKeywordSets.ES6_RESERVED_WORDS;
                if (tokenSet == null) {
                    JSNamesValidator.$$$reportNull$$$0(4);
                }
                return tokenSet;
            }
        }
        TokenSet tokenSet = JSKeywordSets.JS_RESERVED_AND_STRICT_KEYWORDS;
        if (tokenSet == null) {
            JSNamesValidator.$$$reportNull$$$0(5);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSNamesValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSNamesValidator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIdentifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isToken";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

