/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParameterGenericId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RecursionCounter {
    private static final int MAX_SUBSTITUTION_LIMIT = 100;
    private static final int MAX_GENERIC_TYPES_LIMIT = 20;
    private int myCounter;
    @NotNull
    private final Set<JSResolvedTypeId> myRawVisited;
    @NotNull
    private final Map<JSResolvedTypeId, Integer> myGenericVisited;
    private static final Logger LOG = Logger.getInstance(RecursionCounter.class);

    public RecursionCounter() {
        this.myCounter = 0;
        this.myRawVisited = new HashSet<JSResolvedTypeId>();
        this.myGenericVisited = new HashMap<JSResolvedTypeId, Integer>();
    }

    public RecursionCounter(@NotNull RecursionCounter old) {
        if (old == null) {
            RecursionCounter.$$$reportNull$$$0(0);
        }
        this.myCounter = old.myCounter;
        this.myRawVisited = new HashSet<JSResolvedTypeId>(old.myRawVisited);
        this.myGenericVisited = new HashMap<JSResolvedTypeId, Integer>(old.myGenericVisited);
    }

    public boolean isVisited(@NotNull JSResolvedTypeId id) {
        if (id == null) {
            RecursionCounter.$$$reportNull$$$0(1);
        }
        return this.myRawVisited.contains(id);
    }

    public boolean add(@NotNull JSType originalType, @NotNull List<JSType> genericArguments) {
        if (originalType == null) {
            RecursionCounter.$$$reportNull$$$0(2);
        }
        if (genericArguments == null) {
            RecursionCounter.$$$reportNull$$$0(3);
        }
        if (!this.checkLimit()) {
            LOG.error("Possibly infinite type substitution " + originalType.getTypeText());
            return false;
        }
        if (!this.addInternal(originalType, genericArguments)) {
            if (JSEvaluatorComplexityTracker.isAssertOnPrevention()) {
                throw new StackOverflowPreventedException("Infinite type substitution " + originalType.getTypeText());
            }
            return false;
        }
        return true;
    }

    private boolean addInternal(@NotNull JSType originalType, @NotNull List<JSType> genericArguments) {
        if (originalType == null) {
            RecursionCounter.$$$reportNull$$$0(4);
        }
        if (genericArguments == null) {
            RecursionCounter.$$$reportNull$$$0(5);
        }
        ++this.myCounter;
        JSResolvedTypeId id = originalType.getResolvedTypeId();
        if (genericArguments.isEmpty()) {
            return this.myRawVisited.add(id);
        }
        Integer genericsCounter = this.myGenericVisited.get(id);
        if (genericsCounter == null) {
            this.myGenericVisited.put(id, 1);
            return true;
        }
        Integer n = genericsCounter;
        genericsCounter = genericsCounter + 1;
        this.myGenericVisited.put(id, genericsCounter);
        return genericsCounter < 20;
    }

    private boolean checkLimit() {
        return this.myCounter < 100;
    }

    public boolean isEmpty() {
        return this.myRawVisited.isEmpty();
    }

    @Nullable
    public JSType getGenericParameterTypeFromHierarchyForMappedType(@NotNull JSGenericParameterType parameterType) {
        JSTypeGenericId genericId;
        if (parameterType == null) {
            RecursionCounter.$$$reportNull$$$0(6);
        }
        if (!((genericId = parameterType.getGenericId()) instanceof TypeScriptTypeParameterGenericId)) {
            return null;
        }
        PsiElement owner = ((TypeScriptTypeParameterGenericId)genericId).getOwner();
        if (!(owner instanceof TypeScriptTypeParameterListOwner)) {
            return null;
        }
        TypeScriptGenericOrMappedTypeParameter typeParameter = ((TypeScriptTypeParameterListOwner)owner).getTypeParameter(genericId.getName());
        int index = ArrayUtil.indexOf((Object[])((TypeScriptTypeParameterListOwner)owner).getTypeParameters(), (Object)typeParameter);
        if (index < 0) {
            return null;
        }
        for (JSResolvedTypeId id : this.myRawVisited) {
            List<JSType> arguments;
            JSType innerType;
            JSType ownerType = id.getOwnerType();
            if (!(ownerType instanceof JSGenericTypeImpl) || !((innerType = ((JSGenericTypeImpl)ownerType).getType()) instanceof JSTypeImpl) || !((JSTypeImpl)innerType).resolveType().getDeclarations().contains(owner) || index >= (arguments = ((JSGenericTypeImpl)ownerType).getArguments()).size()) continue;
            return arguments.get(index);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericArguments";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/RecursionCounter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisited";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addInternal";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getGenericParameterTypeFromHierarchyForMappedType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

