/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class ES6ConvertVarToLetConstInspectionBase
extends JSInspection {
    public boolean myConservativeOption = !ApplicationManager.getApplication().isUnitTestMode();
    @TestOnly
    public boolean myEmulateBatch = false;
    @TestOnly
    public boolean myEmulateDoNotShow = false;
    private static final Set<Class<?>> ourBlockLikeTypes = new HashSet();

    protected static boolean isAvailableForStatement(@NotNull JSVarStatement node) {
        JSAttributeList list;
        if (node == null) {
            ES6ConvertVarToLetConstInspectionBase.$$$reportNull$$$0(0);
        }
        if ((list = node.getAttributeList()) == null) {
            return true;
        }
        return !list.hasModifier(JSAttributeList.ModifierType.EXPORT) && !list.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    protected boolean checkHighlightLevel(@NotNull JSVarStatement node) {
        if (node == null) {
            ES6ConvertVarToLetConstInspectionBase.$$$reportNull$$$0(1);
        }
        if (this.myEmulateDoNotShow && ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        return InspectionProjectProfileManager.isInformationLevel((String)this.getShortName(), (PsiElement)node);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myConservativeOption", (String)JavaScriptBundle.message("js.convert.var.to.let.or.const.inspection.conservative.option", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(JavaScriptBundle.message("js.convert.var.to.let.or.const.inspection.conservative.option.description", new Object[0]))});
        if (optPane == null) {
            ES6ConvertVarToLetConstInspectionBase.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static boolean isBlockLike(@NotNull PsiElement element2) {
        Class<?> clazz;
        if (element2 == null) {
            ES6ConvertVarToLetConstInspectionBase.$$$reportNull$$$0(3);
        }
        if (!JSStatement.class.isAssignableFrom(clazz = element2.getClass())) {
            return false;
        }
        for (Class<?> type2 : ourBlockLikeTypes) {
            if (!type2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    static ScopeInfo getScopeInformation(PsiElement element2) {
        ScopeInfo scope2 = new ScopeInfo();
        PsiElement current = element2.getParent();
        while (current != null && (scope2.functionParent == null || scope2.blockParent == null)) {
            if (JSUtils.isScopeOwner(current)) {
                scope2.functionParent = (JSNamedElement)current;
            } else if (scope2.blockParent == null && ES6ConvertVarToLetConstInspectionBase.isBlockLike(current)) {
                JSVarStatement forDeclaration;
                if (scope2.wrappingBlockParent == null && current instanceof JSVariableDeclaringScope && (forDeclaration = ((JSVariableDeclaringScope)current).getVarDeclaration()) != null) {
                    scope2.wrappingBlockParent = current;
                    if (PsiTreeUtil.isAncestor((PsiElement)forDeclaration, (PsiElement)element2, (boolean)false)) {
                        current = current.getParent();
                        continue;
                    }
                }
                scope2.blockParent = current;
            }
            if (current instanceof PsiFile || (scope2.isEmbedded = current instanceof JSEmbeddedContent)) {
                scope2.topLevel = true;
                break;
            }
            current = current.getParent();
        }
        if (scope2.wrappingBlockParent == null) {
            scope2.wrappingBlockParent = scope2.blockParent;
        }
        return scope2;
    }

    static Pair<List<JSVariable>, Boolean> findDuplicates(@NotNull JSVariable variable, @NotNull PsiElement variableScopeElement, @Nullable PsiElement variableBlockScope) {
        if (variable == null) {
            ES6ConvertVarToLetConstInspectionBase.$$$reportNull$$$0(4);
        }
        if (variableScopeElement == null) {
            ES6ConvertVarToLetConstInspectionBase.$$$reportNull$$$0(5);
        }
        ArrayList varDuplicates = new ArrayList();
        ArrayList letConstDuplicates = new ArrayList();
        Ref success = new Ref((Object)true);
        JSTreeUtil.JSScopeNamesUsages usages = JSTreeUtil.getScopeNamesUsages((CompositeElement)variableScopeElement.getNode());
        Stream.concat(Stream.of(usages.rootUsages.get(variable.getName())), usages.blockUsages.values().stream().map(it -> (JSTreeUtil.JSScopeDeclarationsAndAssignments)it.get(variable.getName()))).flatMap(it -> it != null ? it.getElements().stream() : Stream.empty()).forEach(compositeElement -> {
            PsiElement element2 = compositeElement.getPsi();
            if (!PsiTreeUtil.isAncestor((PsiElement)variableScopeElement, (PsiElement)element2, (boolean)false)) {
                return;
            }
            if (element2 instanceof JSVariable && element2 != variable) {
                if (element2.getParent() != null && element2.getParent().getNode().findChildByType(JSTokenTypes.VAR_KEYWORD) == null) {
                    letConstDuplicates.add((JSVariable)element2);
                } else {
                    varDuplicates.add((JSVariable)element2);
                }
            }
        });
        if (!letConstDuplicates.isEmpty()) {
            boolean conflicting = false;
            HashSet<PsiElement> varDuplicatesBlocks = new HashSet<PsiElement>();
            if (variableBlockScope == null) {
                varDuplicatesBlocks.add(variableScopeElement);
            } else {
                varDuplicatesBlocks.add(variableBlockScope);
            }
            for (JSVariable duplicate : varDuplicates) {
                varDuplicatesBlocks.add(ES6ConvertVarToLetConstInspectionBase.getBlockScope((PsiElement)duplicate, variableScopeElement));
            }
            block1: for (JSVariable letConst : letConstDuplicates) {
                PsiElement block = ES6ConvertVarToLetConstInspectionBase.getBlockScope((PsiElement)letConst, variableScopeElement);
                if (varDuplicatesBlocks.contains(block)) {
                    conflicting = true;
                    break;
                }
                for (PsiElement duplicatesBlock : varDuplicatesBlocks) {
                    if (!PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)duplicatesBlock, (boolean)false)) continue;
                    conflicting = true;
                    continue block1;
                }
            }
            success.set((Object)(!conflicting ? 1 : 0));
        }
        return Pair.create(varDuplicates, (Object)((Boolean)success.get()));
    }

    static PsiElement getBlockScope(PsiElement element2, PsiElement stopParent) {
        PsiElement current;
        for (current = element2.getParent(); current != null && !ES6ConvertVarToLetConstInspectionBase.isBlockLike(current) && current != stopParent; current = current.getParent()) {
        }
        return current;
    }

    static {
        Collections.addAll(ourBlockLikeTypes, JSBlockStatement.class, JSIfStatement.class, JSForInStatement.class, JSLoopStatement.class, JSSwitchStatement.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableScopeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForStatement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkHighlightLevel";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isBlockLike";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static class ScopeInfo {
        boolean isEmbedded;
        boolean topLevel = false;
        PsiElement blockParent = null;
        PsiElement wrappingBlockParent = null;
        JSNamedElement functionParent = null;

        ScopeInfo() {
        }
    }
}

