/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSFunctionExpressionToArrowFunctionQuickFix
extends LocalQuickFixOnPsiElement
implements HighPriorityAction {
    public JSFunctionExpressionToArrowFunctionQuickFix(JSFunctionExpression node) {
        super((PsiElement)node);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.to.arrow.function", new Object[0]);
        if (string == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(3);
        }
        if (startElement == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(5);
        }
        JSFunctionExpression functionExpression = (JSFunctionExpression)startElement;
        JSFunctionExpressionToArrowFunctionQuickFix.rebindInnerNameReferencesIfNeeded(functionExpression);
        JSFunctionExpression arrowFunction = JSFunctionsRefactoringUtil.createArrowFunction(functionExpression);
        boolean wrapWithParenthesis = functionExpression.getParent() instanceof JSReferenceExpression;
        JSExpression expression = JSChangeUtil.replaceExpression(functionExpression, wrapWithParenthesis ? JSChangeUtil.wrapInParentheses(arrowFunction) : arrowFunction);
        JSRefactoringUtil.reformatElementWithoutBody((PsiElement)expression, (PsiElement)expression);
    }

    private static void rebindInnerNameReferencesIfNeeded(@NotNull JSFunctionExpression functionExpression) {
        JSQualifiedNamedElement assigned;
        if (functionExpression == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(6);
        }
        if ((assigned = functionExpression.getElementAssignedTo()) != null) {
            PsiTreeUtil.processElements((PsiElement)functionExpression, element2 -> {
                JSReferenceExpression referenceExpression;
                if (element2 instanceof JSReferenceExpression && (referenceExpression = (JSReferenceExpression)element2).isReferenceTo(functionExpression)) {
                    referenceExpression.bindToElement((PsiElement)assigned);
                }
                return true;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rebindInnerNameReferencesIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

