/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.gist;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubValueMap<T> {
    private static final StubValueMap<Object> EMPTY = new StubValueMap(Collections.emptyMap());
    private static final Logger LOG = Logger.getInstance(StubValueMap.class);
    @NotNull
    private final Map<Integer, T> myMap;
    @Nullable
    private final SegmentedData myData;

    public StubValueMap(@NotNull ConcurrentHashMap<Integer, T> map2) {
        if (map2 == null) {
            StubValueMap.$$$reportNull$$$0(0);
        }
        this((Map<Integer, T>)map2);
    }

    private StubValueMap(@NotNull Map<Integer, T> map2) {
        if (map2 == null) {
            StubValueMap.$$$reportNull$$$0(1);
        }
        this.myMap = map2;
        this.myData = null;
    }

    private StubValueMap(@NotNull SegmentedData data2) {
        if (data2 == null) {
            StubValueMap.$$$reportNull$$$0(2);
        }
        this.myMap = new ConcurrentHashMap<Integer, T>();
        this.myData = data2;
    }

    @Nullable
    public T get(int stubId, DataExternalizer<T> valueExternalizer) {
        T value = this.myMap.get(stubId);
        if (value != null) {
            return value;
        }
        if (this.myData == null) {
            LOG.error("stubId + " + stubId + " not found");
            return null;
        }
        value = this.myData.read(stubId, valueExternalizer);
        this.myMap.put(stubId, value);
        return value;
    }

    @NotNull
    public static <T> DataExternalizer<StubValueMap<T>> createExternalizer(final @NotNull DataExternalizer<T> valueExternalizer) {
        if (valueExternalizer == null) {
            StubValueMap.$$$reportNull$$$0(3);
        }
        return new DataExternalizer<StubValueMap<T>>(){

            public void save(@NotNull DataOutput out, StubValueMap<T> value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(byteArray);
                Int2IntOpenHashMap offsets = new Int2IntOpenHashMap();
                for (Map.Entry entry : value.myMap.entrySet()) {
                    offsets.put(entry.getKey().intValue(), dataOut.size());
                    valueExternalizer.save((DataOutput)dataOut, entry.getValue());
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)offsets.size());
                for (Int2IntMap.Entry entry : offsets.int2IntEntrySet()) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getIntKey());
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)entry.getIntValue());
                }
                byte[] data2 = byteArray.toByteArray();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)data2.length);
                out.write(data2);
            }

            public StubValueMap<T> read(@NotNull DataInput in) throws IOException {
                int size;
                if (in == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((size = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
                    DataInputOutputUtil.readINT((DataInput)in);
                    return EMPTY;
                }
                Int2IntOpenHashMap offsets = new Int2IntOpenHashMap();
                for (int i = 0; i < size; ++i) {
                    int stubId = DataInputOutputUtil.readINT((DataInput)in);
                    int offset = DataInputOutputUtil.readINT((DataInput)in);
                    offsets.put(stubId, offset);
                }
                int dataSize = DataInputOutputUtil.readINT((DataInput)in);
                byte[] data2 = new byte[dataSize];
                in.readFully(data2);
                return new StubValueMap(new SegmentedData((Int2IntMap)offsets, data2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/index/gist/StubValueMap$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/index/gist/StubValueMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createExternalizer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SegmentedData {
        @NotNull
        private final Int2IntMap myOffsets;
        private final byte @NotNull [] myData;

        private SegmentedData(@NotNull Int2IntMap offsets, byte @NotNull [] data2) {
            if (offsets == null) {
                SegmentedData.$$$reportNull$$$0(0);
            }
            if (data2 == null) {
                SegmentedData.$$$reportNull$$$0(1);
            }
            this.myOffsets = offsets;
            this.myData = data2;
        }

        @Nullable
        <T> T read(int stubId, DataExternalizer<T> externalizer) {
            int offset = this.myOffsets.getOrDefault(stubId, -1);
            if (offset == -1) {
                LOG.error("offset for " + stubId + " not found");
                return null;
            }
            try {
                return (T)externalizer.read((DataInput)new DataInputStream(new ByteArrayInputStream(this.myData, offset, this.myData.length - offset)));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "offsets";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "data";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/index/gist/StubValueMap$SegmentedData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

