/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config;

import com.intellij.lang.ecmascript6.index.ES6FileIncludeProvider;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSFileImportsBase;
import com.intellij.lang.javascript.config.JSFileImportsResolver;
import com.intellij.lang.javascript.config.JSFileInclude;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.config.JSSimpleFileInclude;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000fJ\u0013\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/config/JSFileImportsImpl;", "Lcom/intellij/lang/javascript/config/JSFileImportsBase;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/lang/javascript/config/JSConfig;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSConfig;)V", "simpleFileInclude", "Lcom/intellij/lang/javascript/config/JSSimpleFileInclude;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/config/JSSimpleFileInclude;)V", "myIncludeScope", "Lcom/intellij/lang/javascript/config/JSFileInclude;", "getOutFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "processReferencedFilesUsingPsi", "", "rootFiles", "", "getRootFiles", "()Ljava/util/Set;", "equals", "o", "", "hashCode", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSFileImportsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSFileImportsImpl.kt\ncom/intellij/lang/javascript/config/JSFileImportsImpl\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n19#2:75\n1617#3,9:76\n1869#3:85\n1870#3:87\n1626#3:88\n1869#3,2:89\n1#4:86\n*S KotlinDebug\n*F\n+ 1 JSFileImportsImpl.kt\ncom/intellij/lang/javascript/config/JSFileImportsImpl\n*L\n31#1:75\n33#1:76,9\n33#1:85\n33#1:87\n33#1:88\n58#1:89,2\n33#1:86\n*E\n"})
public final class JSFileImportsImpl
extends JSFileImportsBase {
    @NotNull
    private final JSFileInclude myIncludeScope;

    public JSFileImportsImpl(@NotNull Project project, @NotNull JSConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(project, config);
        JSFileInclude jSFileInclude = config.getInclude();
        Intrinsics.checkNotNullExpressionValue((Object)jSFileInclude, (String)"getInclude(...)");
        this.myIncludeScope = jSFileInclude;
    }

    public JSFileImportsImpl(@NotNull Project project, @NotNull JSSimpleFileInclude simpleFileInclude) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)simpleFileInclude, (String)"simpleFileInclude");
        JSImportResolveContext jSImportResolveContext = simpleFileInclude.getResolveContext();
        Intrinsics.checkNotNullExpressionValue((Object)jSImportResolveContext, (String)"getResolveContext(...)");
        JSFileImportsResolver jSFileImportsResolver = simpleFileInclude.getImportResolver();
        Intrinsics.checkNotNullExpressionValue((Object)jSFileImportsResolver, (String)"getImportResolver(...)");
        super(project, jSImportResolveContext, jSFileImportsResolver);
        this.myIncludeScope = simpleFileInclude;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<VirtualFile> getOutFiles(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.processReferencedFilesUsingPsi(file)) {
            List list;
            Set<String> set;
            JSFile jSFile;
            PsiFile psiFile;
            PsiFile $this$asSafely$iv = psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file);
            boolean $i$f$asSafely = false;
            PsiFile psiFile2 = $this$asSafely$iv;
            if (!(psiFile2 instanceof JSFile)) {
                psiFile2 = null;
            }
            if ((jSFile = (JSFile)psiFile2) != null && (set = jSFile.getReferencedPaths()) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = set;
                boolean $i$f$mapNotNull = false;
                void var8_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    String string = ES6FileIncludeProvider.preProcessPath(it);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"preProcessPath(...)");
                    if (this.resolveFile(string, file) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            return list;
        }
        Stream stream = FileIncludeIndex.getIncludes((VirtualFile)file, (Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"getIncludes(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence((Stream)stream), arg_0 -> JSFileImportsImpl.getOutFiles$lambda$1(this, file, arg_0)));
    }

    public final boolean processReferencedFilesUsingPsi(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof VirtualFileWithId)) {
            return true;
        }
        return TypeScriptLibraryProvider.checkLibraryFile(this.getProject(), file);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRootFiles() {
        GlobalSearchScope globalSearchScope = this.myIncludeScope.getRootScope(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getRootScope(...)");
        GlobalSearchScope scope2 = globalSearchScope;
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.getMyResolver().processAllFilesInScope(scope2, (Processor<? super VirtualFile>)((Processor)processor));
        Set<VirtualFile> set = this.myIncludeScope.getAdditionalRootFiles(this.getProject());
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAdditionalRootFiles(...)");
        Set<VirtualFile> additionalFiles = set;
        Iterable $this$forEach$iv = additionalFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            processor.process((Object)it);
        }
        Collection collection = processor.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
        return CollectionsKt.toMutableSet((Iterable)collection);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSFileImportsImpl imports = (JSFileImportsImpl)o;
        return Intrinsics.areEqual((Object)this.myIncludeScope, (Object)imports.myIncludeScope);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{super.hashCode(), this.myIncludeScope};
        return Objects.hash(objectArray);
    }

    private static final VirtualFile getOutFiles$lambda$1(JSFileImportsImpl this$0, VirtualFile $file, FileIncludeInfo it) {
        String string = it.path;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return this$0.resolveFile(string, $file);
    }
}

