/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.coverage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public final class FileModificationsSettledDownTracker {
    private static final Logger LOG = Logger.getInstance(FileModificationsSettledDownTracker.class);
    private final String myFilePath;
    private final int myFileExistenceChecks;
    private final int myFileExistenceCheckIntervalMillis;
    private final int myFileModificationChecks;
    private final int myFileModificationCheckIntervalMillis;
    private final BooleanSupplier myValidCondition;
    private final Runnable myFileModificationsSettledDownCallback;
    private final long myOutdatedFileLastModified;
    private volatile boolean myStopped;
    private final long myStartTimeNano;

    /*
     * WARNING - void declaration
     */
    public FileModificationsSettledDownTracker(@NotNull String filePath, int fileExistenceChecks, int fileExistenceCheckIntervalMillis, int fileModificationChecks, int fileModificationCheckIntervalMillis, long outdatedFileLastModified, @NotNull BooleanSupplier validCondition, @NotNull Runnable runnable) {
        void fileModificationsSettledDownCallback;
        if (filePath == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(0);
        }
        if (validCondition == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(1);
        }
        if (runnable == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(2);
        }
        this.myStopped = false;
        this.myStartTimeNano = System.nanoTime();
        this.myFilePath = filePath;
        this.myFileExistenceChecks = fileExistenceChecks;
        this.myFileExistenceCheckIntervalMillis = fileExistenceCheckIntervalMillis;
        this.myFileModificationChecks = fileModificationChecks;
        this.myFileModificationCheckIntervalMillis = fileModificationCheckIntervalMillis;
        this.myOutdatedFileLastModified = outdatedFileLastModified;
        this.myValidCondition = validCondition;
        this.myFileModificationsSettledDownCallback = fileModificationsSettledDownCallback;
        this.checkFileExistence(0);
    }

    private void checkFileExistence(int performedChecks) {
        FileModificationsSettledDownTracker.scheduleOnPooledThread(() -> {
            if (this.isAborted(performedChecks)) {
                return;
            }
            if (performedChecks >= this.myFileExistenceChecks) {
                LOG.info(this.getPrefix(performedChecks) + "Too long waiting for " + this.myFilePath + ", isFile: " + new File(this.myFilePath).isFile() + ", lastModified: " + new File(this.myFilePath).lastModified() + ", outdatedLastModified: " + this.myOutdatedFileLastModified + ", performed checks: " + this.myFileExistenceChecks + ", delay between checks: " + this.myFileExistenceCheckIntervalMillis + " ms");
                return;
            }
            File file = new File(this.myFilePath);
            if (!file.isFile()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getPrefix(performedChecks) + "No such file " + this.myFilePath);
                }
                this.checkFileExistence(performedChecks + 1);
                return;
            }
            long lastModified = file.lastModified();
            if (lastModified == this.myOutdatedFileLastModified) {
                LOG.info(this.getPrefix(performedChecks) + "Outdated file " + this.myFilePath + ", lastModified: " + lastModified + ", outdatedLastModified: " + this.myOutdatedFileLastModified);
                this.checkFileExistence(performedChecks + 1);
                return;
            }
            LOG.info(this.getPrefix(performedChecks) + "Updated file " + this.myFilePath + ", lastModified: " + lastModified + ", outdatedLastModified: " + this.myOutdatedFileLastModified + ", starting modification checks");
            this.checkFileModification(0, lastModified);
        }, this.myFileExistenceCheckIntervalMillis);
    }

    private void checkFileModification(int performedChecks, long prevLastModified) {
        FileModificationsSettledDownTracker.scheduleOnPooledThread(() -> {
            if (this.isAborted(performedChecks)) {
                return;
            }
            File file = new File(this.myFilePath);
            if (!file.isFile()) {
                LOG.info(this.getPrefix(performedChecks) + "Not a file " + this.myFilePath + ", aborting");
                return;
            }
            long lastModified = file.lastModified();
            if (lastModified == prevLastModified) {
                LOG.info(this.getPrefix(performedChecks) + "File " + this.myFilePath + " hasn't been modified for " + this.myFileModificationCheckIntervalMillis + " ms, lastModified: " + lastModified + ". Success!");
                this.myFileModificationsSettledDownCallback.run();
                return;
            }
            if (performedChecks >= this.myFileModificationChecks) {
                LOG.info(this.getPrefix(performedChecks) + "Constantly modified " + this.myFilePath + ", done " + this.myFileModificationChecks + " checks with " + this.myFileModificationCheckIntervalMillis + " ms delay. Aborting");
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.getPrefix(performedChecks) + "Found modifications for " + this.myFilePath);
            }
            this.checkFileModification(performedChecks + 1, lastModified);
        }, this.myFileModificationCheckIntervalMillis);
    }

    private boolean isAborted(int performedChecks) {
        if (this.myStopped) {
            LOG.info(this.getPrefix(performedChecks) + "Stopped, aborting");
            return true;
        }
        if (!this.myValidCondition.getAsBoolean()) {
            LOG.info(this.getPrefix(performedChecks) + "Invalid condition, aborting");
            return true;
        }
        return false;
    }

    @NotNull
    private String getPrefix(int performedChecks) {
        String string = "[#" + (performedChecks + 1) + ", passed " + TimeoutUtil.getDurationMillis((long)this.myStartTimeNano) + "ms] ";
        if (string == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void stop() {
        this.myStopped = true;
    }

    private static void scheduleOnPooledThread(@NotNull Runnable runnable, int delayMillis) {
        if (runnable == null) {
            FileModificationsSettledDownTracker.$$$reportNull$$$0(4);
        }
        AppExecutorUtil.getAppScheduledExecutorService().schedule(runnable, (long)delayMillis, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validCondition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileModificationsSettledDownCallback";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/coverage/FileModificationsSettledDownTracker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/coverage/FileModificationsSettledDownTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleOnPooledThread";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

