/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.references;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.PuppetRubyPluginsIndex;
import com.intellij.lang.puppet.psi.PuppetResourceDeclarationBase;
import com.intellij.lang.puppet.psi.PuppetTypeDefinition;
import com.intellij.lang.puppet.psi.references.PuppetParameterReferenceBase;
import com.intellij.lang.puppet.psi.resolve.PuppetNamedPsiElementProcessor;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetTypeStubIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class PuppetTypeParameterReference
extends PuppetParameterReferenceBase {
    public PuppetTypeParameterReference(PsiElement psiElement) {
        super(psiElement);
    }

    @Override
    protected boolean processCandidates(@NotNull String paramName, @NotNull PuppetNamedPsiElementProcessor processor) {
        if (paramName == null) {
            PuppetTypeParameterReference.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PuppetTypeParameterReference.$$$reportNull$$$0(1);
        }
        PuppetResourceDeclarationBase resourceDeclaration = (PuppetResourceDeclarationBase)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PuppetResourceDeclarationBase.class);
        assert (resourceDeclaration != null);
        String typeName = resourceDeclaration.getEffectiveTypeName();
        if (typeName == null) {
            return true;
        }
        if (StringUtil.isEmpty((String)(typeName = StringUtil.trimStart((String)typeName, (String)"::")))) {
            return true;
        }
        boolean[] foundInRuby = new boolean[]{false};
        PuppetRubyPluginsIndex.processElementParameters(PuppetRubyPluginsIndex.SymbolType.TYPE, typeName, resourceDeclaration.getProject(), resourceDeclaration.getResolveScope(), (name, element) -> {
            foundInRuby[0] = foundInRuby[0] || StringUtil.equals((CharSequence)paramName, (CharSequence)name);
            processor.executeWithName(name, element);
        });
        if (foundInRuby[0]) {
            return true;
        }
        PsiElementProcessor variableProcessor = variable -> {
            String variableName = variable.getName();
            if (StringUtil.isNotEmpty((String)variableName)) {
                processor.executeWithName(variableName, variable);
            }
            return true;
        };
        for (PuppetTypeDefinition typeDefinition : PuppetTypeStubIndex.getInstance().find(typeName, this.myElement)) {
            typeDefinition.processParametersDeclarations(variableProcessor);
        }
        for (PuppetTypeDefinition typeDefinition : PuppetTypeStubIndex.getMetaparametersContainingTypes(this.myElement)) {
            typeDefinition.processParametersDeclarations(variableProcessor);
        }
        return true;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = PuppetBundle.message("puppet.type.names.type.parameter", new Object[0]);
        if (string == null) {
            PuppetTypeParameterReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/psi/references/PuppetTypeParameterReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/psi/references/PuppetTypeParameterReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

