/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.ruby;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.ide.navigation.plugins.PuppetExtFunctionInfo;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.RubyFunctionIndexer;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.RubyTypeIndexer;
import com.intellij.lang.puppet.psi.PuppetLazyProxyLightElement;
import com.intellij.lang.puppet.psi.resolve.PuppetNamedPsiElementProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class PuppetRubyPluginsIndex
extends FileBasedIndexExtension<EntryKey, PuppetExtFunctionInfo> {
    public static final ID<EntryKey, PuppetExtFunctionInfo> KEY = ID.create((String)"PuppetRubyPluginsIndex");
    private static final MyKeyDescriptor KEY_DESCRIPTOR = new MyKeyDescriptor();
    private static final int VERSION = 3;
    private static final String EXT_RUBY = "rb";

    @NotNull
    public ID<EntryKey, PuppetExtFunctionInfo> getName() {
        ID<EntryKey, PuppetExtFunctionInfo> iD = KEY;
        if (iD == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent> getIndexer() {
        return new DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent>(){

            @NotNull
            public Map<EntryKey, PuppetExtFunctionInfo> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                VirtualFile file = inputData.getFile();
                SymbolType symbolType = PuppetRubyPluginsIndex.getSymbolTypeByFileLocation(file);
                assert (symbolType != null) : "Input filter should have filtered this!";
                Map map = symbolType.myIndexer.map((Object)inputData);
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public KeyDescriptor<EntryKey> getKeyDescriptor() {
        MyKeyDescriptor myKeyDescriptor = KEY_DESCRIPTOR;
        if (myKeyDescriptor == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(1);
        }
        return myKeyDescriptor;
    }

    @NotNull
    public DataExternalizer<PuppetExtFunctionInfo> getValueExternalizer() {
        DataExternalizer<PuppetExtFunctionInfo> dataExternalizer = PuppetExtFunctionInfo.EXTERNALIZER;
        if (dataExternalizer == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        final FileBasedIndex.InputFilter filter = file -> {
            if (!EXT_RUBY.equals(file.getExtension())) {
                return false;
            }
            return PuppetRubyPluginsIndex.getSymbolTypeByFileLocation(file) != null;
        };
        FileType rubyFileType = FileTypeManager.getInstance().getFileTypeByExtension(EXT_RUBY);
        if (rubyFileType == UnknownFileType.INSTANCE) {
            FileBasedIndex.InputFilter inputFilter = filter;
            if (inputFilter == null) {
                PuppetRubyPluginsIndex.$$$reportNull$$$0(3);
            }
            return inputFilter;
        }
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{rubyFileType}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return filter.acceptInput(file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$2", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 3;
    }

    public static List<PsiElement> findElementsByKey(@NotNull SymbolType type, @NotNull String key, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(4);
        }
        if (key == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(7);
        }
        @NotNull List<Pair<PuppetExtFunctionInfo, VirtualFile>> values = PuppetRubyPluginsIndex.getSymbolsByKey(type, key, searchScope);
        return ContainerUtil.mapNotNull(values, info -> PuppetRubyPluginsIndex.getLightProxyElement(project, key, (VirtualFile)info.getSecond(), ((PuppetExtFunctionInfo)info.getFirst()).getOffsetInFile(), type));
    }

    @NotNull
    public static List<Pair<PuppetExtFunctionInfo, VirtualFile>> getSymbolsByKey(@NotNull SymbolType type, @NotNull String key, @NotNull GlobalSearchScope searchScope) {
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(8);
        }
        if (key == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(10);
        }
        SmartList result = new SmartList();
        FileBasedIndex.getInstance().processValues(KEY, (Object)new EntryKey(type, key), null, (arg_0, arg_1) -> PuppetRubyPluginsIndex.lambda$getSymbolsByKey$2((List)result, arg_0, arg_1), searchScope);
        SmartList smartList = result;
        if (smartList == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    public static void processElementParameters(@NotNull SymbolType type, @NotNull String key, @NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull PuppetNamedPsiElementProcessor processor) {
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(12);
        }
        if (key == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(16);
        }
        for (Pair<PuppetExtFunctionInfo, VirtualFile> typeInfo : PuppetRubyPluginsIndex.getSymbolsByKey(type, key, searchScope)) {
            for (PuppetExtFunctionInfo.PuppetExtParamInfo info : ((PuppetExtFunctionInfo)typeInfo.getFirst()).getParamInfos()) {
                String paramName = info.getParamName();
                processor.executeWithName(paramName, PuppetRubyPluginsIndex.getLightProxyElement(project, paramName, (VirtualFile)typeInfo.getSecond(), info.getOffsetInFile(), type));
            }
        }
    }

    @NotNull
    private static PsiElement getLightProxyElement(@NotNull Project project, @NotNull String name, @NotNull VirtualFile file, int offset, SymbolType type) {
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(17);
        }
        if (name == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(18);
        }
        if (file == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(19);
        }
        return new PuppetLazyProxyLightElement(project, name, file, offset, type.getTypeName());
    }

    public static void processAllElements(@NotNull SymbolType symbolType, @NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull PuppetNamedPsiElementProcessor processor) {
        if (symbolType == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(20);
        }
        if (project == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(21);
        }
        if (searchScope == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(23);
        }
        FileBasedIndex.getInstance().processAllKeys(KEY, s -> {
            if (s.mySymbolType != symbolType) {
                return true;
            }
            for (PsiElement targetElement : PuppetRubyPluginsIndex.findElementsByKey(symbolType, s.mySymbolName, project, searchScope)) {
                processor.executeWithName(s.mySymbolName, targetElement);
            }
            return true;
        }, project);
    }

    @Nullable
    private static SymbolType getSymbolTypeByFileLocation(@NotNull VirtualFile file) {
        if (file == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(24);
        }
        assert (!file.isDirectory());
        for (SymbolType type : SymbolType.values()) {
            if (!PuppetRubyPluginsIndex.isInLocationForType(file, type)) continue;
            return type;
        }
        return null;
    }

    private static boolean isInLocationForType(@NotNull VirtualFile file, @NotNull SymbolType type) {
        if (file == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(25);
        }
        if (type == null) {
            PuppetRubyPluginsIndex.$$$reportNull$$$0(26);
        }
        Collection<List<String>> locations = type.myLocations;
        VirtualFile currentDir = file;
        block0: for (List<String> location : locations) {
            for (int i = location.size() - 1; i >= 0; --i) {
                VirtualFile nextDir = currentDir.getParent();
                if (nextDir == null || !nextDir.getName().equals(location.get(i))) continue block0;
                currentDir = nextDir;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$getSymbolsByKey$2(List result, VirtualFile file, PuppetExtFunctionInfo value) {
        result.add(Pair.create((Object)value, (Object)file));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolsByKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByKey";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolsByKey";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processElementParameters";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLightProxyElement";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processAllElements";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolTypeByFileLocation";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isInLocationForType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26 -> new IllegalArgumentException(string);
        };
    }

    private static class MyKeyDescriptor
    implements KeyDescriptor<EntryKey> {
        private MyKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, EntryKey value) throws IOException {
            if (out == null) {
                MyKeyDescriptor.$$$reportNull$$$0(0);
            }
            out.writeUTF(value.mySymbolType.name());
            out.writeUTF(value.mySymbolName);
        }

        public EntryKey read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                MyKeyDescriptor.$$$reportNull$$$0(1);
            }
            String typeName = in.readUTF();
            String symbolName = in.readUTF();
            return new EntryKey(SymbolType.valueOf(typeName), symbolName);
        }

        public int getHashCode(EntryKey value) {
            return value.hashCode();
        }

        public boolean isEqual(EntryKey val1, EntryKey val2) {
            return val1.equals(val2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$MyKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum SymbolType {
        FUNCTION(Arrays.asList(Arrays.asList("lib", "puppet", "parser", "functions"), Arrays.asList("lib", "stubs")), new RubyFunctionIndexer(), "puppet.type.names.function_definition"),
        TYPE(Collections.singletonList(Arrays.asList("lib", "puppet", "type")), new RubyTypeIndexer(), "puppet.type.names.resource_definition");

        @NotNull
        private final Collection<List<String>> myLocations;
        @NotNull
        private final DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent> myIndexer;
        @NotNull
        private final String myKey;

        private SymbolType(@NotNull @PropertyKey(resourceBundle="messages.PuppetBundle") @NotNull @PropertyKey(resourceBundle="messages.PuppetBundle") Collection<List<String>> locations, DataIndexer<EntryKey, PuppetExtFunctionInfo, FileContent> indexer, String key) {
            if (locations == null) {
                SymbolType.$$$reportNull$$$0(0);
            }
            if (indexer == null) {
                SymbolType.$$$reportNull$$$0(1);
            }
            if (key == null) {
                SymbolType.$$$reportNull$$$0(2);
            }
            this.myLocations = locations;
            this.myIndexer = indexer;
            this.myKey = key;
        }

        @NotNull
        @Nls
        public String getTypeName() {
            String string = PuppetBundle.message(this.myKey, new Object[0]);
            if (string == null) {
                SymbolType.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locations";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$SymbolType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$SymbolType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class EntryKey {
        @NotNull
        private final SymbolType mySymbolType;
        @NotNull
        private final String mySymbolName;

        EntryKey(@NotNull SymbolType symbolType, @NotNull String symbolName) {
            if (symbolType == null) {
                EntryKey.$$$reportNull$$$0(0);
            }
            if (symbolName == null) {
                EntryKey.$$$reportNull$$$0(1);
            }
            this.mySymbolType = symbolType;
            this.mySymbolName = symbolName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryKey key = (EntryKey)o;
            if (this.mySymbolType != key.mySymbolType) {
                return false;
            }
            return this.mySymbolName.equals(key.mySymbolName);
        }

        public int hashCode() {
            int result = this.mySymbolType.name().hashCode();
            result = 31 * result + this.mySymbolName.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbolType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbolName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/puppet/ide/navigation/plugins/ruby/PuppetRubyPluginsIndex$EntryKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

