/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.microservices.ui.diagrams.model.MsDiagramElement;
import com.intellij.microservices.ui.diagrams.serialization.MsDiagramElementJsonConverter;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/microservices/ui/diagrams/serialization/MsDiagramVfsResolver;", "Lcom/intellij/diagram/DiagramVfsResolver;", "Lcom/intellij/microservices/ui/diagrams/model/MsDiagramElement;", "<init>", "()V", "getQualifiedName", "", "element", "resolveElementByFQN", "fqn", "project", "Lcom/intellij/openapi/project/Project;", "createGsonBuilder", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "intellij.microservices.ui.diagrams"})
@SourceDebugExtension(value={"SMAP\nMsDiagramVfsResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsDiagramVfsResolver.kt\ncom/intellij/microservices/ui/diagrams/serialization/MsDiagramVfsResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,28:1\n1#2:29\n*E\n"})
public final class MsDiagramVfsResolver
implements DiagramVfsResolver<MsDiagramElement> {
    @Nullable
    public String getQualifiedName(@Nullable MsDiagramElement element) {
        String string;
        MsDiagramElement msDiagramElement = element;
        if (msDiagramElement != null && (msDiagramElement = msDiagramElement.getProject()) != null) {
            MsDiagramElement it = msDiagramElement;
            boolean bl = false;
            string = this.createGsonBuilder((Project)it).toJson((Object)element, (Type)((Object)MsDiagramElement.class));
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public MsDiagramElement resolveElementByFQN(@NotNull String fqn, @NotNull Project project) {
        MsDiagramElement msDiagramElement;
        Intrinsics.checkNotNullParameter((Object)fqn, (String)"fqn");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            msDiagramElement = (MsDiagramElement)this.createGsonBuilder(project).fromJson(fqn, MsDiagramElement.class);
        }
        catch (JsonSyntaxException e) {
            msDiagramElement = null;
        }
        return msDiagramElement;
    }

    private final Gson createGsonBuilder(Project project) {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)MsDiagramElement.class), (Object)new MsDiagramElementJsonConverter(project)).create();
    }
}

