/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.css.inspections.invalid.CssValueInspectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssInvalidPropertyValueInspection
extends CssBaseInspection {
    private static final CssPropertyInvalidValueRangeProvider INVALID_VALUE_RANGE_PROVIDER = new CssPropertyInvalidValueRangeProvider();

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidPropertyValueInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            @Override
            public void visitCssDeclaration(@NotNull CssDeclaration declaration) {
                Collection<? extends CssPropertyDescriptor> descriptors;
                if (declaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((descriptors = CssInvalidPropertyValueInspection.getFilteredPropertyDescriptors(declaration)).isEmpty()) {
                    return;
                }
                CssValueInspectionUtil.inspectCssValueAgainstDescriptors(descriptors, declaration, holder, "css.inspections.property.mismatched.values", INVALID_VALUE_RANGE_PROVIDER, true, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$1", "visitCssDeclaration"));
            }
        };
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getFilteredPropertyDescriptors(@NotNull CssDeclaration declaration) {
        Collection<? extends CssPropertyDescriptor> filteredByMediaTypeDescriptors;
        if (declaration == null) {
            CssInvalidPropertyValueInspection.$$$reportNull$$$0(1);
        }
        String name = declaration.getPropertyName();
        PsiElement nameIdentifier = declaration.getPropertyNameElement();
        if (StringUtil.isEmpty((String)name) || nameIdentifier == null) {
            List list = Collections.emptyList();
            if (list == null) {
                CssInvalidPropertyValueInspection.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection<? extends CssPropertyDescriptor> descriptors = declaration.getDescriptors();
        Collection<? extends CssPropertyDescriptor> filteredByContextDescriptors = CssDescriptorsUtil.filterDescriptorsByContext(descriptors, nameIdentifier);
        if (!filteredByContextDescriptors.isEmpty() && !(filteredByMediaTypeDescriptors = CssDescriptorsUtil.filterDescriptorsByMediaType(descriptors = filteredByContextDescriptors, nameIdentifier)).isEmpty()) {
            descriptors = filteredByMediaTypeDescriptors;
        }
        Collection<? extends CssPropertyDescriptor> collection = descriptors;
        if (collection == null) {
            CssInvalidPropertyValueInspection.$$$reportNull$$$0(3);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredPropertyDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredPropertyDescriptors";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class CssPropertyInvalidValueRangeProvider
    extends CssInspectionsUtil.CssInvalidValueRangeProvider {
        private CssPropertyInvalidValueRangeProvider() {
        }

        @Override
        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                CssPropertyInvalidValueRangeProvider.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CssPropertyInvalidValueRangeProvider.$$$reportNull$$$0(1);
            }
            if (valueOwner instanceof CssDeclaration) {
                int endOfValue;
                int startOfInvalidElements;
                TextRange range;
                CssDeclaration declaration = (CssDeclaration)valueOwner;
                TextRange declarationTextRange = declaration.getTextRange();
                int declarationStartOffset = declarationTextRange.getStartOffset();
                if (lastMatchedElement != null && !(range = TextRange.create((int)(startOfInvalidElements = lastMatchedElement.getTextRange().getEndOffset()), (int)(endOfValue = Math.max(declaration.getTrimmedValueTextRange().getEndOffset(), startOfInvalidElements)))).isEmpty()) {
                    return range.shiftRight(-declarationStartOffset);
                }
            }
            return super.calculateInvalidRange(valueOwner, lastMatchedElement, defaultValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidPropertyValueInspection$CssPropertyInvalidValueRangeProvider";
            objectArray[2] = "calculateInvalidRange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

