/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssUnusedSymbolUtils;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

class CssUnusedSymbolVisitor
extends PsiElementVisitor {
    private final ProblemsHolder myHolder;
    private final boolean myOnTheFly;

    CssUnusedSymbolVisitor(ProblemsHolder holder, boolean onTheFly) {
        this.myHolder = holder;
        this.myOnTheFly = onTheFly;
    }

    public void visitFile(@NotNull PsiFile psiFile) {
        boolean fragment;
        boolean nonTrivialInjection;
        if (psiFile == null) {
            CssUnusedSymbolVisitor.$$$reportNull$$$0(0);
        }
        boolean bl = nonTrivialInjection = (fragment = InjectedLanguageManager.getInstance((Project)psiFile.getProject()).isInjectedFragment(psiFile)) && psiFile.textContains('\n');
        if (CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)psiFile) && !(psiFile instanceof StylesheetFile) || psiFile instanceof StylesheetFile && (nonTrivialInjection || !this.myOnTheFly && !fragment)) {
            CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider((PsiElement)psiFile);
            boolean checkIds = descriptorProvider == null || descriptorProvider.providesClassicCss();
            psiFile.accept((PsiElementVisitor)new MyRecursiveElementVisitor(this.myHolder, this.myOnTheFly, psiFile, checkIds));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/psi/css/inspections/CssUnusedSymbolVisitor", "visitFile"));
    }

    private static class MyRecursiveElementVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myCheckIds;
        private final SearchScope myScope;

        MyRecursiveElementVisitor(ProblemsHolder holder, boolean onTheFly, PsiFile file, boolean checkIds) {
            super(false);
            this.myHolder = holder;
            this.myCheckIds = checkIds;
            this.myScope = onTheFly ? CssUtil.getUseScope(file) : GlobalSearchScope.projectScope((Project)file.getProject());
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                MyRecursiveElementVisitor.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            CssSelectorSuffix suffix = (CssSelectorSuffix)ObjectUtils.tryCast((Object)element, CssSelectorSuffix.class);
            if (suffix != null && suffix.getName() != null && CssUnusedSymbolUtils.isUnused(suffix, this.myScope, this.myCheckIds)) {
                String name = suffix.getName();
                this.myHolder.registerProblem(element, CssBundle.message("css.inspections.unused.symbol.text", name), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{CssFixFactory.getInstance().removeUnusedSymbolIntentionAction(name)});
            }
            super.visitElement(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/CssUnusedSymbolVisitor$MyRecursiveElementVisitor", "visitElement"));
        }
    }
}

