/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.rearranger;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.rearranger.CssArrangementEntry;
import com.intellij.lang.css.rearranger.CssArrangementVisitor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.StylesheetFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssRearranger
implements Rearranger<CssArrangementEntry>,
ArrangementStandardSettingsAware {
    public static final StdArrangementMatchRule SORT_BY_NAME_RULE = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)".*")), StdArrangementTokens.Order.BY_NAME);
    private static final StdArrangementSettings DEFAULT_SETTINGS = new StdArrangementSettings();
    private static final ArrangementSettingsSerializer SETTINGS_SERIALIZER = new DefaultArrangementSettingsSerializer(DEFAULT_SETTINGS);

    public static boolean isSortPropertiesByName(ArrangementSettings arrangementSettings) {
        List rules = ArrangementUtil.collectMatchRules((List)arrangementSettings.getSections());
        return rules.size() == 1 && ((ArrangementMatchRule)rules.get(0)).equals((Object)SORT_BY_NAME_RULE);
    }

    @Nullable
    public Pair<CssArrangementEntry, List<CssArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<? extends TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            CssRearranger.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            CssRearranger.$$$reportNull$$$0(1);
        }
        if (element == null) {
            CssRearranger.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            CssRearranger.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public List<CssArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<? extends TextRange> ranges, @NotNull ArrangementSettings arrangementSettings) {
        if (root == null) {
            CssRearranger.$$$reportNull$$$0(4);
        }
        if (ranges == null) {
            CssRearranger.$$$reportNull$$$0(5);
        }
        if (arrangementSettings == null) {
            CssRearranger.$$$reportNull$$$0(6);
        }
        CssStylesheet stylesheet = null;
        if (root instanceof StylesheetFile) {
            stylesheet = ((StylesheetFile)root).getStylesheet();
        } else if (root instanceof CssStylesheet) {
            stylesheet = (CssStylesheet)root;
        }
        if (stylesheet == null) {
            List<CssArrangementEntry> list = Collections.emptyList();
            if (list == null) {
                CssRearranger.$$$reportNull$$$0(7);
            }
            return list;
        }
        CssArrangementVisitor visitor = new CssArrangementVisitor(ranges, CssRearranger.isSortPropertiesByName(arrangementSettings), root.getLanguage());
        visitor.visitCssStylesheet(stylesheet);
        List<CssArrangementEntry> list = visitor.getTopLevelEntries();
        if (list == null) {
            CssRearranger.$$$reportNull$$$0(8);
        }
        return list;
    }

    public int getBlankLines(@NotNull CodeStyleSettings settings, @Nullable CssArrangementEntry parent, @Nullable CssArrangementEntry previous, @NotNull CssArrangementEntry target) {
        if (settings == null) {
            CssRearranger.$$$reportNull$$$0(9);
        }
        if (target == null) {
            CssRearranger.$$$reportNull$$$0(10);
        }
        return -1;
    }

    @NotNull
    public ArrangementSettingsSerializer getSerializer() {
        ArrangementSettingsSerializer arrangementSettingsSerializer = SETTINGS_SERIALIZER;
        if (arrangementSettingsSerializer == null) {
            CssRearranger.$$$reportNull$$$0(11);
        }
        return arrangementSettingsSerializer;
    }

    @Nullable
    public StdArrangementSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return null;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return List.of(new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME}));
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition condition) {
        if (token == null) {
            CssRearranger.$$$reportNull$$$0(12);
        }
        return token.equals((Object)StdArrangementTokens.Regexp.NAME) || token.equals((Object)StdArrangementTokens.Order.KEEP) || token.equals((Object)StdArrangementTokens.Order.BY_NAME);
    }

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            CssRearranger.$$$reportNull$$$0(13);
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        List<Set<ArrangementSettingsToken>> list = Collections.emptyList();
        if (list == null) {
            CssRearranger.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public Collection<ArrangementStandardSettingsAware.ArrangementTabInfo> getArrangementTabInfos() {
        String cssLanguageDisplayName = CSSLanguage.INSTANCE.getDisplayName();
        Language scssLanguage = Language.findLanguageByID((String)"SCSS");
        if (scssLanguage != null) {
            Icon scssIcon;
            LanguageFileType scssFileType = FileTypeRegistry.getInstance().findFileTypeByLanguage(scssLanguage);
            Icon icon = scssIcon = scssFileType != null ? scssFileType.getIcon() : null;
            if (scssIcon == null) {
                scssIcon = AllIcons.FileTypes.Css;
            }
            List<ArrangementStandardSettingsAware.ArrangementTabInfo> list = List.of(new ArrangementStandardSettingsAware.ArrangementTabInfo(AllIcons.FileTypes.Css, cssLanguageDisplayName, CodeStyleSettings.generateConfigurableIdByLanguage((Language)CSSLanguage.INSTANCE)), new ArrangementStandardSettingsAware.ArrangementTabInfo(scssIcon, scssLanguage.getDisplayName(), CodeStyleSettings.generateConfigurableIdByLanguage((Language)scssLanguage)));
            if (list == null) {
                CssRearranger.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<ArrangementStandardSettingsAware.ArrangementTabInfo> list = List.of(new ArrangementStandardSettingsAware.ArrangementTabInfo(AllIcons.FileTypes.Css, cssLanguageDisplayName, CodeStyleSettings.generateConfigurableIdByLanguage((Language)CSSLanguage.INSTANCE)));
        if (list == null) {
            CssRearranger.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 11, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrangementSettings";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/rearranger/CssRearranger";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/rearranger/CssRearranger";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializer";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutexes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrangementTabInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseWithNew";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBlankLines";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 11, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

