/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.vfs2.FileSystemException;

public class MonitorOutputStream
extends BufferedOutputStream {
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public MonitorOutputStream(OutputStream out) {
        super(out);
    }

    public MonitorOutputStream(OutputStream out, int bufferSize) {
        super(out, bufferSize);
    }

    protected void assertOpen() throws FileSystemException {
        if (this.isClosed()) {
            throw new FileSystemException("vfs.provider/closed.error");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        IOException exc = null;
        try {
            super.flush();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.out.close();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.onClose();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        if (exc != null) {
            throw exc;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.isClosed()) {
            return;
        }
        super.flush();
    }

    private boolean isClosed() {
        return this.closed.get();
    }

    protected void onClose() throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.assertOpen();
        super.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.assertOpen();
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.assertOpen();
        super.write(b);
    }
}

