/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.grpc.restClient.execution;

import com.intellij.httpClient.execution.common.CommonClientResponse;
import com.intellij.httpClient.execution.common.RequestHandler;
import com.intellij.httpClient.execution.common.RunContext;
import com.intellij.httpClient.grpc.GrpcBundle;
import com.intellij.httpClient.grpc.requests.GrpcRequestManager;
import com.intellij.httpClient.grpc.requests.RejectedRPCException;
import com.intellij.httpClient.grpc.restClient.execution.GrpcRequest;
import java.net.ConnectException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequestHandler;", "Lcom/intellij/httpClient/execution/common/RequestHandler;", "Lcom/intellij/httpClient/grpc/restClient/execution/GrpcRequest;", "<init>", "()V", "prepareExecutionEnvironment", "", "request", "runContext", "Lcom/intellij/httpClient/execution/common/RunContext;", "execute", "Lcom/intellij/httpClient/execution/common/CommonClientResponse;", "intellij.httpClient.grpc"})
public final class GrpcRequestHandler
implements RequestHandler<GrpcRequest> {
    public void prepareExecutionEnvironment(@NotNull GrpcRequest request, @NotNull RunContext runContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
    }

    @NotNull
    public CommonClientResponse execute(@NotNull GrpcRequest request, @NotNull RunContext runContext) {
        CommonClientResponse commonClientResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)runContext, (String)"runContext");
        try {
            commonClientResponse = GrpcRequestManager.executeCallSynchronously$default((GrpcRequestManager)runContext.getProject().getService(GrpcRequestManager.class), request, false, 2, null);
        }
        catch (Exception exception) {
            RejectedRPCException rejectedRPCException;
            Throwable cause = exception.getCause();
            if (exception instanceof RejectedRPCException) {
                rejectedRPCException = (RejectedRPCException)exception;
            } else if (exception instanceof ConnectException) {
                var7_6 = new Object[]{request.getAuthority()};
                RejectedRPCException rejectedRPCException2 = new RejectedRPCException(GrpcBundle.INSTANCE.message("connection.refused.0", var7_6), exception);
                rejectedRPCException = rejectedRPCException2;
            } else if (cause instanceof ConnectException) {
                var7_6 = new Object[]{request.getAuthority()};
                RejectedRPCException rejectedRPCException3 = new RejectedRPCException(GrpcBundle.INSTANCE.message("connection.refused.0", var7_6), cause);
                rejectedRPCException = rejectedRPCException3;
            } else if (cause != null) {
                var7_6 = new Object[1];
                String string = cause.getMessage();
                if (string == null) {
                    string = "";
                }
                var7_6[0] = string;
                RejectedRPCException rejectedRPCException4 = new RejectedRPCException(GrpcBundle.INSTANCE.message("request.ended.with.exception.0", var7_6), cause);
                rejectedRPCException = rejectedRPCException4;
            } else {
                var7_6 = new Object[1];
                String string = exception.getMessage();
                if (string == null) {
                    string = "";
                }
                var7_6[0] = string;
                RejectedRPCException rejectedRPCException5 = new RejectedRPCException(GrpcBundle.INSTANCE.message("request.ended.with.exception.0", var7_6), exception);
                rejectedRPCException = rejectedRPCException5;
            }
            RejectedRPCException effectiveExceptionToRethrow = rejectedRPCException;
            throw effectiveExceptionToRethrow;
        }
        return commonClientResponse;
    }
}

