/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.data;

import com.jetbrains.nodejs.NodeJSBundle;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public enum V8HeapNodeType {
    kHidden(0, "hidden", NodeJSBundle.messagePointer("profile.cpu.node_type.hidden.description", new Object[0])),
    kArray(1, "array", NodeJSBundle.messagePointer("profile.cpu.node_type.array.description", new Object[0])),
    kString(2, "string", NodeJSBundle.messagePointer("profile.cpu.node_type.string.description", new Object[0])),
    kObject(3, "object", NodeJSBundle.messagePointer("profile.cpu.node_type.object.description", new Object[0])),
    kCode(4, "compiled code", NodeJSBundle.messagePointer("profile.cpu.node_type.compiled_code.description", new Object[0])),
    kClosure(5, "closure", NodeJSBundle.messagePointer("profile.cpu.node_type.closure.description", new Object[0])),
    kRegExp(6, "regexp", NodeJSBundle.messagePointer("profile.cpu.node_type.regexp.description", new Object[0])),
    kHeapNumber(7, "number", NodeJSBundle.messagePointer("profile.cpu.node_type.number.description", new Object[0])),
    kNative(8, "native", NodeJSBundle.messagePointer("profile.cpu.node_type.native.description", new Object[0])),
    kSynthetic(9, "synthetic", NodeJSBundle.messagePointer("profile.cpu.node_type.synthetic.description", new Object[0])),
    kConsString(10, "concatenated string", NodeJSBundle.messagePointer("profile.cpu.node_type.concatenated_string.description", new Object[0])),
    kSlicedString(11, "sliced string", NodeJSBundle.messagePointer("profile.cpu.node_type.sliced_string.description", new Object[0])),
    kSymbol(12, "Symbol", NodeJSBundle.messagePointer("profile.cpu.node_type.symbol.description", new Object[0])),
    kBigInt(13, "BigInt", NodeJSBundle.messagePointer("profile.cpu.node_type.bigint.description", new Object[0])),
    kObjectShape(14, "Object Shape", NodeJSBundle.messagePointer("profile.cpu.node_type.ObjectShape.description", new Object[0]));

    private final int myNumber;
    @Nls
    private final String myName;
    private final Supplier<@Nls String> myDescriptionSupplier;

    private V8HeapNodeType(@Nls /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nls @Nls int number, String name, Supplier<String> descriptionSupplier) {
        this.myNumber = number;
        this.myName = name;
        this.myDescriptionSupplier = descriptionSupplier;
        Inner.ourMap.put(number, this);
    }

    @Nullable
    public static V8HeapNodeType getByNumber(int number) {
        return Inner.ourMap.get(number);
    }

    public int getNumber() {
        return this.myNumber;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    @Nls
    public String getDescription() {
        return this.myDescriptionSupplier.get();
    }

    public boolean isStringType() {
        return this == kConsString || this == kSlicedString || this == kString;
    }

    private static class Inner {
        private static final Map<Integer, V8HeapNodeType> ourMap = new HashMap<Integer, V8HeapNodeType>();

        private Inner() {
        }
    }
}

