/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitExecutionUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitRunProfileState;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettingsSerializationUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import com.jetbrains.nodejs.nodeunit.execution.ui.NodeunitSettingsEditor;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeunitRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption {
    private NodeunitSettings mySettings;

    public NodeunitRunConfiguration(@NotNull Project project, ConfigurationFactory factory, String name) {
        if (project == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(0);
        }
        super(project, factory, name);
        this.mySettings = new NodeunitSettings.Builder().build();
    }

    public void onNewConfigurationCreated() {
        VirtualFile dir;
        if (this.mySettings.getWorkingDirectory().isEmpty() && (dir = this.getProject().getBaseDir()) != null) {
            this.mySettings = this.mySettings.builder().setWorkingDirectory(dir.getPath()).build();
        }
        if (this.mySettings.getTestType() == NodeunitTestType.DIRECTORY && this.mySettings.getDirectory().isEmpty()) {
            String workingDirPath = this.mySettings.getWorkingDirectory();
            VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(workingDirPath);
            if (workingDir != null && workingDir.isValid() && workingDir.isDirectory()) {
                String testDirName;
                String[] testDirNames = new String[]{"test", "spec", "tests", "specs"};
                VirtualFile testDir = null;
                String[] stringArray = testDirNames;
                int n = stringArray.length;
                for (int i = 0; !(i >= n || (testDir = workingDir.findChild(testDirName = stringArray[i])) != null && testDir.isValid() && testDir.isDirectory()); ++i) {
                }
                if (testDir != null) {
                    this.mySettings = this.mySettings.builder().setDirectory(testDir.getPath()).build();
                }
            }
        }
        if (this.mySettings.getNodeunitPackage().isEmptyPath()) {
            NodeJsInterpreter interpreter = this.mySettings.getInterpreterRef().resolve(this.getProject());
            NodePackage pkg = NodeunitExecutionUtils.PKG.findFirstDirectDependencyPackage(this.getProject(), interpreter, null);
            this.mySettings = this.mySettings.builder().setNodeunitPackage(pkg).build();
        }
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new NodeunitSettingsEditor(this.getProject());
    }

    @NotNull
    public NodeunitSettings getSettings() {
        NodeunitSettings nodeunitSettings = this.mySettings;
        if (nodeunitSettings == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(1);
        }
        return nodeunitSettings;
    }

    public void setSettings(@NotNull NodeunitSettings settings) {
        if (settings == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(2);
        }
        this.mySettings = settings;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        NodeunitSettings settings = NodeunitSettingsSerializationUtils.readFromJDomElement(element);
        this.setSettings(settings);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(4);
        }
        super.writeExternal(element);
        NodeunitSettingsSerializationUtils.writeToJDomElement(element, this.mySettings);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        if (executor == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(5);
        }
        if (environment == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(6);
        }
        return new NodeunitRunProfileState(environment, this.mySettings);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeunitExecutionUtils.checkConfiguration(this.getProject(), this.mySettings);
    }

    @NotNull
    public String suggestedName() {
        NodeunitSettings settings = this.getSettings();
        if (settings.getTestType() == NodeunitTestType.DIRECTORY) {
            if (!settings.getDirectory().isEmpty()) {
                String string = NodeJSBundle.message("nodeunit.rc.run.all.in.label", settings.getDirectory());
                if (string == null) {
                    NodeunitRunConfiguration.$$$reportNull$$$0(7);
                }
                return string;
            }
        } else if (!settings.getJsFile().isEmpty()) {
            String string = settings.getJsFile();
            if (string == null) {
                NodeunitRunConfiguration.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = NodeJSBundle.message("nodeunit.rc.unnamed.label", new Object[0]);
        if (string == null) {
            NodeunitRunConfiguration.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.mySettings.getInterpreterRef().resolve(this.getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

