/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl.operations;

import com.intellij.dataWrangler.annotations.CommandParameterName;
import com.intellij.dataWrangler.annotations.DWCollectionItemType;
import com.intellij.dataWrangler.annotations.DWParameterType;
import com.intellij.dataWrangler.annotations.DisplayNameProvider;
import com.intellij.dataWrangler.annotations.FloatValuesProvider;
import com.intellij.dataWrangler.annotations.IntValuesProvider;
import com.intellij.dataWrangler.annotations.PossibleValuesProvider;
import com.intellij.dataWrangler.annotations.StringValuesProvider;
import com.intellij.dataWrangler.annotations.ValueDisplayNameProvider;
import com.intellij.dataWrangler.annotations.ValuesProvider;
import com.intellij.dataWrangler.impl.operations.DWTypeDesc;
import com.intellij.dataWrangler.impl.operations.DWTypeSource;
import com.intellij.dataWrangler.impl.operations.DWTypesKt;
import com.intellij.dataWrangler.impl.operations.EnumPossibleValuesProvider;
import com.intellij.dataWrangler.impl.operations.FixedPossibleValuesProvider;
import java.lang.annotation.Annotation;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020+H\u0002J\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cJ\u000e\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0002J\b\u00101\u001a\u00020+H\u0002JW\u00102\u001a\u00020+\"\b\b\u0001\u00103*\u00020\u00022\b\u00104\u001a\u0004\u0018\u0001H32\b\u00105\u001a\u0004\u0018\u0001H32\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u0001072\u001b\u00108\u001a\u0017\u0012\u0004\u0012\u0002H3\u0012\b\u0012\u0006\u0012\u0002\b\u00030709\u00a2\u0006\u0002\b:H\u0082\b\u00a2\u0006\u0002\u0010;J\u001c\u0010<\u001a\u00020%*\u0006\u0012\u0002\b\u0003072\n\u0010=\u001a\u0006\u0012\u0002\b\u000307H\u0002J\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0002J\b\u0010A\u001a\u00020+H\u0002J\u0014\u0010B\u001a\u00020+2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J(\u0010C\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u0016\"\b\b\u0001\u0010\u0001*\u00020\u00022\f\u00106\u001a\b\u0012\u0004\u0012\u0002H\u000107H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R \u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006D"}, d2={"Lcom/intellij/dataWrangler/impl/operations/DWTypeBuilder;", "V", "", "source", "Lcom/intellij/dataWrangler/impl/operations/DWTypeSource;", "<init>", "(Lcom/intellij/dataWrangler/impl/operations/DWTypeSource;)V", "getSource", "()Lcom/intellij/dataWrangler/impl/operations/DWTypeSource;", "defaultName", "", "getDefaultName", "()Ljava/lang/String;", "setDefaultName", "(Ljava/lang/String;)V", "displayName", "Lcom/intellij/dataWrangler/annotations/DisplayNameProvider;", "getDisplayName", "()Lcom/intellij/dataWrangler/annotations/DisplayNameProvider;", "setDisplayName", "(Lcom/intellij/dataWrangler/annotations/DisplayNameProvider;)V", "possibleValues", "Lcom/intellij/dataWrangler/annotations/PossibleValuesProvider;", "getPossibleValues", "()Lcom/intellij/dataWrangler/annotations/PossibleValuesProvider;", "setPossibleValues", "(Lcom/intellij/dataWrangler/annotations/PossibleValuesProvider;)V", "collectionItemType", "Lcom/intellij/dataWrangler/impl/operations/DWTypeDesc;", "getCollectionItemType", "()Lcom/intellij/dataWrangler/impl/operations/DWTypeDesc;", "setCollectionItemType", "(Lcom/intellij/dataWrangler/impl/operations/DWTypeDesc;)V", "parent", "getParent", "setParent", "hasTypeAnnotation", "", "getHasTypeAnnotation", "()Z", "setHasTypeAnnotation", "(Z)V", "processAnnotation", "", "annotation", "", "validateValues", "build", "create", "finalValidate", "validateInheritedTypes", "T", "x", "parentX", "targetType", "Lkotlin/reflect/KClass;", "getType", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;)V", "isAssignableFrom", "other", "createCollection", "itemType", "createPrimitive", "detectValues", "inheritValues", "detectPossibleValuesProvider", "intellij.dataWrangler.impl"})
@SourceDebugExtension(value={"SMAP\nDWTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DWTypes.kt\ncom/intellij/dataWrangler/impl/operations/DWTypeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,296:1\n124#1,9:298\n124#1,9:307\n1#2:297\n*S KotlinDebug\n*F\n+ 1 DWTypes.kt\ncom/intellij/dataWrangler/impl/operations/DWTypeBuilder\n*L\n110#1:298,9\n111#1:307,9\n*E\n"})
final class DWTypeBuilder<V> {
    @NotNull
    private final DWTypeSource<V> source;
    @Nullable
    private String defaultName;
    @Nullable
    private DisplayNameProvider<?> displayName;
    @Nullable
    private PossibleValuesProvider<?> possibleValues;
    @Nullable
    private DWTypeDesc<?> collectionItemType;
    @Nullable
    private DWTypeDesc<?> parent;
    private boolean hasTypeAnnotation;

    public DWTypeBuilder(@NotNull DWTypeSource<V> source) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.source = source;
    }

    @NotNull
    public final DWTypeSource<V> getSource() {
        return this.source;
    }

    @Nullable
    public final String getDefaultName() {
        return this.defaultName;
    }

    public final void setDefaultName(@Nullable String string) {
        this.defaultName = string;
    }

    @Nullable
    public final DisplayNameProvider<?> getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(@Nullable DisplayNameProvider<?> displayNameProvider) {
        this.displayName = displayNameProvider;
    }

    @Nullable
    public final PossibleValuesProvider<?> getPossibleValues() {
        return this.possibleValues;
    }

    public final void setPossibleValues(@Nullable PossibleValuesProvider<?> possibleValuesProvider) {
        this.possibleValues = possibleValuesProvider;
    }

    @Nullable
    public final DWTypeDesc<?> getCollectionItemType() {
        return this.collectionItemType;
    }

    public final void setCollectionItemType(@Nullable DWTypeDesc<?> dWTypeDesc) {
        this.collectionItemType = dWTypeDesc;
    }

    @Nullable
    public final DWTypeDesc<?> getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable DWTypeDesc<?> dWTypeDesc) {
        this.parent = dWTypeDesc;
    }

    public final boolean getHasTypeAnnotation() {
        return this.hasTypeAnnotation;
    }

    public final void setHasTypeAnnotation(boolean bl) {
        this.hasTypeAnnotation = bl;
    }

    public final void processAnnotation(@NotNull Annotation annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if (annotation instanceof ValueDisplayNameProvider) {
            this.displayName = (DisplayNameProvider)KClasses.createInstance((KClass)Reflection.getOrCreateKotlinClass((Class)((ValueDisplayNameProvider)annotation).value()));
        } else if (annotation instanceof ValuesProvider) {
            this.possibleValues = (PossibleValuesProvider)KClasses.createInstance((KClass)Reflection.getOrCreateKotlinClass((Class)((ValuesProvider)annotation).value()));
        } else if (annotation instanceof IntValuesProvider) {
            this.possibleValues = new FixedPossibleValuesProvider(ArraysKt.asList((int[])((IntValuesProvider)annotation).value()), Reflection.getOrCreateKotlinClass(Integer.TYPE));
        } else if (annotation instanceof FloatValuesProvider) {
            this.possibleValues = new FixedPossibleValuesProvider(ArraysKt.asList((float[])((FloatValuesProvider)annotation).value()), Reflection.getOrCreateKotlinClass(Float.TYPE));
        } else if (annotation instanceof StringValuesProvider) {
            this.possibleValues = new FixedPossibleValuesProvider(ArraysKt.asList((Object[])((StringValuesProvider)annotation).value()), Reflection.getOrCreateKotlinClass(String.class));
        } else if (annotation instanceof DWCollectionItemType) {
            this.collectionItemType = (DWTypeDesc)DWTypesKt.access$getTypesCache$p().get(Reflection.getOrCreateKotlinClass((Class)((DWCollectionItemType)annotation).value()));
        } else if (annotation instanceof CommandParameterName) {
            this.defaultName = ((CommandParameterName)annotation).value();
        } else if (annotation instanceof DWParameterType) {
            KClass kClass;
            this.hasTypeAnnotation = true;
            KClass it = kClass = Reflection.getOrCreateKotlinClass((Class)((DWParameterType)annotation).extends());
            boolean bl = false;
            Object object = DWTypesKt.access$isDWType(it) ? kClass : null;
            if (object != null) {
                it = object;
                boolean bl2 = false;
                this.parent = (DWTypeDesc)DWTypesKt.access$getTypesCache$p().get(it);
            }
        } else if (DWTypesKt.access$isDWType(JvmClassMappingKt.getAnnotationClass((Annotation)annotation))) {
            this.parent = (DWTypeDesc)DWTypesKt.access$getTypesCache$p().get(JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
        }
    }

    private final void validateValues() {
        if (!this.hasTypeAnnotation && this.source.getType() != null) {
            throw new AssertionError((Object)(this.source + " does not have " + Reflection.getOrCreateKotlinClass(DWParameterType.class).getSimpleName() + " annotation"));
        }
    }

    @NotNull
    public final DWTypeDesc<V> build() {
        this.validateValues();
        DWTypeDesc<?> dWTypeDesc = this.parent;
        if (dWTypeDesc != null) {
            DWTypeDesc<?> it = dWTypeDesc;
            boolean bl = false;
            this.inheritValues(it);
        }
        this.detectValues();
        return this.create();
    }

    private final DWTypeDesc<V> create() {
        this.finalValidate();
        DWTypeDesc<?> itemType = this.collectionItemType;
        return itemType != null ? this.createCollection(itemType) : this.createPrimitive();
    }

    private final void finalValidate() {
        KClass anyTarget;
        Object object;
        KClass kClass;
        KClass kClass2;
        DisplayNameProvider parentX$iv;
        Object $this$finalValidate_u24lambda_u243;
        DWTypeBuilder dWTypeBuilder;
        DWTypeBuilder this_$iv;
        DisplayNameProvider<?> x$iv;
        if (this.parent instanceof DWTypeDesc.DWCollectionTypeDesc && this.collectionItemType == null) {
            throw new AssertionError((Object)(this.source + " inherits collection type " + this.parent + " but has no item type"));
        }
        PossibleValuesProvider<?> possibleValues2 = this.possibleValues;
        DisplayNameProvider<?> displayName = this.displayName;
        if (this.collectionItemType != null) {
            if (possibleValues2 != null) {
                throw new AssertionError((Object)(this.source + " inherits collection type but has " + Reflection.getOrCreateKotlinClass(ValuesProvider.class).getSimpleName()));
            }
            if (displayName != null) {
                throw new AssertionError((Object)(this.source + " inherits collection type but has " + Reflection.getOrCreateKotlinClass(ValueDisplayNameProvider.class).getSimpleName()));
            }
        }
        KClass targetType = this.source.getTargetType();
        DWTypeDesc<?> dWTypeDesc = this.parent;
        DWTypeDesc.DWPrimitiveTypeDesc pPrimitive = dWTypeDesc instanceof DWTypeDesc.DWPrimitiveTypeDesc ? (DWTypeDesc.DWPrimitiveTypeDesc)dWTypeDesc : null;
        dWTypeDesc = this;
        PossibleValuesProvider<?> possibleValuesProvider = possibleValues2;
        DWTypeDesc.DWPrimitiveTypeDesc dWPrimitiveTypeDesc = pPrimitive;
        PossibleValuesProvider possibleValuesProvider2 = dWPrimitiveTypeDesc != null ? dWPrimitiveTypeDesc.getPossibleValues() : null;
        KClass targetType$iv = targetType;
        boolean $i$f$validateInheritedTypes = false;
        if (x$iv != null) {
            boolean bl;
            if (targetType$iv != null) {
                void var10_10 = x$iv;
                dWTypeBuilder = this_$iv;
                bl = false;
                if (!dWTypeBuilder.isAssignableFrom($this$finalValidate_u24lambda_u243.getTargetType(), targetType$iv)) {
                    throw new AssertionError((Object)(this_$iv.source + " uses " + this_$iv.displayName + " that is not applicable"));
                }
            }
            if (parentX$iv != null) {
                $this$finalValidate_u24lambda_u243 = x$iv;
                dWTypeBuilder = this_$iv;
                bl = false;
                $this$finalValidate_u24lambda_u243 = parentX$iv;
                kClass2 = $this$finalValidate_u24lambda_u243.getTargetType();
                bl = false;
                kClass = $this$finalValidate_u24lambda_u243.getTargetType();
                if (!dWTypeBuilder.isAssignableFrom(kClass2, kClass)) {
                    DWTypeDesc<?> dWTypeDesc2 = this_$iv.parent;
                    throw new AssertionError((Object)(this_$iv.source + " uses " + this_$iv.displayName + " and inherits " + (dWTypeDesc2 != null ? dWTypeDesc2.getSource$intellij_dataWrangler_impl() : null) + " that uses " + parentX$iv + " - they are not compatible"));
                }
            }
        }
        this_$iv = this;
        x$iv = displayName;
        DWTypeDesc.DWPrimitiveTypeDesc dWPrimitiveTypeDesc2 = pPrimitive;
        parentX$iv = dWPrimitiveTypeDesc2 != null ? dWPrimitiveTypeDesc2.getDisplayName() : null;
        targetType$iv = targetType;
        $i$f$validateInheritedTypes = false;
        if (x$iv != null) {
            Object $this$finalValidate_u24lambda_u244;
            boolean bl;
            if (targetType$iv != null) {
                $this$finalValidate_u24lambda_u243 = x$iv;
                dWTypeBuilder = this_$iv;
                bl = false;
                if (!dWTypeBuilder.isAssignableFrom($this$finalValidate_u24lambda_u244.getTargetType(), targetType$iv)) {
                    throw new AssertionError((Object)(this_$iv.source + " uses " + this_$iv.displayName + " that is not applicable"));
                }
            }
            if (parentX$iv != null) {
                $this$finalValidate_u24lambda_u244 = x$iv;
                dWTypeBuilder = this_$iv;
                bl = false;
                $this$finalValidate_u24lambda_u244 = parentX$iv;
                kClass2 = $this$finalValidate_u24lambda_u244.getTargetType();
                bl = false;
                kClass = $this$finalValidate_u24lambda_u244.getTargetType();
                if (!dWTypeBuilder.isAssignableFrom(kClass2, kClass)) {
                    DWTypeDesc<?> dWTypeDesc3 = this_$iv.parent;
                    throw new AssertionError((Object)(this_$iv.source + " uses " + this_$iv.displayName + " and inherits " + (dWTypeDesc3 != null ? dWTypeDesc3.getSource$intellij_dataWrangler_impl() : null) + " that uses " + parentX$iv + " - they are not compatible"));
                }
            }
        }
        if ((object = targetType) == null) {
            PossibleValuesProvider<?> possibleValuesProvider3 = possibleValues2;
            object = possibleValuesProvider3 != null ? possibleValuesProvider3.getTargetType() : null;
        }
        if ((anyTarget = object) != null) {
            if (this.collectionItemType != null && !KClasses.isSubclassOf((KClass)anyTarget, (KClass)Reflection.getOrCreateKotlinClass(Collection.class))) {
                throw new AssertionError((Object)(this.source + " inherits collection type but applied to " + targetType));
            }
            if (this.collectionItemType == null && KClasses.isSubclassOf((KClass)anyTarget, (KClass)Reflection.getOrCreateKotlinClass(Collection.class))) {
                throw new AssertionError((Object)(this.source + " does not inherit collection type but applied to collection " + targetType));
            }
        }
    }

    private final <T> void validateInheritedTypes(T x, T parentX, KClass<?> targetType, Function1<? super T, ? extends KClass<?>> getType) {
        boolean $i$f$validateInheritedTypes = false;
        if (x != null) {
            if (targetType != null && !this.isAssignableFrom((KClass)getType.invoke(x), targetType)) {
                throw new AssertionError((Object)(this.source + " uses " + this.displayName + " that is not applicable"));
            }
            if (parentX != null && !this.isAssignableFrom((KClass)getType.invoke(x), (KClass)getType.invoke(parentX))) {
                DWTypeDesc<?> dWTypeDesc = this.parent;
                throw new AssertionError((Object)(this.source + " uses " + this.displayName + " and inherits " + (dWTypeDesc != null ? dWTypeDesc.getSource$intellij_dataWrangler_impl() : null) + " that uses " + parentX + " - they are not compatible"));
            }
        }
    }

    private final boolean isAssignableFrom(KClass<?> $this$isAssignableFrom, KClass<?> other) {
        return JvmClassMappingKt.getJavaClass($this$isAssignableFrom).isAssignableFrom(JvmClassMappingKt.getJavaClass(other));
    }

    private final DWTypeDesc<V> createCollection(DWTypeDesc<?> itemType) {
        DWTypeSource<V> dWTypeSource = this.source;
        Intrinsics.checkNotNull(dWTypeSource, (String)"null cannot be cast to non-null type com.intellij.dataWrangler.impl.operations.DWTypeSource<kotlin.collections.Collection<kotlin.Any>>");
        Intrinsics.checkNotNull(itemType, (String)"null cannot be cast to non-null type com.intellij.dataWrangler.impl.operations.DWTypeDesc<kotlin.Any>");
        return new DWTypeDesc.DWCollectionTypeDesc(dWTypeSource, this.defaultName, itemType, this.parent);
    }

    private final DWTypeDesc<V> createPrimitive() {
        return new DWTypeDesc.DWPrimitiveTypeDesc<V>(this.source, this.defaultName, this.possibleValues, this.displayName, this.parent);
    }

    private final void detectValues() {
        KClass<V> targetType = this.source.getTargetType();
        if (this.possibleValues == null && targetType != null) {
            this.possibleValues = this.detectPossibleValuesProvider(targetType);
        }
        if (this.displayName == null && targetType != null) {
            this.displayName = DWTypesKt.access$detectDisplayNameProvider(targetType);
        }
    }

    private final void inheritValues(DWTypeDesc<?> parent) {
        if (this.defaultName == null) {
            this.defaultName = parent.getDefaultName();
        }
        if (this.possibleValues == null && parent instanceof DWTypeDesc.DWPrimitiveTypeDesc) {
            this.possibleValues = ((DWTypeDesc.DWPrimitiveTypeDesc)parent).getPossibleValues();
        }
        if (this.collectionItemType == null && parent instanceof DWTypeDesc.DWCollectionTypeDesc) {
            this.collectionItemType = ((DWTypeDesc.DWCollectionTypeDesc)parent).getItemType();
        }
    }

    private final <V> PossibleValuesProvider<V> detectPossibleValuesProvider(KClass<V> targetType) {
        if (KClasses.isSubclassOf(targetType, (KClass)Reflection.getOrCreateKotlinClass(Enum.class))) {
            return new EnumPossibleValuesProvider<V>(targetType);
        }
        return null;
    }
}

