/// <reference path="./gsk-4.0.d.ts" />
/// <reference path="./graphene-1.0.d.ts" />
/// <reference path="./gobject-2.0.d.ts" />
/// <reference path="./glib-2.0.d.ts" />
/// <reference path="./gdk-4.0.d.ts" />
/// <reference path="./cairo-1.0.d.ts" />
/// <reference path="./cairo.d.ts" />
/// <reference path="./pangocairo-1.0.d.ts" />
/// <reference path="./pango-1.0.d.ts" />
/// <reference path="./harfbuzz-0.0.d.ts" />
/// <reference path="./freetype2-2.0.d.ts" />
/// <reference path="./gio-2.0.d.ts" />
/// <reference path="./gmodule-2.0.d.ts" />
/// <reference path="./gdkpixbuf-2.0.d.ts" />

/**
 * Type Definitions for Gjs (https://gjs.guide/)
 *
 * These type definitions are automatically generated, do not edit them by hand.
 * If you found a bug fix it in `ts-for-gir` or create a bug report on https://github.com/gjsify/ts-for-gir
 *
 * The based EJS template file is used for the generated .d.ts file of each GIR module like Gtk-4.0, GObject-2.0, ...
 */

declare module 'gi://Gtk?version=4.0' {
    // Module dependencies
    import type Gsk from 'gi://Gsk?version=4.0';
    import type Graphene from 'gi://Graphene?version=1.0';
    import type GObject from 'gi://GObject?version=2.0';
    import type GLib from 'gi://GLib?version=2.0';
    import type Gdk from 'gi://Gdk?version=4.0';
    import type cairo from 'cairo';
    import type PangoCairo from 'gi://PangoCairo?version=1.0';
    import type Pango from 'gi://Pango?version=1.0';
    import type HarfBuzz from 'gi://HarfBuzz?version=0.0';
    import type freetype2 from 'gi://freetype2?version=2.0';
    import type Gio from 'gi://Gio?version=2.0';
    import type GModule from 'gi://GModule?version=2.0';
    import type GdkPixbuf from 'gi://GdkPixbuf?version=2.0';

    export namespace Gtk {
        /**
         * Gtk-4.0
         */

        /**
         * The priority of an accessibility announcement.
         */

        /**
         * The priority of an accessibility announcement.
         */
        export namespace AccessibleAnnouncementPriority {
            export const $gtype: GObject.GType<AccessibleAnnouncementPriority>;
        }

        enum AccessibleAnnouncementPriority {
            /**
             * The announcement is low priority,
             *   and might be read only on the user's request.
             */
            LOW,
            /**
             * The announcement is of medium
             *   priority, and is usually spoken at the next opportunity, such as at the
             *   end of speaking the current sentence or when the user pauses typing.
             */
            MEDIUM,
            /**
             * The announcement is of high
             *   priority, and is usually spoken immediately. Because an interruption
             *   might disorient users or cause them to not complete their current task,
             *   authors SHOULD NOT use high priority announcements unless the
             *   interruption is imperative. An example would be a notification about a
             *   critical battery power level.
             */
            HIGH,
        }
        /**
         * The possible values for the %GTK_ACCESSIBLE_PROPERTY_AUTOCOMPLETE
         * accessible property.
         */

        /**
         * The possible values for the %GTK_ACCESSIBLE_PROPERTY_AUTOCOMPLETE
         * accessible property.
         */
        export namespace AccessibleAutocomplete {
            export const $gtype: GObject.GType<AccessibleAutocomplete>;
        }

        enum AccessibleAutocomplete {
            /**
             * Automatic suggestions are not displayed.
             */
            NONE,
            /**
             * When a user is providing input, text
             *    suggesting one way to complete the provided input may be dynamically
             *    inserted after the caret.
             */
            INLINE,
            /**
             * When a user is providing input, an element
             *    containing a collection of values that could complete the provided input
             *    may be displayed.
             */
            LIST,
            /**
             * When a user is providing input, an element
             *    containing a collection of values that could complete the provided input
             *    may be displayed. If displayed, one value in the collection is automatically
             *    selected, and the text needed to complete the automatically selected value
             *    appears after the caret in the input.
             */
            BOTH,
        }
        /**
         * The possible values for the %GTK_ACCESSIBLE_STATE_INVALID
         * accessible state.
         *
         * Note that the %GTK_ACCESSIBLE_INVALID_FALSE and
         * %GTK_ACCESSIBLE_INVALID_TRUE have the same values
         * as %FALSE and %TRUE.
         */

        /**
         * The possible values for the %GTK_ACCESSIBLE_STATE_INVALID
         * accessible state.
         *
         * Note that the %GTK_ACCESSIBLE_INVALID_FALSE and
         * %GTK_ACCESSIBLE_INVALID_TRUE have the same values
         * as %FALSE and %TRUE.
         */
        export namespace AccessibleInvalidState {
            export const $gtype: GObject.GType<AccessibleInvalidState>;
        }

        enum AccessibleInvalidState {
            /**
             * There are no detected errors in the value
             */
            FALSE,
            /**
             * The value entered by the user has failed validation
             */
            TRUE,
            /**
             * A grammatical error was detected
             */
            GRAMMAR,
            /**
             * A spelling error was detected
             */
            SPELLING,
        }
        /**
         * The various platform states which can be queried
         * using [method`Gtk`.Accessible.get_platform_state].
         */

        /**
         * The various platform states which can be queried
         * using [method`Gtk`.Accessible.get_platform_state].
         */
        export namespace AccessiblePlatformState {
            export const $gtype: GObject.GType<AccessiblePlatformState>;
        }

        enum AccessiblePlatformState {
            /**
             * whether the accessible can be focused
             */
            FOCUSABLE,
            /**
             * whether the accessible has focus
             */
            FOCUSED,
            /**
             * whether the accessible is active
             */
            ACTIVE,
        }
        /**
         * The possible accessible properties of a [iface`Accessible]`.
         */

        /**
         * The possible accessible properties of a [iface`Accessible]`.
         */
        export namespace AccessibleProperty {
            export const $gtype: GObject.GType<AccessibleProperty>;
        }

        enum AccessibleProperty {
            /**
             * Indicates whether inputting text
             *    could trigger display of one or more predictions of the user's intended
             *    value for a combobox, searchbox, or textbox and specifies how predictions
             *    would be presented if they were made. Value type: [enum`AccessibleAutocomplete]`
             */
            AUTOCOMPLETE,
            /**
             * Defines a string value that describes
             *    or annotates the current element. Value type: string
             */
            DESCRIPTION,
            /**
             * Indicates the availability and type of
             *    interactive popup element, such as menu or dialog, that can be triggered
             *    by an element.
             */
            HAS_POPUP,
            /**
             * Indicates keyboard shortcuts that an
             *    author has implemented to activate or give focus to an element. Value type:
             *    string. The format of the value is a space-separated list of shortcuts, with
             *    each shortcut consisting of one or more modifiers (`Control`, `Alt` or `Shift`),
             *    followed by a non-modifier key, all separated by `+`.
             *    Examples: `F2`, `Alt-F`, `Control+Shift+N`
             */
            KEY_SHORTCUTS,
            /**
             * Defines a string value that labels the current
             *    element. Value type: string
             */
            LABEL,
            /**
             * Defines the hierarchical level of an element
             *    within a structure. Value type: integer
             */
            LEVEL,
            /**
             * Indicates whether an element is modal when
             *    displayed. Value type: boolean
             */
            MODAL,
            /**
             * Indicates whether a text box accepts
             *    multiple lines of input or only a single line. Value type: boolean
             */
            MULTI_LINE,
            /**
             * Indicates that the user may select
             *    more than one item from the current selectable descendants. Value type:
             *    boolean
             */
            MULTI_SELECTABLE,
            /**
             * Indicates whether the element's
             *    orientation is horizontal, vertical, or unknown/ambiguous. Value type:
             *    [enum`Orientation]`
             */
            ORIENTATION,
            /**
             * Defines a short hint (a word or short
             *    phrase) intended to aid the user with data entry when the control has no
             *    value. A hint could be a sample value or a brief description of the expected
             *    format. Value type: string
             */
            PLACEHOLDER,
            /**
             * Indicates that the element is not editable,
             *    but is otherwise operable. Value type: boolean
             */
            READ_ONLY,
            /**
             * Indicates that user input is required on
             *    the element before a form may be submitted. Value type: boolean
             */
            REQUIRED,
            /**
             * Defines a human-readable,
             *    author-localized description for the role of an element. Value type: string
             */
            ROLE_DESCRIPTION,
            /**
             * Indicates if items in a table or grid are
             *    sorted in ascending or descending order. Value type: [enum`AccessibleSort]`
             */
            SORT,
            /**
             * Defines the maximum allowed value for a
             *    range widget. Value type: double
             */
            VALUE_MAX,
            /**
             * Defines the minimum allowed value for a
             *    range widget. Value type: double
             */
            VALUE_MIN,
            /**
             * Defines the current value for a range widget.
             *    Value type: double
             */
            VALUE_NOW,
            /**
             * Defines the human readable text alternative
             *    of aria-valuenow for a range widget. Value type: string
             */
            VALUE_TEXT,
            /**
             * Defines a string value that provides a description of non-standard keyboard
             * interactions of the current element. Value type: string
             */
            HELP_TEXT,
        }
        /**
         * The possible accessible relations of a [iface`Accessible]`.
         *
         * Accessible relations can be references to other widgets,
         * integers or strings.
         */

        /**
         * The possible accessible relations of a [iface`Accessible]`.
         *
         * Accessible relations can be references to other widgets,
         * integers or strings.
         */
        export namespace AccessibleRelation {
            export const $gtype: GObject.GType<AccessibleRelation>;
        }

        enum AccessibleRelation {
            /**
             * Identifies the currently active
             *    element when focus is on a composite widget, combobox, textbox, group,
             *    or application. Value type: reference
             */
            ACTIVE_DESCENDANT,
            /**
             * Defines the total number of columns
             *    in a table, grid, or treegrid. Value type: integer
             */
            COL_COUNT,
            /**
             * Defines an element's column index or
             *    position with respect to the total number of columns within a table,
             *    grid, or treegrid. Value type: integer
             */
            COL_INDEX,
            /**
             * Defines a human readable text
             *   alternative of %GTK_ACCESSIBLE_RELATION_COL_INDEX. Value type: string
             */
            COL_INDEX_TEXT,
            /**
             * Defines the number of columns spanned
             *   by a cell or gridcell within a table, grid, or treegrid. Value type: integer
             */
            COL_SPAN,
            /**
             * Identifies the element (or elements) whose
             *    contents or presence are controlled by the current element. Value type: reference
             */
            CONTROLS,
            /**
             * Identifies the element (or elements)
             *    that describes the object. Value type: reference
             */
            DESCRIBED_BY,
            /**
             * Identifies the element (or elements) that
             *    provide additional information related to the object. Value type: reference
             */
            DETAILS,
            /**
             * Identifies the element (or elements) that
             *    provide an error message for an object. Value type: reference
             */
            ERROR_MESSAGE,
            /**
             * Identifies the next element (or elements)
             *    in an alternate reading order of content which, at the user's discretion,
             *    allows assistive technology to override the general default of reading in
             *    document source order. Value type: reference
             */
            FLOW_TO,
            /**
             * Identifies the element (or elements)
             *    that labels the current element. Value type: reference
             */
            LABELLED_BY,
            /**
             * Identifies an element (or elements) in order
             *    to define a visual, functional, or contextual parent/child relationship
             *    between elements where the widget hierarchy cannot be used to represent
             *    the relationship. Value type: reference
             */
            OWNS,
            /**
             * Defines an element's number or position
             *    in the current set of listitems or treeitems. Value type: integer
             */
            POS_IN_SET,
            /**
             * Defines the total number of rows in a table,
             *    grid, or treegrid. Value type: integer
             */
            ROW_COUNT,
            /**
             * Defines an element's row index or position
             *    with respect to the total number of rows within a table, grid, or treegrid.
             *    Value type: integer
             */
            ROW_INDEX,
            /**
             * Defines a human readable text
             *    alternative of aria-rowindex. Value type: string
             */
            ROW_INDEX_TEXT,
            /**
             * Defines the number of rows spanned by a
             *    cell or gridcell within a table, grid, or treegrid. Value type: integer
             */
            ROW_SPAN,
            /**
             * Defines the number of items in the current
             *    set of listitems or treeitems. Value type: integer
             */
            SET_SIZE,
            /**
             * Identifies the element (or elements) that are labeled by the
             * current element. Value type: reference
             *
             * This relation is managed by GTK and should not be set from application code.
             */
            LABEL_FOR,
            /**
             * Identifies the element (or elements) that are described by
             * the current element. Value type: reference
             *
             * This relation is managed by GTK and should not be set from application code.
             */
            DESCRIPTION_FOR,
            /**
             * Identifies the element (or elements) that the current
             * element is controlled by. Value type: reference
             *
             * This relation is managed by GTK and should not be set from application code.
             */
            CONTROLLED_BY,
            /**
             * Identifies the element (or elements) for which the current
             * element provides additional information. Value type: reference
             *
             * This relation is managed by GTK and should not be set from application code.
             */
            DETAILS_FOR,
            /**
             * Identifies the element (or elements) for which the current
             * element provides an error message. Value type: reference
             *
             * This relation is managed by GTK and should not be set from application code.
             */
            ERROR_MESSAGE_FOR,
            /**
             * Identifies the previous element (or elements) in an alternate
             * reading order of content which, at the user's discretion, allows
             * assistive technology to override the general default of reading in
             * document source order. Value type: reference
             *
             * This relation is managed by GTK and should not be set from application code.
             */
            FLOW_FROM,
        }
        /**
         * The accessible role for a [iface`Accessible]` implementation.
         *
         * Abstract roles are only used as part of the ontology; application
         * developers must not use abstract roles in their code.
         */

        /**
         * The accessible role for a [iface`Accessible]` implementation.
         *
         * Abstract roles are only used as part of the ontology; application
         * developers must not use abstract roles in their code.
         */
        export namespace AccessibleRole {
            export const $gtype: GObject.GType<AccessibleRole>;
        }

        enum AccessibleRole {
            /**
             * An element with important, and usually
             *   time-sensitive, information
             */
            ALERT,
            /**
             * A type of dialog that contains an
             *   alert message
             */
            ALERT_DIALOG,
            /**
             * Unused
             */
            BANNER,
            /**
             * An input element that allows for
             *   user-triggered actions when clicked or pressed
             */
            BUTTON,
            /**
             * Unused
             */
            CAPTION,
            /**
             * Unused
             */
            CELL,
            /**
             * A checkable input element that has
             *   three possible values: `true`, `false`, or `mixed`
             */
            CHECKBOX,
            /**
             * A header in a columned list.
             */
            COLUMN_HEADER,
            /**
             * An input that controls another element,
             *   such as a list or a grid, that can dynamically pop up to help the user
             *   set the value of the input
             */
            COMBO_BOX,
            /**
             * Abstract role.
             */
            COMMAND,
            /**
             * Abstract role.
             */
            COMPOSITE,
            /**
             * A dialog is a window that is designed to interrupt
             *   the current processing of an application in order to prompt the user to enter
             *   information or require a response.
             */
            DIALOG,
            /**
             * Content that assistive technology users may want to
             *   browse in a reading mode.
             */
            DOCUMENT,
            /**
             * Unused
             */
            FEED,
            /**
             * Unused
             */
            FORM,
            /**
             * A nameless container that has no semantic meaning
             *   of its own. This is the role that GTK uses by default for widgets.
             */
            GENERIC,
            /**
             * A grid of items.
             */
            GRID,
            /**
             * An item in a grid or tree grid.
             */
            GRID_CELL,
            /**
             * An element that groups multiple related widgets. GTK uses
             *   this role for various containers, like [class`Gtk`.HeaderBar] or [class`Gtk`.Notebook].
             */
            GROUP,
            /**
             * Unused
             */
            HEADING,
            /**
             * An image.
             */
            IMG,
            /**
             * Abstract role.
             */
            INPUT,
            /**
             * A visible name or caption for a user interface component.
             */
            LABEL,
            /**
             * Abstract role.
             */
            LANDMARK,
            /**
             * Unused
             */
            LEGEND,
            /**
             * A clickable link.
             */
            LINK,
            /**
             * A list of items.
             */
            LIST,
            /**
             * Unused.
             */
            LIST_BOX,
            /**
             * An item in a list.
             */
            LIST_ITEM,
            /**
             * Unused
             */
            LOG,
            /**
             * Unused
             */
            MAIN,
            /**
             * Unused
             */
            MARQUEE,
            /**
             * Unused
             */
            MATH,
            /**
             * An element that represents a value within a known range.
             */
            METER,
            /**
             * A menu.
             */
            MENU,
            /**
             * A menubar.
             */
            MENU_BAR,
            /**
             * An item in a menu.
             */
            MENU_ITEM,
            /**
             * A check item in a menu.
             */
            MENU_ITEM_CHECKBOX,
            /**
             * A radio item in a menu.
             */
            MENU_ITEM_RADIO,
            /**
             * Unused
             */
            NAVIGATION,
            /**
             * An element that is not represented to accessibility technologies.
             *   This role is synonymous to `GTK_ACCESSIBLE_ROLE_PRESENTATION`.
             */
            NONE,
            /**
             * Unused
             */
            NOTE,
            /**
             * Unused
             */
            OPTION,
            /**
             * An element that is not represented to accessibility technologies.
             *   This role is synonymous to `GTK_ACCESSIBLE_ROLE_NONE`.
             */
            PRESENTATION,
            /**
             * An element that displays the progress
             *   status for tasks that take a long time.
             */
            PROGRESS_BAR,
            /**
             * A checkable input in a group of radio roles,
             *   only one of which can be checked at a time.
             */
            RADIO,
            /**
             * Unused
             */
            RADIO_GROUP,
            /**
             * Abstract role.
             */
            RANGE,
            /**
             * Unused
             */
            REGION,
            /**
             * A row in a columned list.
             */
            ROW,
            /**
             * Unused
             */
            ROW_GROUP,
            /**
             * Unused
             */
            ROW_HEADER,
            /**
             * A graphical object that controls the scrolling
             *   of content within a viewing area, regardless of whether the content is fully
             *   displayed within the viewing area.
             */
            SCROLLBAR,
            /**
             * Unused
             */
            SEARCH,
            /**
             * A type of textbox intended for specifying
             *   search criteria.
             */
            SEARCH_BOX,
            /**
             * Abstract role.
             */
            SECTION,
            /**
             * Abstract role.
             */
            SECTION_HEAD,
            /**
             * Abstract role.
             */
            SELECT,
            /**
             * A divider that separates and distinguishes
             *   sections of content or groups of menuitems.
             */
            SEPARATOR,
            /**
             * A user input where the user selects a value
             *   from within a given range.
             */
            SLIDER,
            /**
             * A form of range that expects the user to
             *   select from among discrete choices.
             */
            SPIN_BUTTON,
            /**
             * Unused
             */
            STATUS,
            /**
             * Abstract role.
             */
            STRUCTURE,
            /**
             * A type of checkbox that represents on/off values,
             *   as opposed to checked/unchecked values.
             */
            SWITCH,
            /**
             * An item in a list of tab used for switching pages.
             */
            TAB,
            /**
             * Unused
             */
            TABLE,
            /**
             * A list of tabs for switching pages.
             */
            TAB_LIST,
            /**
             * A page in a notebook or stack.
             */
            TAB_PANEL,
            /**
             * A type of input that allows free-form text
             *   as its value.
             */
            TEXT_BOX,
            /**
             * Unused
             */
            TIME,
            /**
             * Unused
             */
            TIMER,
            /**
             * Unused
             */
            TOOLBAR,
            /**
             * Unused
             */
            TOOLTIP,
            /**
             * Unused
             */
            TREE,
            /**
             * A treeview-like, columned list.
             */
            TREE_GRID,
            /**
             * Unused
             */
            TREE_ITEM,
            /**
             * Abstract role for interactive components of a
             *   graphical user interface
             */
            WIDGET,
            /**
             * Abstract role for windows.
             */
            WINDOW,
            /**
             * A type of push button which stays pressed until depressed by a second
             * activation.
             */
            TOGGLE_BUTTON,
            /**
             * A toplevel element of a graphical user interface.
             *
             * This is the role that GTK uses by default for windows.
             */
            APPLICATION,
            /**
             * A paragraph of content.
             */
            PARAGRAPH,
            /**
             * A section of content that is quoted from another source.
             */
            BLOCK_QUOTE,
            /**
             * A section of a page that consists of a composition that forms an independent
             * part of a document, page, or site.
             */
            ARTICLE,
            /**
             * A comment contains content expressing reaction to other content.
             */
            COMMENT,
            /**
             * A virtual terminal.
             */
            TERMINAL,
        }
        /**
         * The possible values for the %GTK_ACCESSIBLE_PROPERTY_SORT
         * accessible property.
         */

        /**
         * The possible values for the %GTK_ACCESSIBLE_PROPERTY_SORT
         * accessible property.
         */
        export namespace AccessibleSort {
            export const $gtype: GObject.GType<AccessibleSort>;
        }

        enum AccessibleSort {
            /**
             * There is no defined sort applied to the column.
             */
            NONE,
            /**
             * Items are sorted in ascending order by this column.
             */
            ASCENDING,
            /**
             * Items are sorted in descending order by this column.
             */
            DESCENDING,
            /**
             * A sort algorithm other than ascending or
             *    descending has been applied.
             */
            OTHER,
        }
        /**
         * The possible accessible states of a [iface`Accessible]`.
         */

        /**
         * The possible accessible states of a [iface`Accessible]`.
         */
        export namespace AccessibleState {
            export const $gtype: GObject.GType<AccessibleState>;
        }

        enum AccessibleState {
            /**
             * A “busy” state. This state has boolean values
             */
            BUSY,
            /**
             * A “checked” state; indicates the current
             *   state of a [class`CheckButton]`. Value type: [enum`AccessibleTristate]`
             */
            CHECKED,
            /**
             * A “disabled” state; corresponds to the
             *   [property`Widget:`sensitive] property. It indicates a UI element
             *   that is perceivable, but not editable or operable. Value type: boolean
             */
            DISABLED,
            /**
             * An “expanded” state; corresponds to the
             *   [property`Expander:`expanded] property. Value type: boolean
             *   or undefined
             */
            EXPANDED,
            /**
             * A “hidden” state; corresponds to the
             *   [property`Widget:`visible] property. You can use this state
             *   explicitly on UI elements that should not be exposed to an assistive
             *   technology. Value type: boolean
             *   See also: %GTK_ACCESSIBLE_STATE_DISABLED
             */
            HIDDEN,
            /**
             * An “invalid” state; set when a widget
             *   is showing an error. Value type: [enum`AccessibleInvalidState]`
             */
            INVALID,
            /**
             * A “pressed” state; indicates the current
             *   state of a [class`ToggleButton]`. Value type: [enum`AccessibleTristate]`
             *   enumeration
             */
            PRESSED,
            /**
             * A “selected” state; set when a widget
             *   is selected. Value type: boolean or undefined
             */
            SELECTED,
            /**
             * Indicates that a widget with the GTK_ACCESSIBLE_ROLE_LINK has been visited.
             * Value type: boolean.
             */
            VISITED,
        }
        /**
         * The type of contents change operation.
         */

        /**
         * The type of contents change operation.
         */
        export namespace AccessibleTextContentChange {
            export const $gtype: GObject.GType<AccessibleTextContentChange>;
        }

        enum AccessibleTextContentChange {
            /**
             * contents change as the result of
             *   an insert operation
             */
            INSERT,
            /**
             * contents change as the result of
             *   a remove operation
             */
            REMOVE,
        }
        /**
         * The granularity for queries about the text contents of a [iface`Gtk`.AccessibleText]
         * implementation.
         */

        /**
         * The granularity for queries about the text contents of a [iface`Gtk`.AccessibleText]
         * implementation.
         */
        export namespace AccessibleTextGranularity {
            export const $gtype: GObject.GType<AccessibleTextGranularity>;
        }

        enum AccessibleTextGranularity {
            /**
             * Use the boundary between
             *   characters (including non-printing characters)
             */
            CHARACTER,
            /**
             * Use the boundary between words,
             *   starting from the beginning of the current word and ending at the
             *   beginning of the next word
             */
            WORD,
            /**
             * Use the boundary between
             *   sentences, starting from the beginning of the current sentence and
             *   ending at the beginning of the next sentence
             */
            SENTENCE,
            /**
             * Use the boundary between lines,
             *   starting from the beginning of the current line and ending at the
             *   beginning of the next line
             */
            LINE,
            /**
             * Use the boundary between
             *   paragraphs, starting from the beginning of the current paragraph and
             *   ending at the beginning of the next paragraph
             */
            PARAGRAPH,
        }
        /**
         * The possible values for the %GTK_ACCESSIBLE_STATE_PRESSED
         * accessible state.
         *
         * Note that the %GTK_ACCESSIBLE_TRISTATE_FALSE and
         * %GTK_ACCESSIBLE_TRISTATE_TRUE have the same values
         * as %FALSE and %TRUE.
         */

        /**
         * The possible values for the %GTK_ACCESSIBLE_STATE_PRESSED
         * accessible state.
         *
         * Note that the %GTK_ACCESSIBLE_TRISTATE_FALSE and
         * %GTK_ACCESSIBLE_TRISTATE_TRUE have the same values
         * as %FALSE and %TRUE.
         */
        export namespace AccessibleTristate {
            export const $gtype: GObject.GType<AccessibleTristate>;
        }

        enum AccessibleTristate {
            /**
             * The state is `false`
             */
            FALSE,
            /**
             * The state is `true`
             */
            TRUE,
            /**
             * The state is `mixed`
             */
            MIXED,
        }
        /**
         * Controls how a widget deals with extra space in a single dimension.
         *
         * Alignment only matters if the widget receives a “too large” allocation,
         * for example if you packed the widget with the [property`Gtk`.Widget:hexpand]
         * property inside a [class`Box]`, then the widget might get extra space.
         * If you have for example a 16x16 icon inside a 32x32 space, the icon
         * could be scaled and stretched, it could be centered, or it could be
         * positioned to one side of the space.
         *
         * Note that in horizontal context `GTK_ALIGN_START` and `GTK_ALIGN_END`
         * are interpreted relative to text direction.
         *
         * Baseline support is optional for containers and widgets, and is only available
         * for vertical alignment. `GTK_ALIGN_BASELINE_CENTER` and `GTK_ALIGN_BASELINE_FILL`
         * are treated similar to `GTK_ALIGN_CENTER` and `GTK_ALIGN_FILL`, except that it
         * positions the widget to line up the baselines, where that is supported.
         */

        /**
         * Controls how a widget deals with extra space in a single dimension.
         *
         * Alignment only matters if the widget receives a “too large” allocation,
         * for example if you packed the widget with the [property`Gtk`.Widget:hexpand]
         * property inside a [class`Box]`, then the widget might get extra space.
         * If you have for example a 16x16 icon inside a 32x32 space, the icon
         * could be scaled and stretched, it could be centered, or it could be
         * positioned to one side of the space.
         *
         * Note that in horizontal context `GTK_ALIGN_START` and `GTK_ALIGN_END`
         * are interpreted relative to text direction.
         *
         * Baseline support is optional for containers and widgets, and is only available
         * for vertical alignment. `GTK_ALIGN_BASELINE_CENTER` and `GTK_ALIGN_BASELINE_FILL`
         * are treated similar to `GTK_ALIGN_CENTER` and `GTK_ALIGN_FILL`, except that it
         * positions the widget to line up the baselines, where that is supported.
         */
        export namespace Align {
            export const $gtype: GObject.GType<Align>;
        }

        enum Align {
            /**
             * stretch to fill all space if possible, center if
             *   no meaningful way to stretch
             */
            FILL,
            /**
             * snap to left or top side, leaving space on right or bottom
             */
            START,
            /**
             * snap to right or bottom side, leaving space on left or top
             */
            END,
            /**
             * center natural width of widget inside the allocation
             */
            CENTER,
            /**
             * a different name for `GTK_ALIGN_BASELINE`.
             */
            BASELINE_FILL,
            /**
             * align the widget according to the baseline.
             */
            BASELINE,
            /**
             * stretch to fill all space, but align the baseline.
             */
            BASELINE_CENTER,
        }
        /**
         * Indicates the direction in which an arrow should point.
         */

        /**
         * Indicates the direction in which an arrow should point.
         */
        export namespace ArrowType {
            export const $gtype: GObject.GType<ArrowType>;
        }

        enum ArrowType {
            /**
             * Represents an upward pointing arrow.
             */
            UP,
            /**
             * Represents a downward pointing arrow.
             */
            DOWN,
            /**
             * Represents a left pointing arrow.
             */
            LEFT,
            /**
             * Represents a right pointing arrow.
             */
            RIGHT,
            /**
             * No arrow.
             */
            NONE,
        }
        /**
         * Determines the role of a page inside a `GtkAssistant`.
         *
         * The role is used to handle buttons sensitivity and visibility.
         *
         * Note that an assistant needs to end its page flow with a page of type
         * %GTK_ASSISTANT_PAGE_CONFIRM, %GTK_ASSISTANT_PAGE_SUMMARY or
         * %GTK_ASSISTANT_PAGE_PROGRESS to be correct.
         *
         * The Cancel button will only be shown if the page isn’t “committed”.
         * See gtk_assistant_commit() for details.
         */

        /**
         * Determines the role of a page inside a `GtkAssistant`.
         *
         * The role is used to handle buttons sensitivity and visibility.
         *
         * Note that an assistant needs to end its page flow with a page of type
         * %GTK_ASSISTANT_PAGE_CONFIRM, %GTK_ASSISTANT_PAGE_SUMMARY or
         * %GTK_ASSISTANT_PAGE_PROGRESS to be correct.
         *
         * The Cancel button will only be shown if the page isn’t “committed”.
         * See gtk_assistant_commit() for details.
         */
        export namespace AssistantPageType {
            export const $gtype: GObject.GType<AssistantPageType>;
        }

        enum AssistantPageType {
            /**
             * The page has regular contents. Both the
             *  Back and forward buttons will be shown.
             */
            CONTENT,
            /**
             * The page contains an introduction to the
             *  assistant task. Only the Forward button will be shown if there is a
             *   next page.
             */
            INTRO,
            /**
             * The page lets the user confirm or deny the
             *  changes. The Back and Apply buttons will be shown.
             */
            CONFIRM,
            /**
             * The page informs the user of the changes
             *  done. Only the Close button will be shown.
             */
            SUMMARY,
            /**
             * Used for tasks that take a long time to
             *  complete, blocks the assistant until the page is marked as complete.
             *   Only the back button will be shown.
             */
            PROGRESS,
            /**
             * Used for when other page types are not
             *  appropriate. No buttons will be shown, and the application must
             *  add its own buttons through gtk_assistant_add_action_widget().
             */
            CUSTOM,
        }
        /**
         * Baseline position in a row of widgets.
         *
         * Whenever a container has some form of natural row it may align
         * children in that row along a common typographical baseline. If
         * the amount of vertical space in the row is taller than the total
         * requested height of the baseline-aligned children then it can use a
         * `GtkBaselinePosition` to select where to put the baseline inside the
         * extra available space.
         */

        /**
         * Baseline position in a row of widgets.
         *
         * Whenever a container has some form of natural row it may align
         * children in that row along a common typographical baseline. If
         * the amount of vertical space in the row is taller than the total
         * requested height of the baseline-aligned children then it can use a
         * `GtkBaselinePosition` to select where to put the baseline inside the
         * extra available space.
         */
        export namespace BaselinePosition {
            export const $gtype: GObject.GType<BaselinePosition>;
        }

        enum BaselinePosition {
            /**
             * Align the baseline at the top
             */
            TOP,
            /**
             * Center the baseline
             */
            CENTER,
            /**
             * Align the baseline at the bottom
             */
            BOTTOM,
        }
        /**
         * Describes how the border of a UI element should be rendered.
         */

        /**
         * Describes how the border of a UI element should be rendered.
         */
        export namespace BorderStyle {
            export const $gtype: GObject.GType<BorderStyle>;
        }

        enum BorderStyle {
            /**
             * No visible border
             */
            NONE,
            /**
             * Same as %GTK_BORDER_STYLE_NONE
             */
            HIDDEN,
            /**
             * A single line segment
             */
            SOLID,
            /**
             * Looks as if the content is sunken into the canvas
             */
            INSET,
            /**
             * Looks as if the content is coming out of the canvas
             */
            OUTSET,
            /**
             * A series of round dots
             */
            DOTTED,
            /**
             * A series of square-ended dashes
             */
            DASHED,
            /**
             * Two parallel lines with some space between them
             */
            DOUBLE,
            /**
             * Looks as if it were carved in the canvas
             */
            GROOVE,
            /**
             * Looks as if it were coming out of the canvas
             */
            RIDGE,
        }
        /**
         * Error codes that identify various errors that can occur while using
         * `GtkBuilder`.
         */
        class BuilderError extends GLib.Error {
            static $gtype: GObject.GType<BuilderError>;

            // Static fields

            /**
             * A type-func attribute didn’t name
             *  a function that returns a `GType`.
             */
            static INVALID_TYPE_FUNCTION: number;
            /**
             * The input contained a tag that `GtkBuilder`
             *  can’t handle.
             */
            static UNHANDLED_TAG: number;
            /**
             * An attribute that is required by
             *  `GtkBuilder` was missing.
             */
            static MISSING_ATTRIBUTE: number;
            /**
             * `GtkBuilder` found an attribute that
             *  it doesn’t understand.
             */
            static INVALID_ATTRIBUTE: number;
            /**
             * `GtkBuilder` found a tag that
             *  it doesn’t understand.
             */
            static INVALID_TAG: number;
            /**
             * A required property value was
             *  missing.
             */
            static MISSING_PROPERTY_VALUE: number;
            /**
             * `GtkBuilder` couldn’t parse
             *  some attribute value.
             */
            static INVALID_VALUE: number;
            /**
             * The input file requires a newer version
             *  of GTK.
             */
            static VERSION_MISMATCH: number;
            /**
             * An object id occurred twice.
             */
            static DUPLICATE_ID: number;
            /**
             * A specified object type is of the same type or
             *  derived from the type of the composite class being extended with builder XML.
             */
            static OBJECT_TYPE_REFUSED: number;
            /**
             * The wrong type was specified in a composite class’s template XML
             */
            static TEMPLATE_MISMATCH: number;
            /**
             * The specified property is unknown for the object class.
             */
            static INVALID_PROPERTY: number;
            /**
             * The specified signal is unknown for the object class.
             */
            static INVALID_SIGNAL: number;
            /**
             * An object id is unknown.
             */
            static INVALID_ID: number;
            /**
             * A function could not be found. This often happens
             *   when symbols are set to be kept private. Compiling code with -rdynamic or using the
             *   `gmodule-export-2.0` pkgconfig module can fix this problem.
             */
            static INVALID_FUNCTION: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for [class`Gtk`.Builder] errors.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Prebuilt sets of buttons for `GtkDialog`.
         *
         * If none of these choices are appropriate, simply use
         * %GTK_BUTTONS_NONE and call [method`Gtk`.Dialog.add_buttons].
         *
         * > Please note that %GTK_BUTTONS_OK, %GTK_BUTTONS_YES_NO
         * > and %GTK_BUTTONS_OK_CANCEL are discouraged by the
         * > [GNOME Human Interface Guidelines](https://developer.gnome.org/hig/).
         */

        /**
         * Prebuilt sets of buttons for `GtkDialog`.
         *
         * If none of these choices are appropriate, simply use
         * %GTK_BUTTONS_NONE and call [method`Gtk`.Dialog.add_buttons].
         *
         * > Please note that %GTK_BUTTONS_OK, %GTK_BUTTONS_YES_NO
         * > and %GTK_BUTTONS_OK_CANCEL are discouraged by the
         * > [GNOME Human Interface Guidelines](https://developer.gnome.org/hig/).
         */
        export namespace ButtonsType {
            export const $gtype: GObject.GType<ButtonsType>;
        }

        enum ButtonsType {
            /**
             * no buttons at all
             */
            NONE,
            /**
             * an OK button
             */
            OK,
            /**
             * a Close button
             */
            CLOSE,
            /**
             * a Cancel button
             */
            CANCEL,
            /**
             * Yes and No buttons
             */
            YES_NO,
            /**
             * OK and Cancel buttons
             */
            OK_CANCEL,
        }
        /**
         * The available modes for [property`Gtk`.CellRendererAccel:accel-mode].
         */

        /**
         * The available modes for [property`Gtk`.CellRendererAccel:accel-mode].
         */
        export namespace CellRendererAccelMode {
            export const $gtype: GObject.GType<CellRendererAccelMode>;
        }

        enum CellRendererAccelMode {
            /**
             * GTK accelerators mode
             */
            GTK,
            /**
             * Other accelerator mode
             */
            OTHER,
        }
        /**
         * Identifies how the user can interact with a particular cell.
         */

        /**
         * Identifies how the user can interact with a particular cell.
         */
        export namespace CellRendererMode {
            export const $gtype: GObject.GType<CellRendererMode>;
        }

        enum CellRendererMode {
            /**
             * The cell is just for display
             *  and cannot be interacted with.  Note that this doesn’t mean that eg. the
             *  row being drawn can’t be selected -- just that a particular element of
             *  it cannot be individually modified.
             */
            INERT,
            /**
             * The cell can be clicked.
             */
            ACTIVATABLE,
            /**
             * The cell can be edited or otherwise modified.
             */
            EDITABLE,
        }
        /**
         * Describes how a [class`Gtk`.StringSorter] turns strings into sort keys to
         * compare them.
         *
         * Note that the result of sorting will in general depend on the current locale
         * unless the mode is `GTK_COLLATION_NONE`.
         */

        /**
         * Describes how a [class`Gtk`.StringSorter] turns strings into sort keys to
         * compare them.
         *
         * Note that the result of sorting will in general depend on the current locale
         * unless the mode is `GTK_COLLATION_NONE`.
         */
        export namespace Collation {
            export const $gtype: GObject.GType<Collation>;
        }

        enum Collation {
            /**
             * Don't do any collation
             */
            NONE,
            /**
             * Use [func`GLib`.utf8_collate_key]
             */
            UNICODE,
            /**
             * Use [func`GLib`.utf8_collate_key_for_filename]
             */
            FILENAME,
        }
        /**
         * The widget attributes that can be used when creating a [class`Constraint]`.
         */

        /**
         * The widget attributes that can be used when creating a [class`Constraint]`.
         */
        export namespace ConstraintAttribute {
            export const $gtype: GObject.GType<ConstraintAttribute>;
        }

        enum ConstraintAttribute {
            /**
             * No attribute, used for constant
             *   relations
             */
            NONE,
            /**
             * The left edge of a widget, regardless of
             *   text direction
             */
            LEFT,
            /**
             * The right edge of a widget, regardless
             *   of text direction
             */
            RIGHT,
            /**
             * The top edge of a widget
             */
            TOP,
            /**
             * The bottom edge of a widget
             */
            BOTTOM,
            /**
             * The leading edge of a widget, depending
             *   on text direction; equivalent to %GTK_CONSTRAINT_ATTRIBUTE_LEFT for LTR
             *   languages, and %GTK_CONSTRAINT_ATTRIBUTE_RIGHT for RTL ones
             */
            START,
            /**
             * The trailing edge of a widget, depending
             *   on text direction; equivalent to %GTK_CONSTRAINT_ATTRIBUTE_RIGHT for LTR
             *   languages, and %GTK_CONSTRAINT_ATTRIBUTE_LEFT for RTL ones
             */
            END,
            /**
             * The width of a widget
             */
            WIDTH,
            /**
             * The height of a widget
             */
            HEIGHT,
            /**
             * The center of a widget, on the
             *   horizontal axis
             */
            CENTER_X,
            /**
             * The center of a widget, on the
             *   vertical axis
             */
            CENTER_Y,
            /**
             * The baseline of a widget
             */
            BASELINE,
        }
        /**
         * The relation between two terms of a constraint.
         */

        /**
         * The relation between two terms of a constraint.
         */
        export namespace ConstraintRelation {
            export const $gtype: GObject.GType<ConstraintRelation>;
        }

        enum ConstraintRelation {
            /**
             * Less than, or equal
             */
            LE,
            /**
             * Equal
             */
            EQ,
            /**
             * Greater than, or equal
             */
            GE,
        }
        /**
         * The strength of a constraint, expressed as a symbolic constant.
         *
         * The strength of a [class`Constraint]` can be expressed with any positive
         * integer; the values of this enumeration can be used for readability.
         */

        /**
         * The strength of a constraint, expressed as a symbolic constant.
         *
         * The strength of a [class`Constraint]` can be expressed with any positive
         * integer; the values of this enumeration can be used for readability.
         */
        export namespace ConstraintStrength {
            export const $gtype: GObject.GType<ConstraintStrength>;
        }

        enum ConstraintStrength {
            /**
             * The constraint is required towards solving the layout
             */
            REQUIRED,
            /**
             * A strong constraint
             */
            STRONG,
            /**
             * A medium constraint
             */
            MEDIUM,
            /**
             * A weak constraint
             */
            WEAK,
        }
        /**
         * Domain for VFL parsing errors.
         */
        class ConstraintVflParserError extends GLib.Error {
            static $gtype: GObject.GType<ConstraintVflParserError>;

            // Static fields

            /**
             * Invalid or unknown symbol
             */
            static SYMBOL: number;
            /**
             * Invalid or unknown attribute
             */
            static ATTRIBUTE: number;
            /**
             * Invalid or unknown view
             */
            static VIEW: number;
            /**
             * Invalid or unknown metric
             */
            static METRIC: number;
            /**
             * Invalid or unknown priority
             */
            static PRIORITY: number;
            /**
             * Invalid or unknown relation
             */
            static RELATION: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for VFL error parsing.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Controls how a content should be made to fit inside an allocation.
         */

        /**
         * Controls how a content should be made to fit inside an allocation.
         */
        export namespace ContentFit {
            export const $gtype: GObject.GType<ContentFit>;
        }

        enum ContentFit {
            /**
             * Make the content fill the entire allocation,
             *   without taking its aspect ratio in consideration. The resulting
             *   content will appear as stretched if its aspect ratio is different
             *   from the allocation aspect ratio.
             */
            FILL,
            /**
             * Scale the content to fit the allocation,
             *   while taking its aspect ratio in consideration. The resulting
             *   content will appear as letterboxed if its aspect ratio is different
             *   from the allocation aspect ratio.
             */
            CONTAIN,
            /**
             * Cover the entire allocation, while taking
             *   the content aspect ratio in consideration. The resulting content
             *   will appear as clipped if its aspect ratio is different from the
             *   allocation aspect ratio.
             */
            COVER,
            /**
             * The content is scaled down to fit the
             *   allocation, if needed, otherwise its original size is used.
             */
            SCALE_DOWN,
        }
        /**
         * Specifies which corner a child widget should be placed in when packed into
         * a `GtkScrolledWindow.`
         *
         * This is effectively the opposite of where the scroll bars are placed.
         */

        /**
         * Specifies which corner a child widget should be placed in when packed into
         * a `GtkScrolledWindow.`
         *
         * This is effectively the opposite of where the scroll bars are placed.
         */
        export namespace CornerType {
            export const $gtype: GObject.GType<CornerType>;
        }

        enum CornerType {
            /**
             * Place the scrollbars on the right and bottom of the
             *   widget (default behaviour).
             */
            TOP_LEFT,
            /**
             * Place the scrollbars on the top and right of the
             *   widget.
             */
            BOTTOM_LEFT,
            /**
             * Place the scrollbars on the left and bottom of the
             *   widget.
             */
            TOP_RIGHT,
            /**
             * Place the scrollbars on the top and left of the
             *   widget.
             */
            BOTTOM_RIGHT,
        }
        /**
         * Errors that can occur while parsing CSS.
         *
         * These errors are unexpected and will cause parts of the given CSS
         * to be ignored.
         */
        class CssParserError extends GLib.Error {
            static $gtype: GObject.GType<CssParserError>;

            // Static fields

            /**
             * Unknown failure.
             */
            static FAILED: number;
            /**
             * The given text does not form valid syntax
             */
            static SYNTAX: number;
            /**
             * Failed to import a resource
             */
            static IMPORT: number;
            /**
             * The given name has not been defined
             */
            static NAME: number;
            /**
             * The given value is not correct
             */
            static UNKNOWN_VALUE: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;
        }

        /**
         * Warnings that can occur while parsing CSS.
         *
         * Unlike `GtkCssParserError`s, warnings do not cause the parser to
         * skip any input, but they indicate issues that should be fixed.
         */

        /**
         * Warnings that can occur while parsing CSS.
         *
         * Unlike `GtkCssParserError`s, warnings do not cause the parser to
         * skip any input, but they indicate issues that should be fixed.
         */
        export namespace CssParserWarning {
            export const $gtype: GObject.GType<CssParserWarning>;
        }

        enum CssParserWarning {
            /**
             * The given construct is
             *   deprecated and will be removed in a future version
             */
            DEPRECATED,
            /**
             * A syntax construct was used
             *   that should be avoided
             */
            SYNTAX,
            /**
             * A feature is not implemented
             */
            UNIMPLEMENTED,
        }
        /**
         * Passed to various keybinding signals for deleting text.
         */

        /**
         * Passed to various keybinding signals for deleting text.
         */
        export namespace DeleteType {
            export const $gtype: GObject.GType<DeleteType>;
        }

        enum DeleteType {
            /**
             * Delete characters.
             */
            CHARS,
            /**
             * Delete only the portion of the word to the
             *   left/right of cursor if we’re in the middle of a word.
             */
            WORD_ENDS,
            /**
             * Delete words.
             */
            WORDS,
            /**
             * Delete display-lines. Display-lines
             *   refers to the visible lines, with respect to the current line
             *   breaks. As opposed to paragraphs, which are defined by line
             *   breaks in the input.
             */
            DISPLAY_LINES,
            /**
             * Delete only the portion of the
             *   display-line to the left/right of cursor.
             */
            DISPLAY_LINE_ENDS,
            /**
             * Delete to the end of the
             *   paragraph. Like C-k in Emacs (or its reverse).
             */
            PARAGRAPH_ENDS,
            /**
             * Delete entire line. Like C-k in pico.
             */
            PARAGRAPHS,
            /**
             * Delete only whitespace. Like M-\ in Emacs.
             */
            WHITESPACE,
        }
        /**
         * Error codes in the `GTK_DIALOG_ERROR` domain that can be returned
         * by async dialog functions.
         */
        class DialogError extends GLib.Error {
            static $gtype: GObject.GType<DialogError>;

            // Static fields

            /**
             * Generic error condition for when
             *   an operation fails and no more specific code is applicable
             */
            static FAILED: number;
            /**
             * The async function call was cancelled
             *   via its `GCancellable`
             */
            static CANCELLED: number;
            /**
             * The operation was cancelled
             *   by the user (via a Cancel or Close button)
             */
            static DISMISSED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for an operation that requires a dialog if
             * necessary.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Focus movement types.
         */

        /**
         * Focus movement types.
         */
        export namespace DirectionType {
            export const $gtype: GObject.GType<DirectionType>;
        }

        enum DirectionType {
            /**
             * Move forward.
             */
            TAB_FORWARD,
            /**
             * Move backward.
             */
            TAB_BACKWARD,
            /**
             * Move up.
             */
            UP,
            /**
             * Move down.
             */
            DOWN,
            /**
             * Move left.
             */
            LEFT,
            /**
             * Move right.
             */
            RIGHT,
        }
        /**
         * The identifiers for [iface`Gtk`.Editable] properties.
         *
         * See [func`Gtk`.Editable.install_properties] for details on how to
         * implement the `GtkEditable` interface.
         */

        /**
         * The identifiers for [iface`Gtk`.Editable] properties.
         *
         * See [func`Gtk`.Editable.install_properties] for details on how to
         * implement the `GtkEditable` interface.
         */
        export namespace EditableProperties {
            export const $gtype: GObject.GType<EditableProperties>;
        }

        enum EditableProperties {
            /**
             * the property id for [property`Gtk`.Editable:text]
             */
            PROP_TEXT,
            /**
             * the property id for [property`Gtk`.Editable:cursor-position]
             */
            PROP_CURSOR_POSITION,
            /**
             * the property id for [property`Gtk`.Editable:selection-bound]
             */
            PROP_SELECTION_BOUND,
            /**
             * the property id for [property`Gtk`.Editable:editable]
             */
            PROP_EDITABLE,
            /**
             * the property id for [property`Gtk`.Editable:width-chars]
             */
            PROP_WIDTH_CHARS,
            /**
             * the property id for [property`Gtk`.Editable:max-width-chars]
             */
            PROP_MAX_WIDTH_CHARS,
            /**
             * the property id for [property`Gtk`.Editable:xalign]
             */
            PROP_XALIGN,
            /**
             * the property id for [property`Gtk`.Editable:enable-undo]
             */
            PROP_ENABLE_UNDO,
            /**
             * the number of properties
             */
            NUM_PROPERTIES,
        }
        /**
         * Specifies the side of the entry at which an icon is placed.
         */

        /**
         * Specifies the side of the entry at which an icon is placed.
         */
        export namespace EntryIconPosition {
            export const $gtype: GObject.GType<EntryIconPosition>;
        }

        enum EntryIconPosition {
            /**
             * At the beginning of the entry (depending on the text direction).
             */
            PRIMARY,
            /**
             * At the end of the entry (depending on the text direction).
             */
            SECONDARY,
        }
        /**
         * Describes the state of a [struct`Gdk`.EventSequence] in a [class`Gesture]`.
         */

        /**
         * Describes the state of a [struct`Gdk`.EventSequence] in a [class`Gesture]`.
         */
        export namespace EventSequenceState {
            export const $gtype: GObject.GType<EventSequenceState>;
        }

        enum EventSequenceState {
            /**
             * The sequence is handled, but not grabbed.
             */
            NONE,
            /**
             * The sequence is handled and grabbed.
             */
            CLAIMED,
            /**
             * The sequence is denied.
             */
            DENIED,
        }
        /**
         * Describes whether a `GtkFileChooser` is being used to open existing files
         * or to save to a possibly new file.
         */

        /**
         * Describes whether a `GtkFileChooser` is being used to open existing files
         * or to save to a possibly new file.
         */
        export namespace FileChooserAction {
            export const $gtype: GObject.GType<FileChooserAction>;
        }

        enum FileChooserAction {
            /**
             * Indicates open mode.  The file chooser
             *  will only let the user pick an existing file.
             */
            OPEN,
            /**
             * Indicates save mode.  The file chooser
             *  will let the user pick an existing file, or type in a new
             *  filename.
             */
            SAVE,
            /**
             * Indicates an Open mode for
             *  selecting folders.  The file chooser will let the user pick an
             *  existing folder.
             */
            SELECT_FOLDER,
        }
        /**
         * These identify the various errors that can occur while calling
         * `GtkFileChooser` functions.
         */
        class FileChooserError extends GLib.Error {
            static $gtype: GObject.GType<FileChooserError>;

            // Static fields

            /**
             * Indicates that a file does not exist.
             */
            static NONEXISTENT: number;
            /**
             * Indicates a malformed filename.
             */
            static BAD_FILENAME: number;
            /**
             * Indicates a duplicate path (e.g. when
             *  adding a bookmark).
             */
            static ALREADY_EXISTS: number;
            /**
             * Indicates an incomplete hostname
             *  (e.g. "http://foo" without a slash after that).
             */
            static INCOMPLETE_HOSTNAME: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for `GtkFileChooser` errors.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Describes changes in a filter in more detail and allows objects
         * using the filter to optimize refiltering items.
         *
         * If you are writing an implementation and are not sure which
         * value to pass, `GTK_FILTER_CHANGE_DIFFERENT` is always a correct
         * choice.
         */

        /**
         * Describes changes in a filter in more detail and allows objects
         * using the filter to optimize refiltering items.
         *
         * If you are writing an implementation and are not sure which
         * value to pass, `GTK_FILTER_CHANGE_DIFFERENT` is always a correct
         * choice.
         */
        export namespace FilterChange {
            export const $gtype: GObject.GType<FilterChange>;
        }

        enum FilterChange {
            /**
             * The filter change cannot be
             *   described with any of the other enumeration values
             */
            DIFFERENT,
            /**
             * The filter is less strict than
             *   it was before: All items that it used to return true
             *   still return true, others now may, too.
             */
            LESS_STRICT,
            /**
             * The filter is more strict than
             *   it was before: All items that it used to return false
             *   still return false, others now may, too.
             */
            MORE_STRICT,
        }
        /**
         * Describes the known strictness of a filter.
         *
         * Note that for filters where the strictness is not known,
         * `GTK_FILTER_MATCH_SOME` is always an acceptable value,
         * even if a filter does match all or no items.
         */

        /**
         * Describes the known strictness of a filter.
         *
         * Note that for filters where the strictness is not known,
         * `GTK_FILTER_MATCH_SOME` is always an acceptable value,
         * even if a filter does match all or no items.
         */
        export namespace FilterMatch {
            export const $gtype: GObject.GType<FilterMatch>;
        }

        enum FilterMatch {
            /**
             * The filter matches some items,
             *   [method`Gtk`.Filter.match] may return true or false
             */
            SOME,
            /**
             * The filter does not match any item,
             *   [method`Gtk`.Filter.match] will always return false
             */
            NONE,
            /**
             * The filter matches all items,
             *   [method`Gtk`.Filter.match] will alays return true
             */
            ALL,
        }
        /**
         * The level of granularity for the font selection.
         *
         * Depending on this value, the `PangoFontDescription` that
         * is returned by [method`Gtk`.FontDialogButton.get_font_desc]
         * will have more or less fields set.
         */

        /**
         * The level of granularity for the font selection.
         *
         * Depending on this value, the `PangoFontDescription` that
         * is returned by [method`Gtk`.FontDialogButton.get_font_desc]
         * will have more or less fields set.
         */
        export namespace FontLevel {
            export const $gtype: GObject.GType<FontLevel>;
        }

        enum FontLevel {
            /**
             * Select a font family
             */
            FAMILY,
            /**
             * Select a font face (i.e. a family and a style)
             */
            FACE,
            /**
             * Select a font (i.e. a face with a size, and possibly font variations)
             */
            FONT,
            /**
             * Select a font and font features
             */
            FEATURES,
        }
        /**
         * Values for the [property`Gtk`.Settings:gtk-font-rendering] setting
         * that influence how GTK renders fonts.
         */

        /**
         * Values for the [property`Gtk`.Settings:gtk-font-rendering] setting
         * that influence how GTK renders fonts.
         */
        export namespace FontRendering {
            export const $gtype: GObject.GType<FontRendering>;
        }

        enum FontRendering {
            /**
             * Set up font rendering automatically,
             *   taking factors like screen resolution and scale into account
             */
            AUTOMATIC,
            /**
             * Follow low-level font-related settings
             *   when configuring font rendering
             */
            MANUAL,
        }
        /**
         * Represents the state of graphics offloading.
         */

        /**
         * Represents the state of graphics offloading.
         */
        export namespace GraphicsOffloadEnabled {
            export const $gtype: GObject.GType<GraphicsOffloadEnabled>;
        }

        enum GraphicsOffloadEnabled {
            /**
             * Graphics offloading is enabled.
             */
            ENABLED,
            /**
             * Graphics offloading is disabled.
             */
            DISABLED,
        }
        /**
         * Built-in icon sizes.
         *
         * Icon sizes default to being inherited. Where they cannot be
         * inherited, text size is the default.
         *
         * All widgets which use `GtkIconSize` set the normal-icons or
         * large-icons style classes correspondingly, and let themes
         * determine the actual size to be used with the
         * `-gtk-icon-size` CSS property.
         */

        /**
         * Built-in icon sizes.
         *
         * Icon sizes default to being inherited. Where they cannot be
         * inherited, text size is the default.
         *
         * All widgets which use `GtkIconSize` set the normal-icons or
         * large-icons style classes correspondingly, and let themes
         * determine the actual size to be used with the
         * `-gtk-icon-size` CSS property.
         */
        export namespace IconSize {
            export const $gtype: GObject.GType<IconSize>;
        }

        enum IconSize {
            /**
             * Keep the size of the parent element
             */
            INHERIT,
            /**
             * Size similar to text size
             */
            NORMAL,
            /**
             * Large size, for example in an icon view
             */
            LARGE,
        }
        /**
         * Error codes for `GtkIconTheme` operations.
         */
        class IconThemeError extends GLib.Error {
            static $gtype: GObject.GType<IconThemeError>;

            // Static fields

            /**
             * The icon specified does not exist in the theme
             */
            static NOT_FOUND: number;
            /**
             * An unspecified error occurred.
             */
            static FAILED: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for [class`Gtk`.IconTheme] errors.
             */
            static quark(): GLib.Quark;
        }

        /**
         * An enum for determining where a dropped item goes.
         */

        /**
         * An enum for determining where a dropped item goes.
         */
        export namespace IconViewDropPosition {
            export const $gtype: GObject.GType<IconViewDropPosition>;
        }

        enum IconViewDropPosition {
            /**
             * no drop possible
             */
            NO_DROP,
            /**
             * dropped item replaces the item
             */
            DROP_INTO,
            /**
             * dropped item is inserted to the left
             */
            DROP_LEFT,
            /**
             * dropped item is inserted to the right
             */
            DROP_RIGHT,
            /**
             * dropped item is inserted above
             */
            DROP_ABOVE,
            /**
             * dropped item is inserted below
             */
            DROP_BELOW,
        }
        /**
         * Describes the image data representation used by a [class`Gtk`.Image].
         *
         * If you want to get the image from the widget, you can only get the
         * currently-stored representation; for instance, if the gtk_image_get_storage_type()
         * returns %GTK_IMAGE_PAINTABLE, then you can call gtk_image_get_paintable().
         *
         * For empty images, you can request any storage type (call any of the "get"
         * functions), but they will all return %NULL values.
         */

        /**
         * Describes the image data representation used by a [class`Gtk`.Image].
         *
         * If you want to get the image from the widget, you can only get the
         * currently-stored representation; for instance, if the gtk_image_get_storage_type()
         * returns %GTK_IMAGE_PAINTABLE, then you can call gtk_image_get_paintable().
         *
         * For empty images, you can request any storage type (call any of the "get"
         * functions), but they will all return %NULL values.
         */
        export namespace ImageType {
            export const $gtype: GObject.GType<ImageType>;
        }

        enum ImageType {
            /**
             * there is no image displayed by the widget
             */
            EMPTY,
            /**
             * the widget contains a named icon
             */
            ICON_NAME,
            /**
             * the widget contains a `GIcon`
             */
            GICON,
            /**
             * the widget contains a `GdkPaintable`
             */
            PAINTABLE,
        }
        /**
         * Describes primary purpose of the input widget.
         *
         * This information is useful for on-screen keyboards and similar input
         * methods to decide which keys should be presented to the user.
         *
         * Note that the purpose is not meant to impose a totally strict rule
         * about allowed characters, and does not replace input validation.
         * It is fine for an on-screen keyboard to let the user override the
         * character set restriction that is expressed by the purpose. The
         * application is expected to validate the entry contents, even if
         * it specified a purpose.
         *
         * The difference between %GTK_INPUT_PURPOSE_DIGITS and
         * %GTK_INPUT_PURPOSE_NUMBER is that the former accepts only digits
         * while the latter also some punctuation (like commas or points, plus,
         * minus) and “e” or “E” as in 3.14E+000.
         *
         * This enumeration may be extended in the future; input methods should
         * interpret unknown values as “free form”.
         */

        /**
         * Describes primary purpose of the input widget.
         *
         * This information is useful for on-screen keyboards and similar input
         * methods to decide which keys should be presented to the user.
         *
         * Note that the purpose is not meant to impose a totally strict rule
         * about allowed characters, and does not replace input validation.
         * It is fine for an on-screen keyboard to let the user override the
         * character set restriction that is expressed by the purpose. The
         * application is expected to validate the entry contents, even if
         * it specified a purpose.
         *
         * The difference between %GTK_INPUT_PURPOSE_DIGITS and
         * %GTK_INPUT_PURPOSE_NUMBER is that the former accepts only digits
         * while the latter also some punctuation (like commas or points, plus,
         * minus) and “e” or “E” as in 3.14E+000.
         *
         * This enumeration may be extended in the future; input methods should
         * interpret unknown values as “free form”.
         */
        export namespace InputPurpose {
            export const $gtype: GObject.GType<InputPurpose>;
        }

        enum InputPurpose {
            /**
             * Allow any character
             */
            FREE_FORM,
            /**
             * Allow only alphabetic characters
             */
            ALPHA,
            /**
             * Allow only digits
             */
            DIGITS,
            /**
             * Edited field expects numbers
             */
            NUMBER,
            /**
             * Edited field expects phone number
             */
            PHONE,
            /**
             * Edited field expects URL
             */
            URL,
            /**
             * Edited field expects email address
             */
            EMAIL,
            /**
             * Edited field expects the name of a person
             */
            NAME,
            /**
             * Like %GTK_INPUT_PURPOSE_FREE_FORM, but characters are hidden
             */
            PASSWORD,
            /**
             * Like %GTK_INPUT_PURPOSE_DIGITS, but characters are hidden
             */
            PIN,
            /**
             * Allow any character, in addition to control codes
             */
            TERMINAL,
        }
        /**
         * The different methods to handle text in #GtkInscription when it doesn't
         * fit the available space.
         */

        /**
         * The different methods to handle text in #GtkInscription when it doesn't
         * fit the available space.
         */
        export namespace InscriptionOverflow {
            export const $gtype: GObject.GType<InscriptionOverflow>;
        }

        enum InscriptionOverflow {
            /**
             * Clip the remaining text
             */
            CLIP,
            /**
             * Omit characters at the start of the text
             */
            ELLIPSIZE_START,
            /**
             * Omit characters at the middle of the text
             */
            ELLIPSIZE_MIDDLE,
            /**
             * Omit characters at the end of the text
             */
            ELLIPSIZE_END,
        }
        /**
         * Used for justifying the text inside a [class`Label]` widget.
         */

        /**
         * Used for justifying the text inside a [class`Label]` widget.
         */
        export namespace Justification {
            export const $gtype: GObject.GType<Justification>;
        }

        enum Justification {
            /**
             * The text is placed at the left edge of the label.
             */
            LEFT,
            /**
             * The text is placed at the right edge of the label.
             */
            RIGHT,
            /**
             * The text is placed in the center of the label.
             */
            CENTER,
            /**
             * The text is placed is distributed across the label.
             */
            FILL,
        }
        /**
         * Describes how [class`LevelBar]` contents should be rendered.
         *
         * Note that this enumeration could be extended with additional modes
         * in the future.
         */

        /**
         * Describes how [class`LevelBar]` contents should be rendered.
         *
         * Note that this enumeration could be extended with additional modes
         * in the future.
         */
        export namespace LevelBarMode {
            export const $gtype: GObject.GType<LevelBarMode>;
        }

        enum LevelBarMode {
            /**
             * the bar has a continuous mode
             */
            CONTINUOUS,
            /**
             * the bar has a discrete mode
             */
            DISCRETE,
        }
        /**
         * The type of license for an application.
         *
         * This enumeration can be expanded at later date.
         */

        /**
         * The type of license for an application.
         *
         * This enumeration can be expanded at later date.
         */
        export namespace License {
            export const $gtype: GObject.GType<License>;
        }

        enum License {
            /**
             * No license specified
             */
            UNKNOWN,
            /**
             * A license text is going to be specified by the
             *   developer
             */
            CUSTOM,
            /**
             * The GNU General Public License, version 2.0 or later
             */
            GPL_2_0,
            /**
             * The GNU General Public License, version 3.0 or later
             */
            GPL_3_0,
            /**
             * The GNU Lesser General Public License, version 2.1 or later
             */
            LGPL_2_1,
            /**
             * The GNU Lesser General Public License, version 3.0 or later
             */
            LGPL_3_0,
            /**
             * The BSD standard license
             */
            BSD,
            /**
             * The MIT/X11 standard license
             */
            MIT_X11,
            /**
             * The Artistic License, version 2.0
             */
            ARTISTIC,
            /**
             * The GNU General Public License, version 2.0 only
             */
            GPL_2_0_ONLY,
            /**
             * The GNU General Public License, version 3.0 only
             */
            GPL_3_0_ONLY,
            /**
             * The GNU Lesser General Public License, version 2.1 only
             */
            LGPL_2_1_ONLY,
            /**
             * The GNU Lesser General Public License, version 3.0 only
             */
            LGPL_3_0_ONLY,
            /**
             * The GNU Affero General Public License, version 3.0 or later
             */
            AGPL_3_0,
            /**
             * The GNU Affero General Public License, version 3.0 only
             */
            AGPL_3_0_ONLY,
            /**
             * The 3-clause BSD licence
             */
            BSD_3,
            /**
             * The Apache License, version 2.0
             */
            APACHE_2_0,
            /**
             * The Mozilla Public License, version 2.0
             */
            MPL_2_0,
            /**
             * Zero-Clause BSD license
             */
            '0BSD',
        }
        /**
         * Used to configure the focus behavior in the `GTK_DIR_TAB_FORWARD`
         * and `GTK_DIR_TAB_BACKWARD` direction, like the <kbd>Tab</kbd> key
         * in a [class`Gtk`.ListView].
         */

        /**
         * Used to configure the focus behavior in the `GTK_DIR_TAB_FORWARD`
         * and `GTK_DIR_TAB_BACKWARD` direction, like the <kbd>Tab</kbd> key
         * in a [class`Gtk`.ListView].
         */
        export namespace ListTabBehavior {
            export const $gtype: GObject.GType<ListTabBehavior>;
        }

        enum ListTabBehavior {
            /**
             * Cycle through all focusable items of the list
             */
            ALL,
            /**
             * Cycle through a single list element, then move
             *   focus out of the list. Moving focus between items needs to be
             *   done with the arrow keys.
             */
            ITEM,
            /**
             * Cycle only through a single cell, then
             *   move focus out of the list. Moving focus between cells needs to
             *   be done with the arrow keys. This is only relevant for
             *   cell-based widgets like #GtkColumnView, otherwise it behaves
             *   like `GTK_LIST_TAB_ITEM`.
             */
            CELL,
        }
        /**
         * The type of message being displayed in a [class`MessageDialog]`.
         */

        /**
         * The type of message being displayed in a [class`MessageDialog]`.
         */
        export namespace MessageType {
            export const $gtype: GObject.GType<MessageType>;
        }

        enum MessageType {
            /**
             * Informational message
             */
            INFO,
            /**
             * Non-fatal warning message
             */
            WARNING,
            /**
             * Question requiring a choice
             */
            QUESTION,
            /**
             * Fatal error message
             */
            ERROR,
            /**
             * None of the above
             */
            OTHER,
        }
        /**
         * Passed as argument to various keybinding signals for moving the
         * cursor position.
         */

        /**
         * Passed as argument to various keybinding signals for moving the
         * cursor position.
         */
        export namespace MovementStep {
            export const $gtype: GObject.GType<MovementStep>;
        }

        enum MovementStep {
            /**
             * Move forward or back by graphemes
             */
            LOGICAL_POSITIONS,
            /**
             * Move left or right by graphemes
             */
            VISUAL_POSITIONS,
            /**
             * Move forward or back by words
             */
            WORDS,
            /**
             * Move up or down lines (wrapped lines)
             */
            DISPLAY_LINES,
            /**
             * Move to either end of a line
             */
            DISPLAY_LINE_ENDS,
            /**
             * Move up or down paragraphs (newline-ended lines)
             */
            PARAGRAPHS,
            /**
             * Move to either end of a paragraph
             */
            PARAGRAPH_ENDS,
            /**
             * Move by pages
             */
            PAGES,
            /**
             * Move to ends of the buffer
             */
            BUFFER_ENDS,
            /**
             * Move horizontally by pages
             */
            HORIZONTAL_PAGES,
        }
        /**
         * Options for selecting a different wrap mode for natural size
         * requests.
         *
         * See for example the [property`Gtk`.Label:natural-wrap-mode] property.
         */

        /**
         * Options for selecting a different wrap mode for natural size
         * requests.
         *
         * See for example the [property`Gtk`.Label:natural-wrap-mode] property.
         */
        export namespace NaturalWrapMode {
            export const $gtype: GObject.GType<NaturalWrapMode>;
        }

        enum NaturalWrapMode {
            /**
             * Inherit the minimum size request.
             *   In particular, this should be used with %PANGO_WRAP_CHAR.
             */
            INHERIT,
            /**
             * Try not to wrap the text. This mode is the
             *   closest to GTK3's behavior but can lead to a wide label leaving
             *   lots of empty space below the text.
             */
            NONE,
            /**
             * Attempt to wrap at word boundaries. This
             *   is useful in particular when using %PANGO_WRAP_WORD_CHAR as the
             *   wrap mode.
             */
            WORD,
        }
        /**
         * The parameter used in the action signals of `GtkNotebook`.
         */

        /**
         * The parameter used in the action signals of `GtkNotebook`.
         */
        export namespace NotebookTab {
            export const $gtype: GObject.GType<NotebookTab>;
        }

        enum NotebookTab {
            /**
             * the first tab in the notebook
             */
            FIRST,
            /**
             * the last tab in the notebook
             */
            LAST,
        }
        /**
         * Used to determine the layout of pages on a sheet when printing
         * multiple pages per sheet.
         */

        /**
         * Used to determine the layout of pages on a sheet when printing
         * multiple pages per sheet.
         */
        export namespace NumberUpLayout {
            export const $gtype: GObject.GType<NumberUpLayout>;
        }

        enum NumberUpLayout {
            /**
             * ![](layout-lrtb.png)
             */
            LRTB,
            /**
             * ![](layout-lrbt.png)
             */
            LRBT,
            /**
             * ![](layout-rltb.png)
             */
            RLTB,
            /**
             * ![](layout-rlbt.png)
             */
            RLBT,
            /**
             * ![](layout-tblr.png)
             */
            TBLR,
            /**
             * ![](layout-tbrl.png)
             */
            TBRL,
            /**
             * ![](layout-btlr.png)
             */
            BTLR,
            /**
             * ![](layout-btrl.png)
             */
            BTRL,
        }
        /**
         * Describes the way two values can be compared.
         *
         * These values can be used with a [callback`GLib`.CompareFunc]. However,
         * a `GCompareFunc` is allowed to return any integer values.
         * For converting such a value to a `GtkOrdering` value, use
         * [func`Gtk`.Ordering.from_cmpfunc].
         */

        /**
         * Describes the way two values can be compared.
         *
         * These values can be used with a [callback`GLib`.CompareFunc]. However,
         * a `GCompareFunc` is allowed to return any integer values.
         * For converting such a value to a `GtkOrdering` value, use
         * [func`Gtk`.Ordering.from_cmpfunc].
         */
        export namespace Ordering {
            export const $gtype: GObject.GType<Ordering>;
        }

        enum Ordering {
            /**
             * the first value is smaller than the second
             */
            SMALLER,
            /**
             * the two values are equal
             */
            EQUAL,
            /**
             * the first value is larger than the second
             */
            LARGER,
        }
        /**
         * Represents the orientation of widgets and other objects.
         *
         * Typical examples are [class`Box]` or [class`GesturePan]`.
         */

        /**
         * Represents the orientation of widgets and other objects.
         *
         * Typical examples are [class`Box]` or [class`GesturePan]`.
         */
        export namespace Orientation {
            export const $gtype: GObject.GType<Orientation>;
        }

        enum Orientation {
            /**
             * The element is in horizontal orientation.
             */
            HORIZONTAL,
            /**
             * The element is in vertical orientation.
             */
            VERTICAL,
        }
        /**
         * Defines how content overflowing a given area should be handled.
         *
         * This is used in [method`Gtk`.Widget.set_overflow]. The
         * [property`Gtk`.Widget:overflow] property is modeled after the
         * CSS overflow property, but implements it only partially.
         */

        /**
         * Defines how content overflowing a given area should be handled.
         *
         * This is used in [method`Gtk`.Widget.set_overflow]. The
         * [property`Gtk`.Widget:overflow] property is modeled after the
         * CSS overflow property, but implements it only partially.
         */
        export namespace Overflow {
            export const $gtype: GObject.GType<Overflow>;
        }

        enum Overflow {
            /**
             * No change is applied. Content is drawn at the specified
             *   position.
             */
            VISIBLE,
            /**
             * Content is clipped to the bounds of the area. Content
             *   outside the area is not drawn and cannot be interacted with.
             */
            HIDDEN,
        }
        /**
         * Represents the packing location of a children in its parent.
         *
         * See [class`WindowControls]` for example.
         */

        /**
         * Represents the packing location of a children in its parent.
         *
         * See [class`WindowControls]` for example.
         */
        export namespace PackType {
            export const $gtype: GObject.GType<PackType>;
        }

        enum PackType {
            /**
             * The child is packed into the start of the widget
             */
            START,
            /**
             * The child is packed into the end of the widget
             */
            END,
        }
        /**
         * The type of a pad action.
         */

        /**
         * The type of a pad action.
         */
        export namespace PadActionType {
            export const $gtype: GObject.GType<PadActionType>;
        }

        enum PadActionType {
            /**
             * Action is triggered by a pad button
             */
            BUTTON,
            /**
             * Action is triggered by a pad ring
             */
            RING,
            /**
             * Action is triggered by a pad strip
             */
            STRIP,
        }
        /**
         * See also gtk_print_settings_set_orientation().
         */

        /**
         * See also gtk_print_settings_set_orientation().
         */
        export namespace PageOrientation {
            export const $gtype: GObject.GType<PageOrientation>;
        }

        enum PageOrientation {
            /**
             * Portrait mode.
             */
            PORTRAIT,
            /**
             * Landscape mode.
             */
            LANDSCAPE,
            /**
             * Reverse portrait mode.
             */
            REVERSE_PORTRAIT,
            /**
             * Reverse landscape mode.
             */
            REVERSE_LANDSCAPE,
        }
        /**
         * See also gtk_print_job_set_page_set().
         */

        /**
         * See also gtk_print_job_set_page_set().
         */
        export namespace PageSet {
            export const $gtype: GObject.GType<PageSet>;
        }

        enum PageSet {
            /**
             * All pages.
             */
            ALL,
            /**
             * Even pages.
             */
            EVEN,
            /**
             * Odd pages.
             */
            ODD,
        }
        /**
         * Describes the panning direction of a [class`GesturePan]`.
         */

        /**
         * Describes the panning direction of a [class`GesturePan]`.
         */
        export namespace PanDirection {
            export const $gtype: GObject.GType<PanDirection>;
        }

        enum PanDirection {
            /**
             * panned towards the left
             */
            LEFT,
            /**
             * panned towards the right
             */
            RIGHT,
            /**
             * panned upwards
             */
            UP,
            /**
             * panned downwards
             */
            DOWN,
        }
        /**
         * Determines how the size should be computed to achieve the one of the
         * visibility mode for the scrollbars.
         */

        /**
         * Determines how the size should be computed to achieve the one of the
         * visibility mode for the scrollbars.
         */
        export namespace PolicyType {
            export const $gtype: GObject.GType<PolicyType>;
        }

        enum PolicyType {
            /**
             * The scrollbar is always visible. The view size is
             *   independent of the content.
             */
            ALWAYS,
            /**
             * The scrollbar will appear and disappear as necessary.
             *   For example, when all of a `GtkTreeView` can not be seen.
             */
            AUTOMATIC,
            /**
             * The scrollbar should never appear. In this mode the
             *   content determines the size.
             */
            NEVER,
            /**
             * Don't show a scrollbar, but don't force the
             *   size to follow the content. This can be used e.g. to make multiple
             *   scrolled windows share a scrollbar.
             */
            EXTERNAL,
        }
        /**
         * Describes which edge of a widget a certain feature is positioned at.
         *
         * For examples, see the tabs of a [class`Notebook]`, or the label
         * of a [class`Scale]`.
         */

        /**
         * Describes which edge of a widget a certain feature is positioned at.
         *
         * For examples, see the tabs of a [class`Notebook]`, or the label
         * of a [class`Scale]`.
         */
        export namespace PositionType {
            export const $gtype: GObject.GType<PositionType>;
        }

        enum PositionType {
            /**
             * The feature is at the left edge.
             */
            LEFT,
            /**
             * The feature is at the right edge.
             */
            RIGHT,
            /**
             * The feature is at the top edge.
             */
            TOP,
            /**
             * The feature is at the bottom edge.
             */
            BOTTOM,
        }
        /**
         * See also gtk_print_settings_set_duplex().
         */

        /**
         * See also gtk_print_settings_set_duplex().
         */
        export namespace PrintDuplex {
            export const $gtype: GObject.GType<PrintDuplex>;
        }

        enum PrintDuplex {
            /**
             * No duplex.
             */
            SIMPLEX,
            /**
             * Horizontal duplex.
             */
            HORIZONTAL,
            /**
             * Vertical duplex.
             */
            VERTICAL,
        }
        /**
         * Error codes that identify various errors that can occur while
         * using the GTK printing support.
         */
        class PrintError extends GLib.Error {
            static $gtype: GObject.GType<PrintError>;

            // Static fields

            /**
             * An unspecified error occurred.
             */
            static GENERAL: number;
            /**
             * An internal error occurred.
             */
            static INTERNAL_ERROR: number;
            /**
             * A memory allocation failed.
             */
            static NOMEM: number;
            /**
             * An error occurred while loading a page setup
             *   or paper size from a key file.
             */
            static INVALID_FILE: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for `GtkPrintOperation` if necessary.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Determines what action the print operation should perform.
         *
         * A parameter of this typs is passed to [method`Gtk`.PrintOperation.run].
         */

        /**
         * Determines what action the print operation should perform.
         *
         * A parameter of this typs is passed to [method`Gtk`.PrintOperation.run].
         */
        export namespace PrintOperationAction {
            export const $gtype: GObject.GType<PrintOperationAction>;
        }

        enum PrintOperationAction {
            /**
             * Show the print dialog.
             */
            PRINT_DIALOG,
            /**
             * Start to print without showing
             *   the print dialog, based on the current print settings.
             */
            PRINT,
            /**
             * Show the print preview.
             */
            PREVIEW,
            /**
             * Export to a file. This requires
             *   the export-filename property to be set.
             */
            EXPORT,
        }
        /**
         * The result of a print operation.
         *
         * A value of this type is returned by [method`Gtk`.PrintOperation.run].
         */

        /**
         * The result of a print operation.
         *
         * A value of this type is returned by [method`Gtk`.PrintOperation.run].
         */
        export namespace PrintOperationResult {
            export const $gtype: GObject.GType<PrintOperationResult>;
        }

        enum PrintOperationResult {
            /**
             * An error has occurred.
             */
            ERROR,
            /**
             * The print settings should be stored.
             */
            APPLY,
            /**
             * The print operation has been canceled,
             *   the print settings should not be stored.
             */
            CANCEL,
            /**
             * The print operation is not complete
             *   yet. This value will only be returned when running asynchronously.
             */
            IN_PROGRESS,
        }
        /**
         * See also gtk_print_job_set_pages()
         */

        /**
         * See also gtk_print_job_set_pages()
         */
        export namespace PrintPages {
            export const $gtype: GObject.GType<PrintPages>;
        }

        enum PrintPages {
            /**
             * All pages.
             */
            ALL,
            /**
             * Current page.
             */
            CURRENT,
            /**
             * Range of pages.
             */
            RANGES,
            /**
             * Selected pages.
             */
            SELECTION,
        }
        /**
         * See also gtk_print_settings_set_quality().
         */

        /**
         * See also gtk_print_settings_set_quality().
         */
        export namespace PrintQuality {
            export const $gtype: GObject.GType<PrintQuality>;
        }

        enum PrintQuality {
            /**
             * Low quality.
             */
            LOW,
            /**
             * Normal quality.
             */
            NORMAL,
            /**
             * High quality.
             */
            HIGH,
            /**
             * Draft quality.
             */
            DRAFT,
        }
        /**
         * The status gives a rough indication of the completion of a running
         * print operation.
         */

        /**
         * The status gives a rough indication of the completion of a running
         * print operation.
         */
        export namespace PrintStatus {
            export const $gtype: GObject.GType<PrintStatus>;
        }

        enum PrintStatus {
            /**
             * The printing has not started yet; this
             *   status is set initially, and while the print dialog is shown.
             */
            INITIAL,
            /**
             * This status is set while the begin-print
             *   signal is emitted and during pagination.
             */
            PREPARING,
            /**
             * This status is set while the
             *   pages are being rendered.
             */
            GENERATING_DATA,
            /**
             * The print job is being sent off to the
             *   printer.
             */
            SENDING_DATA,
            /**
             * The print job has been sent to the printer,
             *   but is not printed for some reason, e.g. the printer may be stopped.
             */
            PENDING,
            /**
             * Some problem has occurred during
             *   printing, e.g. a paper jam.
             */
            PENDING_ISSUE,
            /**
             * The printer is processing the print job.
             */
            PRINTING,
            /**
             * The printing has been completed successfully.
             */
            FINISHED,
            /**
             * The printing has been aborted.
             */
            FINISHED_ABORTED,
        }
        /**
         * Describes limits of a [class`EventController]` for handling events
         * targeting other widgets.
         */

        /**
         * Describes limits of a [class`EventController]` for handling events
         * targeting other widgets.
         */
        export namespace PropagationLimit {
            export const $gtype: GObject.GType<PropagationLimit>;
        }

        enum PropagationLimit {
            /**
             * Events are handled regardless of what their
             *   target is.
             */
            NONE,
            /**
             * Events are only handled if their target is in
             *   the same [iface`Native]` (or widget with [property`Gtk`.Widget:limit-events]
             *   set) as the event controllers widget.
             *   Note that some event types have two targets (origin and destination).
             */
            SAME_NATIVE,
        }
        /**
         * Describes the stage at which events are fed into a [class`EventController]`.
         */

        /**
         * Describes the stage at which events are fed into a [class`EventController]`.
         */
        export namespace PropagationPhase {
            export const $gtype: GObject.GType<PropagationPhase>;
        }

        enum PropagationPhase {
            /**
             * Events are not delivered.
             */
            NONE,
            /**
             * Events are delivered in the capture phase. The
             *   capture phase happens before the bubble phase, runs from the toplevel down
             *   to the event widget. This option should only be used on containers that
             *   might possibly handle events before their children do.
             */
            CAPTURE,
            /**
             * Events are delivered in the bubble phase. The bubble
             *   phase happens after the capture phase, and before the default handlers
             *   are run. This phase runs from the event widget, up to the toplevel.
             */
            BUBBLE,
            /**
             * Events are delivered in the default widget event handlers,
             *   note that widget implementations must chain up on button, motion, touch and
             *   grab broken handlers for controllers in this phase to be run.
             */
            TARGET,
        }
        /**
         * Error codes for `GtkRecentManager` operations
         */
        class RecentManagerError extends GLib.Error {
            static $gtype: GObject.GType<RecentManagerError>;

            // Static fields

            /**
             * the URI specified does not exists in
             *   the recently used resources list.
             */
            static NOT_FOUND: number;
            /**
             * the URI specified is not valid.
             */
            static INVALID_URI: number;
            /**
             * the supplied string is not
             *   UTF-8 encoded.
             */
            static INVALID_ENCODING: number;
            /**
             * no application has registered
             *   the specified item.
             */
            static NOT_REGISTERED: number;
            /**
             * failure while reading the recently used
             *   resources file.
             */
            static READ: number;
            /**
             * failure while writing the recently used
             *   resources file.
             */
            static WRITE: number;
            /**
             * unspecified error.
             */
            static UNKNOWN: number;

            // Constructors

            constructor(options: { message: string; code: number });
            _init(...args: any[]): void;

            // Static methods

            /**
             * Registers an error quark for [class`RecentManager]` errors.
             */
            static quark(): GLib.Quark;
        }

        /**
         * Predefined values for use as response ids in gtk_dialog_add_button().
         *
         * All predefined values are negative; GTK leaves values of 0 or greater for
         * application-defined response ids.
         */

        /**
         * Predefined values for use as response ids in gtk_dialog_add_button().
         *
         * All predefined values are negative; GTK leaves values of 0 or greater for
         * application-defined response ids.
         */
        export namespace ResponseType {
            export const $gtype: GObject.GType<ResponseType>;
        }

        enum ResponseType {
            /**
             * Returned if an action widget has no response id,
             *   or if the dialog gets programmatically hidden or destroyed
             */
            NONE,
            /**
             * Generic response id, not used by GTK dialogs
             */
            REJECT,
            /**
             * Generic response id, not used by GTK dialogs
             */
            ACCEPT,
            /**
             * Returned if the dialog is deleted
             */
            DELETE_EVENT,
            /**
             * Returned by OK buttons in GTK dialogs
             */
            OK,
            /**
             * Returned by Cancel buttons in GTK dialogs
             */
            CANCEL,
            /**
             * Returned by Close buttons in GTK dialogs
             */
            CLOSE,
            /**
             * Returned by Yes buttons in GTK dialogs
             */
            YES,
            /**
             * Returned by No buttons in GTK dialogs
             */
            NO,
            /**
             * Returned by Apply buttons in GTK dialogs
             */
            APPLY,
            /**
             * Returned by Help buttons in GTK dialogs
             */
            HELP,
        }
        /**
         * These enumeration values describe the possible transitions
         * when the child of a `GtkRevealer` widget is shown or hidden.
         */

        /**
         * These enumeration values describe the possible transitions
         * when the child of a `GtkRevealer` widget is shown or hidden.
         */
        export namespace RevealerTransitionType {
            export const $gtype: GObject.GType<RevealerTransitionType>;
        }

        enum RevealerTransitionType {
            /**
             * No transition
             */
            NONE,
            /**
             * Fade in
             */
            CROSSFADE,
            /**
             * Slide in from the left
             */
            SLIDE_RIGHT,
            /**
             * Slide in from the right
             */
            SLIDE_LEFT,
            /**
             * Slide in from the bottom
             */
            SLIDE_UP,
            /**
             * Slide in from the top
             */
            SLIDE_DOWN,
            /**
             * Floop in from the left
             */
            SWING_RIGHT,
            /**
             * Floop in from the right
             */
            SWING_LEFT,
            /**
             * Floop in from the bottom
             */
            SWING_UP,
            /**
             * Floop in from the top
             */
            SWING_DOWN,
        }
        /**
         * Passed as argument to various keybinding signals.
         */

        /**
         * Passed as argument to various keybinding signals.
         */
        export namespace ScrollStep {
            export const $gtype: GObject.GType<ScrollStep>;
        }

        enum ScrollStep {
            /**
             * Scroll in steps.
             */
            STEPS,
            /**
             * Scroll by pages.
             */
            PAGES,
            /**
             * Scroll to ends.
             */
            ENDS,
            /**
             * Scroll in horizontal steps.
             */
            HORIZONTAL_STEPS,
            /**
             * Scroll by horizontal pages.
             */
            HORIZONTAL_PAGES,
            /**
             * Scroll to the horizontal ends.
             */
            HORIZONTAL_ENDS,
        }
        /**
         * Scrolling types.
         */

        /**
         * Scrolling types.
         */
        export namespace ScrollType {
            export const $gtype: GObject.GType<ScrollType>;
        }

        enum ScrollType {
            /**
             * No scrolling.
             */
            NONE,
            /**
             * Jump to new location.
             */
            JUMP,
            /**
             * Step backward.
             */
            STEP_BACKWARD,
            /**
             * Step forward.
             */
            STEP_FORWARD,
            /**
             * Page backward.
             */
            PAGE_BACKWARD,
            /**
             * Page forward.
             */
            PAGE_FORWARD,
            /**
             * Step up.
             */
            STEP_UP,
            /**
             * Step down.
             */
            STEP_DOWN,
            /**
             * Page up.
             */
            PAGE_UP,
            /**
             * Page down.
             */
            PAGE_DOWN,
            /**
             * Step to the left.
             */
            STEP_LEFT,
            /**
             * Step to the right.
             */
            STEP_RIGHT,
            /**
             * Page to the left.
             */
            PAGE_LEFT,
            /**
             * Page to the right.
             */
            PAGE_RIGHT,
            /**
             * Scroll to start.
             */
            START,
            /**
             * Scroll to end.
             */
            END,
        }
        /**
         * Defines the policy to be used in a scrollable widget when updating
         * the scrolled window adjustments in a given orientation.
         */

        /**
         * Defines the policy to be used in a scrollable widget when updating
         * the scrolled window adjustments in a given orientation.
         */
        export namespace ScrollablePolicy {
            export const $gtype: GObject.GType<ScrollablePolicy>;
        }

        enum ScrollablePolicy {
            /**
             * Scrollable adjustments are based on the minimum size
             */
            MINIMUM,
            /**
             * Scrollable adjustments are based on the natural size
             */
            NATURAL,
        }
        /**
         * Used to control what selections users are allowed to make.
         */

        /**
         * Used to control what selections users are allowed to make.
         */
        export namespace SelectionMode {
            export const $gtype: GObject.GType<SelectionMode>;
        }

        enum SelectionMode {
            /**
             * No selection is possible.
             */
            NONE,
            /**
             * Zero or one element may be selected.
             */
            SINGLE,
            /**
             * Exactly one element is selected.
             *   In some circumstances, such as initially or during a search
             *   operation, it’s possible for no element to be selected with
             *   %GTK_SELECTION_BROWSE. What is really enforced is that the user
             *   can’t deselect a currently selected element except by selecting
             *   another element.
             */
            BROWSE,
            /**
             * Any number of elements may be selected.
             *   The Ctrl key may be used to enlarge the selection, and Shift
             *   key to select between the focus and the child pointed to.
             *   Some widgets may also allow Click-drag to select a range of elements.
             */
            MULTIPLE,
        }
        /**
         * Determines how GTK handles the sensitivity of various controls,
         * such as combo box buttons.
         */

        /**
         * Determines how GTK handles the sensitivity of various controls,
         * such as combo box buttons.
         */
        export namespace SensitivityType {
            export const $gtype: GObject.GType<SensitivityType>;
        }

        enum SensitivityType {
            /**
             * The control is made insensitive if no
             *   action can be triggered
             */
            AUTO,
            /**
             * The control is always sensitive
             */
            ON,
            /**
             * The control is always insensitive
             */
            OFF,
        }
        /**
         * Describes where [class`Shortcut]`s added to a
         * [class`ShortcutController]` get handled.
         */

        /**
         * Describes where [class`Shortcut]`s added to a
         * [class`ShortcutController]` get handled.
         */
        export namespace ShortcutScope {
            export const $gtype: GObject.GType<ShortcutScope>;
        }

        enum ShortcutScope {
            /**
             * Shortcuts are handled inside
             *   the widget the controller belongs to.
             */
            LOCAL,
            /**
             * Shortcuts are handled by
             *   the first ancestor that is a [iface`ShortcutManager]`
             */
            MANAGED,
            /**
             * Shortcuts are handled by
             *   the root widget.
             */
            GLOBAL,
        }
        /**
         * GtkShortcutType specifies the kind of shortcut that is being described.
         *
         * More values may be added to this enumeration over time.
         */

        /**
         * GtkShortcutType specifies the kind of shortcut that is being described.
         *
         * More values may be added to this enumeration over time.
         */
        export namespace ShortcutType {
            export const $gtype: GObject.GType<ShortcutType>;
        }

        enum ShortcutType {
            /**
             * The shortcut is a keyboard accelerator. The GtkShortcutsShortcut:accelerator
             *   property will be used.
             */
            ACCELERATOR,
            /**
             * The shortcut is a pinch gesture. GTK provides an icon and subtitle.
             */
            GESTURE_PINCH,
            /**
             * The shortcut is a stretch gesture. GTK provides an icon and subtitle.
             */
            GESTURE_STRETCH,
            /**
             * The shortcut is a clockwise rotation gesture. GTK provides an icon and subtitle.
             */
            GESTURE_ROTATE_CLOCKWISE,
            /**
             * The shortcut is a counterclockwise rotation gesture. GTK provides an icon and subtitle.
             */
            GESTURE_ROTATE_COUNTERCLOCKWISE,
            /**
             * The shortcut is a two-finger swipe gesture. GTK provides an icon and subtitle.
             */
            GESTURE_TWO_FINGER_SWIPE_LEFT,
            /**
             * The shortcut is a two-finger swipe gesture. GTK provides an icon and subtitle.
             */
            GESTURE_TWO_FINGER_SWIPE_RIGHT,
            /**
             * The shortcut is a gesture. The GtkShortcutsShortcut:icon property will be
             *   used.
             */
            GESTURE,
            /**
             * The shortcut is a swipe gesture. GTK provides an icon and subtitle.
             */
            GESTURE_SWIPE_LEFT,
            /**
             * The shortcut is a swipe gesture. GTK provides an icon and subtitle.
             */
            GESTURE_SWIPE_RIGHT,
        }
        /**
         * The mode of the size group determines the directions in which the size
         * group affects the requested sizes of its component widgets.
         */

        /**
         * The mode of the size group determines the directions in which the size
         * group affects the requested sizes of its component widgets.
         */
        export namespace SizeGroupMode {
            export const $gtype: GObject.GType<SizeGroupMode>;
        }

        enum SizeGroupMode {
            /**
             * group has no effect
             */
            NONE,
            /**
             * group affects horizontal requisition
             */
            HORIZONTAL,
            /**
             * group affects vertical requisition
             */
            VERTICAL,
            /**
             * group affects both horizontal and vertical requisition
             */
            BOTH,
        }
        /**
         * Specifies a preference for height-for-width or
         * width-for-height geometry management.
         */

        /**
         * Specifies a preference for height-for-width or
         * width-for-height geometry management.
         */
        export namespace SizeRequestMode {
            export const $gtype: GObject.GType<SizeRequestMode>;
        }

        enum SizeRequestMode {
            /**
             * Prefer height-for-width geometry management
             */
            HEIGHT_FOR_WIDTH,
            /**
             * Prefer width-for-height geometry management
             */
            WIDTH_FOR_HEIGHT,
            /**
             * Don’t trade height-for-width or width-for-height
             */
            CONSTANT_SIZE,
        }
        /**
         * Determines the direction of a sort.
         */

        /**
         * Determines the direction of a sort.
         */
        export namespace SortType {
            export const $gtype: GObject.GType<SortType>;
        }

        enum SortType {
            /**
             * Sorting is in ascending order.
             */
            ASCENDING,
            /**
             * Sorting is in descending order.
             */
            DESCENDING,
        }
        /**
         * Describes changes in a sorter in more detail and allows users
         * to optimize resorting.
         */

        /**
         * Describes changes in a sorter in more detail and allows users
         * to optimize resorting.
         */
        export namespace SorterChange {
            export const $gtype: GObject.GType<SorterChange>;
        }

        enum SorterChange {
            /**
             * The sorter change cannot be described
             *   by any of the other enumeration values
             */
            DIFFERENT,
            /**
             * The sort order was inverted. Comparisons
             *   that returned %GTK_ORDERING_SMALLER now return %GTK_ORDERING_LARGER
             *   and vice versa. Other comparisons return the same values as before.
             */
            INVERTED,
            /**
             * The sorter is less strict: Comparisons
             *   may now return %GTK_ORDERING_EQUAL that did not do so before.
             */
            LESS_STRICT,
            /**
             * The sorter is more strict: Comparisons
             *   that did return %GTK_ORDERING_EQUAL may not do so anymore.
             */
            MORE_STRICT,
        }
        /**
         * Describes the type of order that a `GtkSorter` may produce.
         */

        /**
         * Describes the type of order that a `GtkSorter` may produce.
         */
        export namespace SorterOrder {
            export const $gtype: GObject.GType<SorterOrder>;
        }

        enum SorterOrder {
            /**
             * A partial order. Any `GtkOrdering` is possible.
             */
            PARTIAL,
            /**
             * No order, all elements are considered equal.
             *   gtk_sorter_compare() will only return %GTK_ORDERING_EQUAL.
             */
            NONE,
            /**
             * A total order. gtk_sorter_compare() will only
             *   return %GTK_ORDERING_EQUAL if an item is compared with itself. Two
             *   different items will never cause this value to be returned.
             */
            TOTAL,
        }
        /**
         * Determines whether the spin button displays values outside the adjustment
         * bounds.
         *
         * See [method`Gtk`.SpinButton.set_update_policy].
         */

        /**
         * Determines whether the spin button displays values outside the adjustment
         * bounds.
         *
         * See [method`Gtk`.SpinButton.set_update_policy].
         */
        export namespace SpinButtonUpdatePolicy {
            export const $gtype: GObject.GType<SpinButtonUpdatePolicy>;
        }

        enum SpinButtonUpdatePolicy {
            /**
             * When refreshing your `GtkSpinButton`, the value is
             *   always displayed
             */
            ALWAYS,
            /**
             * When refreshing your `GtkSpinButton`, the value is
             *   only displayed if it is valid within the bounds of the spin button's
             *   adjustment
             */
            IF_VALID,
        }
        /**
         * The values of the GtkSpinType enumeration are used to specify the
         * change to make in gtk_spin_button_spin().
         */

        /**
         * The values of the GtkSpinType enumeration are used to specify the
         * change to make in gtk_spin_button_spin().
         */
        export namespace SpinType {
            export const $gtype: GObject.GType<SpinType>;
        }

        enum SpinType {
            /**
             * Increment by the adjustments step increment.
             */
            STEP_FORWARD,
            /**
             * Decrement by the adjustments step increment.
             */
            STEP_BACKWARD,
            /**
             * Increment by the adjustments page increment.
             */
            PAGE_FORWARD,
            /**
             * Decrement by the adjustments page increment.
             */
            PAGE_BACKWARD,
            /**
             * Go to the adjustments lower bound.
             */
            HOME,
            /**
             * Go to the adjustments upper bound.
             */
            END,
            /**
             * Change by a specified amount.
             */
            USER_DEFINED,
        }
        /**
         * Possible transitions between pages in a `GtkStack` widget.
         *
         * New values may be added to this enumeration over time.
         */

        /**
         * Possible transitions between pages in a `GtkStack` widget.
         *
         * New values may be added to this enumeration over time.
         */
        export namespace StackTransitionType {
            export const $gtype: GObject.GType<StackTransitionType>;
        }

        enum StackTransitionType {
            /**
             * No transition
             */
            NONE,
            /**
             * A cross-fade
             */
            CROSSFADE,
            /**
             * Slide from left to right
             */
            SLIDE_RIGHT,
            /**
             * Slide from right to left
             */
            SLIDE_LEFT,
            /**
             * Slide from bottom up
             */
            SLIDE_UP,
            /**
             * Slide from top down
             */
            SLIDE_DOWN,
            /**
             * Slide from left or right according to the children order
             */
            SLIDE_LEFT_RIGHT,
            /**
             * Slide from top down or bottom up according to the order
             */
            SLIDE_UP_DOWN,
            /**
             * Cover the old page by sliding up
             */
            OVER_UP,
            /**
             * Cover the old page by sliding down
             */
            OVER_DOWN,
            /**
             * Cover the old page by sliding to the left
             */
            OVER_LEFT,
            /**
             * Cover the old page by sliding to the right
             */
            OVER_RIGHT,
            /**
             * Uncover the new page by sliding up
             */
            UNDER_UP,
            /**
             * Uncover the new page by sliding down
             */
            UNDER_DOWN,
            /**
             * Uncover the new page by sliding to the left
             */
            UNDER_LEFT,
            /**
             * Uncover the new page by sliding to the right
             */
            UNDER_RIGHT,
            /**
             * Cover the old page sliding up or uncover the new page sliding down, according to order
             */
            OVER_UP_DOWN,
            /**
             * Cover the old page sliding down or uncover the new page sliding up, according to order
             */
            OVER_DOWN_UP,
            /**
             * Cover the old page sliding left or uncover the new page sliding right, according to order
             */
            OVER_LEFT_RIGHT,
            /**
             * Cover the old page sliding right or uncover the new page sliding left, according to order
             */
            OVER_RIGHT_LEFT,
            /**
             * Pretend the pages are sides of a cube and rotate that cube to the left
             */
            ROTATE_LEFT,
            /**
             * Pretend the pages are sides of a cube and rotate that cube to the right
             */
            ROTATE_RIGHT,
            /**
             * Pretend the pages are sides of a cube and rotate that cube to the left or right according to the children order
             */
            ROTATE_LEFT_RIGHT,
        }
        /**
         * Specifies how search strings are matched inside text.
         */

        /**
         * Specifies how search strings are matched inside text.
         */
        export namespace StringFilterMatchMode {
            export const $gtype: GObject.GType<StringFilterMatchMode>;
        }

        enum StringFilterMatchMode {
            /**
             * The search string and
             *   text must match exactly
             */
            EXACT,
            /**
             * The search string
             *   must be contained as a substring inside the text
             */
            SUBSTRING,
            /**
             * The text must begin
             *   with the search string
             */
            PREFIX,
        }
        /**
         * The indexes of colors passed to symbolic color rendering, such as
         * [vfunc`Gtk`.SymbolicPaintable.snapshot_symbolic].
         *
         * More values may be added over time.
         */

        /**
         * The indexes of colors passed to symbolic color rendering, such as
         * [vfunc`Gtk`.SymbolicPaintable.snapshot_symbolic].
         *
         * More values may be added over time.
         */
        export namespace SymbolicColor {
            export const $gtype: GObject.GType<SymbolicColor>;
        }

        enum SymbolicColor {
            /**
             * The default foreground color
             */
            FOREGROUND,
            /**
             * Indication color for errors
             */
            ERROR,
            /**
             * Indication color for warnings
             */
            WARNING,
            /**
             * Indication color for success
             */
            SUCCESS,
        }
        /**
         * Values that can be passed to the [vfunc`Gtk`.Widget.system_setting_changed]
         * vfunc.
         *
         * The values indicate which system setting has changed.
         * Widgets may need to drop caches, or react otherwise.
         *
         * Most of the values correspond to [class`Settings]` properties.
         *
         * More values may be added over time.
         */

        /**
         * Values that can be passed to the [vfunc`Gtk`.Widget.system_setting_changed]
         * vfunc.
         *
         * The values indicate which system setting has changed.
         * Widgets may need to drop caches, or react otherwise.
         *
         * Most of the values correspond to [class`Settings]` properties.
         *
         * More values may be added over time.
         */
        export namespace SystemSetting {
            export const $gtype: GObject.GType<SystemSetting>;
        }

        enum SystemSetting {
            /**
             * the [property`Gtk`.Settings:gtk-xft-dpi] setting has changed
             */
            DPI,
            /**
             * The [property`Gtk`.Settings:gtk-font-name] setting has changed
             */
            FONT_NAME,
            /**
             * The font configuration has changed in a way that
             *   requires text to be redrawn. This can be any of the
             *   [property`Gtk`.Settings:gtk-xft-antialias],
             *   [property`Gtk`.Settings:gtk-xft-hinting],
             *   [property`Gtk`.Settings:gtk-xft-hintstyle],
             *   [property`Gtk`.Settings:gtk-xft-rgba] or
             *   [property`Gtk`.Settings:gtk-fontconfig-timestamp] settings
             */
            FONT_CONFIG,
            /**
             * The display has changed
             */
            DISPLAY,
            /**
             * The icon theme has changed in a way that requires
             *   icons to be looked up again
             */
            ICON_THEME,
        }
        /**
         * Reading directions for text.
         */

        /**
         * Reading directions for text.
         */
        export namespace TextDirection {
            export const $gtype: GObject.GType<TextDirection>;
        }

        enum TextDirection {
            /**
             * No direction.
             */
            NONE,
            /**
             * Left to right text direction.
             */
            LTR,
            /**
             * Right to left text direction.
             */
            RTL,
        }
        /**
         * Granularity types that extend the text selection. Use the
         * `GtkTextView::extend-selection` signal to customize the selection.
         */

        /**
         * Granularity types that extend the text selection. Use the
         * `GtkTextView::extend-selection` signal to customize the selection.
         */
        export namespace TextExtendSelection {
            export const $gtype: GObject.GType<TextExtendSelection>;
        }

        enum TextExtendSelection {
            /**
             * Selects the current word. It is triggered by
             *   a double-click for example.
             */
            WORD,
            /**
             * Selects the current line. It is triggered by
             *   a triple-click for example.
             */
            LINE,
        }
        /**
         * Used to reference the layers of `GtkTextView` for the purpose of customized
         * drawing with the ::snapshot_layer vfunc.
         */

        /**
         * Used to reference the layers of `GtkTextView` for the purpose of customized
         * drawing with the ::snapshot_layer vfunc.
         */
        export namespace TextViewLayer {
            export const $gtype: GObject.GType<TextViewLayer>;
        }

        enum TextViewLayer {
            /**
             * The layer rendered below the text (but above the background).
             */
            BELOW_TEXT,
            /**
             * The layer rendered above the text.
             */
            ABOVE_TEXT,
        }
        /**
         * Used to reference the parts of `GtkTextView`.
         */

        /**
         * Used to reference the parts of `GtkTextView`.
         */
        export namespace TextWindowType {
            export const $gtype: GObject.GType<TextWindowType>;
        }

        enum TextWindowType {
            /**
             * Window that floats over scrolling areas.
             */
            WIDGET,
            /**
             * Scrollable text window.
             */
            TEXT,
            /**
             * Left side border window.
             */
            LEFT,
            /**
             * Right side border window.
             */
            RIGHT,
            /**
             * Top border window.
             */
            TOP,
            /**
             * Bottom border window.
             */
            BOTTOM,
        }
        /**
         * The sizing method the column uses to determine its width.  Please note
         * that %GTK_TREE_VIEW_COLUMN_AUTOSIZE are inefficient for large views, and
         * can make columns appear choppy.
         */

        /**
         * The sizing method the column uses to determine its width.  Please note
         * that %GTK_TREE_VIEW_COLUMN_AUTOSIZE are inefficient for large views, and
         * can make columns appear choppy.
         */
        export namespace TreeViewColumnSizing {
            export const $gtype: GObject.GType<TreeViewColumnSizing>;
        }

        enum TreeViewColumnSizing {
            /**
             * Columns only get bigger in reaction to changes in the model
             */
            GROW_ONLY,
            /**
             * Columns resize to be the optimal size every time the model changes.
             */
            AUTOSIZE,
            /**
             * Columns are a fixed numbers of pixels wide.
             */
            FIXED,
        }
        /**
         * An enum for determining where a dropped row goes.
         */

        /**
         * An enum for determining where a dropped row goes.
         */
        export namespace TreeViewDropPosition {
            export const $gtype: GObject.GType<TreeViewDropPosition>;
        }

        enum TreeViewDropPosition {
            /**
             * dropped row is inserted before
             */
            BEFORE,
            /**
             * dropped row is inserted after
             */
            AFTER,
            /**
             * dropped row becomes a child or is inserted before
             */
            INTO_OR_BEFORE,
            /**
             * dropped row becomes a child or is inserted after
             */
            INTO_OR_AFTER,
        }
        /**
         * Used to indicate which grid lines to draw in a tree view.
         */

        /**
         * Used to indicate which grid lines to draw in a tree view.
         */
        export namespace TreeViewGridLines {
            export const $gtype: GObject.GType<TreeViewGridLines>;
        }

        enum TreeViewGridLines {
            /**
             * No grid lines.
             */
            NONE,
            /**
             * Horizontal grid lines.
             */
            HORIZONTAL,
            /**
             * Vertical grid lines.
             */
            VERTICAL,
            /**
             * Horizontal and vertical grid lines.
             */
            BOTH,
        }
        /**
         * See also gtk_print_settings_set_paper_width().
         */

        /**
         * See also gtk_print_settings_set_paper_width().
         */
        export namespace Unit {
            export const $gtype: GObject.GType<Unit>;
        }

        enum Unit {
            /**
             * No units.
             */
            NONE,
            /**
             * Dimensions in points.
             */
            POINTS,
            /**
             * Dimensions in inches.
             */
            INCH,
            /**
             * Dimensions in millimeters
             */
            MM,
        }
        /**
         * Describes a type of line wrapping.
         */

        /**
         * Describes a type of line wrapping.
         */
        export namespace WrapMode {
            export const $gtype: GObject.GType<WrapMode>;
        }

        enum WrapMode {
            /**
             * do not wrap lines; just make the text area wider
             */
            NONE,
            /**
             * wrap text, breaking lines anywhere the cursor can
             *   appear (between characters, usually - if you want to be technical,
             *   between graphemes, see pango_get_log_attrs())
             */
            CHAR,
            /**
             * wrap text, breaking lines in between words
             */
            WORD,
            /**
             * wrap text, breaking lines in between words, or if
             *   that is not enough, also between graphemes
             */
            WORD_CHAR,
        }
        /**
         * An attribute for the background color, expressed as an RGB value
         * encoded in a string using the format: `{r8},{g8},{b8}`.
         */
        const ACCESSIBLE_ATTRIBUTE_BACKGROUND: string;
        /**
         * An attribute for the font family name.
         */
        const ACCESSIBLE_ATTRIBUTE_FAMILY: string;
        /**
         * An attribute for the foreground color, expressed as an RGB value
         * encoded in a string using the format: `{r8},{g8},{b8}`.
         */
        const ACCESSIBLE_ATTRIBUTE_FOREGROUND: string;
        /**
         * An attribute for the overline style.
         *
         * Possible values are:
         *
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_OVERLINE_NONE]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_OVERLINE_SINGLE]
         */
        const ACCESSIBLE_ATTRIBUTE_OVERLINE: string;
        /**
         * The "none" overline value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_OVERLINE].
         */
        const ACCESSIBLE_ATTRIBUTE_OVERLINE_NONE: string;
        /**
         * The "single" overline value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_OVERLINE].
         */
        const ACCESSIBLE_ATTRIBUTE_OVERLINE_SINGLE: string;
        /**
         * An attribute for the font size, expressed in points.
         */
        const ACCESSIBLE_ATTRIBUTE_SIZE: string;
        /**
         * An attribute for the font stretch type.
         *
         * Possible values are:
         *
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_CONDENSED]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_CONDENSED]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH_CONDENSED]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_CONDENSED]
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH: string;
        /**
         * The "condensed" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_CONDENSED: string;
        /**
         * The "expanded" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_EXPANDED: string;
        /**
         * The "extra condensed" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_CONDENSED: string;
        /**
         * The "extra expanded" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_EXTRA_EXPANDED: string;
        /**
         * The "normal" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_NORMAL: string;
        /**
         * The "semi condensed" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_CONDENSED: string;
        /**
         * The "semi expanded" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_SEMI_EXPANDED: string;
        /**
         * The "ultra condensed" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_CONDENSED: string;
        /**
         * The "ultra expanded" stretch value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STRETCH].
         */
        const ACCESSIBLE_ATTRIBUTE_STRETCH_ULTRA_EXPANDED: string;
        /**
         * An attribute for strikethrough text.
         *
         * Possible values are `true` or `false`.
         */
        const ACCESSIBLE_ATTRIBUTE_STRIKETHROUGH: string;
        /**
         * An attribute for the font style.
         *
         * Possible values are:
         *
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STYLE_NORMAL]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STYLE_OBLIQUE]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STYLE_ITALIC]
         */
        const ACCESSIBLE_ATTRIBUTE_STYLE: string;
        /**
         * The "italic" style value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STYLE].
         */
        const ACCESSIBLE_ATTRIBUTE_STYLE_ITALIC: string;
        /**
         * The "normal" style value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STYLE].
         */
        const ACCESSIBLE_ATTRIBUTE_STYLE_NORMAL: string;
        /**
         * The "oblique" style value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_STYLE].
         */
        const ACCESSIBLE_ATTRIBUTE_STYLE_OBLIQUE: string;
        /**
         * An attribute for the underline style.
         *
         * Possible values are:
         *
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE_NONE]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE_SINGLE]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE_DOUBLE]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE_ERROR]
         */
        const ACCESSIBLE_ATTRIBUTE_UNDERLINE: string;
        /**
         * The "double" underline value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
         */
        const ACCESSIBLE_ATTRIBUTE_UNDERLINE_DOUBLE: string;
        /**
         * The "error" underline value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
         */
        const ACCESSIBLE_ATTRIBUTE_UNDERLINE_ERROR: string;
        /**
         * The "none" underline value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
         */
        const ACCESSIBLE_ATTRIBUTE_UNDERLINE_NONE: string;
        /**
         * The "single" underline value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_UNDERLINE].
         */
        const ACCESSIBLE_ATTRIBUTE_UNDERLINE_SINGLE: string;
        /**
         * An attribute for the font variant.
         *
         * Possible values are:
         *
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT_SMALL_CAPS]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_SMALL_CAPS]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT_PETITE_CAPS]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_PETITE_CAPS]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT_UNICASE]
         * - [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT_TITLE_CAPS]
         */
        const ACCESSIBLE_ATTRIBUTE_VARIANT: string;
        /**
         * The "all petite caps" variant value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT].
         */
        const ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_PETITE_CAPS: string;
        /**
         * The "all small caps" variant value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT].
         */
        const ACCESSIBLE_ATTRIBUTE_VARIANT_ALL_SMALL_CAPS: string;
        /**
         * The "petite caps" variant value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT].
         */
        const ACCESSIBLE_ATTRIBUTE_VARIANT_PETITE_CAPS: string;
        /**
         * The "small caps" variant value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT].
         */
        const ACCESSIBLE_ATTRIBUTE_VARIANT_SMALL_CAPS: string;
        /**
         * The "title caps" variant value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT].
         */
        const ACCESSIBLE_ATTRIBUTE_VARIANT_TITLE_CAPS: string;
        /**
         * The "unicase" variant value for [const`Gtk`.ACCESSIBLE_ATTRIBUTE_VARIANT].
         */
        const ACCESSIBLE_ATTRIBUTE_VARIANT_UNICASE: string;
        /**
         * An attribute for the font weight.
         */
        const ACCESSIBLE_ATTRIBUTE_WEIGHT: string;
        /**
         * An undefined value. The accessible attribute is either unset, or its
         * value is undefined.
         */
        const ACCESSIBLE_VALUE_UNDEFINED: number;
        /**
         * Like [func`get_binary_age]`, but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const BINARY_AGE: number;
        /**
         * The default name of the extension point.
         */
        const IM_MODULE_EXTENSION_POINT_NAME: string;
        /**
         * Constant to return from a signal handler for the ::input
         * signal in case of conversion failure.
         *
         * See [signal`Gtk`.SpinButton::input].
         */
        const INPUT_ERROR: number;
        /**
         * Like [func`get_interface_age]`, but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const INTERFACE_AGE: number;
        /**
         * The value used to refer to a guaranteed invalid position
         * in a `GListModel`.
         *
         * This value may be returned from some functions, others may
         * accept it as input. Its interpretation may differ for different
         * functions.
         *
         * Refer to each function's documentation for if this value is
         * allowed and what it does.
         */
        const INVALID_LIST_POSITION: number;
        /**
         * The name used for the stock full offset included by `GtkLevelBar`.
         */
        const LEVEL_BAR_OFFSET_FULL: string;
        /**
         * The name used for the stock high offset included by `GtkLevelBar`.
         */
        const LEVEL_BAR_OFFSET_HIGH: string;
        /**
         * The name used for the stock low offset included by `GtkLevelBar`.
         */
        const LEVEL_BAR_OFFSET_LOW: string;
        /**
         * Like [func`get_major_version]`, but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const MAJOR_VERSION: number;
        /**
         * Evaluates to the maximum length of a compose sequence.
         *
         * This macro is longer used by GTK.
         */
        const MAX_COMPOSE_LEN: number;
        /**
         * The default extension point name for media file.
         */
        const MEDIA_FILE_EXTENSION_POINT_NAME: string;
        /**
         * Like [func`get_micro_version]`, but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const MICRO_VERSION: number;
        /**
         * Like [func`get_minor_version]`, but from the headers used at
         * application compile time, rather than from the library linked
         * against at application run time.
         */
        const MINOR_VERSION: number;
        /**
         * Name for the A3 paper size.
         */
        const PAPER_NAME_A3: string;
        /**
         * Name for the A4 paper size.
         */
        const PAPER_NAME_A4: string;
        /**
         * Name for the A5 paper size.
         */
        const PAPER_NAME_A5: string;
        /**
         * Name for the B5 paper size.
         */
        const PAPER_NAME_B5: string;
        /**
         * Name for the Executive paper size.
         */
        const PAPER_NAME_EXECUTIVE: string;
        /**
         * Name for the Legal paper size.
         */
        const PAPER_NAME_LEGAL: string;
        /**
         * Name for the Letter paper size.
         */
        const PAPER_NAME_LETTER: string;
        /**
         * The key used by the “Print to file” printer to store whether to collate the
         * printed pages.
         */
        const PRINT_SETTINGS_COLLATE: string;
        /**
         * The key used by the “Print to file” printer to store the default source.
         */
        const PRINT_SETTINGS_DEFAULT_SOURCE: string;
        /**
         * The key used by the “Print to file” printer to store the dither used.
         */
        const PRINT_SETTINGS_DITHER: string;
        /**
         * The key used by the “Print to file” printer to store whether to print the
         * output in duplex.
         */
        const PRINT_SETTINGS_DUPLEX: string;
        /**
         * The key used by the “Print to file” printer to store the finishings.
         */
        const PRINT_SETTINGS_FINISHINGS: string;
        /**
         * The key used by the “Print to file” printer to store the media type.
         *
         * The set of media types is defined in PWG 5101.1-2002 PWG.
         */
        const PRINT_SETTINGS_MEDIA_TYPE: string;
        /**
         * The key used by the “Print to file” printer to store the number of pages per
         * sheet.
         */
        const PRINT_SETTINGS_NUMBER_UP: string;
        /**
         * The key used by the “Print to file” printer to store the number of pages per
         * sheet in number-up mode.
         */
        const PRINT_SETTINGS_NUMBER_UP_LAYOUT: string;
        /**
         * The key used by the “Print to file” printer to store the number of copies.
         */
        const PRINT_SETTINGS_N_COPIES: string;
        /**
         * The key used by the “Print to file” printer to store the orientation.
         */
        const PRINT_SETTINGS_ORIENTATION: string;
        /**
         * The key used by the “Print to file” printer to store the file
         * name of the output without the path to the directory and the
         * file extension.
         */
        const PRINT_SETTINGS_OUTPUT_BASENAME: string;
        /**
         * The key used by the “Print to file” printer to store the output bin.
         */
        const PRINT_SETTINGS_OUTPUT_BIN: string;
        /**
         * The key used by the “Print to file” printer to store the
         * directory to which the output should be written.
         */
        const PRINT_SETTINGS_OUTPUT_DIR: string;
        /**
         * The key used by the “Print to file” printer to store the format
         * of the output. The supported values are “PS” and “PDF”.
         */
        const PRINT_SETTINGS_OUTPUT_FILE_FORMAT: string;
        /**
         * The key used by the “Print to file” printer to store the URI
         * to which the output should be written. GTK itself supports
         * only “file://” URIs.
         */
        const PRINT_SETTINGS_OUTPUT_URI: string;
        /**
         * The key used by the “Print to file” printer to store the array of page ranges
         * to print.
         */
        const PRINT_SETTINGS_PAGE_RANGES: string;
        /**
         * The key used by the “Print to file” printer to store the set of pages to print.
         */
        const PRINT_SETTINGS_PAGE_SET: string;
        /**
         * The key used by the “Print to file” printer to store the page format.
         */
        const PRINT_SETTINGS_PAPER_FORMAT: string;
        /**
         * The key used by the “Print to file” printer to store the page height.
         */
        const PRINT_SETTINGS_PAPER_HEIGHT: string;
        /**
         * The key used by the “Print to file” printer to store the paper width.
         */
        const PRINT_SETTINGS_PAPER_WIDTH: string;
        /**
         * The key used by the “Print to file” printer to store the printer name.
         */
        const PRINT_SETTINGS_PRINTER: string;
        /**
         * The key used by the “Print to file” printer to store the resolution in lines
         * per inch.
         */
        const PRINT_SETTINGS_PRINTER_LPI: string;
        /**
         * The key used by the “Print to file” printer to store which pages to print.
         */
        const PRINT_SETTINGS_PRINT_PAGES: string;
        /**
         * The key used by the “Print to file” printer to store the printing quality.
         */
        const PRINT_SETTINGS_QUALITY: string;
        /**
         * The key used by the “Print to file” printer to store the resolution in DPI.
         */
        const PRINT_SETTINGS_RESOLUTION: string;
        /**
         * The key used by the “Print to file” printer to store the horizontal
         * resolution in DPI.
         */
        const PRINT_SETTINGS_RESOLUTION_X: string;
        /**
         * The key used by the “Print to file” printer to store the vertical resolution
         * in DPI.
         */
        const PRINT_SETTINGS_RESOLUTION_Y: string;
        /**
         * The key used by the “Print to file” printer to store whether to reverse the
         * order of the printed pages.
         */
        const PRINT_SETTINGS_REVERSE: string;
        /**
         * The key used by the “Print to file” printer to store the scale.
         */
        const PRINT_SETTINGS_SCALE: string;
        /**
         * The key used by the “Print to file” printer to store whether to print with
         * colors.
         */
        const PRINT_SETTINGS_USE_COLOR: string;
        /**
         * The key used by the “Print to file” printer to store 32-bit Windows extra
         * driver.
         */
        const PRINT_SETTINGS_WIN32_DRIVER_EXTRA: string;
        /**
         * The key used by the “Print to file” printer to store the 32-bit Windows
         * driver version.
         */
        const PRINT_SETTINGS_WIN32_DRIVER_VERSION: string;
        /**
         * Use this priority for functionality related to size allocation.
         *
         * It is used internally by GTK+ to compute the sizes of widgets.
         * This priority is higher than %GDK_PRIORITY_REDRAW to avoid
         * resizing a widget which was just redrawn.
         */
        const PRIORITY_RESIZE: number;
        /**
         * A priority that can be used when adding a `GtkStyleProvider`
         * for application-specific style information.
         */
        const STYLE_PROVIDER_PRIORITY_APPLICATION: number;
        /**
         * The priority used for default style information
         * that is used in the absence of themes.
         *
         * Note that this is not very useful for providing default
         * styling for custom style classes - themes are likely to
         * override styling provided at this priority with
         * catch-all `* {...}` rules.
         */
        const STYLE_PROVIDER_PRIORITY_FALLBACK: number;
        /**
         * The priority used for style information provided
         * via `GtkSettings`.
         *
         * This priority is higher than %GTK_STYLE_PROVIDER_PRIORITY_THEME
         * to let settings override themes.
         */
        const STYLE_PROVIDER_PRIORITY_SETTINGS: number;
        /**
         * The priority used for style information provided
         * by themes.
         */
        const STYLE_PROVIDER_PRIORITY_THEME: number;
        /**
         * The priority used for the style information from
         * `$XDG_CONFIG_HOME/gtk-4.0/gtk.css`.
         *
         * You should not use priorities higher than this, to
         * give the user the last word.
         */
        const STYLE_PROVIDER_PRIORITY_USER: number;
        /**
         * The priority at which the text view validates onscreen lines
         * in an idle job in the background.
         */
        const TEXT_VIEW_PRIORITY_VALIDATE: number;
        /**
         * Uses the default sort function in a [iface`Gtk`.TreeSortable].
         *
         * See also: [method`Gtk`.TreeSortable.set_sort_column_id]
         */
        const TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID: number;
        /**
         * Disables sorting in a [iface`Gtk`.TreeSortable].
         *
         * See also: [method`Gtk`.TreeSortable.set_sort_column_id]
         */
        const TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID: number;
        /**
         * Gets the modifier mask.
         *
         * The modifier mask determines which modifiers are considered significant
         * for keyboard accelerators. This includes all keyboard modifiers except
         * for `GDK_LOCK_MASK`.
         * @returns the modifier mask for accelerators
         */
        function accelerator_get_default_mod_mask(): Gdk.ModifierType;
        /**
         * Converts an accelerator keyval and modifier mask into a string
         * which can be used to represent the accelerator to the user.
         * @param accelerator_key accelerator keyval
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly-allocated string representing the accelerator
         */
        function accelerator_get_label(accelerator_key: number, accelerator_mods: Gdk.ModifierType | null): string;
        /**
         * Converts an accelerator keyval and modifier mask
         * into a string that can be displayed to the user.
         *
         * The string may be translated.
         *
         * This function is similar to [func`Gtk`.accelerator_get_label],
         * but handling keycodes. This is only useful for system-level
         * components, applications should use [func`Gtk`.accelerator_get_label]
         * instead.
         * @param display a `GdkDisplay`
         * @param accelerator_key accelerator keyval
         * @param keycode accelerator keycode
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly-allocated string representing the accelerator
         */
        function accelerator_get_label_with_keycode(
            display: Gdk.Display | null,
            accelerator_key: number,
            keycode: number,
            accelerator_mods: Gdk.ModifierType | null,
        ): string;
        /**
         * Converts an accelerator keyval and modifier mask into a string
         * that can be parsed by [func`Gtk`.accelerator_parse].
         *
         * For example, if you pass in `GDK_KEY_q` and `GDK_CONTROL_MASK`,
         * this function returns `<Control>q`.
         *
         * If you need to display accelerators in the user interface,
         * see [func`Gtk`.accelerator_get_label].
         * @param accelerator_key accelerator keyval
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly-allocated accelerator name
         */
        function accelerator_name(accelerator_key: number, accelerator_mods: Gdk.ModifierType | null): string;
        /**
         * Converts an accelerator keyval and modifier mask
         * into a string that can be parsed by [func`Gtk`.accelerator_parse_with_keycode].
         *
         * This is similar to [func`Gtk`.accelerator_name] but handling keycodes.
         * This is only useful for system-level components, applications
         * should use [func`Gtk`.accelerator_name] instead.
         * @param display a `GdkDisplay`
         * @param accelerator_key accelerator keyval
         * @param keycode accelerator keycode
         * @param accelerator_mods accelerator modifier mask
         * @returns a newly allocated accelerator name.
         */
        function accelerator_name_with_keycode(
            display: Gdk.Display | null,
            accelerator_key: number,
            keycode: number,
            accelerator_mods: Gdk.ModifierType | null,
        ): string;
        /**
         * Parses a string representing an accelerator.
         *
         * The format looks like “`<Control>a`” or “`<Shift><Alt>F1`”.
         *
         * The parser is fairly liberal and allows lower or upper case, and also
         * abbreviations such as “`<Ctl>`” and “`<Ctrl>`”.
         *
         * Key names are parsed using [func`Gdk`.keyval_from_name]. For character keys
         * the name is not the symbol, but the lowercase name, e.g. one would use
         * “`<Ctrl>minus`” instead of “`<Ctrl>-`”.
         *
         * Modifiers are enclosed in angular brackets `<>`, and match the
         * [flags`Gdk`.ModifierType] mask:
         *
         * - `<Shift>` for `GDK_SHIFT_MASK`
         * - `<Ctrl>` for `GDK_CONTROL_MASK`
         * - `<Alt>` for `GDK_ALT_MASK`
         * - `<Meta>` for `GDK_META_MASK`
         * - `<Super>` for `GDK_SUPER_MASK`
         * - `<Hyper>` for `GDK_HYPER_MASK`
         *
         * If the parse operation fails, `accelerator_key` and `accelerator_mods` will
         * be set to 0 (zero).
         * @param accelerator string representing an accelerator
         * @returns whether parsing succeeded
         */
        function accelerator_parse(accelerator: string): [boolean, number, Gdk.ModifierType | null];
        /**
         * Parses a string representing an accelerator.
         *
         * This is similar to [func`Gtk`.accelerator_parse] but handles keycodes as
         * well. This is only useful for system-level components, applications should
         * use [func`Gtk`.accelerator_parse] instead.
         *
         * If `accelerator_codes` is given and the result stored in it is non-%NULL,
         * the result must be freed with g_free().
         *
         * If a keycode is present in the accelerator and no `accelerator_codes`
         * is given, the parse will fail.
         *
         * If the parse fails, `accelerator_key,` `accelerator_mods` and
         * `accelerator_codes` will be set to 0 (zero).
         * @param accelerator string representing an accelerator
         * @param display the `GdkDisplay` to look up @accelerator_codes in
         * @returns true if parsing succeeded
         */
        function accelerator_parse_with_keycode(
            accelerator: string,
            display: Gdk.Display | null,
        ): [boolean, number, number[] | null, Gdk.ModifierType | null];
        /**
         * Determines whether a given keyval and modifier mask constitute
         * a valid keyboard accelerator.
         *
         * For example, the `GDK_KEY_a` keyval plus `GDK_CONTROL_MASK` mask is valid,
         * and matches the “Ctrl+a” accelerator. But, you can't, for instance, use
         * the `GDK_KEY_Control_L` keyval as an accelerator.
         * @param keyval a GDK keyval
         * @param modifiers modifier mask
         * @returns true if the accelerator is valid
         */
        function accelerator_valid(keyval: number, modifiers: Gdk.ModifierType | null): boolean;
        /**
         * Initializes `value` with the appropriate type for the `property`.
         *
         * This function is mostly meant for language bindings, in conjunction
         * with gtk_accessible_update_property_value().
         * @param property a `GtkAccessibleProperty`
         * @param value an uninitialized `GValue`
         */
        function accessible_property_init_value(property: AccessibleProperty | null, value: GObject.Value | any): void;
        /**
         * Initializes `value` with the appropriate type for the `relation`.
         *
         * This function is mostly meant for language bindings, in conjunction
         * with gtk_accessible_update_relation_value().
         * @param relation a `GtkAccessibleRelation`
         * @param value an uninitialized `GValue`
         */
        function accessible_relation_init_value(relation: AccessibleRelation | null, value: GObject.Value | any): void;
        /**
         * Initializes `value` with the appropriate type for the `state`.
         *
         * This function is mostly meant for language bindings, in conjunction
         * with gtk_accessible_update_relation_state().
         * @param state a `GtkAccessibleState`
         * @param value an uninitialized `GValue`
         */
        function accessible_state_init_value(state: AccessibleState | null, value: GObject.Value | any): void;
        /**
         * Initializes `iter` to point to `target`.
         *
         * If `target` is not found, finds the next value after it.
         * If no value >= `target` exists in `set,` this function returns %FALSE.
         * @param set a `GtkBitset`
         * @param target target value to start iterating at
         * @returns %TRUE if a value was found.
         */
        function bitset_iter_init_at(set: Bitset, target: number): [boolean, BitsetIter, number];
        /**
         * Initializes an iterator for `set` and points it to the first
         * value in `set`.
         *
         * If `set` is empty, %FALSE is returned and `value` is set to %G_MAXUINT.
         * @param set a `GtkBitset`
         * @returns %TRUE if @set isn't empty.
         */
        function bitset_iter_init_first(set: Bitset): [boolean, BitsetIter, number];
        /**
         * Initializes an iterator for `set` and points it to the last
         * value in `set`.
         *
         * If `set` is empty, %FALSE is returned.
         * @param set a `GtkBitset`
         * @returns %TRUE if @set isn't empty.
         */
        function bitset_iter_init_last(set: Bitset): [boolean, BitsetIter, number];
        /**
         * Registers an error quark for [class`Gtk`.Builder] errors.
         * @returns the error quark
         */
        function builder_error_quark(): GLib.Quark;
        /**
         * Checks that the GTK library in use is compatible with the
         * given version.
         *
         * Generally you would pass in the constants %GTK_MAJOR_VERSION,
         * %GTK_MINOR_VERSION, %GTK_MICRO_VERSION as the three arguments
         * to this function; that produces a check that the library in
         * use is compatible with the version of GTK the application or
         * module was compiled against.
         *
         * Compatibility is defined by two things: first the version
         * of the running library is newer than the version
         * `required_major`.required_minor.`required_micro`. Second
         * the running library must be binary compatible with the
         * version `required_major`.required_minor.`required_micro`
         * (same major version.)
         *
         * This function is primarily for GTK modules; the module
         * can call this function to check that it wasn’t loaded
         * into an incompatible version of GTK. However, such a
         * check isn’t completely reliable, since the module may be
         * linked against an old version of GTK and calling the
         * old version of gtk_check_version(), but still get loaded
         * into an application using a newer version of GTK.
         * @param required_major the required major version
         * @param required_minor the required minor version
         * @param required_micro the required micro version
         * @returns %NULL if the GTK library is compatible with the   given version, or a string describing the version mismatch.   The returned string is owned by GTK and should not be modified   or freed.
         */
        function check_version(required_major: number, required_minor: number, required_micro: number): string | null;
        /**
         * Registers an error quark for VFL error parsing.
         * @returns the error quark
         */
        function constraint_vfl_parser_error_quark(): GLib.Quark;
        /**
         * Registers an error quark for CSS parsing errors.
         * @returns the error quark
         */
        function css_parser_error_quark(): GLib.Quark;
        /**
         * Registers an error quark for CSS parsing warnings.
         * @returns the warning quark
         */
        function css_parser_warning_quark(): GLib.Quark;
        /**
         * Registers an error quark for an operation that requires a dialog if
         * necessary.
         * @returns the error quark
         */
        function dialog_error_quark(): GLib.Quark;
        /**
         * Prevents GTK from using portals.
         *
         * This is equivalent to setting `GDK_DEBUG=no-portals` in the environment.
         *
         * This should only be used in portal implementations, apps must not call it.
         */
        function disable_portals(): void;
        /**
         * Prevents [func`Gtk`.init] and [func`Gtk`.init_check] from calling `setlocale()`.
         *
         * You would want to use this function if you wanted to set the locale for
         * your program to something other than the user’s locale, or if you wanted
         * to set different values for different locale categories.
         *
         * Most programs should not need to call this function.
         */
        function disable_setlocale(): void;
        /**
         * Distributes `extra_space` to child `sizes` by bringing smaller
         * children up to natural size first.
         *
         * The remaining space will be added to the `minimum_size` member of the
         * `GtkRequestedSize` struct. If all sizes reach their natural size then
         * the remaining space is returned.
         * @param extra_space Extra space to redistribute among children after subtracting   minimum sizes and any child padding from the overall allocation
         * @param sizes An array of structs with a client pointer and a minimum/natural size  in the orientation of the allocation.
         * @returns The remainder of @extra_space after redistributing space to @sizes.
         */
        function distribute_natural_allocation(extra_space: number, sizes: RequestedSize[]): number;
        /**
         * Gets a property of the `GtkEditable` delegate for `object`.
         *
         * This is helper function that should be called in the `get_property`
         * function of your `GtkEditable` implementation, before handling your
         * own properties.
         * @param object a `GObject`
         * @param prop_id a property ID
         * @param value value to set
         * @param pspec the `GParamSpec` for the property
         * @returns %TRUE if the property was found
         */
        function editable_delegate_get_property(
            object: GObject.Object,
            prop_id: number,
            value: GObject.Value | any,
            pspec: GObject.ParamSpec,
        ): boolean;
        /**
         * Sets a property on the `GtkEditable` delegate for `object`.
         *
         * This is a helper function that should be called in the `set_property`
         * function of your `GtkEditable` implementation, before handling your
         * own properties.
         * @param object a `GObject`
         * @param prop_id a property ID
         * @param value value to set
         * @param pspec the `GParamSpec` for the property
         * @returns %TRUE if the property was found
         */
        function editable_delegate_set_property(
            object: GObject.Object,
            prop_id: number,
            value: GObject.Value | any,
            pspec: GObject.ParamSpec,
        ): boolean;
        /**
         * Overrides the `GtkEditable` properties for `class`.
         *
         * This is a helper function that should be called in class_init,
         * after installing your own properties.
         *
         * Note that your class must have "text", "cursor-position",
         * "selection-bound", "editable", "width-chars", "max-width-chars",
         * "xalign" and "enable-undo" properties for this function to work.
         *
         * To handle the properties in your set_property and get_property
         * functions, you can either use [func`Gtk`.Editable.delegate_set_property]
         * and [func`Gtk`.Editable.delegate_get_property] (if you are using
         * a delegate), or remember the `first_prop` offset and add it to the
         * values in the [enum`Gtk`.EditableProperties] enumeration to get the
         * property IDs for these properties.
         * @param object_class a `GObjectClass`
         * @param first_prop property ID to use for the first property
         * @returns the number of properties that were installed
         */
        function editable_install_properties(object_class: typeof GObject.Object, first_prop: number): number;
        /**
         * Calls a function for all printers that are known to GTK.
         *
         * If `func` returns true, the enumeration is stopped.
         * @param func a function to call for each printer
         * @param wait if true, wait in a recursive mainloop until    all printers are enumerated; otherwise return early
         */
        function enumerate_printers(func: PrinterFunc, wait: boolean): void;
        /**
         * Registers an error quark for `GtkFileChooser` errors.
         * @returns The error quark used for `GtkFileChooser` errors.
         */
        function file_chooser_error_quark(): GLib.Quark;
        /**
         * Returns the binary age as passed to `libtool`.
         *
         * If `libtool` means nothing to you, don't worry about it.
         * @returns the binary age of the GTK library
         */
        function get_binary_age(): number;
        /**
         * Returns the GTK debug flags that are currently active.
         *
         * This function is intended for GTK modules that want
         * to adjust their debug output based on GTK debug flags.
         * @returns the GTK debug flags.
         */
        function get_debug_flags(): DebugFlags;
        /**
         * Returns the `PangoLanguage` for the default language
         * currently in effect.
         *
         * Note that this can change over the life of an
         * application.
         *
         * The default language is derived from the current
         * locale. It determines, for example, whether GTK uses
         * the right-to-left or left-to-right text direction.
         *
         * This function is equivalent to [func`Pango`.Language.get_default].
         * See that function for details.
         * @returns the default language
         */
        function get_default_language(): Pango.Language;
        /**
         * Returns the interface age as passed to `libtool`.
         *
         * If `libtool` means nothing to you, don't worry about it.
         * @returns the interface age of the GTK library
         */
        function get_interface_age(): number;
        /**
         * Gets the direction of the current locale.
         *
         * This is the expected reading direction for text and UI.
         *
         * This function depends on the current locale being set with
         * `setlocale()` and will default to setting the `GTK_TEXT_DIR_LTR`
         * direction otherwise. `GTK_TEXT_DIR_NONE` will never be returned.
         *
         * GTK sets the default text direction according to the locale during
         * [func`Gtk`.init], and you should normally use [method`Gtk`.Widget.get_direction]
         * or [func`Gtk`.Widget.get_default_direction] to obtain the current direction.
         *
         * This function is only needed rare cases when the locale is
         * changed after GTK has already been initialized. In this case,
         * you can use it to update the default text direction as follows:
         *
         * ```c
         * #include <locale.h>
         *
         * static void
         * update_locale (const char *new_locale)
         * {
         *   setlocale (LC_ALL, new_locale);
         *   gtk_widget_set_default_direction (gtk_get_locale_direction ());
         * }
         * ```
         * @returns the direction of the current locale
         */
        function get_locale_direction(): TextDirection;
        /**
         * Returns the major version number of the GTK library.
         *
         * For example, in GTK version 3.1.5 this is 3.
         *
         * This function is in the library, so it represents the GTK library
         * your code is running against. Contrast with the %GTK_MAJOR_VERSION
         * macro, which represents the major version of the GTK headers you
         * have included when compiling your code.
         * @returns the major version number of the GTK library
         */
        function get_major_version(): number;
        /**
         * Returns the micro version number of the GTK library.
         *
         * For example, in GTK version 3.1.5 this is 5.
         *
         * This function is in the library, so it represents the GTK library
         * your code is are running against. Contrast with the
         * %GTK_MICRO_VERSION macro, which represents the micro version of the
         * GTK headers you have included when compiling your code.
         * @returns the micro version number of the GTK library
         */
        function get_micro_version(): number;
        /**
         * Returns the minor version number of the GTK library.
         *
         * For example, in GTK version 3.1.5 this is 1.
         *
         * This function is in the library, so it represents the GTK library
         * your code is are running against. Contrast with the
         * %GTK_MINOR_VERSION macro, which represents the minor version of the
         * GTK headers you have included when compiling your code.
         * @returns the minor version number of the GTK library
         */
        function get_minor_version(): number;
        /**
         * Converts a color from HSV space to RGB.
         *
         * Input values must be in the [0.0, 1.0] range;
         * output values will be in the same range.
         * @param h Hue
         * @param s Saturation
         * @param v Value
         */
        function hsv_to_rgb(h: number, s: number, v: number): [number, number, number];
        /**
         * Registers an error quark for [class`Gtk`.IconTheme] errors.
         * @returns the error quark
         */
        function icon_theme_error_quark(): GLib.Quark;
        /**
         * Initializes GTK.
         *
         * This function must be called before using any other GTK functions
         * in your GUI applications.
         *
         * It will initialize everything needed to operate the toolkit. In particular,
         * it will open the default display (see [func`Gdk`.Display.get_default]).
         *
         * If you are using [class`Gtk`.Application], you usually don't have to call this
         * function; the [vfunc`Gio`.Application.startup] handler does it for you. Though,
         * if you are using `GApplication` methods that will be invoked before `startup`,
         * such as `local_command_line`, you may need to initialize GTK explicitly.
         *
         * This function will terminate your program if it was unable to initialize
         * the windowing system for some reason. If you want your program to fall back
         * to a textual interface, call [func`Gtk`.init_check] instead.
         *
         * GTK calls `signal (SIGPIPE, SIG_IGN)` during initialization, to ignore
         * SIGPIPE signals, since these are almost never wanted in graphical
         * applications. If you do need to handle SIGPIPE for some reason, reset
         * the handler after gtk_init(), but notice that other libraries (e.g.
         * libdbus or gvfs) might do similar things.
         */
        function init(): void;
        /**
         * Initializes GTK.
         *
         * This function does the same work as [func`Gtk`.init] with only a
         * single change: It does not terminate the program if the windowing
         * system can’t be initialized. Instead it returns false on failure.
         *
         * This way the application can fall back to some other means of
         * communication with the user - for example a curses or command line
         * interface.
         * @returns true if the windowing system has been successfully   initialized, false otherwise
         */
        function init_check(): boolean;
        /**
         * Returns whether GTK has been initialized.
         *
         * See [func`Gtk`.init].
         * @returns the initialization status
         */
        function is_initialized(): boolean;
        /**
         * Finds the `GtkNative` associated with the surface.
         * @param surface a `GdkSurface`
         * @returns the `GtkNative` that is associated with @surface
         */
        function native_get_for_surface(surface: Gdk.Surface): Native | null;
        /**
         * Returns the name of the default paper size, which
         * depends on the current locale.
         * @returns the name of the default paper size. The string is owned by GTK and should not be modified.
         */
        function paper_size_get_default(): string;
        /**
         * Creates a list of known paper sizes.
         * @param include_custom whether to include custom paper sizes   as defined in the page setup dialog
         * @returns a newly allocated list of newly    allocated `GtkPaperSize` objects
         */
        function paper_size_get_paper_sizes(include_custom: boolean): PaperSize[];
        /**
         * Creates a new `GParamSpec` instance for a property holding a `GtkExpression`.
         *
         * See `g_param_spec_internal()` for details on the property strings.
         * @param name canonical name of the property
         * @param nick a user-readable name for the property
         * @param blurb a user-readable description of the property
         * @param flags flags for the property
         * @returns a newly created property specification
         */
        function param_spec_expression(
            name: string,
            nick: string,
            blurb: string,
            flags: GObject.ParamFlags | null,
        ): GObject.ParamSpec;
        /**
         * Registers an error quark for `GtkPrintOperation` if necessary.
         * @returns The error quark used for `GtkPrintOperation` errors.
         */
        function print_error_quark(): GLib.Quark;
        /**
         * Runs a page setup dialog, letting the user modify the values from `page_setup`.
         *
         * If the user cancels the dialog, the returned `GtkPageSetup` is identical
         * to the passed in `page_setup,` otherwise it contains the modifications
         * done in the dialog.
         *
         * Note that this function may use a recursive mainloop to show the page
         * setup dialog. See [func`Gtk`.print_run_page_setup_dialog_async] if this is
         * a problem.
         * @param parent transient parent
         * @param page_setup an existing `GtkPageSetup`
         * @param settings a `GtkPrintSettings`
         * @returns a new `GtkPageSetup`
         */
        function print_run_page_setup_dialog(
            parent: Window | null,
            page_setup: PageSetup | null,
            settings: PrintSettings,
        ): PageSetup;
        /**
         * Runs a page setup dialog, letting the user modify the values from `page_setup`.
         *
         * In contrast to [func`Gtk`.print_run_page_setup_dialog], this function  returns
         * after showing the page setup dialog on platforms that support this, and calls
         * `done_cb` from a signal handler for the ::response signal of the dialog.
         * @param parent transient parent
         * @param page_setup an existing `GtkPageSetup`
         * @param settings a `GtkPrintSettings`
         * @param done_cb a function to call when the user saves    the modified page setup
         */
        function print_run_page_setup_dialog_async(
            parent: Window | null,
            page_setup: PageSetup | null,
            settings: PrintSettings,
            done_cb: PageSetupDoneFunc,
        ): void;
        /**
         * Registers an error quark for [class`RecentManager]` errors.
         * @returns the error quark
         */
        function recent_manager_error_quark(): GLib.Quark;
        /**
         * Renders an activity indicator (such as in `GtkSpinner`).
         * The state %GTK_STATE_FLAG_CHECKED determines whether there is
         * activity going on.
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_activity(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders an arrow pointing to `angle`.
         *
         * Typical arrow rendering at 0, 1⁄2 π;, π; and 3⁄2 π:
         *
         * ![](arrows.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param angle arrow angle from 0 to 2 * %G_PI, being 0 the arrow pointing to the north
         * @param x X origin of the render area
         * @param y Y origin of the render area
         * @param size square side for render area
         */
        function render_arrow(
            context: StyleContext,
            cr: cairo.Context,
            angle: number,
            x: number,
            y: number,
            size: number,
        ): void;
        /**
         * Renders the background of an element.
         *
         * Typical background rendering, showing the effect of
         * `background-image`, `border-width` and `border-radius`:
         *
         * ![](background.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_background(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a checkmark (as in a `GtkCheckButton`).
         *
         * The %GTK_STATE_FLAG_CHECKED state determines whether the check is
         * on or off, and %GTK_STATE_FLAG_INCONSISTENT determines whether it
         * should be marked as undefined.
         *
         * Typical checkmark rendering:
         *
         * ![](checks.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_check(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders an expander (as used in `GtkTreeView` and `GtkExpander`) in the area
         * defined by `x,` `y,` `width,` `height`. The state %GTK_STATE_FLAG_CHECKED
         * determines whether the expander is collapsed or expanded.
         *
         * Typical expander rendering:
         *
         * ![](expanders.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_expander(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a focus indicator on the rectangle determined by `x,` `y,` `width,` `height`.
         *
         * Typical focus rendering:
         *
         * ![](focus.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_focus(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a frame around the rectangle defined by `x,` `y,` `width,` `height`.
         *
         * Examples of frame rendering, showing the effect of `border-image`,
         * `border-color`, `border-width`, `border-radius` and junctions:
         *
         * ![](frames.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_frame(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders a handle (as in `GtkPaned` and `GtkWindow`’s resize grip),
         * in the rectangle determined by `x,` `y,` `width,` `height`.
         *
         * Handles rendered for the paned and grip classes:
         *
         * ![](handles.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_handle(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Renders the icon in `texture` at the specified `x` and `y` coordinates.
         *
         * This function will render the icon in `texture` at exactly its size,
         * regardless of scaling factors, which may not be appropriate when
         * drawing on displays with high pixel densities.
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param texture a `GdkTexture` containing the icon to draw
         * @param x X position for the @texture
         * @param y Y position for the @texture
         */
        function render_icon(
            context: StyleContext,
            cr: cairo.Context,
            texture: Gdk.Texture,
            x: number,
            y: number,
        ): void;
        /**
         * Renders `layout` on the coordinates `x,` `y`
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin
         * @param y Y origin
         * @param layout the `PangoLayout` to render
         */
        function render_layout(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            layout: Pango.Layout,
        ): void;
        /**
         * Renders a line from (x0, y0) to (x1, y1).
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x0 X coordinate for the origin of the line
         * @param y0 Y coordinate for the origin of the line
         * @param x1 X coordinate for the end of the line
         * @param y1 Y coordinate for the end of the line
         */
        function render_line(
            context: StyleContext,
            cr: cairo.Context,
            x0: number,
            y0: number,
            x1: number,
            y1: number,
        ): void;
        /**
         * Renders an option mark (as in a radio button), the %GTK_STATE_FLAG_CHECKED
         * state will determine whether the option is on or off, and
         * %GTK_STATE_FLAG_INCONSISTENT whether it should be marked as undefined.
         *
         * Typical option mark rendering:
         *
         * ![](options.png)
         * @param context a `GtkStyleContext`
         * @param cr a `cairo_t`
         * @param x X origin of the rectangle
         * @param y Y origin of the rectangle
         * @param width rectangle width
         * @param height rectangle height
         */
        function render_option(
            context: StyleContext,
            cr: cairo.Context,
            x: number,
            y: number,
            width: number,
            height: number,
        ): void;
        /**
         * Converts a color from RGB space to HSV.
         *
         * Input values must be in the [0.0, 1.0] range;
         * output values will be in the same range.
         * @param r Red
         * @param g Green
         * @param b Blue
         */
        function rgb_to_hsv(r: number, g: number, b: number): [number, number, number];
        /**
         * Sets the GTK debug flags.
         * @param flags the debug flags to set
         */
        function set_debug_flags(flags: DebugFlags | null): void;
        /**
         * This function launches the default application for showing
         * a given uri, or shows an error dialog if that fails.
         * @param parent parent window
         * @param uri the uri to show
         * @param timestamp timestamp from the event that triggered this call, or %GDK_CURRENT_TIME
         */
        function show_uri(parent: Window | null, uri: string, timestamp: number): void;
        /**
         * This function launches the default application for showing
         * a given uri.
         *
         * The `callback` will be called when the launch is completed.
         *
         * This is the recommended call to be used as it passes information
         * necessary for sandbox helpers to parent their dialogs properly.
         * @param parent parent window
         * @param uri the uri to show
         * @param timestamp timestamp from the event that triggered this call, or %GDK_CURRENT_TIME
         * @param cancellable a `GCancellable` to cancel the launch
         */
        function show_uri_full(
            parent: Window | null,
            uri: string,
            timestamp: number,
            cancellable?: Gio.Cancellable | null,
        ): Promise<boolean>;
        /**
         * This function launches the default application for showing
         * a given uri.
         *
         * The `callback` will be called when the launch is completed.
         *
         * This is the recommended call to be used as it passes information
         * necessary for sandbox helpers to parent their dialogs properly.
         * @param parent parent window
         * @param uri the uri to show
         * @param timestamp timestamp from the event that triggered this call, or %GDK_CURRENT_TIME
         * @param cancellable a `GCancellable` to cancel the launch
         * @param callback a callback to call when the action is complete
         */
        function show_uri_full(
            parent: Window | null,
            uri: string,
            timestamp: number,
            cancellable: Gio.Cancellable | null,
            callback: Gio.AsyncReadyCallback<Window | null> | null,
        ): void;
        /**
         * This function launches the default application for showing
         * a given uri.
         *
         * The `callback` will be called when the launch is completed.
         *
         * This is the recommended call to be used as it passes information
         * necessary for sandbox helpers to parent their dialogs properly.
         * @param parent parent window
         * @param uri the uri to show
         * @param timestamp timestamp from the event that triggered this call, or %GDK_CURRENT_TIME
         * @param cancellable a `GCancellable` to cancel the launch
         * @param callback a callback to call when the action is complete
         */
        function show_uri_full(
            parent: Window | null,
            uri: string,
            timestamp: number,
            cancellable?: Gio.Cancellable | null,
            callback?: Gio.AsyncReadyCallback<Window | null> | null,
        ): Promise<boolean> | void;
        /**
         * Finishes the gtk_show_uri() call and returns the result
         * of the operation.
         * @param parent the `GtkWindow` passed to gtk_show_uri()
         * @param result `GAsyncResult` that was passed to @callback
         * @returns %TRUE if the URI was shown successfully.   Otherwise, %FALSE is returned and @error is set
         */
        function show_uri_full_finish(parent: Window, result: Gio.AsyncResult): boolean;
        /**
         * Prints an assertion message for gtk_test_accessible_assert_role().
         * @param domain a domain
         * @param file a file name
         * @param line the line in @file
         * @param func a function name in @file
         * @param expr the expression being tested
         * @param accessible a `GtkAccessible`
         * @param expected_role the expected `GtkAccessibleRole`
         * @param actual_role the actual `GtkAccessibleRole`
         */
        function test_accessible_assertion_message_role(
            domain: string,
            file: string,
            line: number,
            func: string,
            expr: string,
            accessible: Accessible,
            expected_role: AccessibleRole | null,
            actual_role: AccessibleRole | null,
        ): void;
        /**
         * Checks whether the `GtkAccessible` has `property` set.
         * @param accessible a `GtkAccessible`
         * @param property a `GtkAccessibleProperty`
         * @returns %TRUE if the @property is set in the @accessible
         */
        function test_accessible_has_property(accessible: Accessible, property: AccessibleProperty | null): boolean;
        /**
         * Checks whether the `GtkAccessible` has `relation` set.
         * @param accessible a `GtkAccessible`
         * @param relation a `GtkAccessibleRelation`
         * @returns %TRUE if the @relation is set in the @accessible
         */
        function test_accessible_has_relation(accessible: Accessible, relation: AccessibleRelation | null): boolean;
        /**
         * Checks whether the `GtkAccessible:accessible-role` of the accessible
         * is `role`.
         * @param accessible a `GtkAccessible`
         * @param role a `GtkAccessibleRole`
         * @returns %TRUE if the role matches
         */
        function test_accessible_has_role(accessible: Accessible, role: AccessibleRole | null): boolean;
        /**
         * Checks whether the `GtkAccessible` has `state` set.
         * @param accessible a `GtkAccessible`
         * @param state a `GtkAccessibleState`
         * @returns %TRUE if the @state is set in the @accessible
         */
        function test_accessible_has_state(accessible: Accessible, state: AccessibleState | null): boolean;
        /**
         * Return the type ids that have been registered after
         * calling gtk_test_register_all_types().
         * @returns 0-terminated array of type ids
         */
        function test_list_all_types(): GObject.GType[];
        /**
         * Force registration of all core GTK object types.
         *
         * This allows to refer to any of those object types via
         * g_type_from_name() after calling this function.
         */
        function test_register_all_types(): void;
        /**
         * Enters the main loop and waits for `widget` to be “drawn”.
         *
         * In this context that means it waits for the frame clock of
         * `widget` to have run a full styling, layout and drawing cycle.
         *
         * This function is intended to be used for syncing with actions that
         * depend on `widget` relayouting or on interaction with the display
         * server.
         * @param widget the widget to wait for
         */
        function test_widget_wait_for_draw(widget: Widget): void;
        /**
         * Creates a content provider for dragging `path` from `tree_model`.
         * @param tree_model a `GtkTreeModel`
         * @param path a row in @tree_model
         * @returns a new `GdkContentProvider`
         */
        function tree_create_row_drag_content(tree_model: TreeModel, path: TreePath): Gdk.ContentProvider;
        /**
         * Obtains a `tree_model` and `path` from value of target type
         * %GTK_TYPE_TREE_ROW_DATA.
         *
         * The returned path must be freed with gtk_tree_path_free().
         * @param value a `GValue`
         * @returns %TRUE if @selection_data had target type %GTK_TYPE_TREE_ROW_DATA  is otherwise valid
         */
        function tree_get_row_drag_data(value: GObject.Value | any): [boolean, TreeModel | null, TreePath | null];
        /**
         * Lets a set of row reference created by
         * gtk_tree_row_reference_new_proxy() know that the
         * model emitted the ::row-deleted signal.
         * @param proxy a `GObject`
         * @param path the path position that was deleted
         */
        function tree_row_reference_deleted(proxy: GObject.Object, path: TreePath): void;
        /**
         * Lets a set of row reference created by
         * gtk_tree_row_reference_new_proxy() know that the
         * model emitted the ::row-inserted signal.
         * @param proxy a `GObject`
         * @param path the row position that was inserted
         */
        function tree_row_reference_inserted(proxy: GObject.Object, path: TreePath): void;
        /**
         * Retrieves the `GtkExpression` stored inside the given `value`, and acquires
         * a reference to it.
         * @param value a `GValue` initialized with type `GTK_TYPE_EXPRESSION`
         * @returns a `GtkExpression`
         */
        function value_dup_expression(value: GObject.Value | any): Expression | null;
        /**
         * Retrieves the `GtkExpression` stored inside the given `value`.
         * @param value a `GValue` initialized with type `GTK_TYPE_EXPRESSION`
         * @returns a `GtkExpression`
         */
        function value_get_expression(value: GObject.Value | any): Expression | null;
        /**
         * Stores the given `GtkExpression` inside `value`.
         *
         * The `GValue` will acquire a reference to the `expression`.
         * @param value a `GValue` initialized with type `GTK_TYPE_EXPRESSION`
         * @param expression a `GtkExpression`
         */
        function value_set_expression(value: GObject.Value | any, expression: Expression): void;
        /**
         * Stores the given `GtkExpression` inside `value`.
         *
         * This function transfers the ownership of the `expression` to the `GValue`.
         * @param value a `GValue` initialized with type `GTK_TYPE_EXPRESSION`
         * @param expression a `GtkExpression`
         */
        function value_take_expression(value: GObject.Value | any, expression?: Expression | null): void;
        interface AssistantPageFunc {
            (current_page: number): number;
        }
        interface CellAllocCallback {
            (renderer: CellRenderer, cell_area: Gdk.Rectangle, cell_background: Gdk.Rectangle): boolean;
        }
        interface CellCallback {
            (renderer: CellRenderer): boolean;
        }
        interface CellLayoutDataFunc {
            (cell_layout: CellLayout, cell: CellRenderer, tree_model: TreeModel, iter: TreeIter): void;
        }
        interface CustomAllocateFunc {
            (widget: Widget, width: number, height: number, baseline: number): void;
        }
        interface CustomFilterFunc<A = GObject.Object> {
            (item: A): boolean;
        }
        interface CustomMeasureFunc {
            (widget: Widget, orientation: Orientation, for_size: number): void;
        }
        interface CustomRequestModeFunc {
            (widget: Widget): SizeRequestMode;
        }
        interface DrawingAreaDrawFunc {
            (drawing_area: DrawingArea, cr: cairo.Context, width: number, height: number): void;
        }
        interface EntryCompletionMatchFunc {
            (completion: EntryCompletion, key: string, iter: TreeIter): boolean;
        }
        interface ExpressionNotify {
            (): void;
        }
        interface FlowBoxCreateWidgetFunc<A = GObject.Object> {
            (item: A): Widget;
        }
        interface FlowBoxFilterFunc {
            (child: FlowBoxChild): boolean;
        }
        interface FlowBoxForeachFunc {
            (box: FlowBox, child: FlowBoxChild): void;
        }
        interface FlowBoxSortFunc {
            (child1: FlowBoxChild, child2: FlowBoxChild): number;
        }
        interface FontFilterFunc {
            (family: Pango.FontFamily, face: Pango.FontFace): boolean;
        }
        interface IconViewForeachFunc {
            (icon_view: IconView, path: TreePath): void;
        }
        interface ListBoxCreateWidgetFunc<A = GObject.Object> {
            (item: A): Widget;
        }
        interface ListBoxFilterFunc {
            (row: ListBoxRow): boolean;
        }
        interface ListBoxForeachFunc {
            (box: ListBox, row: ListBoxRow): void;
        }
        interface ListBoxSortFunc {
            (row1: ListBoxRow, row2: ListBoxRow): number;
        }
        interface ListBoxUpdateHeaderFunc {
            (row: ListBoxRow, before?: ListBoxRow | null): void;
        }
        interface MapListModelMapFunc<A = GObject.Object> {
            (item: A): GObject.Object;
        }
        interface MenuButtonCreatePopupFunc {
            (menu_button: MenuButton): void;
        }
        interface PageSetupDoneFunc {
            (page_setup: PageSetup): void;
        }
        interface PrintJobCompleteFunc {
            (print_job: PrintJob, error: GLib.Error): void;
        }
        interface PrintSettingsFunc {
            (key: string, value: string): void;
        }
        interface PrinterFunc {
            (printer: Printer): boolean;
        }
        interface ScaleFormatValueFunc {
            (scale: Scale, value: number): string;
        }
        interface ShortcutFunc {
            (widget: Widget, args?: GLib.Variant | null): boolean;
        }
        interface TextBufferCommitNotify {
            (buffer: TextBuffer, flags: TextBufferNotifyFlags, position: number, length: number): void;
        }
        interface TextCharPredicate {
            (ch: number): boolean;
        }
        interface TextTagTableForeach {
            (tag: TextTag): void;
        }
        interface TickCallback {
            (widget: Widget, frame_clock: Gdk.FrameClock): boolean;
        }
        interface TreeCellDataFunc {
            (tree_column: TreeViewColumn, cell: CellRenderer, tree_model: TreeModel, iter: TreeIter): void;
        }
        interface TreeIterCompareFunc {
            (model: TreeModel, a: TreeIter, b: TreeIter): number;
        }
        interface TreeListModelCreateModelFunc<A = GObject.Object> {
            (item: A): Gio.ListModel | null;
        }
        interface TreeModelFilterModifyFunc {
            (model: TreeModel, iter: TreeIter, column: number): void;
        }
        interface TreeModelFilterVisibleFunc {
            (model: TreeModel, iter: TreeIter): boolean;
        }
        interface TreeModelForeachFunc {
            (model: TreeModel, path: TreePath, iter: TreeIter): boolean;
        }
        interface TreeSelectionForeachFunc {
            (model: TreeModel, path: TreePath, iter: TreeIter): void;
        }
        interface TreeSelectionFunc {
            (selection: TreeSelection, model: TreeModel, path: TreePath, path_currently_selected: boolean): boolean;
        }
        interface TreeViewColumnDropFunc {
            (
                tree_view: TreeView,
                column: TreeViewColumn,
                prev_column: TreeViewColumn,
                next_column: TreeViewColumn,
            ): boolean;
        }
        interface TreeViewMappingFunc {
            (tree_view: TreeView, path: TreePath): void;
        }
        interface TreeViewRowSeparatorFunc {
            (model: TreeModel, iter: TreeIter): boolean;
        }
        interface TreeViewSearchEqualFunc {
            (model: TreeModel, column: number, key: string, iter: TreeIter): boolean;
        }
        interface WidgetActionActivateFunc {
            (widget: Widget, action_name: string, parameter?: GLib.Variant | null): void;
        }
        type TreeRowData = object | null;
        /**
         * Types of user actions that may be blocked by `GtkApplication`.
         *
         * See [method`Gtk`.Application.inhibit].
         */

        /**
         * Types of user actions that may be blocked by `GtkApplication`.
         *
         * See [method`Gtk`.Application.inhibit].
         */
        export namespace ApplicationInhibitFlags {
            export const $gtype: GObject.GType<ApplicationInhibitFlags>;
        }

        enum ApplicationInhibitFlags {
            /**
             * Inhibit ending the user session
             *   by logging out or by shutting down the computer
             */
            LOGOUT,
            /**
             * Inhibit user switching
             */
            SWITCH,
            /**
             * Inhibit suspending the
             *   session or computer
             */
            SUSPEND,
            /**
             * Inhibit the session being
             *   marked as idle (and possibly locked)
             */
            IDLE,
        }
        /**
         * The list of flags that can be passed to gtk_builder_create_closure().
         *
         * New values may be added in the future for new features, so external
         * implementations of [iface`Gtk`.BuilderScope] should test the flags
         * for unknown values and raise a %GTK_BUILDER_ERROR_INVALID_ATTRIBUTE error
         * when they encounter one.
         */

        /**
         * The list of flags that can be passed to gtk_builder_create_closure().
         *
         * New values may be added in the future for new features, so external
         * implementations of [iface`Gtk`.BuilderScope] should test the flags
         * for unknown values and raise a %GTK_BUILDER_ERROR_INVALID_ATTRIBUTE error
         * when they encounter one.
         */
        export namespace BuilderClosureFlags {
            export const $gtype: GObject.GType<BuilderClosureFlags>;
        }

        enum BuilderClosureFlags {
            /**
             * The closure should be created swapped. See
             *   g_cclosure_new_swap() for details.
             */
            SWAPPED,
        }
        /**
         * Tells how a cell is to be rendered.
         */

        /**
         * Tells how a cell is to be rendered.
         */
        export namespace CellRendererState {
            export const $gtype: GObject.GType<CellRendererState>;
        }

        enum CellRendererState {
            /**
             * The cell is currently selected, and
             *  probably has a selection colored background to render to.
             */
            SELECTED,
            /**
             * The mouse is hovering over the cell.
             */
            PRELIT,
            /**
             * The cell is drawn in an insensitive manner
             */
            INSENSITIVE,
            /**
             * The cell is in a sorted row
             */
            SORTED,
            /**
             * The cell is in the focus row.
             */
            FOCUSED,
            /**
             * The cell is in a row that can be expanded
             */
            EXPANDABLE,
            /**
             * The cell is in a row that is expanded
             */
            EXPANDED,
        }
        /**
         * Flags to use with gtk_set_debug_flags().
         *
         * Settings these flags causes GTK to print out different
         * types of debugging information. Some of these flags are
         * only available when GTK has been configured with `-Ddebug=true`.
         */

        /**
         * Flags to use with gtk_set_debug_flags().
         *
         * Settings these flags causes GTK to print out different
         * types of debugging information. Some of these flags are
         * only available when GTK has been configured with `-Ddebug=true`.
         */
        export namespace DebugFlags {
            export const $gtype: GObject.GType<DebugFlags>;
        }

        enum DebugFlags {
            /**
             * Information about GtkTextView
             */
            TEXT,
            /**
             * Information about GtkTreeView
             */
            TREE,
            /**
             * Information about keyboard shortcuts
             */
            KEYBINDINGS,
            /**
             * Information about modules and extensions
             */
            MODULES,
            /**
             * Information about size allocation
             */
            GEOMETRY,
            /**
             * Information about icon themes
             */
            ICONTHEME,
            /**
             * Information about printing
             */
            PRINTING,
            BUILDER_TRACE,
            /**
             * Information about size requests
             */
            SIZE_REQUEST,
            /**
             * Disable the style property cache
             */
            NO_CSS_CACHE,
            /**
             * Open the GTK inspector
             */
            INTERACTIVE,
            /**
             * Information about actions and menu models
             */
            ACTIONS,
            /**
             * Information from layout managers
             */
            LAYOUT,
            /**
             * Include debug render nodes in the generated snapshots
             */
            SNAPSHOT,
            /**
             * Information from the constraints solver
             */
            CONSTRAINTS,
            /**
             * Log unused GtkBuilder objects
             */
            BUILDER_OBJECTS,
            /**
             * Information about accessibility state changes
             */
            A11Y,
            /**
             * Information about icon fallback.
             */
            ICONFALLBACK,
            /**
             * Inverts the default text-direction.
             */
            INVERT_TEXT_DIR,
            /**
             * Information about deprecated CSS features.
             */
            CSS,
            /**
             * Trace GtkBuilder operation
             */
            BUILDER,
        }
        /**
         * Flags used to influence dialog construction.
         */

        /**
         * Flags used to influence dialog construction.
         */
        export namespace DialogFlags {
            export const $gtype: GObject.GType<DialogFlags>;
        }

        enum DialogFlags {
            /**
             * Make the constructed dialog modal
             */
            MODAL,
            /**
             * Destroy the dialog when its parent is destroyed
             */
            DESTROY_WITH_PARENT,
            /**
             * Create dialog with actions in header
             *   bar instead of action area
             */
            USE_HEADER_BAR,
        }
        /**
         * Describes the behavior of a `GtkEventControllerScroll`.
         */

        /**
         * Describes the behavior of a `GtkEventControllerScroll`.
         */
        export namespace EventControllerScrollFlags {
            export const $gtype: GObject.GType<EventControllerScrollFlags>;
        }

        enum EventControllerScrollFlags {
            /**
             * Don't emit scroll.
             */
            NONE,
            /**
             * Emit scroll with vertical deltas.
             */
            VERTICAL,
            /**
             * Emit scroll with horizontal deltas.
             */
            HORIZONTAL,
            /**
             * Only emit deltas that are multiples of 1.
             */
            DISCRETE,
            /**
             * Emit ::decelerate after continuous scroll finishes.
             */
            KINETIC,
            /**
             * Emit scroll on both axes.
             */
            BOTH_AXES,
        }
        /**
         * Specifies the granularity of font selection
         * that is desired in a `GtkFontChooser`.
         *
         * This enumeration may be extended in the future; applications should
         * ignore unknown values.
         */

        /**
         * Specifies the granularity of font selection
         * that is desired in a `GtkFontChooser`.
         *
         * This enumeration may be extended in the future; applications should
         * ignore unknown values.
         */
        export namespace FontChooserLevel {
            export const $gtype: GObject.GType<FontChooserLevel>;
        }

        enum FontChooserLevel {
            /**
             * Allow selecting a font family
             */
            FAMILY,
            /**
             * Allow selecting a specific font face
             */
            STYLE,
            /**
             * Allow selecting a specific font size
             */
            SIZE,
            /**
             * Allow changing OpenType font variation axes
             */
            VARIATIONS,
            /**
             * Allow selecting specific OpenType font features
             */
            FEATURES,
        }
        /**
         * Used to specify options for gtk_icon_theme_lookup_icon().
         */

        /**
         * Used to specify options for gtk_icon_theme_lookup_icon().
         */
        export namespace IconLookupFlags {
            export const $gtype: GObject.GType<IconLookupFlags>;
        }

        enum IconLookupFlags {
            /**
             * Perform a regular lookup.
             */
            NONE,
            /**
             * Try to always load regular icons, even
             *   when symbolic icon names are given
             */
            FORCE_REGULAR,
            /**
             * Try to always load symbolic icons, even
             *   when regular icon names are given
             */
            FORCE_SYMBOLIC,
            /**
             * Starts loading the texture in the background
             *   so it is ready when later needed.
             */
            PRELOAD,
        }
        /**
         * Describes hints that might be taken into account by input methods
         * or applications.
         *
         * Note that input methods may already tailor their behaviour according
         * to the [enum`InputPurpose]` of the entry.
         *
         * Some common sense is expected when using these flags - mixing
         * %GTK_INPUT_HINT_LOWERCASE with any of the uppercase hints makes no sense.
         *
         * This enumeration may be extended in the future; input methods should
         * ignore unknown values.
         */

        /**
         * Describes hints that might be taken into account by input methods
         * or applications.
         *
         * Note that input methods may already tailor their behaviour according
         * to the [enum`InputPurpose]` of the entry.
         *
         * Some common sense is expected when using these flags - mixing
         * %GTK_INPUT_HINT_LOWERCASE with any of the uppercase hints makes no sense.
         *
         * This enumeration may be extended in the future; input methods should
         * ignore unknown values.
         */
        export namespace InputHints {
            export const $gtype: GObject.GType<InputHints>;
        }

        enum InputHints {
            /**
             * No special behaviour suggested
             */
            NONE,
            /**
             * Suggest checking for typos
             */
            SPELLCHECK,
            /**
             * Suggest not checking for typos
             */
            NO_SPELLCHECK,
            /**
             * Suggest word completion
             */
            WORD_COMPLETION,
            /**
             * Suggest to convert all text to lowercase
             */
            LOWERCASE,
            /**
             * Suggest to capitalize all text
             */
            UPPERCASE_CHARS,
            /**
             * Suggest to capitalize the first
             *   character of each word
             */
            UPPERCASE_WORDS,
            /**
             * Suggest to capitalize the
             *   first word of each sentence
             */
            UPPERCASE_SENTENCES,
            /**
             * Suggest to not show an onscreen keyboard
             *   (e.g for a calculator that already has all the keys).
             */
            INHIBIT_OSK,
            /**
             * The text is vertical
             */
            VERTICAL_WRITING,
            /**
             * Suggest offering Emoji support
             */
            EMOJI,
            /**
             * Suggest not offering Emoji support
             */
            NO_EMOJI,
            /**
             * Request that the input method should not
             *    update personalized data (like typing history)
             */
            PRIVATE,
        }
        /**
         * List of actions to perform when scrolling to items in
         * a list widget.
         */

        /**
         * List of actions to perform when scrolling to items in
         * a list widget.
         */
        export namespace ListScrollFlags {
            export const $gtype: GObject.GType<ListScrollFlags>;
        }

        enum ListScrollFlags {
            /**
             * Don't do anything extra
             */
            NONE,
            /**
             * Focus the target item
             */
            FOCUS,
            /**
             * Select the target item and
             *   unselect all other items.
             */
            SELECT,
        }
        /**
         * Flags that influence the behavior of [method`Widget`.pick].
         */

        /**
         * Flags that influence the behavior of [method`Widget`.pick].
         */
        export namespace PickFlags {
            export const $gtype: GObject.GType<PickFlags>;
        }

        enum PickFlags {
            /**
             * The default behavior, include widgets that are receiving events
             */
            DEFAULT,
            /**
             * Include widgets that are insensitive
             */
            INSENSITIVE,
            /**
             * Include widgets that are marked as non-targetable. See [property`Widget:`can-target]
             */
            NON_TARGETABLE,
        }
        /**
         * Flags that affect how [class`Gtk`.PopoverMenu] widgets built from
         * a [class`Gio`.MenuModel] are created and displayed.
         */

        /**
         * Flags that affect how [class`Gtk`.PopoverMenu] widgets built from
         * a [class`Gio`.MenuModel] are created and displayed.
         */
        export namespace PopoverMenuFlags {
            export const $gtype: GObject.GType<PopoverMenuFlags>;
        }

        enum PopoverMenuFlags {
            /**
             * Submenus are presented as sliding submenus that replace the main menu.
             */
            SLIDING,
            /**
             * Submenus are presented as traditional, nested
             *   popovers.
             */
            NESTED,
        }
        /**
         * Specifies which features the print dialog should offer.
         *
         * If neither %GTK_PRINT_CAPABILITY_GENERATE_PDF nor
         * %GTK_PRINT_CAPABILITY_GENERATE_PS is specified, GTK assumes that all
         * formats are supported.
         */

        /**
         * Specifies which features the print dialog should offer.
         *
         * If neither %GTK_PRINT_CAPABILITY_GENERATE_PDF nor
         * %GTK_PRINT_CAPABILITY_GENERATE_PS is specified, GTK assumes that all
         * formats are supported.
         */
        export namespace PrintCapabilities {
            export const $gtype: GObject.GType<PrintCapabilities>;
        }

        enum PrintCapabilities {
            /**
             * Print dialog will offer printing even/odd pages.
             */
            PAGE_SET,
            /**
             * Print dialog will allow to print multiple copies.
             */
            COPIES,
            /**
             * Print dialog will allow to collate multiple copies.
             */
            COLLATE,
            /**
             * Print dialog will allow to print pages in reverse order.
             */
            REVERSE,
            /**
             * Print dialog will allow to scale the output.
             */
            SCALE,
            /**
             * The program will send the document to
             *   the printer in PDF format
             */
            GENERATE_PDF,
            /**
             * The program will send the document to
             *   the printer in Postscript format
             */
            GENERATE_PS,
            /**
             * Print dialog will offer a preview
             */
            PREVIEW,
            /**
             * Print dialog will offer printing multiple
             *   pages per sheet
             */
            NUMBER_UP,
            /**
             * Print dialog will allow to rearrange
             *   pages when printing multiple pages per sheet
             */
            NUMBER_UP_LAYOUT,
        }
        /**
         * Flags that can be passed to action activation.
         *
         * More flags may be added in the future.
         */

        /**
         * Flags that can be passed to action activation.
         *
         * More flags may be added in the future.
         */
        export namespace ShortcutActionFlags {
            export const $gtype: GObject.GType<ShortcutActionFlags>;
        }

        enum ShortcutActionFlags {
            /**
             * The action is the only
             *   action that can be activated. If this flag is not set,
             *   a future activation may select a different action.
             */
            EXCLUSIVE,
        }
        /**
         * Describes a widget state.
         *
         * Widget states are used to match the widget against CSS pseudo-classes.
         * Note that GTK extends the regular CSS classes and sometimes uses
         * different names.
         */

        /**
         * Describes a widget state.
         *
         * Widget states are used to match the widget against CSS pseudo-classes.
         * Note that GTK extends the regular CSS classes and sometimes uses
         * different names.
         */
        export namespace StateFlags {
            export const $gtype: GObject.GType<StateFlags>;
        }

        enum StateFlags {
            /**
             * State during normal operation
             */
            NORMAL,
            /**
             * Widget is active
             */
            ACTIVE,
            /**
             * Widget has a mouse pointer over it
             */
            PRELIGHT,
            /**
             * Widget is selected
             */
            SELECTED,
            /**
             * Widget is insensitive
             */
            INSENSITIVE,
            /**
             * Widget is inconsistent
             */
            INCONSISTENT,
            /**
             * Widget has the keyboard focus
             */
            FOCUSED,
            /**
             * Widget is in a background toplevel window
             */
            BACKDROP,
            /**
             * Widget is in left-to-right text direction
             */
            DIR_LTR,
            /**
             * Widget is in right-to-left text direction
             */
            DIR_RTL,
            /**
             * Widget is a link
             */
            LINK,
            /**
             * The location the widget points to has already been visited
             */
            VISITED,
            /**
             * Widget is checked
             */
            CHECKED,
            /**
             * Widget is highlighted as a drop target for DND
             */
            DROP_ACTIVE,
            /**
             * Widget has the visible focus
             */
            FOCUS_VISIBLE,
            /**
             * Widget contains the keyboard focus
             */
            FOCUS_WITHIN,
        }
        /**
         * Flags that modify the behavior of gtk_style_context_to_string().
         *
         * New values may be added to this enumeration.
         */

        /**
         * Flags that modify the behavior of gtk_style_context_to_string().
         *
         * New values may be added to this enumeration.
         */
        export namespace StyleContextPrintFlags {
            export const $gtype: GObject.GType<StyleContextPrintFlags>;
        }

        enum StyleContextPrintFlags {
            /**
             * Default value.
             */
            NONE,
            /**
             * Print the entire tree of
             *   CSS nodes starting at the style context's node
             */
            RECURSE,
            /**
             * Show the values of the
             *   CSS properties for each node
             */
            SHOW_STYLE,
            /**
             * Show information about
             *   what changes affect the styles
             */
            SHOW_CHANGE,
        }
        /**
         * Values for [callback`Gtk`.TextBufferCommitNotify] to denote the
         * point of the notification.
         */

        /**
         * Values for [callback`Gtk`.TextBufferCommitNotify] to denote the
         * point of the notification.
         */
        export namespace TextBufferNotifyFlags {
            export const $gtype: GObject.GType<TextBufferNotifyFlags>;
        }

        enum TextBufferNotifyFlags {
            /**
             * Be notified before text
             *   is inserted into the underlying buffer.
             */
            BEFORE_INSERT,
            /**
             * Be notified after text
             *   has been inserted into the underlying buffer.
             */
            AFTER_INSERT,
            /**
             * Be notified before text
             *   is deleted from the underlying buffer.
             */
            BEFORE_DELETE,
            /**
             * Be notified after text
             *   has been deleted from the underlying buffer.
             */
            AFTER_DELETE,
        }
        /**
         * Flags affecting how a search is done.
         *
         * If neither `GTK_TEXT_SEARCH_VISIBLE_ONLY` nor `GTK_TEXT_SEARCH_TEXT_ONLY`
         * are enabled, the match must be exact; the special 0xFFFC character will
         * match embedded paintables or child widgets.
         */

        /**
         * Flags affecting how a search is done.
         *
         * If neither `GTK_TEXT_SEARCH_VISIBLE_ONLY` nor `GTK_TEXT_SEARCH_TEXT_ONLY`
         * are enabled, the match must be exact; the special 0xFFFC character will
         * match embedded paintables or child widgets.
         */
        export namespace TextSearchFlags {
            export const $gtype: GObject.GType<TextSearchFlags>;
        }

        enum TextSearchFlags {
            /**
             * Search only visible data. A search match may
             * have invisible text interspersed.
             */
            VISIBLE_ONLY,
            /**
             * Search only text. A match may have paintables or
             * child widgets mixed inside the matched range.
             */
            TEXT_ONLY,
            /**
             * The text will be matched regardless of
             * what case it is in.
             */
            CASE_INSENSITIVE,
        }
        /**
         * These flags indicate various properties of a `GtkTreeModel`.
         *
         * They are returned by [method`Gtk`.TreeModel.get_flags], and must be
         * static for the lifetime of the object. A more complete description
         * of %GTK_TREE_MODEL_ITERS_PERSIST can be found in the overview of
         * this section.
         */

        /**
         * These flags indicate various properties of a `GtkTreeModel`.
         *
         * They are returned by [method`Gtk`.TreeModel.get_flags], and must be
         * static for the lifetime of the object. A more complete description
         * of %GTK_TREE_MODEL_ITERS_PERSIST can be found in the overview of
         * this section.
         */
        export namespace TreeModelFlags {
            export const $gtype: GObject.GType<TreeModelFlags>;
        }

        enum TreeModelFlags {
            /**
             * iterators survive all signals
             *   emitted by the tree
             */
            ITERS_PERSIST,
            /**
             * the model is a list only, and never
             *   has children
             */
            LIST_ONLY,
        }
        namespace ATContext {
            // Signal callback interfaces

            interface StateChange {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {
                accessible: Accessible;
                accessible_role: AccessibleRole;
                accessibleRole: AccessibleRole;
                display: Gdk.Display;
            }
        }

        /**
         * Communicates with platform-specific assistive technologies API.
         *
         * Each platform supported by GTK implements a `GtkATContext` subclass, and
         * is responsible for updating the accessible state in response to state
         * changes in `GtkAccessible`.
         */
        abstract class ATContext extends GObject.Object {
            static $gtype: GObject.GType<ATContext>;

            // Properties

            /**
             * The `GtkAccessible` that created the `GtkATContext` instance.
             */
            get accessible(): Accessible;
            /**
             * The accessible role used by the AT context.
             *
             * Depending on the given role, different states and properties can be
             * set or retrieved.
             */
            get accessible_role(): AccessibleRole;
            set accessible_role(val: AccessibleRole);
            /**
             * The accessible role used by the AT context.
             *
             * Depending on the given role, different states and properties can be
             * set or retrieved.
             */
            get accessibleRole(): AccessibleRole;
            set accessibleRole(val: AccessibleRole);
            /**
             * The `GdkDisplay` for the `GtkATContext`.
             */
            get display(): Gdk.Display;
            set display(val: Gdk.Display);

            // Constructors

            constructor(properties?: Partial<ATContext.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static create(accessible_role: AccessibleRole, accessible: Accessible, display: Gdk.Display): ATContext;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'state-change', callback: (_source: this) => void): number;
            connect_after(signal: 'state-change', callback: (_source: this) => void): number;
            emit(signal: 'state-change'): void;

            // Methods

            /**
             * Retrieves the `GtkAccessible` using this context.
             * @returns a `GtkAccessible`
             */
            get_accessible(): Accessible;
            /**
             * Retrieves the accessible role of this context.
             * @returns a `GtkAccessibleRole`
             */
            get_accessible_role(): AccessibleRole;
        }

        namespace AboutDialog {
            // Signal callback interfaces

            interface ActivateLink {
                (uri: string): boolean;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Window.ConstructorProps,
                    Accessible.ConstructorProps,
                    Buildable.ConstructorProps,
                    ConstraintTarget.ConstructorProps,
                    Native.ConstructorProps,
                    Root.ConstructorProps,
                    ShortcutManager.ConstructorProps {
                artists: string[];
                authors: string[];
                comments: string;
                copyright: string;
                documenters: string[];
                license: string;
                license_type: License;
                licenseType: License;
                logo: Gdk.Paintable;
                logo_icon_name: string;
                logoIconName: string;
                program_name: string;
                programName: string;
                system_information: string;
                systemInformation: string;
                translator_credits: string;
                translatorCredits: string;
                version: string;
                website: string;
                website_label: string;
                websiteLabel: string;
                wrap_license: boolean;
                wrapLicense: boolean;
            }
        }

        /**
         * Displays information about a program.
         *
         * The shown information includes the programs' logo, name, copyright,
         * website and license. It is also possible to give credits to the authors,
         * documenters, translators and artists who have worked on the program.
         *
         * An about dialog is typically opened when the user selects the `About`
         * option from the `Help` menu. All parts of the dialog are optional.
         *
         * <picture>
         *   <source srcset="aboutdialot-dark.png" media="(prefers-color-scheme: dark)">
         *   <img alt="An example GtkAboutDialog" src="aboutdialog.png">
         * </picture>
         *
         * About dialogs often contain links and email addresses. `GtkAboutDialog`
         * displays these as clickable links. By default, it calls [method`Gtk`.FileLauncher.launch]
         * when a user clicks one. The behaviour can be overridden with the
         * [signal`Gtk`.AboutDialog::activate-link] signal.
         *
         * To specify a person with an email address, use a string like
         * `Edgar Allan Poe <edgar`poe`.com>`. To specify a website with a title,
         * use a string like `GTK team https://www.gtk.org`.
         *
         * To make constructing an about dialog as convenient as possible, you can
         * use the function [func`Gtk`.show_about_dialog] which constructs and shows
         * a dialog and keeps it around so that it can be shown again.
         *
         * Note that GTK sets a default title of `_("About %s")` on the dialog
         * window (where `%s` is replaced by the name of the application, but in
         * order to ensure proper translation of the title, applications should
         * set the title property explicitly when constructing an about dialog,
         * as shown in the following example:
         *
         * ```c
         * GFile *logo_file = g_file_new_for_path ("./logo.png");
         * GdkTexture *example_logo = gdk_texture_new_from_file (logo_file, NULL);
         * g_object_unref (logo_file);
         *
         * gtk_show_about_dialog (NULL,
         *                        "program-name", "ExampleCode",
         *                        "logo", example_logo,
         *                        "title", _("About ExampleCode"),
         *                        NULL);
         * ```
         *
         * ## Shortcuts and Gestures
         *
         * `GtkAboutDialog` supports the following keyboard shortcuts:
         *
         * - <kbd>Escape</kbd> closes the window.
         *
         * ## CSS nodes
         *
         * `GtkAboutDialog` has a single CSS node with the name `window` and style
         * class `.aboutdialog`.
         */
        class AboutDialog
            extends Window
            implements Accessible, Buildable, ConstraintTarget, Native, Root, ShortcutManager
        {
            static $gtype: GObject.GType<AboutDialog>;

            // Properties

            /**
             * The people who contributed artwork to the program.
             *
             * Each string may contain email addresses and URLs, which will be displayed
             * as links.
             */
            get artists(): string[];
            set artists(val: string[]);
            /**
             * The authors of the program.
             *
             * Each string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get authors(): string[];
            set authors(val: string[]);
            /**
             * Comments about the program.
             *
             * This string is displayed in a label in the main dialog, thus it
             * should be a short explanation of the main purpose of the program,
             * not a detailed list of features.
             */
            get comments(): string;
            set comments(val: string);
            /**
             * Copyright information for the program.
             */
            get copyright(): string;
            set copyright(val: string);
            /**
             * The people documenting the program.
             *
             * Each string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get documenters(): string[];
            set documenters(val: string[]);
            /**
             * The license of the program, as free-form text.
             *
             * This string is displayed in a text view in a secondary dialog, therefore
             * it is fine to use a long multi-paragraph text. Note that the text is only
             * wrapped in the text view if the "wrap-license" property is set to `TRUE`;
             * otherwise the text itself must contain the intended linebreaks.
             *
             * When setting this property to a non-`NULL` value, the
             * [property`Gtk`.AboutDialog:license-type] property is set to
             * [enum`Gtk`.License.custom] as a side effect.
             *
             * The text may contain links in this format `<http://www.some.place/>`
             * and email references in the form `<mail-to`some`.body>`, and these will
             * be converted into clickable links.
             */
            get license(): string;
            set license(val: string);
            /**
             * The license of the program.
             *
             * The `GtkAboutDialog` will automatically fill out a standard disclaimer
             * and link the user to the appropriate online resource for the license
             * text.
             *
             * If [enum`Gtk`.License.unknown] is used, the link used will be the same
             * specified in the [property`Gtk`.AboutDialog:website] property.
             *
             * If [enum`Gtk`.License.custom] is used, the current contents of the
             * [property`Gtk`.AboutDialog:license] property are used.
             *
             * For any other [enum`Gtk`.License] value, the contents of the
             * [property`Gtk`.AboutDialog:license] property are also set by
             * this property as a side effect.
             */
            get license_type(): License;
            set license_type(val: License);
            /**
             * The license of the program.
             *
             * The `GtkAboutDialog` will automatically fill out a standard disclaimer
             * and link the user to the appropriate online resource for the license
             * text.
             *
             * If [enum`Gtk`.License.unknown] is used, the link used will be the same
             * specified in the [property`Gtk`.AboutDialog:website] property.
             *
             * If [enum`Gtk`.License.custom] is used, the current contents of the
             * [property`Gtk`.AboutDialog:license] property are used.
             *
             * For any other [enum`Gtk`.License] value, the contents of the
             * [property`Gtk`.AboutDialog:license] property are also set by
             * this property as a side effect.
             */
            get licenseType(): License;
            set licenseType(val: License);
            /**
             * A logo for the about box.
             *
             * If it is `NULL`, the default window icon set with
             * [func`Gtk`.Window.set_default_icon_name] will be used.
             */
            get logo(): Gdk.Paintable;
            set logo(val: Gdk.Paintable);
            /**
             * A named icon to use as the logo for the about box.
             *
             * This property overrides the [property`Gtk`.AboutDialog:logo] property.
             */
            get logo_icon_name(): string;
            set logo_icon_name(val: string);
            /**
             * A named icon to use as the logo for the about box.
             *
             * This property overrides the [property`Gtk`.AboutDialog:logo] property.
             */
            get logoIconName(): string;
            set logoIconName(val: string);
            /**
             * The name of the program.
             *
             * If this is not set, it defaults to the value returned by
             * [func`GLib`.get_application_name].
             */
            get program_name(): string;
            set program_name(val: string);
            /**
             * The name of the program.
             *
             * If this is not set, it defaults to the value returned by
             * [func`GLib`.get_application_name].
             */
            get programName(): string;
            set programName(val: string);
            /**
             * Information about the system on which the program is running.
             *
             * This information is displayed in a separate page, therefore it is fine
             * to use a long multi-paragraph text. Note that the text should contain
             * the intended linebreaks.
             *
             * The text may contain links in this format `<http://www.some.place/>`
             * and email references in the form `<mail-to`some`.body>`, and these will
             * be converted into clickable links.
             */
            get system_information(): string;
            set system_information(val: string);
            /**
             * Information about the system on which the program is running.
             *
             * This information is displayed in a separate page, therefore it is fine
             * to use a long multi-paragraph text. Note that the text should contain
             * the intended linebreaks.
             *
             * The text may contain links in this format `<http://www.some.place/>`
             * and email references in the form `<mail-to`some`.body>`, and these will
             * be converted into clickable links.
             */
            get systemInformation(): string;
            set systemInformation(val: string);
            /**
             * Credits to the translators.
             *
             * This string should be marked as translatable.
             *
             * The string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get translator_credits(): string;
            set translator_credits(val: string);
            /**
             * Credits to the translators.
             *
             * This string should be marked as translatable.
             *
             * The string may contain email addresses and URLs, which will be displayed
             * as links, see the introduction for more details.
             */
            get translatorCredits(): string;
            set translatorCredits(val: string);
            /**
             * The version of the program.
             */
            get version(): string;
            set version(val: string);
            /**
             * The URL for the link to the website of the program.
             *
             * This should be a string starting with `http://` or `https://`.
             */
            get website(): string;
            set website(val: string);
            /**
             * The label for the link to the website of the program.
             */
            get website_label(): string;
            set website_label(val: string);
            /**
             * The label for the link to the website of the program.
             */
            get websiteLabel(): string;
            set websiteLabel(val: string);
            /**
             * Whether to wrap the text in the license dialog.
             */
            get wrap_license(): boolean;
            set wrap_license(val: boolean);
            /**
             * Whether to wrap the text in the license dialog.
             */
            get wrapLicense(): boolean;
            set wrapLicense(val: boolean);

            // Constructors

            constructor(properties?: Partial<AboutDialog.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): AboutDialog;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            connect_after(signal: 'activate-link', callback: (_source: this, uri: string) => boolean): number;
            emit(signal: 'activate-link', uri: string): void;

            // Methods

            /**
             * Creates a new section in the "Credits" page.
             * @param section_name The name of the section
             * @param people the people who belong to that section
             */
            add_credit_section(section_name: string, people: string[]): void;
            /**
             * Returns the names of the artists which are displayed
             * in the credits page.
             * @returns A   `NULL`-terminated string array containing the artists
             */
            get_artists(): string[];
            /**
             * Returns the names of the authors which are displayed
             * in the credits page.
             * @returns A   `NULL`-terminated string array containing the authors
             */
            get_authors(): string[];
            /**
             * Returns the comments string.
             * @returns The comments
             */
            get_comments(): string | null;
            /**
             * Returns the copyright string.
             * @returns The copyright string
             */
            get_copyright(): string | null;
            /**
             * Returns the name of the documenters which are displayed
             * in the credits page.
             * @returns A   `NULL`-terminated string array containing the documenters
             */
            get_documenters(): string[];
            /**
             * Returns the license information.
             * @returns The license information
             */
            get_license(): string | null;
            /**
             * Retrieves the license type.
             * @returns a [enum@Gtk.License] value
             */
            get_license_type(): License;
            /**
             * Returns the paintable displayed as logo in the about dialog.
             * @returns the paintable displayed as   logo or `NULL` if the logo is unset or has been set via   [method@Gtk.AboutDialog.set_logo_icon_name]
             */
            get_logo(): Gdk.Paintable | null;
            /**
             * Returns the icon name displayed as logo in the about dialog.
             * @returns the icon name displayed as logo,   or `NULL` if the logo has been set via [method@Gtk.AboutDialog.set_logo]
             */
            get_logo_icon_name(): string | null;
            /**
             * Returns the program name displayed in the about dialog.
             * @returns the program name
             */
            get_program_name(): string | null;
            /**
             * Returns the system information that is shown in the about dialog.
             * @returns the system information
             */
            get_system_information(): string | null;
            /**
             * Returns the translator credits string which is displayed
             * in the credits page.
             * @returns The translator credits string
             */
            get_translator_credits(): string | null;
            /**
             * Returns the version string.
             * @returns The version string
             */
            get_version(): string | null;
            /**
             * Returns the website URL.
             * @returns The website URL
             */
            get_website(): string | null;
            /**
             * Returns the label used for the website link.
             * @returns The label used for the website link
             */
            get_website_label(): string | null;
            /**
             * Returns whether the license text in the about dialog is
             * automatically wrapped.
             * @returns `TRUE` if the license text is wrapped
             */
            get_wrap_license(): boolean;
            /**
             * Sets the names of the artists to be displayed
             * in the "Credits" page.
             * @param artists the authors of the artwork   of the application
             */
            set_artists(artists: string[]): void;
            /**
             * Sets the names of the authors which are displayed
             * in the "Credits" page of the about dialog.
             * @param authors the authors of the application
             */
            set_authors(authors: string[]): void;
            /**
             * Sets the comments string to display in the about dialog.
             *
             * This should be a short string of one or two lines.
             * @param comments a comments string
             */
            set_comments(comments?: string | null): void;
            /**
             * Sets the copyright string to display in the about dialog.
             *
             * This should be a short string of one or two lines.
             * @param copyright the copyright string
             */
            set_copyright(copyright?: string | null): void;
            /**
             * Sets the names of the documenters which are displayed
             * in the "Credits" page.
             * @param documenters the authors of the documentation   of the application
             */
            set_documenters(documenters: string[]): void;
            /**
             * Sets the license information to be displayed in the
             * about dialog.
             *
             * If `license` is `NULL`, the license page is hidden.
             * @param license the license information
             */
            set_license(license?: string | null): void;
            /**
             * Sets the license of the application showing the about dialog
             * from a list of known licenses.
             *
             * This function overrides the license set using
             * [method`Gtk`.AboutDialog.set_license].
             * @param license_type the type of license
             */
            set_license_type(license_type: License | null): void;
            /**
             * Sets the logo in the about dialog.
             * @param logo a `GdkPaintable`
             */
            set_logo(logo?: Gdk.Paintable | null): void;
            /**
             * Sets the icon name to be displayed as logo in the about dialog.
             * @param icon_name an icon name
             */
            set_logo_icon_name(icon_name?: string | null): void;
            /**
             * Sets the name to display in the about dialog.
             *
             * If `name` is not set, the string returned
             * by `g_get_application_name()` is used.
             * @param name the program name
             */
            set_program_name(name?: string | null): void;
            /**
             * Sets the system information to be displayed in the about
             * dialog.
             *
             * If `system_information` is `NULL`, the system information
             * page is hidden.
             *
             * See [property`Gtk`.AboutDialog:system-information].
             * @param system_information system information
             */
            set_system_information(system_information?: string | null): void;
            /**
             * Sets the translator credits string which is displayed in
             * the credits page.
             *
             * The intended use for this string is to display the translator
             * of the language which is currently used in the user interface.
             * Using `gettext()`, a simple way to achieve that is to mark the
             * string for translation:
             *
             * ```c
             * GtkWidget *about = gtk_about_dialog_new ();
             *  gtk_about_dialog_set_translator_credits (GTK_ABOUT_DIALOG (about),
             *                                           _("translator-credits"));
             * ```
             *
             * It is a good idea to use the customary `msgid` “translator-credits”
             * for this purpose, since translators will already know the purpose of
             * that `msgid`, and since `GtkAboutDialog` will detect if “translator-credits”
             * is untranslated and omit translator credits.
             * @param translator_credits the translator credits
             */
            set_translator_credits(translator_credits?: string | null): void;
            /**
             * Sets the version string to display in the about dialog.
             * @param version the version string
             */
            set_version(version?: string | null): void;
            /**
             * Sets the URL to use for the website link.
             * @param website a URL string starting with `http://`
             */
            set_website(website?: string | null): void;
            /**
             * Sets the label to be used for the website link.
             * @param website_label the label used for the website link
             */
            set_website_label(website_label: string): void;
            /**
             * Sets whether the license text in the about dialog should be
             * automatically wrapped.
             * @param wrap_license whether to wrap the license
             */
            set_wrap_license(wrap_license: boolean): void;

            // Inherited properties
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Align;
            set halign(val: Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): LayoutManager;
            set layout_manager(val: LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): LayoutManager;
            set layoutManager(val: LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Overflow;
            set overflow(val: Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Align;
            set valign(val: Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Returns the renderer that is used for this `GtkNative`.
             * @returns the renderer for @self
             */
            get_renderer(): Gsk.Renderer | null;
            /**
             * Returns the surface of this `GtkNative`.
             * @returns the surface of @self
             */
            get_surface(): Gdk.Surface | null;
            /**
             * Retrieves the surface transform of `self`.
             *
             * This is the translation from `self'`s surface coordinates into
             * `self'`s widget coordinates.
             */
            get_surface_transform(): [number, number];
            /**
             * Realizes a `GtkNative`.
             *
             * This should only be used by subclasses.
             */
            realize(): void;
            /**
             * Unrealizes a `GtkNative`.
             *
             * This should only be used by subclasses.
             */
            unrealize(): void;
            /**
             * Returns the display that this `GtkRoot` is on.
             * @returns the display of @root
             */
            get_display(): Gdk.Display;
            /**
             * Retrieves the current focused widget within the root.
             *
             * Note that this is the widget that would have the focus
             * if the root is active; if the root is not focused then
             * `gtk_widget_has_focus (widget)` will be %FALSE for the
             * widget.
             * @returns the currently focused widget
             */
            get_focus(): Widget | null;
            /**
             * If `focus` is not the current focus widget, and is focusable, sets
             * it as the focus widget for the root.
             *
             * If `focus` is %NULL, unsets the focus widget for the root.
             *
             * To set the focus to a particular widget in the root, it is usually
             * more convenient to use [method`Gtk`.Widget.grab_focus] instead of
             * this function.
             * @param focus widget to be the new focus widget, or %NULL    to unset the focus widget
             */
            set_focus(focus?: Widget | null): void;
            /**
             * Add a `GtkShortcutController` to be managed.
             * @param controller
             */
            vfunc_add_controller(controller: ShortcutController): void;
            /**
             * Remove a `GtkShortcutController` that had previously
             *   been added
             * @param controller
             */
            vfunc_remove_controller(controller: ShortcutController): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates the widget.
             *
             * The activation will emit the signal set using
             * [method`Gtk`.WidgetClass.set_activate_signal]
             * during class initialization.
             *
             * Activation is what happens when you press <kbd>Enter</kbd>
             * on a widget.
             *
             * If you wish to handle the activation keybinding yourself,
             * it is recommended to use [method`Gtk`.WidgetClass.add_shortcut]
             * with an action created with [ctor`Gtk`.SignalAction.new].
             *
             * If `widget` is not activatable, the function returns false.
             * @returns true if the widget was activated
             */
            activate(): boolean;
            /**
             * Activates an action for the widget.
             *
             * The action is looked up in the action groups associated with
             * `widget` and its ancestors.
             *
             * If the action is in an action group added with
             * [method`Gtk`.Widget.insert_action_group], the `name` is expected
             * to be prefixed with the prefix that was used when the group was
             * inserted.
             *
             * The arguments must match the actions expected parameter type,
             * as returned by [method`Gio`.Action.get_parameter_type].
             * @param name the name of the action to activate
             * @param args parameters to use
             * @returns true if the action was activated
             */
            activate_action(name: string, args?: GLib.Variant | null): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): TextDirection;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Requisition | null, Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Widget, previous_sibling?: Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Widget, next_sibling?: Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: PickFlags | null): Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Widget, snapshot: Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace ActionBar {
            // Constructor properties interface

            interface ConstructorProps
                extends Widget.ConstructorProps,
                    Accessible.ConstructorProps,
                    Buildable.ConstructorProps,
                    ConstraintTarget.ConstructorProps {
                revealed: boolean;
            }
        }

        /**
         * Presents contextual actions.
         *
         * <picture>
         *   <source srcset="action-bar-dark.png" media="(prefers-color-scheme: dark)">
         *   <img alt="An example GtkActionBar" src="action-bar.png">
         * </picture>
         *
         * `GtkActionBar` is expected to be displayed below the content and expand
         * horizontally to fill the area.
         *
         * It allows placing children at the start or the end. In addition, it
         * contains an internal centered box which is centered with respect to
         * the full width of the box, even if the children at either side take
         * up different amounts of space.
         *
         * # GtkActionBar as GtkBuildable
         *
         * The `GtkActionBar` implementation of the `GtkBuildable` interface supports
         * adding children at the start or end sides by specifying “start” or “end” as
         * the “type” attribute of a `<child>` element, or setting the center widget
         * by specifying “center” value.
         *
         * # CSS nodes
         *
         * ```
         * actionbar
         * ╰── revealer
         *     ╰── box
         *         ├── box.start
         *         │   ╰── [start children]
         *         ├── [center widget]
         *         ╰── box.end
         *             ╰── [end children]
         * ```
         *
         * A `GtkActionBar`'s CSS node is called `actionbar`. It contains a `revealer`
         * subnode, which contains a `box` subnode, which contains two `box` subnodes at
         * the start and end of the action bar, with `start` and `end` style classes
         * respectively, as well as a center node that represents the center child.
         *
         * Each of the boxes contains children packed for that side.
         */
        class ActionBar extends Widget implements Accessible, Buildable, ConstraintTarget {
            static $gtype: GObject.GType<ActionBar>;

            // Properties

            /**
             * Controls whether the action bar shows its contents.
             */
            get revealed(): boolean;
            set revealed(val: boolean);

            // Constructors

            constructor(properties?: Partial<ActionBar.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): ActionBar;

            // Methods

            /**
             * Retrieves the center bar widget of the bar.
             * @returns the center widget
             */
            get_center_widget(): Widget | null;
            /**
             * Gets whether the contents of the action bar are revealed.
             * @returns the current value of the [property@Gtk.ActionBar:revealed]   property
             */
            get_revealed(): boolean;
            /**
             * Adds a child to the action bar, packed with reference to the
             * end of the action bar.
             * @param child the widget to be added
             */
            pack_end(child: Widget): void;
            /**
             * Adds a child to the action, packed with reference to the
             * start of the action bar.
             * @param child the widget to be added
             */
            pack_start(child: Widget): void;
            /**
             * Removes a child from the action bar.
             * @param child the widget to be removed
             */
            remove(child: Widget): void;
            /**
             * Sets the center widget for the action bar.
             * @param center_widget a widget to use for the center
             */
            set_center_widget(center_widget?: Widget | null): void;
            /**
             * Reveals or conceals the content of the action bar.
             *
             * Note: this does not show or hide the action bar in the
             * [property`Gtk`.Widget:visible] sense, so revealing has
             * no effect if the action bar is hidden.
             * @param revealed the new value for the property
             */
            set_revealed(revealed: boolean): void;

            // Inherited properties
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessible_role(): AccessibleRole;
            set accessible_role(val: AccessibleRole);
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessibleRole(): AccessibleRole;
            set accessibleRole(val: AccessibleRole);

            // Inherited methods
            /**
             * Requests the user's screen reader to announce the given message.
             *
             * This kind of notification is useful for messages that
             * either have only a visual representation or that are not
             * exposed visually at all, e.g. a notification about a
             * successful operation.
             *
             * Also, by using this API, you can ensure that the message
             * does not interrupts the user's current screen reader output.
             * @param message the string to announce
             * @param priority the priority of the announcement
             */
            announce(message: string, priority: AccessibleAnnouncementPriority | null): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             * @returns the accessible parent
             */
            get_accessible_parent(): Accessible | null;
            /**
             * Retrieves the accessible role of an accessible object.
             * @returns the accessible role
             */
            get_accessible_role(): AccessibleRole;
            /**
             * Retrieves the implementation for the given accessible object.
             * @returns the accessible implementation object
             */
            get_at_context(): ATContext;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             * @returns true if the bounds are valid, and false otherwise
             */
            get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             * @returns the first accessible child
             */
            get_first_accessible_child(): Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             * @returns the next accessible sibling
             */
            get_next_accessible_sibling(): Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             * @returns the value of state for the accessible
             */
            get_platform_state(state: AccessiblePlatformState | null): boolean;
            /**
             * Resets the accessible property to its default value.
             * @param property the accessible property
             */
            reset_property(property: AccessibleProperty | null): void;
            /**
             * Resets the accessible relation to its default value.
             * @param relation the accessible relation
             */
            reset_relation(relation: AccessibleRelation | null): void;
            /**
             * Resets the accessible state to its default value.
             * @param state the accessible state
             */
            reset_state(state: AccessibleState | null): void;
            /**
             * Sets the parent and sibling of an accessible object.
             *
             * This function is meant to be used by accessible implementations that are
             * not part of the widget hierarchy, and but act as a logical bridge between
             * widgets. For instance, if a widget creates an object that holds metadata
             * for each child, and you want that object to implement the `GtkAccessible`
             * interface, you will use this function to ensure that the parent of each
             * child widget is the metadata object, and the parent of each metadata
             * object is the container widget.
             * @param parent the parent accessible object
             * @param next_sibling the sibling accessible object
             */
            set_accessible_parent(parent?: Accessible | null, next_sibling?: Accessible | null): void;
            /**
             * Updates the next accessible sibling.
             *
             * That might be useful when a new child of a custom accessible
             * is created, and it needs to be linked to a previous child.
             * @param new_sibling the new next accessible sibling to set
             */
            update_next_accessible_sibling(new_sibling?: Accessible | null): void;
            /**
             * Informs ATs that the platform state has changed.
             *
             * This function should be used by `GtkAccessible` implementations that
             * have a platform state but are not widgets. Widgets handle platform
             * states automatically.
             * @param state the platform state to update
             */
            update_platform_state(state: AccessiblePlatformState | null): void;
            /**
             * Updates an array of accessible properties.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * property change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param properties an array of accessible properties
             * @param values an array of `GValues`, one for each property
             */
            update_property(properties: AccessibleProperty[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible relations.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * relation change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param relations an array of accessible relations
             * @param values an array of `GValues`, one for each relation
             */
            update_relation(relations: AccessibleRelation[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible states.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * state change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param states an array of accessible states
             * @param values an array of `GValues`, one for each state
             */
            update_state(states: AccessibleState[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             */
            vfunc_get_accessible_parent(): Accessible | null;
            /**
             * Retrieves the implementation for the given accessible object.
             */
            vfunc_get_at_context(): ATContext | null;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             */
            vfunc_get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             */
            vfunc_get_first_accessible_child(): Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             */
            vfunc_get_next_accessible_sibling(): Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             */
            vfunc_get_platform_state(state: AccessiblePlatformState): boolean;
            /**
             * Gets the ID of the `buildable` object.
             *
             * `GtkBuilder` sets the name based on the ID attribute
             * of the `<object>` tag used to construct the `buildable`.
             * @returns the ID of the buildable object
             */
            get_buildable_id(): string | null;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a `GtkBuilder`
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a `GtkBuilder`
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called at the end of each custom element handled by
             * the buildable.
             * @param builder `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called for each unknown element under `<child>`.
             * @param builder a `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, BuildableParser, any];
            /**
             * The getter corresponding to `set_id`. Implement this
             *   if you implement `set_id`.
             */
            vfunc_get_id(): string;
            /**
             * Retrieves the internal child called `childname` of the `buildable` object.
             * @param builder a `GtkBuilder`
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Called when a builder finishes the parsing
             *  of a UI definition. It is normally not necessary to implement this,
             *  unless you need to perform special cleanup actions. `GtkWindow` sets
             *  the `GtkWidget:visible` property here.
             * @param builder
             */
            vfunc_parser_finished(builder: Builder): void;
            /**
             * Sets a property of a buildable object.
             *  It is normally not necessary to implement this, g_object_set_property()
             *  is used by default. `GtkWindow` implements this to delay showing itself
             *  (i.e. setting the [property`Gtk`.Widget:visible] property) until the whole
             *  interface is created.
             * @param builder
             * @param name
             * @param value
             */
            vfunc_set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Stores the id attribute given in the `GtkBuilder` UI definition.
             *   `GtkWidget` stores the name as object data. Implement this method if your
             *   object has some notion of “ID” and it makes sense to map the XML id
             *   attribute to it.
             * @param id
             */
            vfunc_set_id(id: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace ActivateAction {
            // Constructor properties interface

            interface ConstructorProps extends ShortcutAction.ConstructorProps {}
        }

        /**
         * Activates a widget.
         *
         * Widgets are activated by calling [method`Gtk`.Widget.activate].
         */
        class ActivateAction extends ShortcutAction {
            static $gtype: GObject.GType<ActivateAction>;

            // Constructors

            constructor(properties?: Partial<ActivateAction.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Static methods

            /**
             * Gets the activate action.
             *
             * This is an action that calls gtk_widget_activate()
             * on the given widget upon activation.
             */
            static get(): ActivateAction;
        }

        namespace Adjustment {
            // Signal callback interfaces

            interface Changed {
                (): void;
            }

            interface ValueChanged {
                (): void;
            }

            // Constructor properties interface

            interface ConstructorProps extends GObject.InitiallyUnowned.ConstructorProps {
                lower: number;
                page_increment: number;
                pageIncrement: number;
                page_size: number;
                pageSize: number;
                step_increment: number;
                stepIncrement: number;
                upper: number;
                value: number;
            }
        }

        /**
         * A model for a numeric value.
         *
         * The `GtkAdjustment` has an associated lower and upper bound.
         * It also contains step and page increments, and a page size.
         *
         * Adjustments are used within several GTK widgets, including
         * [class`Gtk`.SpinButton], [class`Gtk`.Viewport], [class`Gtk`.Scrollbar]
         * and [class`Gtk`.Scale].
         *
         * The `GtkAdjustment` object does not update the value itself. Instead
         * it is left up to the owner of the `GtkAdjustment` to control the value.
         */
        class Adjustment extends GObject.InitiallyUnowned {
            static $gtype: GObject.GType<Adjustment>;

            // Properties

            /**
             * The minimum value of the adjustment.
             */
            get lower(): number;
            set lower(val: number);
            /**
             * The page increment of the adjustment.
             */
            get page_increment(): number;
            set page_increment(val: number);
            /**
             * The page increment of the adjustment.
             */
            get pageIncrement(): number;
            set pageIncrement(val: number);
            /**
             * The page size of the adjustment.
             *
             * Note that the page-size is irrelevant and should be set to zero
             * if the adjustment is used for a simple scalar value, e.g. in a
             * `GtkSpinButton`.
             */
            get page_size(): number;
            set page_size(val: number);
            /**
             * The page size of the adjustment.
             *
             * Note that the page-size is irrelevant and should be set to zero
             * if the adjustment is used for a simple scalar value, e.g. in a
             * `GtkSpinButton`.
             */
            get pageSize(): number;
            set pageSize(val: number);
            /**
             * The step increment of the adjustment.
             */
            get step_increment(): number;
            set step_increment(val: number);
            /**
             * The step increment of the adjustment.
             */
            get stepIncrement(): number;
            set stepIncrement(val: number);
            /**
             * The maximum value of the adjustment.
             *
             * Note that values will be restricted by `upper - page-size` if the page-size
             * property is nonzero.
             */
            get upper(): number;
            set upper(val: number);
            /**
             * The value of the adjustment.
             */
            get value(): number;
            set value(val: number);

            // Constructors

            constructor(properties?: Partial<Adjustment.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](
                value: number,
                lower: number,
                upper: number,
                step_increment: number,
                page_increment: number,
                page_size: number,
            ): Adjustment;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'changed', callback: (_source: this) => void): number;
            connect_after(signal: 'changed', callback: (_source: this) => void): number;
            emit(signal: 'changed'): void;
            connect(signal: 'value-changed', callback: (_source: this) => void): number;
            connect_after(signal: 'value-changed', callback: (_source: this) => void): number;
            emit(signal: 'value-changed'): void;

            // Virtual methods

            vfunc_changed(): void;
            vfunc_value_changed(): void;

            // Methods

            /**
             * Updates the value of the adjustment to ensure that the
             * given range is contained in the current page.
             *
             * The current page goes from `value` to `value` + `page-size`.
             * If the range is larger than the page size, then only the
             * start of it will be in the current page.
             *
             * A [signal`Gtk`.Adjustment::value-changed] signal will be emitted
             * if the value is changed.
             * @param lower the lower value
             * @param upper the upper value
             */
            clamp_page(lower: number, upper: number): void;
            /**
             * Sets all properties of the adjustment at once.
             *
             * Use this function to avoid multiple emissions of the
             * [signal`Gtk`.Adjustment::changed] signal. See
             * [method`Gtk`.Adjustment.set_lower] for an alternative
             * way of compressing multiple emissions of
             * [signal`Gtk`.Adjustment::changed] into one.
             * @param value the new value
             * @param lower the new minimum value
             * @param upper the new maximum value
             * @param step_increment the new step increment
             * @param page_increment the new page increment
             * @param page_size the new page size
             */
            configure(
                value: number,
                lower: number,
                upper: number,
                step_increment: number,
                page_increment: number,
                page_size: number,
            ): void;
            /**
             * Retrieves the minimum value of the adjustment.
             * @returns the minimum value
             */
            get_lower(): number;
            /**
             * Gets the smaller of step increment and page increment.
             * @returns the minimum increment
             */
            get_minimum_increment(): number;
            /**
             * Retrieves the page increment of the adjustment.
             * @returns the page increment
             */
            get_page_increment(): number;
            /**
             * Retrieves the page size of the adjustment.
             * @returns the page size
             */
            get_page_size(): number;
            /**
             * Retrieves the step increment of the adjustment.
             * @returns the step increment
             */
            get_step_increment(): number;
            /**
             * Retrieves the maximum value of the adjustment.
             * @returns the maximum value
             */
            get_upper(): number;
            /**
             * Gets the current value of the adjustment.
             * @returns the current value
             */
            get_value(): number;
            /**
             * Sets the minimum value of the adjustment.
             *
             * When setting multiple adjustment properties via their individual
             * setters, multiple [signal`Gtk`.Adjustment::changed] signals will
             * be emitted. However, since the emission of the
             * [signal`Gtk`.Adjustment::changed] signal is tied to the emission
             * of the ::notify signals of the changed properties, it’s possible
             * to compress the [signal`Gtk`.Adjustment::changed] signals into one
             * by calling g_object_freeze_notify() and g_object_thaw_notify()
             * around the calls to the individual setters.
             *
             * Alternatively, using a single g_object_set() for all the properties
             * to change, or using [method`Gtk`.Adjustment.configure] has the same effect.
             * @param lower the new minimum value
             */
            set_lower(lower: number): void;
            /**
             * Sets the page increment of the adjustment.
             *
             * See [method`Gtk`.Adjustment.set_lower] about how to compress
             * multiple emissions of the [signal`Gtk`.Adjustment::changed]
             * signal when setting multiple adjustment properties.
             * @param page_increment the new page increment
             */
            set_page_increment(page_increment: number): void;
            /**
             * Sets the page size of the adjustment.
             *
             * See [method`Gtk`.Adjustment.set_lower] about how to compress
             * multiple emissions of the [signal`Gtk`.Adjustment::changed]
             * signal when setting multiple adjustment properties.
             * @param page_size the new page size
             */
            set_page_size(page_size: number): void;
            /**
             * Sets the step increment of the adjustment.
             *
             * See [method`Gtk`.Adjustment.set_lower] about how to compress
             * multiple emissions of the [signal`Gtk`.Adjustment::changed]
             * signal when setting multiple adjustment properties.
             * @param step_increment the new step increment
             */
            set_step_increment(step_increment: number): void;
            /**
             * Sets the maximum value of the adjustment.
             *
             * Note that values will be restricted by `upper - page-size`
             * if the page-size property is nonzero.
             *
             * See [method`Gtk`.Adjustment.set_lower] about how to compress
             * multiple emissions of the [signal`Gtk`.Adjustment::changed]
             * signal when setting multiple adjustment properties.
             * @param upper the new maximum value
             */
            set_upper(upper: number): void;
            /**
             * Sets the `GtkAdjustment` value.
             *
             * The value is clamped to lie between [property`Gtk`.Adjustment:lower]
             * and [property`Gtk`.Adjustment:upper].
             *
             * Note that for adjustments which are used in a `GtkScrollbar`,
             * the effective range of allowed values goes from
             * [property`Gtk`.Adjustment:lower] to
             * [property`Gtk`.Adjustment:upper] - [property`Gtk`.Adjustment:page-size].
             * @param value the new value
             */
            set_value(value: number): void;
        }

        namespace AlertDialog {
            // Constructor properties interface

            interface ConstructorProps extends GObject.Object.ConstructorProps {
                buttons: string[];
                cancel_button: number;
                cancelButton: number;
                default_button: number;
                defaultButton: number;
                detail: string;
                message: string;
                modal: boolean;
            }
        }

        /**
         * Collects the arguments that are needed to present a message to the user.
         *
         * The message is shown with the [method`Gtk`.AlertDialog.choose]
         * function.
         *
         * If you don't need to wait for a button to be clicked, you can use
         * [method`Gtk`.AlertDialog.show].
         */
        class AlertDialog extends GObject.Object {
            static $gtype: GObject.GType<AlertDialog>;

            // Properties

            /**
             * Labels for buttons to show in the alert.
             *
             * The labels should be translated and may contain
             * a `_` character to indicate the mnemonic character.
             *
             * If this property is not set, then a 'Close' button is
             * automatically created.
             */
            get buttons(): string[];
            set buttons(val: string[]);
            /**
             * Determines what happens when the <kbd>Escape</kbd> key is pressed
             * while the alert is shown.
             *
             * If this property holds the index of a button in [property`Gtk`.AlertDialog:buttons],
             * then pressing Escape is treated as if that button was pressed. If it is -1
             * or not a valid index for the `buttons` array, then an error is returned.
             *
             * If `buttons` is `NULL`, then the automatically created 'Close' button
             * is treated as both cancel and default button, so 0 is returned.
             */
            get cancel_button(): number;
            set cancel_button(val: number);
            /**
             * Determines what happens when the <kbd>Escape</kbd> key is pressed
             * while the alert is shown.
             *
             * If this property holds the index of a button in [property`Gtk`.AlertDialog:buttons],
             * then pressing Escape is treated as if that button was pressed. If it is -1
             * or not a valid index for the `buttons` array, then an error is returned.
             *
             * If `buttons` is `NULL`, then the automatically created 'Close' button
             * is treated as both cancel and default button, so 0 is returned.
             */
            get cancelButton(): number;
            set cancelButton(val: number);
            /**
             * Determines what happens when the <kbd>Return</kbd> key is pressed
             * while the alert is shown.
             *
             * If this property holds the index of a button in [property`Gtk`.AlertDialog:buttons],
             * then pressing Return is treated as if that button was pressed. If it is -1
             * or not a valid index for the `buttons` array, then nothing happens.
             *
             * If `buttons` is `NULL`, then the automatically created 'Close' button
             * is treated as both cancel and default button, so 0 is returned.
             */
            get default_button(): number;
            set default_button(val: number);
            /**
             * Determines what happens when the <kbd>Return</kbd> key is pressed
             * while the alert is shown.
             *
             * If this property holds the index of a button in [property`Gtk`.AlertDialog:buttons],
             * then pressing Return is treated as if that button was pressed. If it is -1
             * or not a valid index for the `buttons` array, then nothing happens.
             *
             * If `buttons` is `NULL`, then the automatically created 'Close' button
             * is treated as both cancel and default button, so 0 is returned.
             */
            get defaultButton(): number;
            set defaultButton(val: number);
            /**
             * The detail text for the alert.
             */
            get detail(): string;
            set detail(val: string);
            /**
             * The message for the alert.
             */
            get message(): string;
            set message(val: string);
            /**
             * Whether the alert is modal.
             */
            get modal(): boolean;
            set modal(val: boolean);

            // Constructors

            constructor(properties?: Partial<AlertDialog.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            // Methods

            /**
             * Shows the alert to the user.
             *
             * It is ok to pass `NULL` for the callback if the alert
             * does not have more than one button. A simpler API for
             * this case is [method`Gtk`.AlertDialog.show].
             * @param parent the parent window
             * @param cancellable a cancellable to cancel the operation
             */
            choose(parent?: Window | null, cancellable?: Gio.Cancellable | null): Promise<number>;
            /**
             * Shows the alert to the user.
             *
             * It is ok to pass `NULL` for the callback if the alert
             * does not have more than one button. A simpler API for
             * this case is [method`Gtk`.AlertDialog.show].
             * @param parent the parent window
             * @param cancellable a cancellable to cancel the operation
             * @param callback a callback to call   when the operation is complete
             */
            choose(
                parent: Window | null,
                cancellable: Gio.Cancellable | null,
                callback: Gio.AsyncReadyCallback<this> | null,
            ): void;
            /**
             * Shows the alert to the user.
             *
             * It is ok to pass `NULL` for the callback if the alert
             * does not have more than one button. A simpler API for
             * this case is [method`Gtk`.AlertDialog.show].
             * @param parent the parent window
             * @param cancellable a cancellable to cancel the operation
             * @param callback a callback to call   when the operation is complete
             */
            choose(
                parent?: Window | null,
                cancellable?: Gio.Cancellable | null,
                callback?: Gio.AsyncReadyCallback<this> | null,
            ): Promise<number> | void;
            /**
             * Finishes the [method`Gtk`.AlertDialog.choose] call.
             * @param result the result
             * @returns the index of the button that was clicked, or -1 if   the dialog was cancelled and [property@Gtk.AlertDialog:cancel-button]   is not set
             */
            choose_finish(result: Gio.AsyncResult): number;
            /**
             * Returns the button labels for the alert.
             * @returns the button labels
             */
            get_buttons(): string[] | null;
            /**
             * Returns the index of the cancel button.
             * @returns the index of the cancel button, or -1
             */
            get_cancel_button(): number;
            /**
             * Returns the index of the default button.
             * @returns the index of the default button, or -1
             */
            get_default_button(): number;
            /**
             * Returns the detail text that will be shown in the alert.
             * @returns the detail text
             */
            get_detail(): string;
            /**
             * Returns the message that will be shown in the alert.
             * @returns the message
             */
            get_message(): string;
            /**
             * Returns whether the alert blocks interaction
             * with the parent window while it is presented.
             * @returns true if the alert is modal
             */
            get_modal(): boolean;
            /**
             * Sets the button labels for the alert.
             * @param labels the new button labels
             */
            set_buttons(labels: string[]): void;
            /**
             * Sets the index of the cancel button.
             *
             * See [property`Gtk`.AlertDialog:cancel-button] for
             * details of how this value is used.
             * @param button the new cancel button
             */
            set_cancel_button(button: number): void;
            /**
             * Sets the index of the default button.
             *
             * See [property`Gtk`.AlertDialog:default-button] for
             * details of how this value is used.
             * @param button the new default button
             */
            set_default_button(button: number): void;
            /**
             * Sets the detail text that will be shown in the alert.
             * @param detail the new detail text
             */
            set_detail(detail: string): void;
            /**
             * Sets the message that will be shown in the alert.
             * @param message the new message
             */
            set_message(message: string): void;
            /**
             * Sets whether the alert blocks interaction
             * with the parent window while it is presented.
             * @param modal the new value
             */
            set_modal(modal: boolean): void;
            /**
             * Shows the alert to the user.
             *
             * This function is a simpler version of [method`Gtk`.AlertDialog.choose]
             * intended for dialogs with a single button.
             *
             * If you want to cancel the dialog or if the alert has more than one
             * button, you should use that function instead and provide it with a
             * [class`Gio`.Cancellable] and callback respectively.
             * @param parent the parent window
             */
            show(parent?: Window | null): void;
        }

        namespace AlternativeTrigger {
            // Constructor properties interface

            interface ConstructorProps extends ShortcutTrigger.ConstructorProps {
                first: ShortcutTrigger;
                second: ShortcutTrigger;
            }
        }

        /**
         * Combines two shortcut triggers.
         *
         * The `GtkAlternativeTrigger` triggers when either of the two trigger.
         *
         * This can be cascaded to combine more than two triggers.
         */
        class AlternativeTrigger extends ShortcutTrigger {
            static $gtype: GObject.GType<AlternativeTrigger>;

            // Properties

            /**
             * The first `GtkShortcutTrigger` to check.
             */
            get first(): ShortcutTrigger;
            /**
             * The second `GtkShortcutTrigger` to check.
             */
            get second(): ShortcutTrigger;

            // Constructors

            constructor(properties?: Partial<AlternativeTrigger.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](first: ShortcutTrigger, second: ShortcutTrigger): AlternativeTrigger;

            // Methods

            /**
             * Gets the first of the two alternative triggers that may
             * trigger `self`.
             *
             * [method`Gtk`.AlternativeTrigger.get_second] will return
             * the other one.
             * @returns the first alternative trigger
             */
            get_first(): ShortcutTrigger;
            /**
             * Gets the second of the two alternative triggers that may
             * trigger `self`.
             *
             * [method`Gtk`.AlternativeTrigger.get_first] will return
             * the other one.
             * @returns the second alternative trigger
             */
            get_second(): ShortcutTrigger;
        }

        namespace AnyFilter {
            // Constructor properties interface

            interface ConstructorProps<A extends GObject.Object = GObject.Object>
                extends MultiFilter.ConstructorProps,
                    Gio.ListModel.ConstructorProps,
                    Buildable.ConstructorProps {}
        }

        /**
         * Matches an item when at least one of its filters matches.
         *
         * To add filters to a `GtkAnyFilter`, use [method`Gtk`.MultiFilter.append].
         */
        class AnyFilter<A extends GObject.Object = GObject.Object>
            extends MultiFilter
            implements Gio.ListModel<A>, Buildable
        {
            static $gtype: GObject.GType<AnyFilter>;

            // Constructors

            constructor(properties?: Partial<AnyFilter.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](): AnyFilter;

            // Inherited methods
            /**
             * Gets the type of the items in `list`.
             *
             * All items returned from g_list_model_get_item() are of the type
             * returned by this function, or a subtype, or if the type is an
             * interface, they are an implementation of that interface.
             *
             * The item type of a #GListModel can not change during the life of the
             * model.
             * @returns the #GType of the items contained in @list.
             */
            get_item_type(): GObject.GType;
            /**
             * Gets the number of items in `list`.
             *
             * Depending on the model implementation, calling this function may be
             * less efficient than iterating the list with increasing values for
             * `position` until g_list_model_get_item() returns %NULL.
             * @returns the number of items in @list.
             */
            get_n_items(): number;
            /**
             * Get the item at `position`.
             *
             * If `position` is greater than the number of items in `list,` %NULL is
             * returned.
             *
             * %NULL is never returned for an index that is smaller than the length
             * of the list.
             *
             * This function is meant to be used by language bindings in place
             * of g_list_model_get_item().
             *
             * See also: g_list_model_get_n_items()
             * @param position the position of the item to fetch
             * @returns the object at @position.
             */
            get_item(position: number): A | null;
            /**
             * Emits the #GListModel::items-changed signal on `list`.
             *
             * This function should only be called by classes implementing
             * #GListModel. It has to be called after the internal representation
             * of `list` has been updated, because handlers connected to this signal
             * might query the new state of the list.
             *
             * Implementations must only make changes to the model (as visible to
             * its consumer) in places that will not cause problems for that
             * consumer.  For models that are driven directly by a write API (such
             * as #GListStore), changes can be reported in response to uses of that
             * API.  For models that represent remote data, changes should only be
             * made from a fresh mainloop dispatch.  It is particularly not
             * permitted to make changes in response to a call to the #GListModel
             * consumer API.
             *
             * Stated another way: in general, it is assumed that code making a
             * series of accesses to the model via the API, without returning to the
             * mainloop, and without calling other code, will continue to view the
             * same contents of the model.
             * @param position the position at which @list changed
             * @param removed the number of items removed
             * @param added the number of items added
             */
            items_changed(position: number, removed: number, added: number): void;
            /**
             * Get the item at `position`. If `position` is greater than the number of
             * items in `list,` %NULL is returned.
             *
             * %NULL is never returned for an index that is smaller than the length
             * of the list.  See g_list_model_get_n_items().
             *
             * The same #GObject instance may not appear more than once in a #GListModel.
             * @param position the position of the item to fetch
             */
            vfunc_get_item(position: number): A | null;
            /**
             * Gets the type of the items in `list`.
             *
             * All items returned from g_list_model_get_item() are of the type
             * returned by this function, or a subtype, or if the type is an
             * interface, they are an implementation of that interface.
             *
             * The item type of a #GListModel can not change during the life of the
             * model.
             */
            vfunc_get_item_type(): GObject.GType;
            /**
             * Gets the number of items in `list`.
             *
             * Depending on the model implementation, calling this function may be
             * less efficient than iterating the list with increasing values for
             * `position` until g_list_model_get_item() returns %NULL.
             */
            vfunc_get_n_items(): number;
            /**
             * Gets the ID of the `buildable` object.
             *
             * `GtkBuilder` sets the name based on the ID attribute
             * of the `<object>` tag used to construct the `buildable`.
             * @returns the ID of the buildable object
             */
            get_buildable_id(): string | null;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a `GtkBuilder`
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a `GtkBuilder`
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called at the end of each custom element handled by
             * the buildable.
             * @param builder `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called for each unknown element under `<child>`.
             * @param builder a `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, BuildableParser, any];
            /**
             * The getter corresponding to `set_id`. Implement this
             *   if you implement `set_id`.
             */
            vfunc_get_id(): string;
            /**
             * Retrieves the internal child called `childname` of the `buildable` object.
             * @param builder a `GtkBuilder`
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Called when a builder finishes the parsing
             *  of a UI definition. It is normally not necessary to implement this,
             *  unless you need to perform special cleanup actions. `GtkWindow` sets
             *  the `GtkWidget:visible` property here.
             * @param builder
             */
            vfunc_parser_finished(builder: Builder): void;
            /**
             * Sets a property of a buildable object.
             *  It is normally not necessary to implement this, g_object_set_property()
             *  is used by default. `GtkWindow` implements this to delay showing itself
             *  (i.e. setting the [property`Gtk`.Widget:visible] property) until the whole
             *  interface is created.
             * @param builder
             * @param name
             * @param value
             */
            vfunc_set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Stores the id attribute given in the `GtkBuilder` UI definition.
             *   `GtkWidget` stores the name as object data. Implement this method if your
             *   object has some notion of “ID” and it makes sense to map the XML id
             *   attribute to it.
             * @param id
             */
            vfunc_set_id(id: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
        }

        namespace AppChooserButton {
            // Signal callback interfaces

            interface Activate {
                (): void;
            }

            interface Changed {
                (): void;
            }

            interface CustomItemActivated {
                (item_name: string): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Widget.ConstructorProps,
                    Accessible.ConstructorProps,
                    AppChooser.ConstructorProps,
                    Buildable.ConstructorProps,
                    ConstraintTarget.ConstructorProps {
                heading: string;
                modal: boolean;
                show_default_item: boolean;
                showDefaultItem: boolean;
                show_dialog_item: boolean;
                showDialogItem: boolean;
            }
        }

        /**
         * The `GtkAppChooserButton` lets the user select an application.
         *
         * <picture>
         *   <source srcset="appchooserbutton-dark.png" media="(prefers-color-scheme: dark)">
         *   <img alt="An example GtkAppChooserButton" src="appchooserbutton.png">
         * </picture>
         *
         * Initially, a `GtkAppChooserButton` selects the first application
         * in its list, which will either be the most-recently used application
         * or, if [property`Gtk`.AppChooserButton:show-default-item] is %TRUE, the
         * default application.
         *
         * The list of applications shown in a `GtkAppChooserButton` includes
         * the recommended applications for the given content type. When
         * [property`Gtk`.AppChooserButton:show-default-item] is set, the default
         * application is also included. To let the user chooser other applications,
         * you can set the [property`Gtk`.AppChooserButton:show-dialog-item] property,
         * which allows to open a full [class`Gtk`.AppChooserDialog].
         *
         * It is possible to add custom items to the list, using
         * [method`Gtk`.AppChooserButton.append_custom_item]. These items cause
         * the [signal`Gtk`.AppChooserButton::custom-item-activated] signal to be
         * emitted when they are selected.
         *
         * To track changes in the selected application, use the
         * [signal`Gtk`.AppChooserButton::changed] signal.
         *
         * ## CSS nodes
         *
         * `GtkAppChooserButton` has a single CSS node with the name “appchooserbutton”.
         */
        class AppChooserButton extends Widget implements Accessible, AppChooser, Buildable, ConstraintTarget {
            static $gtype: GObject.GType<AppChooserButton>;

            // Properties

            /**
             * The text to show at the top of the dialog that can be
             * opened from the button.
             *
             * The string may contain Pango markup.
             */
            get heading(): string;
            set heading(val: string);
            /**
             * Whether the app chooser dialog should be modal.
             */
            get modal(): boolean;
            set modal(val: boolean);
            /**
             * Determines whether the dropdown menu shows the default application
             * on top for the provided content type.
             */
            get show_default_item(): boolean;
            set show_default_item(val: boolean);
            /**
             * Determines whether the dropdown menu shows the default application
             * on top for the provided content type.
             */
            get showDefaultItem(): boolean;
            set showDefaultItem(val: boolean);
            /**
             * Determines whether the dropdown menu shows an item to open
             * a `GtkAppChooserDialog`.
             */
            get show_dialog_item(): boolean;
            set show_dialog_item(val: boolean);
            /**
             * Determines whether the dropdown menu shows an item to open
             * a `GtkAppChooserDialog`.
             */
            get showDialogItem(): boolean;
            set showDialogItem(val: boolean);

            // Constructors

            constructor(properties?: Partial<AppChooserButton.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](content_type: string): AppChooserButton;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(signal: 'activate', callback: (_source: this) => void): number;
            connect_after(signal: 'activate', callback: (_source: this) => void): number;
            emit(signal: 'activate'): void;
            connect(signal: 'changed', callback: (_source: this) => void): number;
            connect_after(signal: 'changed', callback: (_source: this) => void): number;
            emit(signal: 'changed'): void;
            connect(signal: 'custom-item-activated', callback: (_source: this, item_name: string) => void): number;
            connect_after(
                signal: 'custom-item-activated',
                callback: (_source: this, item_name: string) => void,
            ): number;
            emit(signal: 'custom-item-activated', item_name: string): void;

            // Methods

            /**
             * Appends a custom item to the list of applications that is shown
             * in the popup.
             *
             * The item name must be unique per-widget. Clients can use the
             * provided name as a detail for the
             * [signal`Gtk`.AppChooserButton::custom-item-activated] signal, to add a
             * callback for the activation of a particular custom item in the list.
             *
             * See also [method`Gtk`.AppChooserButton.append_separator].
             * @param name the name of the custom item
             * @param label the label for the custom item
             * @param icon the icon for the custom item
             */
            append_custom_item(name: string, label: string, icon: Gio.Icon): void;
            /**
             * Appends a separator to the list of applications that is shown
             * in the popup.
             */
            append_separator(): void;
            /**
             * Returns the text to display at the top of the dialog.
             * @returns the text to display at the top of the dialog,   or %NULL, in which case a default text is displayed
             */
            get_heading(): string | null;
            /**
             * Gets whether the dialog is modal.
             * @returns %TRUE if the dialog is modal
             */
            get_modal(): boolean;
            /**
             * Returns whether the dropdown menu should show the default
             * application at the top.
             * @returns the value of [property@Gtk.AppChooserButton:show-default-item]
             */
            get_show_default_item(): boolean;
            /**
             * Returns whether the dropdown menu shows an item
             * for a `GtkAppChooserDialog`.
             * @returns the value of [property@Gtk.AppChooserButton:show-dialog-item]
             */
            get_show_dialog_item(): boolean;
            /**
             * Selects a custom item.
             *
             * See [method`Gtk`.AppChooserButton.append_custom_item].
             *
             * Use [method`Gtk`.AppChooser.refresh] to bring the selection
             * to its initial state.
             * @param name the name of the custom item
             */
            set_active_custom_item(name: string): void;
            /**
             * Sets the text to display at the top of the dialog.
             *
             * If the heading is not set, the dialog displays a default text.
             * @param heading a string containing Pango markup
             */
            set_heading(heading: string): void;
            /**
             * Sets whether the dialog should be modal.
             * @param modal %TRUE to make the dialog modal
             */
            set_modal(modal: boolean): void;
            /**
             * Sets whether the dropdown menu of this button should show the
             * default application for the given content type at top.
             * @param setting the new value for [property@Gtk.AppChooserButton:show-default-item]
             */
            set_show_default_item(setting: boolean): void;
            /**
             * Sets whether the dropdown menu of this button should show an
             * entry to trigger a `GtkAppChooserDialog`.
             * @param setting the new value for [property@Gtk.AppChooserButton:show-dialog-item]
             */
            set_show_dialog_item(setting: boolean): void;

            // Inherited properties
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessible_role(): AccessibleRole;
            set accessible_role(val: AccessibleRole);
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessibleRole(): AccessibleRole;
            set accessibleRole(val: AccessibleRole);
            /**
             * The content type of the `GtkAppChooser` object.
             *
             * See `GContentType` for more information about content types.
             */
            get content_type(): string;
            /**
             * The content type of the `GtkAppChooser` object.
             *
             * See `GContentType` for more information about content types.
             */
            get contentType(): string;
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Align;
            set halign(val: Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): LayoutManager;
            set layout_manager(val: LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): LayoutManager;
            set layoutManager(val: LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Overflow;
            set overflow(val: Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Align;
            set valign(val: Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Requests the user's screen reader to announce the given message.
             *
             * This kind of notification is useful for messages that
             * either have only a visual representation or that are not
             * exposed visually at all, e.g. a notification about a
             * successful operation.
             *
             * Also, by using this API, you can ensure that the message
             * does not interrupts the user's current screen reader output.
             * @param message the string to announce
             * @param priority the priority of the announcement
             */
            announce(message: string, priority: AccessibleAnnouncementPriority | null): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             * @returns the accessible parent
             */
            get_accessible_parent(): Accessible | null;
            /**
             * Retrieves the accessible role of an accessible object.
             * @returns the accessible role
             */
            get_accessible_role(): AccessibleRole;
            /**
             * Retrieves the implementation for the given accessible object.
             * @returns the accessible implementation object
             */
            get_at_context(): ATContext;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             * @returns true if the bounds are valid, and false otherwise
             */
            get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             * @returns the first accessible child
             */
            get_first_accessible_child(): Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             * @returns the next accessible sibling
             */
            get_next_accessible_sibling(): Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             * @returns the value of state for the accessible
             */
            get_platform_state(state: AccessiblePlatformState | null): boolean;
            /**
             * Resets the accessible property to its default value.
             * @param property the accessible property
             */
            reset_property(property: AccessibleProperty | null): void;
            /**
             * Resets the accessible relation to its default value.
             * @param relation the accessible relation
             */
            reset_relation(relation: AccessibleRelation | null): void;
            /**
             * Resets the accessible state to its default value.
             * @param state the accessible state
             */
            reset_state(state: AccessibleState | null): void;
            /**
             * Sets the parent and sibling of an accessible object.
             *
             * This function is meant to be used by accessible implementations that are
             * not part of the widget hierarchy, and but act as a logical bridge between
             * widgets. For instance, if a widget creates an object that holds metadata
             * for each child, and you want that object to implement the `GtkAccessible`
             * interface, you will use this function to ensure that the parent of each
             * child widget is the metadata object, and the parent of each metadata
             * object is the container widget.
             * @param parent the parent accessible object
             * @param next_sibling the sibling accessible object
             */
            set_accessible_parent(parent?: Accessible | null, next_sibling?: Accessible | null): void;
            /**
             * Updates the next accessible sibling.
             *
             * That might be useful when a new child of a custom accessible
             * is created, and it needs to be linked to a previous child.
             * @param new_sibling the new next accessible sibling to set
             */
            update_next_accessible_sibling(new_sibling?: Accessible | null): void;
            /**
             * Informs ATs that the platform state has changed.
             *
             * This function should be used by `GtkAccessible` implementations that
             * have a platform state but are not widgets. Widgets handle platform
             * states automatically.
             * @param state the platform state to update
             */
            update_platform_state(state: AccessiblePlatformState | null): void;
            /**
             * Updates an array of accessible properties.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * property change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param properties an array of accessible properties
             * @param values an array of `GValues`, one for each property
             */
            update_property(properties: AccessibleProperty[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible relations.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * relation change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param relations an array of accessible relations
             * @param values an array of `GValues`, one for each relation
             */
            update_relation(relations: AccessibleRelation[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible states.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * state change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param states an array of accessible states
             * @param values an array of `GValues`, one for each state
             */
            update_state(states: AccessibleState[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             */
            vfunc_get_accessible_parent(): Accessible | null;
            /**
             * Retrieves the implementation for the given accessible object.
             */
            vfunc_get_at_context(): ATContext | null;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             */
            vfunc_get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             */
            vfunc_get_first_accessible_child(): Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             */
            vfunc_get_next_accessible_sibling(): Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             */
            vfunc_get_platform_state(state: AccessiblePlatformState): boolean;
            /**
             * Returns the currently selected application.
             * @returns a `GAppInfo` for the   currently selected application
             */
            get_app_info(): Gio.AppInfo | null;
            /**
             * Returns the content type for which the `GtkAppChooser`
             * shows applications.
             * @returns the content type of @self. Free with g_free()
             */
            get_content_type(): string;
            /**
             * Reloads the list of applications.
             */
            refresh(): void;
            /**
             * Gets the ID of the `buildable` object.
             *
             * `GtkBuilder` sets the name based on the ID attribute
             * of the `<object>` tag used to construct the `buildable`.
             * @returns the ID of the buildable object
             */
            get_buildable_id(): string | null;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a `GtkBuilder`
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a `GtkBuilder`
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called at the end of each custom element handled by
             * the buildable.
             * @param builder `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called for each unknown element under `<child>`.
             * @param builder a `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, BuildableParser, any];
            /**
             * The getter corresponding to `set_id`. Implement this
             *   if you implement `set_id`.
             */
            vfunc_get_id(): string;
            /**
             * Retrieves the internal child called `childname` of the `buildable` object.
             * @param builder a `GtkBuilder`
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Called when a builder finishes the parsing
             *  of a UI definition. It is normally not necessary to implement this,
             *  unless you need to perform special cleanup actions. `GtkWindow` sets
             *  the `GtkWidget:visible` property here.
             * @param builder
             */
            vfunc_parser_finished(builder: Builder): void;
            /**
             * Sets a property of a buildable object.
             *  It is normally not necessary to implement this, g_object_set_property()
             *  is used by default. `GtkWindow` implements this to delay showing itself
             *  (i.e. setting the [property`Gtk`.Widget:visible] property) until the whole
             *  interface is created.
             * @param builder
             * @param name
             * @param value
             */
            vfunc_set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Stores the id attribute given in the `GtkBuilder` UI definition.
             *   `GtkWidget` stores the name as object data. Implement this method if your
             *   object has some notion of “ID” and it makes sense to map the XML id
             *   attribute to it.
             * @param id
             */
            vfunc_set_id(id: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates the widget.
             *
             * The activation will emit the signal set using
             * [method`Gtk`.WidgetClass.set_activate_signal]
             * during class initialization.
             *
             * Activation is what happens when you press <kbd>Enter</kbd>
             * on a widget.
             *
             * If you wish to handle the activation keybinding yourself,
             * it is recommended to use [method`Gtk`.WidgetClass.add_shortcut]
             * with an action created with [ctor`Gtk`.SignalAction.new].
             *
             * If `widget` is not activatable, the function returns false.
             * @returns true if the widget was activated
             */
            activate(): boolean;
            /**
             * Activates an action for the widget.
             *
             * The action is looked up in the action groups associated with
             * `widget` and its ancestors.
             *
             * If the action is in an action group added with
             * [method`Gtk`.Widget.insert_action_group], the `name` is expected
             * to be prefixed with the prefix that was used when the group was
             * inserted.
             *
             * The arguments must match the actions expected parameter type,
             * as returned by [method`Gio`.Action.get_parameter_type].
             * @param name the name of the action to activate
             * @param args parameters to use
             * @returns true if the action was activated
             */
            activate_action(name: string, args?: GLib.Variant | null): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): TextDirection;
            /**
             * Get the display for the window that the widget belongs to.
             *
             * This function can only be called after the widget has been
             * added to a widget hierarchy with a `GtkRoot` at the top.
             *
             * In general, you should only create display-specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the display for this widget
             */
            get_display(): Gdk.Display;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Requisition | null, Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Widget, previous_sibling?: Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Widget, next_sibling?: Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: PickFlags | null): Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            realize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Widget, snapshot: Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            unrealize(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace AppChooserDialog {
            // Constructor properties interface

            interface ConstructorProps
                extends Dialog.ConstructorProps,
                    Accessible.ConstructorProps,
                    AppChooser.ConstructorProps,
                    Buildable.ConstructorProps,
                    ConstraintTarget.ConstructorProps,
                    Native.ConstructorProps,
                    Root.ConstructorProps,
                    ShortcutManager.ConstructorProps {
                gfile: Gio.File;
                heading: string;
            }
        }

        /**
         * `GtkAppChooserDialog` shows a `GtkAppChooserWidget` inside a `GtkDialog`.
         *
         * <picture>
         *   <source srcset="appchooserdialog-dark.png" media="(prefers-color-scheme: dark)">
         *   <img alt="An example GtkAppChooserDialog" src="appchooserdialog.png">
         * </picture>
         *
         * Note that `GtkAppChooserDialog` does not have any interesting methods
         * of its own. Instead, you should get the embedded `GtkAppChooserWidget`
         * using [method`Gtk`.AppChooserDialog.get_widget] and call its methods if
         * the generic [iface`Gtk`.AppChooser] interface is not sufficient for
         * your needs.
         *
         * To set the heading that is shown above the `GtkAppChooserWidget`,
         * use [method`Gtk`.AppChooserDialog.set_heading].
         *
         * ## CSS nodes
         *
         * `GtkAppChooserDialog` has a single CSS node with the name `window` and style
         * class `.appchooser`.
         */
        class AppChooserDialog
            extends Dialog
            implements Accessible, AppChooser, Buildable, ConstraintTarget, Native, Root, ShortcutManager
        {
            static $gtype: GObject.GType<AppChooserDialog>;

            // Properties

            /**
             * The GFile used by the `GtkAppChooserDialog`.
             *
             * The dialog's `GtkAppChooserWidget` content type will
             * be guessed from the file, if present.
             */
            get gfile(): Gio.File;
            /**
             * The text to show at the top of the dialog.
             *
             * The string may contain Pango markup.
             */
            get heading(): string;
            set heading(val: string);

            // Constructors

            constructor(properties?: Partial<AppChooserDialog.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](parent: Window | null, flags: DialogFlags, file: Gio.File): AppChooserDialog;
            // Conflicted with Gtk.Dialog.new

            static ['new'](...args: never[]): any;

            static new_for_content_type(
                parent: Window | null,
                flags: DialogFlags,
                content_type: string,
            ): AppChooserDialog;

            // Methods

            /**
             * Returns the text to display at the top of the dialog.
             * @returns the text to display at the top of the dialog,   or %NULL, in which case a default text is displayed
             */
            get_heading(): string | null;
            /**
             * Returns the `GtkAppChooserWidget` of this dialog.
             * @returns the `GtkAppChooserWidget` of @self
             */
            get_widget(): Widget;
            /**
             * Sets the text to display at the top of the dialog.
             *
             * If the heading is not set, the dialog displays a default text.
             * @param heading a string containing Pango markup
             */
            set_heading(heading: string): void;

            // Inherited properties
            /**
             * The content type of the `GtkAppChooser` object.
             *
             * See `GContentType` for more information about content types.
             */
            get content_type(): string;
            /**
             * The content type of the `GtkAppChooser` object.
             *
             * See `GContentType` for more information about content types.
             */
            get contentType(): string;
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Align;
            set halign(val: Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): LayoutManager;
            set layout_manager(val: LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): LayoutManager;
            set layoutManager(val: LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Overflow;
            set overflow(val: Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Align;
            set valign(val: Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Returns the currently selected application.
             * @returns a `GAppInfo` for the   currently selected application
             */
            get_app_info(): Gio.AppInfo | null;
            /**
             * Returns the content type for which the `GtkAppChooser`
             * shows applications.
             * @returns the content type of @self. Free with g_free()
             */
            get_content_type(): string;
            /**
             * Reloads the list of applications.
             */
            refresh(): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates the widget.
             *
             * The activation will emit the signal set using
             * [method`Gtk`.WidgetClass.set_activate_signal]
             * during class initialization.
             *
             * Activation is what happens when you press <kbd>Enter</kbd>
             * on a widget.
             *
             * If you wish to handle the activation keybinding yourself,
             * it is recommended to use [method`Gtk`.WidgetClass.add_shortcut]
             * with an action created with [ctor`Gtk`.SignalAction.new].
             *
             * If `widget` is not activatable, the function returns false.
             * @returns true if the widget was activated
             */
            activate(): boolean;
            /**
             * Activates an action for the widget.
             *
             * The action is looked up in the action groups associated with
             * `widget` and its ancestors.
             *
             * If the action is in an action group added with
             * [method`Gtk`.Widget.insert_action_group], the `name` is expected
             * to be prefixed with the prefix that was used when the group was
             * inserted.
             *
             * The arguments must match the actions expected parameter type,
             * as returned by [method`Gio`.Action.get_parameter_type].
             * @param name the name of the action to activate
             * @param args parameters to use
             * @returns true if the action was activated
             */
            activate_action(name: string, args?: GLib.Variant | null): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): TextDirection;
            /**
             * Get the display for the window that the widget belongs to.
             *
             * This function can only be called after the widget has been
             * added to a widget hierarchy with a `GtkRoot` at the top.
             *
             * In general, you should only create display-specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the display for this widget
             */
            get_display(): Gdk.Display;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Requisition | null, Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Widget, previous_sibling?: Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Widget, next_sibling?: Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: PickFlags | null): Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            realize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Widget, snapshot: Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            unrealize(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace AppChooserWidget {
            // Signal callback interfaces

            interface ApplicationActivated {
                (application: Gio.AppInfo): void;
            }

            interface ApplicationSelected {
                (application: Gio.AppInfo): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Widget.ConstructorProps,
                    Accessible.ConstructorProps,
                    AppChooser.ConstructorProps,
                    Buildable.ConstructorProps,
                    ConstraintTarget.ConstructorProps {
                default_text: string;
                defaultText: string;
                show_all: boolean;
                showAll: boolean;
                show_default: boolean;
                showDefault: boolean;
                show_fallback: boolean;
                showFallback: boolean;
                show_other: boolean;
                showOther: boolean;
                show_recommended: boolean;
                showRecommended: boolean;
            }
        }

        /**
         * `GtkAppChooserWidget` is a widget for selecting applications.
         *
         * It is the main building block for [class`Gtk`.AppChooserDialog].
         * Most applications only need to use the latter; but you can use
         * this widget as part of a larger widget if you have special needs.
         *
         * `GtkAppChooserWidget` offers detailed control over what applications
         * are shown, using the
         * [property`Gtk`.AppChooserWidget:show-default],
         * [property`Gtk`.AppChooserWidget:show-recommended],
         * [property`Gtk`.AppChooserWidget:show-fallback],
         * [property`Gtk`.AppChooserWidget:show-other] and
         * [property`Gtk`.AppChooserWidget:show-all] properties. See the
         * [iface`Gtk`.AppChooser] documentation for more information about these
         * groups of applications.
         *
         * To keep track of the selected application, use the
         * [signal`Gtk`.AppChooserWidget::application-selected] and
         * [signal`Gtk`.AppChooserWidget::application-activated] signals.
         *
         * ## CSS nodes
         *
         * `GtkAppChooserWidget` has a single CSS node with name appchooser.
         */
        class AppChooserWidget extends Widget implements Accessible, AppChooser, Buildable, ConstraintTarget {
            static $gtype: GObject.GType<AppChooserWidget>;

            // Properties

            /**
             * The text that appears in the widget when there are no applications
             * for the given content type.
             */
            get default_text(): string;
            set default_text(val: string);
            /**
             * The text that appears in the widget when there are no applications
             * for the given content type.
             */
            get defaultText(): string;
            set defaultText(val: string);
            /**
             * If %TRUE, the app chooser presents all applications
             * in a single list, without subsections for default,
             * recommended or related applications.
             */
            get show_all(): boolean;
            set show_all(val: boolean);
            /**
             * If %TRUE, the app chooser presents all applications
             * in a single list, without subsections for default,
             * recommended or related applications.
             */
            get showAll(): boolean;
            set showAll(val: boolean);
            /**
             * Determines whether the app chooser should show the default
             * handler for the content type in a separate section.
             *
             * If %FALSE, the default handler is listed among the recommended
             * applications.
             */
            get show_default(): boolean;
            set show_default(val: boolean);
            /**
             * Determines whether the app chooser should show the default
             * handler for the content type in a separate section.
             *
             * If %FALSE, the default handler is listed among the recommended
             * applications.
             */
            get showDefault(): boolean;
            set showDefault(val: boolean);
            /**
             * Determines whether the app chooser should show a section
             * for fallback applications.
             *
             * If %FALSE, the fallback applications are listed among the
             * other applications.
             */
            get show_fallback(): boolean;
            set show_fallback(val: boolean);
            /**
             * Determines whether the app chooser should show a section
             * for fallback applications.
             *
             * If %FALSE, the fallback applications are listed among the
             * other applications.
             */
            get showFallback(): boolean;
            set showFallback(val: boolean);
            /**
             * Determines whether the app chooser should show a section
             * for other applications.
             */
            get show_other(): boolean;
            set show_other(val: boolean);
            /**
             * Determines whether the app chooser should show a section
             * for other applications.
             */
            get showOther(): boolean;
            set showOther(val: boolean);
            /**
             * Determines whether the app chooser should show a section
             * for recommended applications.
             *
             * If %FALSE, the recommended applications are listed
             * among the other applications.
             */
            get show_recommended(): boolean;
            set show_recommended(val: boolean);
            /**
             * Determines whether the app chooser should show a section
             * for recommended applications.
             *
             * If %FALSE, the recommended applications are listed
             * among the other applications.
             */
            get showRecommended(): boolean;
            set showRecommended(val: boolean);

            // Constructors

            constructor(properties?: Partial<AppChooserWidget.ConstructorProps>, ...args: any[]);

            _init(...args: any[]): void;

            static ['new'](content_type: string): AppChooserWidget;

            // Signals

            connect(id: string, callback: (...args: any[]) => any): number;
            connect_after(id: string, callback: (...args: any[]) => any): number;
            emit(id: string, ...args: any[]): void;
            connect(
                signal: 'application-activated',
                callback: (_source: this, application: Gio.AppInfo) => void,
            ): number;
            connect_after(
                signal: 'application-activated',
                callback: (_source: this, application: Gio.AppInfo) => void,
            ): number;
            emit(signal: 'application-activated', application: Gio.AppInfo): void;
            connect(
                signal: 'application-selected',
                callback: (_source: this, application: Gio.AppInfo) => void,
            ): number;
            connect_after(
                signal: 'application-selected',
                callback: (_source: this, application: Gio.AppInfo) => void,
            ): number;
            emit(signal: 'application-selected', application: Gio.AppInfo): void;

            // Methods

            /**
             * Returns the text that is shown if there are not applications
             * that can handle the content type.
             * @returns the value of [property@Gtk.AppChooserWidget:default-text]
             */
            get_default_text(): string | null;
            /**
             * Gets whether the app chooser should show all applications
             * in a flat list.
             * @returns the value of [property@Gtk.AppChooserWidget:show-all]
             */
            get_show_all(): boolean;
            /**
             * Gets whether the app chooser should show the default handler
             * for the content type in a separate section.
             * @returns the value of [property@Gtk.AppChooserWidget:show-default]
             */
            get_show_default(): boolean;
            /**
             * Gets whether the app chooser should show related applications
             * for the content type in a separate section.
             * @returns the value of [property@Gtk.AppChooserWidget:show-fallback]
             */
            get_show_fallback(): boolean;
            /**
             * Gets whether the app chooser should show applications
             * which are unrelated to the content type.
             * @returns the value of [property@Gtk.AppChooserWidget:show-other]
             */
            get_show_other(): boolean;
            /**
             * Gets whether the app chooser should show recommended applications
             * for the content type in a separate section.
             * @returns the value of [property@Gtk.AppChooserWidget:show-recommended]
             */
            get_show_recommended(): boolean;
            /**
             * Sets the text that is shown if there are not applications
             * that can handle the content type.
             * @param text the new value for [property@Gtk.AppChooserWidget:default-text]
             */
            set_default_text(text: string): void;
            /**
             * Sets whether the app chooser should show all applications
             * in a flat list.
             * @param setting the new value for [property@Gtk.AppChooserWidget:show-all]
             */
            set_show_all(setting: boolean): void;
            /**
             * Sets whether the app chooser should show the default handler
             * for the content type in a separate section.
             * @param setting the new value for [property@Gtk.AppChooserWidget:show-default]
             */
            set_show_default(setting: boolean): void;
            /**
             * Sets whether the app chooser should show related applications
             * for the content type in a separate section.
             * @param setting the new value for [property@Gtk.AppChooserWidget:show-fallback]
             */
            set_show_fallback(setting: boolean): void;
            /**
             * Sets whether the app chooser should show applications
             * which are unrelated to the content type.
             * @param setting the new value for [property@Gtk.AppChooserWidget:show-other]
             */
            set_show_other(setting: boolean): void;
            /**
             * Sets whether the app chooser should show recommended applications
             * for the content type in a separate section.
             * @param setting the new value for [property@Gtk.AppChooserWidget:show-recommended]
             */
            set_show_recommended(setting: boolean): void;

            // Inherited properties
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessible_role(): AccessibleRole;
            set accessible_role(val: AccessibleRole);
            /**
             * The accessible role of the given `GtkAccessible` implementation.
             *
             * The accessible role cannot be changed once set.
             */
            get accessibleRole(): AccessibleRole;
            set accessibleRole(val: AccessibleRole);
            /**
             * The content type of the `GtkAppChooser` object.
             *
             * See `GContentType` for more information about content types.
             */
            get content_type(): string;
            /**
             * The content type of the `GtkAppChooser` object.
             *
             * See `GContentType` for more information about content types.
             */
            get contentType(): string;
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get can_focus(): boolean;
            set can_focus(val: boolean);
            /**
             * Whether the widget or any of its descendents can accept
             * the input focus.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get canFocus(): boolean;
            set canFocus(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get can_target(): boolean;
            set can_target(val: boolean);
            /**
             * Whether the widget can receive pointer events.
             */
            get canTarget(): boolean;
            set canTarget(val: boolean);
            /**
             * A list of css classes applied to this widget.
             */
            get css_classes(): string[];
            set css_classes(val: string[]);
            /**
             * A list of css classes applied to this widget.
             */
            get cssClasses(): string[];
            set cssClasses(val: string[]);
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get css_name(): string;
            /**
             * The name of this widget in the CSS tree.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get cssName(): string;
            /**
             * The cursor used by `widget`.
             */
            get cursor(): Gdk.Cursor;
            set cursor(val: Gdk.Cursor);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focus_on_click(): boolean;
            set focus_on_click(val: boolean);
            /**
             * Whether the widget should grab focus when it is clicked with the mouse.
             *
             * This property is only relevant for widgets that can take focus.
             */
            get focusOnClick(): boolean;
            set focusOnClick(val: boolean);
            /**
             * Whether this widget itself will accept the input focus.
             */
            get focusable(): boolean;
            set focusable(val: boolean);
            /**
             * How to distribute horizontal space if widget gets extra space.
             */
            get halign(): Align;
            set halign(val: Align);
            /**
             * Whether the widget is the default widget.
             */
            get has_default(): boolean;
            /**
             * Whether the widget is the default widget.
             */
            get hasDefault(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get has_focus(): boolean;
            /**
             * Whether the widget has the input focus.
             */
            get hasFocus(): boolean;
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get has_tooltip(): boolean;
            set has_tooltip(val: boolean);
            /**
             * Enables or disables the emission of the [signal`Gtk`.Widget::query-tooltip]
             * signal on `widget`.
             *
             * A true value indicates that `widget` can have a tooltip, in this case
             * the widget will be queried using [signal`Gtk`.Widget::query-tooltip] to
             * determine whether it will provide a tooltip or not.
             */
            get hasTooltip(): boolean;
            set hasTooltip(val: boolean);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get height_request(): number;
            set height_request(val: number);
            /**
             * Overrides for height request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get heightRequest(): number;
            set heightRequest(val: number);
            /**
             * Whether to expand horizontally.
             */
            get hexpand(): boolean;
            set hexpand(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpand_set(): boolean;
            set hexpand_set(val: boolean);
            /**
             * Whether to use the `hexpand` property.
             */
            get hexpandSet(): boolean;
            set hexpandSet(val: boolean);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layout_manager(): LayoutManager;
            set layout_manager(val: LayoutManager);
            /**
             * The [class`Gtk`.LayoutManager] instance to use to compute
             * the preferred size of the widget, and allocate its children.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get layoutManager(): LayoutManager;
            set layoutManager(val: LayoutManager);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limit_events(): boolean;
            set limit_events(val: boolean);
            /**
             * Makes this widget act like a modal dialog, with respect to
             * event delivery.
             *
             * Global event controllers will not handle events with targets
             * inside the widget, unless they are set up to ignore propagation
             * limits. See [method`Gtk`.EventController.set_propagation_limit].
             */
            get limitEvents(): boolean;
            set limitEvents(val: boolean);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_bottom(): number;
            set margin_bottom(val: number);
            /**
             * Margin on bottom side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginBottom(): number;
            set marginBottom(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_end(): number;
            set margin_end(val: number);
            /**
             * Margin on end of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginEnd(): number;
            set marginEnd(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_start(): number;
            set margin_start(val: number);
            /**
             * Margin on start of widget, horizontally.
             *
             * This property supports left-to-right and right-to-left text
             * directions.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginStart(): number;
            set marginStart(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get margin_top(): number;
            set margin_top(val: number);
            /**
             * Margin on top side of widget.
             *
             * This property adds margin outside of the widget's normal size
             * request, the margin will be added in addition to the size from
             * [method`Gtk`.Widget.set_size_request] for example.
             */
            get marginTop(): number;
            set marginTop(val: number);
            /**
             * The name of the widget.
             */
            get name(): string;
            set name(val: string);
            /**
             * The requested opacity of the widget.
             */
            get opacity(): number;
            set opacity(val: number);
            /**
             * How content outside the widget's content area is treated.
             *
             * This property is meant to be set by widget implementations,
             * typically in their instance init function.
             */
            get overflow(): Overflow;
            set overflow(val: Overflow);
            /**
             * The parent widget of this widget.
             */
            get parent(): Widget;
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receives_default(): boolean;
            set receives_default(val: boolean);
            /**
             * Whether the widget will receive the default action when it is focused.
             */
            get receivesDefault(): boolean;
            set receivesDefault(val: boolean);
            /**
             * The `GtkRoot` widget of the widget tree containing this widget.
             *
             * This will be `NULL` if the widget is not contained in a root widget.
             */
            get root(): Root;
            /**
             * The scale factor of the widget.
             */
            get scale_factor(): number;
            /**
             * The scale factor of the widget.
             */
            get scaleFactor(): number;
            /**
             * Whether the widget responds to input.
             */
            get sensitive(): boolean;
            set sensitive(val: boolean);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_markup(): string;
            set tooltip_markup(val: string);
            /**
             * Sets the text of tooltip to be the given string, which is marked up
             * with Pango markup.
             *
             * Also see [method`Gtk`.Tooltip.set_markup].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipMarkup(): string;
            set tooltipMarkup(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltip_text(): string;
            set tooltip_text(val: string);
            /**
             * Sets the text of tooltip to be the given string.
             *
             * Also see [method`Gtk`.Tooltip.set_text].
             *
             * This is a convenience property which will take care of getting the
             * tooltip shown if the given string is not `NULL`:
             * [property`Gtk`.Widget:has-tooltip] will automatically be set to true
             * and there will be taken care of [signal`Gtk`.Widget::query-tooltip] in
             * the default signal handler.
             *
             * Note that if both [property`Gtk`.Widget:tooltip-text] and
             * [property`Gtk`.Widget:tooltip-markup] are set, the last one wins.
             */
            get tooltipText(): string;
            set tooltipText(val: string);
            /**
             * How to distribute vertical space if widget gets extra space.
             */
            get valign(): Align;
            set valign(val: Align);
            /**
             * Whether to expand vertically.
             */
            get vexpand(): boolean;
            set vexpand(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpand_set(): boolean;
            set vexpand_set(val: boolean);
            /**
             * Whether to use the `vexpand` property.
             */
            get vexpandSet(): boolean;
            set vexpandSet(val: boolean);
            /**
             * Whether the widget is visible.
             */
            get visible(): boolean;
            set visible(val: boolean);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get width_request(): number;
            set width_request(val: number);
            /**
             * Overrides for width request of the widget.
             *
             * If this is -1, the natural request will be used.
             */
            get widthRequest(): number;
            set widthRequest(val: number);

            // Inherited methods
            /**
             * Requests the user's screen reader to announce the given message.
             *
             * This kind of notification is useful for messages that
             * either have only a visual representation or that are not
             * exposed visually at all, e.g. a notification about a
             * successful operation.
             *
             * Also, by using this API, you can ensure that the message
             * does not interrupts the user's current screen reader output.
             * @param message the string to announce
             * @param priority the priority of the announcement
             */
            announce(message: string, priority: AccessibleAnnouncementPriority | null): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             * @returns the accessible parent
             */
            get_accessible_parent(): Accessible | null;
            /**
             * Retrieves the accessible role of an accessible object.
             * @returns the accessible role
             */
            get_accessible_role(): AccessibleRole;
            /**
             * Retrieves the implementation for the given accessible object.
             * @returns the accessible implementation object
             */
            get_at_context(): ATContext;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             * @returns true if the bounds are valid, and false otherwise
             */
            get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             * @returns the first accessible child
             */
            get_first_accessible_child(): Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             * @returns the next accessible sibling
             */
            get_next_accessible_sibling(): Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             * @returns the value of state for the accessible
             */
            get_platform_state(state: AccessiblePlatformState | null): boolean;
            /**
             * Resets the accessible property to its default value.
             * @param property the accessible property
             */
            reset_property(property: AccessibleProperty | null): void;
            /**
             * Resets the accessible relation to its default value.
             * @param relation the accessible relation
             */
            reset_relation(relation: AccessibleRelation | null): void;
            /**
             * Resets the accessible state to its default value.
             * @param state the accessible state
             */
            reset_state(state: AccessibleState | null): void;
            /**
             * Sets the parent and sibling of an accessible object.
             *
             * This function is meant to be used by accessible implementations that are
             * not part of the widget hierarchy, and but act as a logical bridge between
             * widgets. For instance, if a widget creates an object that holds metadata
             * for each child, and you want that object to implement the `GtkAccessible`
             * interface, you will use this function to ensure that the parent of each
             * child widget is the metadata object, and the parent of each metadata
             * object is the container widget.
             * @param parent the parent accessible object
             * @param next_sibling the sibling accessible object
             */
            set_accessible_parent(parent?: Accessible | null, next_sibling?: Accessible | null): void;
            /**
             * Updates the next accessible sibling.
             *
             * That might be useful when a new child of a custom accessible
             * is created, and it needs to be linked to a previous child.
             * @param new_sibling the new next accessible sibling to set
             */
            update_next_accessible_sibling(new_sibling?: Accessible | null): void;
            /**
             * Informs ATs that the platform state has changed.
             *
             * This function should be used by `GtkAccessible` implementations that
             * have a platform state but are not widgets. Widgets handle platform
             * states automatically.
             * @param state the platform state to update
             */
            update_platform_state(state: AccessiblePlatformState | null): void;
            /**
             * Updates an array of accessible properties.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * property change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param properties an array of accessible properties
             * @param values an array of `GValues`, one for each property
             */
            update_property(properties: AccessibleProperty[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible relations.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * relation change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param relations an array of accessible relations
             * @param values an array of `GValues`, one for each relation
             */
            update_relation(relations: AccessibleRelation[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Updates an array of accessible states.
             *
             * This function should be called by `GtkWidget` types whenever an accessible
             * state change must be communicated to assistive technologies.
             *
             * This function is meant to be used by language bindings.
             * @param states an array of accessible states
             * @param values an array of `GValues`, one for each state
             */
            update_state(states: AccessibleState[] | null, values: (GObject.Value | any)[]): void;
            /**
             * Retrieves the accessible parent for an accessible object.
             *
             * This function returns `NULL` for top level widgets.
             */
            vfunc_get_accessible_parent(): Accessible | null;
            /**
             * Retrieves the implementation for the given accessible object.
             */
            vfunc_get_at_context(): ATContext | null;
            /**
             * Queries the coordinates and dimensions of this accessible
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get the bounds from an ignored
             * child widget.
             */
            vfunc_get_bounds(): [boolean, number, number, number, number];
            /**
             * Retrieves the first accessible child of an accessible object.
             */
            vfunc_get_first_accessible_child(): Accessible | null;
            /**
             * Retrieves the next accessible sibling of an accessible object
             */
            vfunc_get_next_accessible_sibling(): Accessible | null;
            /**
             * Queries a platform state, such as focus.
             *
             * This functionality can be overridden by `GtkAccessible`
             * implementations, e.g. to get platform state from an ignored
             * child widget, as is the case for `GtkText` wrappers.
             * @param state platform state to query
             */
            vfunc_get_platform_state(state: AccessiblePlatformState): boolean;
            /**
             * Returns the currently selected application.
             * @returns a `GAppInfo` for the   currently selected application
             */
            get_app_info(): Gio.AppInfo | null;
            /**
             * Returns the content type for which the `GtkAppChooser`
             * shows applications.
             * @returns the content type of @self. Free with g_free()
             */
            get_content_type(): string;
            /**
             * Reloads the list of applications.
             */
            refresh(): void;
            /**
             * Gets the ID of the `buildable` object.
             *
             * `GtkBuilder` sets the name based on the ID attribute
             * of the `<object>` tag used to construct the `buildable`.
             * @returns the ID of the buildable object
             */
            get_buildable_id(): string | null;
            /**
             * Adds a child to `buildable`. `type` is an optional string
             * describing how the child should be added.
             * @param builder a `GtkBuilder`
             * @param child child to add
             * @param type kind of child or %NULL
             */
            vfunc_add_child(builder: Builder, child: GObject.Object, type?: string | null): void;
            /**
             * Similar to gtk_buildable_parser_finished() but is
             * called once for each custom tag handled by the `buildable`.
             * @param builder a `GtkBuilder`
             * @param child child object or %NULL for non-child tags
             * @param tagname the name of the tag
             * @param data user data created in custom_tag_start
             */
            vfunc_custom_finished(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called at the end of each custom element handled by
             * the buildable.
             * @param builder `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             * @param data user data that will be passed in to parser functions
             */
            vfunc_custom_tag_end(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
                data?: any | null,
            ): void;
            /**
             * Called for each unknown element under `<child>`.
             * @param builder a `GtkBuilder` used to construct this object
             * @param child child object or %NULL for non-child tags
             * @param tagname name of tag
             */
            vfunc_custom_tag_start(
                builder: Builder,
                child: GObject.Object | null,
                tagname: string,
            ): [boolean, BuildableParser, any];
            /**
             * The getter corresponding to `set_id`. Implement this
             *   if you implement `set_id`.
             */
            vfunc_get_id(): string;
            /**
             * Retrieves the internal child called `childname` of the `buildable` object.
             * @param builder a `GtkBuilder`
             * @param childname name of child
             */
            vfunc_get_internal_child<T = GObject.Object>(builder: Builder, childname: string): T;
            /**
             * Called when a builder finishes the parsing
             *  of a UI definition. It is normally not necessary to implement this,
             *  unless you need to perform special cleanup actions. `GtkWindow` sets
             *  the `GtkWidget:visible` property here.
             * @param builder
             */
            vfunc_parser_finished(builder: Builder): void;
            /**
             * Sets a property of a buildable object.
             *  It is normally not necessary to implement this, g_object_set_property()
             *  is used by default. `GtkWindow` implements this to delay showing itself
             *  (i.e. setting the [property`Gtk`.Widget:visible] property) until the whole
             *  interface is created.
             * @param builder
             * @param name
             * @param value
             */
            vfunc_set_buildable_property(builder: Builder, name: string, value: GObject.Value | any): void;
            /**
             * Stores the id attribute given in the `GtkBuilder` UI definition.
             *   `GtkWidget` stores the name as object data. Implement this method if your
             *   object has some notion of “ID” and it makes sense to map the XML id
             *   attribute to it.
             * @param id
             */
            vfunc_set_id(id: string): void;
            /**
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target`.
             *
             * Whenever the `source_property` is changed the `target_property` is
             * updated using the same value. For instance:
             *
             *
             * ```c
             *   g_object_bind_property (action, "active", widget, "sensitive", 0);
             * ```
             *
             *
             * Will result in the "sensitive" property of the widget #GObject instance to be
             * updated with the same value of the "active" property of the action #GObject
             * instance.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well.
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. To remove the binding without affecting the
             * `source` and the `target` you can just call g_object_unref() on the returned
             * #GBinding instance.
             *
             * Removing the binding by calling g_object_unref() on it must only be done if
             * the binding, `source` and `target` are only used from a single thread and it
             * is clear that both `source` and `target` outlive the binding. Especially it
             * is not safe to rely on this if the binding, `source` or `target` can be
             * finalized from different threads. Keep another reference to the binding and
             * use g_binding_unbind() instead to be on the safe side.
             *
             * A #GObject can have multiple bindings.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
            ): GObject.Binding;
            /**
             * Complete version of g_object_bind_property().
             *
             * Creates a binding between `source_property` on `source` and `target_property`
             * on `target,` allowing you to set the transformation functions to be used by
             * the binding.
             *
             * If `flags` contains %G_BINDING_BIDIRECTIONAL then the binding will be mutual:
             * if `target_property` on `target` changes then the `source_property` on `source`
             * will be updated as well. The `transform_from` function is only used in case
             * of bidirectional bindings, otherwise it will be ignored
             *
             * The binding will automatically be removed when either the `source` or the
             * `target` instances are finalized. This will release the reference that is
             * being held on the #GBinding instance; if you want to hold on to the
             * #GBinding instance, you will need to hold a reference to it.
             *
             * To remove the binding, call g_binding_unbind().
             *
             * A #GObject can have multiple bindings.
             *
             * The same `user_data` parameter will be used for both `transform_to`
             * and `transform_from` transformation functions; the `notify` function will
             * be called once, when the binding is removed. If you need different data
             * for each transformation function, please use
             * g_object_bind_property_with_closures() instead.
             * @param source_property the property on @source to bind
             * @param target the target #GObject
             * @param target_property the property on @target to bind
             * @param flags flags to pass to #GBinding
             * @param transform_to the transformation function     from the @source to the @target, or %NULL to use the default
             * @param transform_from the transformation function     from the @target to the @source, or %NULL to use the default
             * @param notify a function to call when disposing the binding, to free     resources used by the transformation functions, or %NULL if not required
             * @returns the #GBinding instance representing the     binding between the two #GObject instances. The binding is released     whenever the #GBinding reference count reaches zero.
             */
            bind_property_full(
                source_property: string,
                target: GObject.Object,
                target_property: string,
                flags: GObject.BindingFlags | null,
                transform_to?: GObject.BindingTransformFunc | null,
                transform_from?: GObject.BindingTransformFunc | null,
                notify?: GLib.DestroyNotify | null,
            ): GObject.Binding;
            // Conflicted with GObject.Object.bind_property_full
            bind_property_full(...args: never[]): any;
            /**
             * This function is intended for #GObject implementations to re-enforce
             * a [floating][floating-ref] object reference. Doing this is seldom
             * required: all #GInitiallyUnowneds are created with a floating reference
             * which usually just needs to be sunken by calling g_object_ref_sink().
             */
            force_floating(): void;
            /**
             * Increases the freeze count on `object`. If the freeze count is
             * non-zero, the emission of "notify" signals on `object` is
             * stopped. The signals are queued until the freeze count is decreased
             * to zero. Duplicate notifications are squashed so that at most one
             * #GObject::notify signal is emitted for each property modified while the
             * object is frozen.
             *
             * This is necessary for accessors that modify multiple properties to prevent
             * premature notification while the object is still being modified.
             */
            freeze_notify(): void;
            /**
             * Gets a named field from the objects table of associations (see g_object_set_data()).
             * @param key name of the key for that association
             * @returns the data if found,          or %NULL if no such data exists.
             */
            get_data(key: string): any | null;
            /**
             * Gets a property of an object.
             *
             * The value can be:
             * - an empty GObject.Value initialized by G_VALUE_INIT, which will be automatically initialized with the expected type of the property (since GLib 2.60)
             * - a GObject.Value initialized with the expected type of the property
             * - a GObject.Value initialized with a type to which the expected type of the property can be transformed
             *
             * In general, a copy is made of the property contents and the caller is responsible for freeing the memory by calling GObject.Value.unset.
             *
             * Note that GObject.Object.get_property is really intended for language bindings, GObject.Object.get is much more convenient for C programming.
             * @param property_name The name of the property to get
             * @param value Return location for the property value. Can be an empty GObject.Value initialized by G_VALUE_INIT (auto-initialized with expected type since GLib 2.60), a GObject.Value initialized with the expected property type, or a GObject.Value initialized with a transformable type
             */
            get_property(property_name: string, value: GObject.Value | any): any;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            get_qdata(quark: GLib.Quark): any | null;
            /**
             * Gets `n_properties` properties for an `object`.
             * Obtained properties will be set to `values`. All properties must be valid.
             * Warnings will be emitted and undefined behaviour may result if invalid
             * properties are passed in.
             * @param names the names of each property to get
             * @param values the values of each property to get
             */
            getv(names: string[], values: (GObject.Value | any)[]): void;
            /**
             * Checks whether `object` has a [floating][floating-ref] reference.
             * @returns %TRUE if @object has a floating reference
             */
            is_floating(): boolean;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param property_name the name of a property installed on the class of @object.
             */
            notify(property_name: string): void;
            /**
             * Emits a "notify" signal for the property specified by `pspec` on `object`.
             *
             * This function omits the property name lookup, hence it is faster than
             * g_object_notify().
             *
             * One way to avoid using g_object_notify() from within the
             * class that registered the properties, and using g_object_notify_by_pspec()
             * instead, is to store the GParamSpec used with
             * g_object_class_install_property() inside a static array, e.g.:
             *
             *
             * ```c
             *   typedef enum
             *   {
             *     PROP_FOO = 1,
             *     PROP_LAST
             *   } MyObjectProperty;
             *
             *   static GParamSpec *properties[PROP_LAST];
             *
             *   static void
             *   my_object_class_init (MyObjectClass *klass)
             *   {
             *     properties[PROP_FOO] = g_param_spec_int ("foo", NULL, NULL,
             *                                              0, 100,
             *                                              50,
             *                                              G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS);
             *     g_object_class_install_property (gobject_class,
             *                                      PROP_FOO,
             *                                      properties[PROP_FOO]);
             *   }
             * ```
             *
             *
             * and then notify a change on the "foo" property with:
             *
             *
             * ```c
             *   g_object_notify_by_pspec (self, properties[PROP_FOO]);
             * ```
             *
             * @param pspec the #GParamSpec of a property installed on the class of @object.
             */
            notify_by_pspec(pspec: GObject.ParamSpec): void;
            /**
             * Increases the reference count of `object`.
             *
             * Since GLib 2.56, if `GLIB_VERSION_MAX_ALLOWED` is 2.56 or greater, the type
             * of `object` will be propagated to the return type (using the GCC typeof()
             * extension), so any casting the caller needs to do on the return type must be
             * explicit.
             * @returns the same @object
             */
            ref(): GObject.Object;
            /**
             * Increase the reference count of `object,` and possibly remove the
             * [floating][floating-ref] reference, if `object` has a floating reference.
             *
             * In other words, if the object is floating, then this call "assumes
             * ownership" of the floating reference, converting it to a normal
             * reference by clearing the floating flag while leaving the reference
             * count unchanged.  If the object is not floating, then this call
             * adds a new normal reference increasing the reference count by one.
             *
             * Since GLib 2.56, the type of `object` will be propagated to the return type
             * under the same conditions as for g_object_ref().
             * @returns @object
             */
            ref_sink(): GObject.Object;
            /**
             * Releases all references to other objects. This can be used to break
             * reference cycles.
             *
             * This function should only be called from object system implementations.
             */
            run_dispose(): void;
            /**
             * Each object carries around a table of associations from
             * strings to pointers.  This function lets you set an association.
             *
             * If the object already had an association with that name,
             * the old association will be destroyed.
             *
             * Internally, the `key` is converted to a #GQuark using g_quark_from_string().
             * This means a copy of `key` is kept permanently (even after `object` has been
             * finalized) — so it is recommended to only use a small, bounded set of values
             * for `key` in your program, to avoid the #GQuark storage growing unbounded.
             * @param key name of the key
             * @param data data to associate with that key
             */
            set_data(key: string, data?: any | null): void;
            /**
             * Sets a property on an object.
             * @param property_name The name of the property to set
             * @param value The value to set the property to
             */
            set_property(property_name: string, value: GObject.Value | any): void;
            /**
             * Remove a specified datum from the object's data associations,
             * without invoking the association's destroy handler.
             * @param key name of the key
             * @returns the data if found, or %NULL          if no such data exists.
             */
            steal_data(key: string): any | null;
            /**
             * This function gets back user data pointers stored via
             * g_object_set_qdata() and removes the `data` from object
             * without invoking its destroy() function (if any was
             * set).
             * Usually, calling this function is only required to update
             * user data pointers with a destroy notifier, for example:
             *
             * ```c
             * void
             * object_add_to_user_list (GObject     *object,
             *                          const gchar *new_string)
             * {
             *   // the quark, naming the object data
             *   GQuark quark_string_list = g_quark_from_static_string ("my-string-list");
             *   // retrieve the old string list
             *   GList *list = g_object_steal_qdata (object, quark_string_list);
             *
             *   // prepend new string
             *   list = g_list_prepend (list, g_strdup (new_string));
             *   // this changed 'list', so we need to set it again
             *   g_object_set_qdata_full (object, quark_string_list, list, free_string_list);
             * }
             * static void
             * free_string_list (gpointer data)
             * {
             *   GList *node, *list = data;
             *
             *   for (node = list; node; node = node->next)
             *     g_free (node->data);
             *   g_list_free (list);
             * }
             * ```
             *
             * Using g_object_get_qdata() in the above example, instead of
             * g_object_steal_qdata() would have left the destroy function set,
             * and thus the partial string list would have been freed upon
             * g_object_set_qdata_full().
             * @param quark A #GQuark, naming the user data pointer
             * @returns The user data pointer set, or %NULL
             */
            steal_qdata(quark: GLib.Quark): any | null;
            /**
             * Reverts the effect of a previous call to
             * g_object_freeze_notify(). The freeze count is decreased on `object`
             * and when it reaches zero, queued "notify" signals are emitted.
             *
             * Duplicate notifications for each property are squashed so that at most one
             * #GObject::notify signal is emitted for each property, in the reverse order
             * in which they have been queued.
             *
             * It is an error to call this function when the freeze count is zero.
             */
            thaw_notify(): void;
            /**
             * Decreases the reference count of `object`. When its reference count
             * drops to 0, the object is finalized (i.e. its memory is freed).
             *
             * If the pointer to the #GObject may be reused in future (for example, if it is
             * an instance variable of another object), it is recommended to clear the
             * pointer to %NULL rather than retain a dangling pointer to a potentially
             * invalid #GObject instance. Use g_clear_object() for this.
             */
            unref(): void;
            /**
             * This function essentially limits the life time of the `closure` to
             * the life time of the object. That is, when the object is finalized,
             * the `closure` is invalidated by calling g_closure_invalidate() on
             * it, in order to prevent invocations of the closure with a finalized
             * (nonexisting) object. Also, g_object_ref() and g_object_unref() are
             * added as marshal guards to the `closure,` to ensure that an extra
             * reference count is held on `object` during invocation of the
             * `closure`.  Usually, this function will be called on closures that
             * use this `object` as closure data.
             * @param closure #GClosure to watch
             */
            watch_closure(closure: GObject.Closure): void;
            /**
             * the `constructed` function is called by g_object_new() as the
             *  final step of the object creation process.  At the point of the call, all
             *  construction properties have been set on the object.  The purpose of this
             *  call is to allow for object initialisation steps that can only be performed
             *  after construction properties have been set.  `constructed` implementors
             *  should chain up to the `constructed` call of their parent class to allow it
             *  to complete its initialisation.
             */
            vfunc_constructed(): void;
            /**
             * emits property change notification for a bunch
             *  of properties. Overriding `dispatch_properties_changed` should be rarely
             *  needed.
             * @param n_pspecs
             * @param pspecs
             */
            vfunc_dispatch_properties_changed(n_pspecs: number, pspecs: GObject.ParamSpec): void;
            /**
             * the `dispose` function is supposed to drop all references to other
             *  objects, but keep the instance otherwise intact, so that client method
             *  invocations still work. It may be run multiple times (due to reference
             *  loops). Before returning, `dispose` should chain up to the `dispose` method
             *  of the parent class.
             */
            vfunc_dispose(): void;
            /**
             * instance finalization function, should finish the finalization of
             *  the instance begun in `dispose` and chain up to the `finalize` method of the
             *  parent class.
             */
            vfunc_finalize(): void;
            /**
             * the generic getter for all properties of this type. Should be
             *  overridden for every type with properties.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_get_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Emits a "notify" signal for the property `property_name` on `object`.
             *
             * When possible, eg. when signaling a property change from within the class
             * that registered the property, you should use g_object_notify_by_pspec()
             * instead.
             *
             * Note that emission of the notify signal may be blocked with
             * g_object_freeze_notify(). In this case, the signal emissions are queued
             * and will be emitted (in reverse order) when g_object_thaw_notify() is
             * called.
             * @param pspec
             */
            vfunc_notify(pspec: GObject.ParamSpec): void;
            /**
             * the generic setter for all properties of this type. Should be
             *  overridden for every type with properties. If implementations of
             *  `set_property` don't emit property change notification explicitly, this will
             *  be done implicitly by the type system. However, if the notify signal is
             *  emitted explicitly, the type system will not emit it a second time.
             * @param property_id
             * @param value
             * @param pspec
             */
            vfunc_set_property(property_id: number, value: GObject.Value | any, pspec: GObject.ParamSpec): void;
            /**
             * Disconnects a handler from an instance so it will not be called during any future or currently ongoing emissions of the signal it has been connected to.
             * @param id Handler ID of the handler to be disconnected
             */
            disconnect(id: number): void;
            /**
             * Sets multiple properties of an object at once. The properties argument should be a dictionary mapping property names to values.
             * @param properties Object containing the properties to set
             */
            set(properties: { [key: string]: any }): void;
            /**
             * Blocks a handler of an instance so it will not be called during any signal emissions
             * @param id Handler ID of the handler to be blocked
             */
            block_signal_handler(id: number): void;
            /**
             * Unblocks a handler so it will be called again during any signal emissions
             * @param id Handler ID of the handler to be unblocked
             */
            unblock_signal_handler(id: number): void;
            /**
             * Stops a signal's emission by the given signal name. This will prevent the default handler and any subsequent signal handlers from being invoked.
             * @param detailedName Name of the signal to stop emission of
             */
            stop_emission_by_name(detailedName: string): void;
            /**
             * Enables or disables an action installed with
             * [method`Gtk`.WidgetClass.install_action].
             * @param action_name action name, such as "clipboard.paste"
             * @param enabled whether the action is now enabled
             */
            action_set_enabled(action_name: string, enabled: boolean): void;
            /**
             * Activates the widget.
             *
             * The activation will emit the signal set using
             * [method`Gtk`.WidgetClass.set_activate_signal]
             * during class initialization.
             *
             * Activation is what happens when you press <kbd>Enter</kbd>
             * on a widget.
             *
             * If you wish to handle the activation keybinding yourself,
             * it is recommended to use [method`Gtk`.WidgetClass.add_shortcut]
             * with an action created with [ctor`Gtk`.SignalAction.new].
             *
             * If `widget` is not activatable, the function returns false.
             * @returns true if the widget was activated
             */
            activate(): boolean;
            /**
             * Activates an action for the widget.
             *
             * The action is looked up in the action groups associated with
             * `widget` and its ancestors.
             *
             * If the action is in an action group added with
             * [method`Gtk`.Widget.insert_action_group], the `name` is expected
             * to be prefixed with the prefix that was used when the group was
             * inserted.
             *
             * The arguments must match the actions expected parameter type,
             * as returned by [method`Gio`.Action.get_parameter_type].
             * @param name the name of the action to activate
             * @param args parameters to use
             * @returns true if the action was activated
             */
            activate_action(name: string, args?: GLib.Variant | null): boolean;
            /**
             * Activates the `default.activate` action for the widget.
             *
             * The action is looked up in the same was as for
             * [method`Gtk`.Widget.activate_action].
             */
            activate_default(): void;
            /**
             * Adds an event controller to the widget.
             *
             * The event controllers of a widget handle the events that are
             * propagated to the widget.
             *
             * You will usually want to call this function right after
             * creating any kind of [class`Gtk`.EventController].
             * @param controller an event controller that hasn't been   added to a widget yet
             */
            add_controller(controller: EventController): void;
            /**
             * Adds a style class to the widget.
             *
             * After calling this function, the widget’s style will match
             * for `css_class,` according to CSS matching rules.
             *
             * Use [method`Gtk`.Widget.remove_css_class] to remove the
             * style again.
             * @param css_class style class to add to @widget, without the leading period
             */
            add_css_class(css_class: string): void;
            /**
             * Adds a widget to the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * Note that the list of mnemonic labels for the widget is cleared
             * when the widget is destroyed, so the caller must make sure
             * to update its internal state at this point as well.
             * @param label a widget that acts as a mnemonic label for @widget
             */
            add_mnemonic_label(label: Widget): void;
            /**
             * Queues an animation frame update and adds a callback to be called
             * before each frame.
             *
             * Until the tick callback is removed, it will be called frequently
             * (usually at the frame rate of the output device or as quickly as
             * the application can be repainted, whichever is slower). For this
             * reason, is most suitable for handling graphics that change every
             * frame or every few frames.
             *
             * The tick callback does not automatically imply a relayout or repaint.
             * If you want a repaint or relayout, and aren’t changing widget properties
             * that would trigger that (for example, changing the text of a label),
             * then you will have to call [method`Gtk`.Widget.queue_resize] or
             * [method`Gtk`.Widget.queue_draw] yourself.
             *
             * [method`Gdk`.FrameClock.get_frame_time] should generally be used
             * for timing continuous animations and
             * [method`Gdk`.FrameTimings.get_predicted_presentation_time] should be
             * used if you are trying to display isolated frames at particular times.
             *
             * This is a more convenient alternative to connecting directly to the
             * [signal`Gdk`.FrameClock::update] signal of the frame clock, since you
             * don't have to worry about when a frame clock is assigned to a widget.
             *
             * To remove a tick callback, pass the ID that is returned by this function
             * to [method`Gtk`.Widget.remove_tick_callback].
             * @param callback function   to call for updating animations
             * @returns an ID for this callback
             */
            add_tick_callback(callback: TickCallback): number;
            /**
             * Assigns size, position, (optionally) a baseline and transform
             * to a child widget.
             *
             * In this function, the allocation and baseline may be adjusted.
             * The given allocation will be forced to be bigger than the
             * widget's minimum size, as well as at least 0×0 in size.
             *
             * This function is only used by widget implementations.
             *
             * For a version that does not take a transform, see
             * [method`Gtk`.Widget.size_allocate].
             * @param width new width
             * @param height new height
             * @param baseline new baseline, or -1
             * @param transform transformation to be applied
             */
            allocate(width: number, height: number, baseline: number, transform?: Gsk.Transform | null): void;
            /**
             * Called by widgets as the user moves around the window using
             * keyboard shortcuts.
             *
             * The `direction` argument indicates what kind of motion is taking
             * place (up, down, left, right, tab forward, tab backward).
             *
             * This function calls the [vfunc`Gtk`.Widget.focus] virtual function;
             * widgets can override the virtual function in order to implement
             * appropriate focus behavior.
             *
             * The default `focus()` virtual function for a widget should return
             * true if moving in `direction` left the focus on a focusable location
             * inside that widget, and false if moving in `direction` moved the focus
             * outside the widget. When returning true, widgets normally call
             * [method`Gtk`.Widget.grab_focus] to place the focus accordingly;
             * when returning false, they don’t modify the current focus location.
             *
             * This function is used by custom widget implementations; if you're
             * writing an app, you’d use [method`Gtk`.Widget.grab_focus] to move
             * the focus to a particular widget.
             * @param direction direction of focus movement
             * @returns true if focus ended up inside @widget
             */
            child_focus(direction: DirectionType | null): boolean;
            /**
             * Computes the bounds for `widget` in the coordinate space of `target`.
             *
             * The bounds of widget are (the bounding box of) the region that it is
             * expected to draw in. See the [coordinate system](coordinates.html)
             * overview to learn more.
             *
             * If the operation is successful, true is returned. If `widget` has no
             * bounds or the bounds cannot be expressed in `target'`s coordinate space
             * (for example if both widgets are in different windows), false is
             * returned and `bounds` is set to the zero rectangle.
             *
             * It is valid for `widget` and `target` to be the same widget.
             * @param target the target widget
             * @returns true if the bounds could be computed
             */
            compute_bounds(target: Widget): [boolean, Graphene.Rect];
            /**
             * Computes whether a parent widget should give this widget
             * extra space when possible.
             *
             * Widgets with children should check this, rather than looking at
             * [method`Gtk`.Widget.get_hexpand] or [method`Gtk`.Widget.get_vexpand].
             *
             * This function already checks whether the widget is visible, so
             * visibility does not need to be checked separately. Non-visible
             * widgets are not expanded.
             *
             * The computed expand value uses either the expand setting explicitly
             * set on the widget itself, or, if none has been explicitly set,
             * the widget may expand if some of its children do.
             * @param orientation expand direction
             * @returns whether widget tree rooted here should be expanded
             */
            compute_expand(orientation: Orientation | null): boolean;
            /**
             * Translates the given `point` in `widget'`s coordinates to coordinates
             * in `target’`s coordinate system.
             *
             * In order to perform this operation, both widgets must share a
             * a common ancestor. If that is not the case, `out_point` is set
             * to (0, 0) and false is returned.
             * @param target the widget to transform into
             * @param point a point in @widget's coordinate system
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            compute_point(target: Widget, point: Graphene.Point): [boolean, Graphene.Point];
            /**
             * Computes a matrix suitable to describe a transformation from
             * `widget'`s coordinate system into `target'`s coordinate system.
             *
             * The transform can not be computed in certain cases, for example
             * when `widget` and `target` do not share a common ancestor. In that
             * case `out_transform` gets set to the identity matrix.
             *
             * To learn more about widget coordinate systems, see the coordinate
             * system [overview](coordinates.html).
             * @param target the target widget that the matrix will transform to
             * @returns true if the transform could be computed
             */
            compute_transform(target: Widget): [boolean, Graphene.Matrix];
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             * @returns true if @widget contains the point (x, y)
             */
            contains(x: number, y: number): boolean;
            /**
             * Creates a new `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map,
             * font options, font description, and base direction set.
             *
             * See also [method`Gtk`.Widget.get_pango_context].
             * @returns the new `PangoContext`
             */
            create_pango_context(): Pango.Context;
            /**
             * Creates a new `PangoLayout` that is configured for the widget.
             *
             * The `PangoLayout` will have the appropriate font map,
             * font description, and base direction set.
             *
             * If you keep a `PangoLayout` created in this way around,
             * you need to re-create it when the widgets `PangoContext`
             * is replaced. This can be tracked by listening to changes
             * of the [property`Gtk`.Widget:root] property on the widget.
             * @param text text to set on the layout
             * @returns the new `PangoLayout`
             */
            create_pango_layout(text?: string | null): Pango.Layout;
            /**
             * Clears the template children for the widget.
             *
             * This function is the opposite of [method`Gtk`.Widget.init_template],
             * and it is used to clear all the template children from a widget
             * instance. If you bound a template child to a field in the instance
             * structure, or in the instance private data structure, the field will
             * be set to `NULL` after this function returns.
             *
             * You should call this function inside the `GObjectClass.dispose()`
             * implementation of any widget that called [method`Gtk`.Widget.init_template].
             * Typically, you will want to call this function last, right before
             * chaining up to the parent type's dispose implementation, e.g.
             *
             * ```c
             * static void
             * some_widget_dispose (GObject *gobject)
             * {
             *   SomeWidget *self = SOME_WIDGET (gobject);
             *
             *   // Clear the template data for SomeWidget
             *   gtk_widget_dispose_template (GTK_WIDGET (self), SOME_TYPE_WIDGET);
             *
             *   G_OBJECT_CLASS (some_widget_parent_class)->dispose (gobject);
             * }
             * ```
             * @param widget_type the type of the widget to finalize the template for
             */
            dispose_template(widget_type: GObject.GType): void;
            /**
             * Checks to see if a drag movement has passed the GTK drag threshold.
             * @param start_x X coordinate of start of drag
             * @param start_y Y coordinate of start of drag
             * @param current_x current X coordinate
             * @param current_y current Y coordinate
             * @returns true if the drag threshold has been passed
             */
            drag_check_threshold(start_x: number, start_y: number, current_x: number, current_y: number): boolean;
            /**
             * Notifies the user about an input-related error on the widget.
             *
             * If the [property`Gtk`.Settings:gtk-error-bell] setting is true,
             * it calls [method`Gdk`.Surface.beep], otherwise it does nothing.
             *
             * Note that the effect of [method`Gdk`.Surface.beep] can be configured
             * in many ways, depending on the windowing backend and the desktop
             * environment or window manager that is used.
             */
            error_bell(): void;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidget`Class.snapshot() function, and when allocating
             * child widgets in `GtkWidget`Class.size_allocate().
             * @returns the baseline of the @widget, or -1 if none
             */
            get_allocated_baseline(): number;
            /**
             * Returns the height that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the height of the @widget
             */
            get_allocated_height(): number;
            /**
             * Returns the width that has currently been allocated to the widget.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns the width of the @widget
             */
            get_allocated_width(): number;
            /**
             * Retrieves the widget’s allocation.
             *
             * Note, when implementing a layout widget: a widget’s allocation
             * will be its “adjusted” allocation, that is, the widget’s parent
             * typically calls [method`Gtk`.Widget.size_allocate] with an allocation,
             * and that allocation is then adjusted (to handle margin
             * and alignment for example) before assignment to the widget.
             * [method`Gtk`.Widget.get_allocation] returns the adjusted allocation that
             * was actually assigned to the widget. The adjusted allocation is
             * guaranteed to be completely contained within the
             * [method`Gtk`.Widget.size_allocate] allocation, however.
             *
             * So a layout widget is guaranteed that its children stay inside
             * the assigned bounds, but not that they have exactly the bounds the
             * widget assigned.
             */
            get_allocation(): Allocation;
            /**
             * Gets the first ancestor of the widget with type `widget_type`.
             *
             * For example, `gtk_widget_get_ancestor (widget, GTK_TYPE_BOX)`
             * gets the first `GtkBox` that’s an ancestor of `widget`. No
             * reference will be added to the returned widget; it should
             * not be unreferenced.
             *
             * Note that unlike [method`Gtk`.Widget.is_ancestor], this function
             * considers `widget` to be an ancestor of itself.
             * @param widget_type ancestor type
             * @returns the ancestor widget
             */
            get_ancestor(widget_type: GObject.GType): Widget | null;
            /**
             * Returns the baseline that has currently been allocated to the widget.
             *
             * This function is intended to be used when implementing handlers
             * for the `GtkWidgetClass.snapshot()` function, and when allocating
             * child widgets in `GtkWidgetClass.size_allocate()`.
             * @returns the baseline of the @widget, or -1 if none
             */
            get_baseline(): number;
            /**
             * Determines whether the input focus can enter the widget or any
             * of its children.
             *
             * See [method`Gtk`.Widget.set_can_focus].
             * @returns true if the input focus can enter @widget
             */
            get_can_focus(): boolean;
            /**
             * Queries whether the widget can be the target of pointer events.
             * @returns true if @widget can receive pointer events
             */
            get_can_target(): boolean;
            /**
             * Gets the value set with [method`Gtk`.Widget.set_child_visible].
             *
             * If you feel a need to use this function, your code probably
             * needs reorganization.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @returns true if the widget is mapped with the parent
             */
            get_child_visible(): boolean;
            /**
             * Gets the clipboard object for the widget.
             *
             * This is a utility function to get the clipboard object for the
             * display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_clipboard(): Gdk.Clipboard;
            /**
             * Gets the current foreground color for the widget’s style.
             *
             * This function should only be used in snapshot
             * implementations that need to do custom drawing
             * with the foreground color.
             */
            get_color(): Gdk.RGBA;
            /**
             * Returns the list of style classes applied to the widget.
             * @returns a `NULL`-terminated list of   css classes currently applied to @widget
             */
            get_css_classes(): string[];
            /**
             * Returns the CSS name of the widget.
             * @returns the CSS name
             */
            get_css_name(): string;
            /**
             * Gets the cursor set on the widget.
             *
             * See [method`Gtk`.Widget.set_cursor] for details.
             * @returns the cursor   that is set on @widget
             */
            get_cursor(): Gdk.Cursor | null;
            /**
             * Gets the reading direction for the widget.
             *
             * See [method`Gtk`.Widget.set_direction].
             * @returns the reading direction for the widget
             */
            get_direction(): TextDirection;
            /**
             * Get the display for the window that the widget belongs to.
             *
             * This function can only be called after the widget has been
             * added to a widget hierarchy with a `GtkRoot` at the top.
             *
             * In general, you should only create display-specific
             * resources when a widget has been realized, and you should
             * free those resources when the widget is unrealized.
             * @returns the display for this widget
             */
            get_display(): Gdk.Display;
            /**
             * Returns the widget’s first child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's first child
             */
            get_first_child(): Widget | null;
            /**
             * Returns the focus child of the widget.
             * @returns the current focus   child of @widget
             */
            get_focus_child(): Widget | null;
            /**
             * Returns whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * See [method`Gtk`.Widget.set_focus_on_click].
             * @returns true if the widget should grab focus when it is   clicked with the mouse
             */
            get_focus_on_click(): boolean;
            /**
             * Determines whether the widget can own the input focus.
             *
             * See [method`Gtk`.Widget.set_focusable].
             * @returns true if @widget can own the input focus
             */
            get_focusable(): boolean;
            /**
             * Gets the font map of the widget.
             *
             * See [method`Gtk`.Widget.set_font_map].
             * @returns the font map of @widget
             */
            get_font_map(): Pango.FontMap | null;
            /**
             * Returns the `cairo_font_options_t` of the widget.
             *
             * Seee [method`Gtk`.Widget.set_font_options].
             * @returns the `cairo_font_options_t` of widget
             */
            get_font_options(): cairo.FontOptions | null;
            /**
             * Obtains the frame clock for a widget.
             *
             * The frame clock is a global “ticker” that can be used to drive
             * animations and repaints. The most common reason to get the frame
             * clock is to call [method`Gdk`.FrameClock.get_frame_time], in order
             * to get a time to use for animating. For example you might record
             * the start of the animation with an initial value from
             * [method`Gdk`.FrameClock.get_frame_time], and then update the animation
             * by calling [method`Gdk`.FrameClock.get_frame_time] again during each repaint.
             *
             * [method`Gdk`.FrameClock.request_phase] will result in a new frame on the
             * clock, but won’t necessarily repaint any widgets. To repaint a widget,
             * you have to use [method`Gtk`.Widget.queue_draw] which invalidates the
             * widget (thus scheduling it to receive a draw on the next frame).
             * [method`Gtk`.Widget.queue_draw] will also end up requesting a frame
             * on the appropriate frame clock.
             *
             * A widget’s frame clock will not change while the widget is mapped.
             * Reparenting a widget (which implies a temporary unmap) can change
             * the widget’s frame clock.
             *
             * Unrealized widgets do not have a frame clock.
             * @returns the frame clock
             */
            get_frame_clock(): Gdk.FrameClock | null;
            /**
             * Gets the horizontal alignment of the widget.
             *
             * For backwards compatibility reasons this method will never return
             * one of the baseline alignments, but instead it will convert it to
             * [enum`Gtk`.Align.fill] or [enum`Gtk`.Align.center].
             *
             * Baselines are not supported for horizontal alignment.
             * @returns the horizontal alignment of @widget
             */
            get_halign(): Align;
            /**
             * Returns the current value of the `has-tooltip` property.
             * @returns current value of `has-tooltip` on @widget
             */
            get_has_tooltip(): boolean;
            /**
             * Returns the content height of the widget.
             *
             * This function returns the height passed to its
             * size-allocate implementation, which is the height you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The height of @widget
             */
            get_height(): number;
            /**
             * Gets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Widgets with children should use [method`Gtk`.Widget.compute_expand]
             * rather than this function, to see whether any of its children,
             * has the expand flag set. If any child of a widget wants to
             * expand, the parent may ask to expand also.
             *
             * This function only looks at the widget’s own hexpand flag, rather
             * than computing whether the entire widget tree rooted at this widget
             * wants to expand.
             * @returns whether hexpand flag is set
             */
            get_hexpand(): boolean;
            /**
             * Gets whether the `hexpand` flag has been explicitly set.
             *
             * If [property`Gtk`.Widget:hexpand] property is set, then it
             * overrides any computed expand value based on child widgets.
             * If `hexpand` is not set, then the expand value depends on
             * whether any children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @returns whether hexpand has been explicitly set
             */
            get_hexpand_set(): boolean;
            /**
             * Returns the widget’s last child.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's last child
             */
            get_last_child(): Widget | null;
            /**
             * Retrieves the layout manager of the widget.
             *
             * See [method`Gtk`.Widget.set_layout_manager].
             * @returns the layout manager of @widget
             */
            get_layout_manager(): LayoutManager | null;
            /**
             * Gets the value of the [property`Gtk`.Widget:limit-events] property.
             */
            get_limit_events(): boolean;
            /**
             * Returns whether the widget is mapped.
             * @returns true if the widget is mapped
             */
            get_mapped(): boolean;
            /**
             * Gets the bottom margin of the widget.
             * @returns The bottom margin of @widget
             */
            get_margin_bottom(): number;
            /**
             * Gets the end margin of the widget.
             * @returns The end margin of @widget
             */
            get_margin_end(): number;
            /**
             * Gets the start margin of the widget.
             * @returns The start margin of @widget
             */
            get_margin_start(): number;
            /**
             * Gets the top margin of the widget.
             * @returns The top margin of @widget
             */
            get_margin_top(): number;
            /**
             * Retrieves the name of a widget.
             *
             * See [method`Gtk`.Widget.set_name] for the significance of widget names.
             * @returns name of the widget
             */
            get_name(): string;
            /**
             * Returns the nearest `GtkNative` ancestor of the widget.
             *
             * This function will return `NULL` if the widget is not
             * contained inside a widget tree with a native ancestor.
             *
             * `GtkNative` widgets will return themselves here.
             * @returns the `GtkNative` ancestor of @widget
             */
            get_native(): Native | null;
            /**
             * Returns the widget’s next sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's next sibling
             */
            get_next_sibling(): Widget | null;
            /**
             * Fetches the requested opacity for the widget.
             *
             * See [method`Gtk`.Widget.set_opacity].
             * @returns the requested opacity for this widget
             */
            get_opacity(): number;
            /**
             * Returns the widget’s overflow value.
             * @returns The widget's overflow value
             */
            get_overflow(): Overflow;
            /**
             * Gets a `PangoContext` that is configured for the widget.
             *
             * The `PangoContext` will have the appropriate font map, font description,
             * and base direction set.
             *
             * Unlike the context returned by [method`Gtk`.Widget.create_pango_context],
             * this context is owned by the widget (it can be used until the screen
             * for the widget changes or the widget is removed from its toplevel),
             * and will be updated to match any changes to the widget’s attributes.
             * This can be tracked by listening to changes of the
             * [property`Gtk`.Widget:root] property on the widget.
             * @returns the `PangoContext` for the widget
             */
            get_pango_context(): Pango.Context;
            /**
             * Returns the parent widget of the widget.
             * @returns the parent widget of @widget
             */
            get_parent(): Widget | null;
            /**
             * Retrieves the minimum and natural size of a widget, taking
             * into account the widget’s preference for height-for-width management.
             *
             * This is used to retrieve a suitable size by container widgets which do
             * not impose any restrictions on the child placement. It can be used
             * to deduce toplevel window and menu sizes as well as child widgets in
             * free-form containers such as `GtkFixed`.
             *
             * Handle with care. Note that the natural height of a height-for-width
             * widget will generally be a smaller size than the minimum height, since
             * the required height for the natural width is generally smaller than the
             * required height for the minimum width.
             *
             * Use [method`Gtk`.Widget.measure] if you want to support baseline alignment.
             */
            get_preferred_size(): [Requisition | null, Requisition | null];
            /**
             * Returns the widget’s previous sibling.
             *
             * This function is primarily meant for widget implementations.
             * @returns the widget's previous sibling
             */
            get_prev_sibling(): Widget | null;
            /**
             * Gets the primary clipboard of the widget.
             *
             * This is a utility function to get the primary clipboard object
             * for the display that `widget` is using.
             *
             * Note that this function always works, even when `widget` is not
             * realized yet.
             * @returns the appropriate clipboard object
             */
            get_primary_clipboard(): Gdk.Clipboard;
            /**
             * Determines whether the widget is realized.
             * @returns true if @widget is realized
             */
            get_realized(): boolean;
            /**
             * Determines whether the widget is always treated as the default widget
             * within its toplevel when it has the focus, even if another widget
             * is the default.
             *
             * See [method`Gtk`.Widget.set_receives_default].
             * @returns true if @widget acts as the default widget when focused
             */
            get_receives_default(): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             * @returns The `GtkSizeRequestMode` preferred by @widget.
             */
            get_request_mode(): SizeRequestMode;
            /**
             * Returns the `GtkRoot` widget of the widget.
             *
             * This function will return `NULL` if the widget is not contained
             * inside a widget tree with a root widget.
             *
             * `GtkRoot` widgets will return themselves here.
             * @returns the root widget of @widget
             */
            get_root(): Root | null;
            /**
             * Retrieves the internal scale factor that maps from window
             * coordinates to the actual device pixels.
             *
             * On traditional systems this is 1, on high density outputs,
             * it can be a higher value (typically 2).
             *
             * See [method`Gdk`.Surface.get_scale_factor].
             *
             * Note that modern systems may support *fractional* scaling,
             * where the scale factor is not an integer. On such systems,
             * this function will return the next higher integer value,
             * but you probably want to use [method`Gdk`.Surface.get_scale]
             * to get the fractional scale value.
             * @returns the scale factor for @widget
             */
            get_scale_factor(): number;
            /**
             * Returns the widget’s sensitivity.
             *
             * This function returns the value that has been set using
             * [method`Gtk`.Widget.set_sensitive]).
             *
             * The effective sensitivity of a widget is however determined
             * by both its own and its parent widget’s sensitivity.
             * See [method`Gtk`.Widget.is_sensitive].
             * @returns true if the widget is sensitive
             */
            get_sensitive(): boolean;
            /**
             * Gets the settings object holding the settings used for the widget.
             *
             * Note that this function can only be called when the `GtkWidget`
             * is attached to a toplevel, since the settings object is specific
             * to a particular display. If you want to monitor the widget for
             * changes in its settings, connect to the `notify::display` signal.
             * @returns the relevant settings object
             */
            get_settings(): Settings;
            /**
             * Returns the content width or height of the widget.
             *
             * Which dimension is returned depends on `orientation`.
             *
             * This is equivalent to calling [method`Gtk`.Widget.get_width]
             * for [enum`Gtk`.Orientation.horizontal] or [method`Gtk`.Widget.get_height]
             * for [enum`Gtk`.Orientation.vertical], but can be used when
             * writing orientation-independent code, such as when
             * implementing [iface`Gtk`.Orientable] widgets.
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @param orientation the orientation to query
             * @returns the size of @widget in @orientation
             */
            get_size(orientation: Orientation | null): number;
            /**
             * Gets the size request that was explicitly set for the widget.
             *
             * A value of -1 stored in `width` or `height` indicates that that
             * dimension has not been set explicitly and the natural requisition
             * of the widget will be used instead.
             *
             * See [method`Gtk`.Widget.set_size_request].
             *
             * To get the size a widget will actually request, call
             * [method`Gtk`.Widget.measure] instead of this function.
             */
            get_size_request(): [number, number];
            /**
             * Returns the widget state as a flag set.
             *
             * It is worth mentioning that the effective [flags`Gtk`.StateFlags.insensitive]
             * state will be returned, that is, also based on parent insensitivity,
             * even if `widget` itself is sensitive.
             *
             * Also note that if you are looking for a way to obtain the
             * [flags`Gtk`.StateFlags] to pass to a [class`Gtk`.StyleContext]
             * method, you should look at [method`Gtk`.StyleContext.get_state].
             * @returns the state flags of widget
             */
            get_state_flags(): StateFlags;
            /**
             * Returns the style context associated to the widget.
             *
             * The returned object is guaranteed to be the same
             * for the lifetime of `widget`.
             * @returns the widgets style context
             */
            get_style_context(): StyleContext;
            /**
             * Fetches an object build from the template XML for `widget_type` in
             * the widget.
             *
             * This will only report children which were previously declared
             * with [method`Gtk`.WidgetClass.bind_template_child_full] or one of its
             * variants.
             *
             * This function is only meant to be called for code which is private
             * to the `widget_type` which declared the child and is meant for language
             * bindings which cannot easily make use of the GObject structure offsets.
             * @param widget_type The `GType` to get a template child for
             * @param name ID of the child defined in the template XML
             * @returns the object built in the template XML with   the id @name
             */
            get_template_child<T = GObject.Object>(widget_type: GObject.GType, name: string): T;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the tooltip has not been set using
             * [method`Gtk`.Widget.set_tooltip_markup], this
             * function returns `NULL`.
             * @returns the tooltip text
             */
            get_tooltip_markup(): string | null;
            /**
             * Gets the contents of the tooltip for the widget.
             *
             * If the `widget'`s tooltip was set using
             * [method`Gtk`.Widget.set_tooltip_markup],
             * this function will return the escaped text.
             * @returns the tooltip text
             */
            get_tooltip_text(): string | null;
            /**
             * Gets the vertical alignment of the widget.
             * @returns the vertical alignment of @widget
             */
            get_valign(): Align;
            /**
             * Gets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.get_hexpand] for more detail.
             * @returns whether vexpand flag is set
             */
            get_vexpand(): boolean;
            /**
             * Gets whether the `vexpand` flag has been explicitly set.
             *
             * See [method`Gtk`.Widget.get_hexpand_set] for more detail.
             * @returns whether vexpand has been explicitly set
             */
            get_vexpand_set(): boolean;
            /**
             * Determines whether the widget is visible.
             *
             * If you want to take into account whether the widget’s
             * parent is also marked as visible, use
             * [method`Gtk`.Widget.is_visible] instead.
             *
             * This function does not check if the widget is
             * obscured in any way.
             *
             * See [method`Gtk`.Widget.set_visible].
             * @returns true if the widget is visible
             */
            get_visible(): boolean;
            /**
             * Returns the content width of the widget.
             *
             * This function returns the width passed to its
             * size-allocate implementation, which is the width you
             * should be using in [vfunc`Gtk`.Widget.snapshot].
             *
             * For pointer events, see [method`Gtk`.Widget.contains].
             *
             * To learn more about widget sizes, see the coordinate
             * system [overview](coordinates.html).
             * @returns The width of @widget
             */
            get_width(): number;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             * @returns true if focus is now inside @widget
             */
            grab_focus(): boolean;
            /**
             * Returns whether a style class is currently applied to the widget.
             * @param css_class style class, without the leading period
             * @returns true if @css_class is currently applied to @widget
             */
            has_css_class(css_class: string): boolean;
            /**
             * Determines if the widget should show a visible indication that
             * it has the global input focus.
             *
             * This is a convenience function that takes into account whether
             * focus indication should currently be shown in the toplevel window
             * of `widget`. See [method`Gtk`.Window.get_focus_visible] for more
             * information about focus indication.
             *
             * To find out if the widget has the global input focus, use
             * [method`Gtk`.Widget.has_focus].
             * @returns true if the widget should display a “focus rectangle”
             */
            has_visible_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            hide(): void;
            /**
             * Returns whether the widget is currently being destroyed.
             *
             * This information can sometimes be used to avoid doing
             * unnecessary work.
             * @returns true if @widget is being destroyed
             */
            in_destruction(): boolean;
            /**
             * Creates and initializes child widgets defined in templates.
             *
             * This function must be called in the instance initializer
             * for any class which assigned itself a template using
             * [method`Gtk`.WidgetClass.set_template].
             *
             * It is important to call this function in the instance initializer
             * of a widget subclass and not in `GObject.constructed()` or
             * `GObject.constructor()` for two reasons:
             *
             *  - derived widgets will assume that the composite widgets
             *    defined by its parent classes have been created in their
             *    relative instance initializers
             *  - when calling `g_object_new()` on a widget with composite templates,
             *    it’s important to build the composite widgets before the construct
             *    properties are set. Properties passed to `g_object_new()` should
             *    take precedence over properties set in the private template XML
             *
             * A good rule of thumb is to call this function as the first thing in
             * an instance initialization function.
             */
            init_template(): void;
            /**
             * Inserts an action group into the widget's actions.
             *
             * Children of `widget` that implement [iface`Gtk`.Actionable] can
             * then be associated with actions in `group` by setting their
             * “action-name” to `prefix`.`action-name`.
             *
             * Note that inheritance is defined for individual actions. I.e.
             * even if you insert a group with prefix `prefix,` actions with
             * the same prefix will still be inherited from the parent, unless
             * the group contains an action with the same name.
             *
             * If `group` is `NULL`, a previously inserted group for `name` is
             * removed from `widget`.
             * @param name the prefix for actions in @group
             * @param group an action group
             */
            insert_action_group(name: string, group?: Gio.ActionGroup | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed after `previous_sibling,` or at the beginning if
             * `previous_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_prev_sibling (widget)`
             * will return `previous_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this
             * function can also be used to reorder `widget` in the child widget
             * list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param previous_sibling the new previous sibling of @widget
             */
            insert_after(parent: Widget, previous_sibling?: Widget | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * In contrast to [method`Gtk`.Widget.set_parent], this function
             * inserts `widget` at a specific position into the list of children
             * of the `parent` widget.
             *
             * It will be placed before `next_sibling,` or at the end if
             * `next_sibling` is `NULL`.
             *
             * After calling this function, `gtk_widget_get_next_sibling (widget)`
             * will return `next_sibling`.
             *
             * If `parent` is already set as the parent widget of `widget,` this function
             * can also be used to reorder `widget` in the child widget list of `parent`.
             *
             * This function is primarily meant for widget implementations; if you are
             * just using a widget, you *must* use its own API for adding children.
             * @param parent the parent widget to insert @widget into
             * @param next_sibling the new next sibling of @widget
             */
            insert_before(parent: Widget, next_sibling?: Widget | null): void;
            /**
             * Determines whether the widget is a descendent of `ancestor`.
             * @param ancestor another `GtkWidget`
             * @returns true if @ancestor contains @widget as a child,   grandchild, great grandchild, etc
             */
            is_ancestor(ancestor: Widget): boolean;
            /**
             * Determines whether the widget can be drawn to.
             *
             * A widget can be drawn if it is mapped and visible.
             * @returns true if @widget is drawable
             */
            is_drawable(): boolean;
            /**
             * Determines if the widget is the focus widget within its
             * toplevel.
             *
             * This does not mean that the [property`Gtk`.Widget:has-focus]
             * property is necessarily set; [property`Gtk`.Widget:has-focus]
             * will only be set if the toplevel widget additionally has the
             * global input focus.
             * @returns true if the widget is the focus widget
             */
            is_focus(): boolean;
            /**
             * Returns the widget’s effective sensitivity.
             *
             * This means it is sensitive itself and also its
             * parent widget is sensitive.
             * @returns true if the widget is effectively sensitive
             */
            is_sensitive(): boolean;
            /**
             * Determines whether the widget and all its parents are marked as
             * visible.
             *
             * This function does not check if the widget is obscured in any way.
             *
             * See also [method`Gtk`.Widget.get_visible] and
             * [method`Gtk`.Widget.set_visible].
             * @returns true if the widget and all its parents are visible
             */
            is_visible(): boolean;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             * @returns true if stopping keyboard navigation is fine, false   if the emitting widget should try to handle the keyboard   navigation attempt in its parent widget
             */
            keynav_failed(direction: DirectionType | null): boolean;
            /**
             * Returns the widgets for which this widget is the target of a
             * mnemonic.
             *
             * Typically, these widgets will be labels. See, for example,
             * [method`Gtk`.Label.set_mnemonic_widget].
             *
             * The widgets in the list are not individually referenced.
             * If you want to iterate through the list and perform actions
             * involving callbacks that might destroy the widgets, you
             * must call `g_list_foreach (result, (GFunc)g_object_ref, NULL)`
             * first, and then unref all the widgets afterwards.
             * @returns the list   of mnemonic labels
             */
            list_mnemonic_labels(): Widget[];
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            measure(orientation: Orientation | null, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             * @returns true if the signal has been handled
             */
            mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Returns a list model to track the children of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track children and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's children
             */
            observe_children(): Gio.ListModel;
            /**
             * Returns a list model to track the event controllers of the widget.
             *
             * Calling this function will enable extra internal bookkeeping
             * to track controllers and emit signals on the returned listmodel.
             * It may slow down operations a lot.
             *
             * Applications should try hard to avoid calling this function
             * because of the slowdowns.
             * @returns a list model tracking @widget's controllers
             */
            observe_controllers(): Gio.ListModel;
            /**
             * Finds the descendant of the widget closest to a point.
             *
             * The point (x, y) must be given in widget coordinates, so (0, 0)
             * is assumed to be the top left of `widget'`s content area.
             *
             * Usually widgets will return `NULL` if the given coordinate is not
             * contained in `widget` checked via [method`Gtk`.Widget.contains].
             * Otherwise they will recursively try to find a child that does
             * not return `NULL`. Widgets are however free to customize their
             * picking algorithm.
             *
             * This function is used on the toplevel to determine the widget
             * below the mouse cursor for purposes of hover highlighting and
             * delivering events.
             * @param x x coordinate to test, relative to @widget's origin
             * @param y y coordinate to test, relative to @widget's origin
             * @param flags flags to influence what is picked
             * @returns the widget's descendant at (x, y)
             */
            pick(x: number, y: number, flags: PickFlags | null): Widget | null;
            /**
             * Flags the widget for a rerun of the [vfunc`Gtk`.Widget.size_allocate]
             * function.
             *
             * Use this function instead of [method`Gtk`.Widget.queue_resize]
             * when the `widget'`s size request didn't change but it wants to
             * reposition its contents.
             *
             * An example user of this function is [method`Gtk`.Widget.set_halign].
             *
             * This function is only for use in widget implementations.
             */
            queue_allocate(): void;
            /**
             * Schedules this widget to be redrawn.
             *
             * The redraw will happen in the paint phase
             * of the current or the next frame.
             *
             * This means `widget'`s [vfunc`Gtk`.Widget.snapshot]
             * implementation will be called.
             */
            queue_draw(): void;
            /**
             * Flags a widget to have its size renegotiated.
             *
             * This should be called when a widget for some reason has a new
             * size request. For example, when you change the text in a
             * [class`Gtk`.Label], the label queues a resize to ensure there’s
             * enough space for the new text.
             *
             * Note that you cannot call gtk_widget_queue_resize() on a widget
             * from inside its implementation of the [vfunc`Gtk`.Widget.size_allocate]
             * virtual method. Calls to gtk_widget_queue_resize() from inside
             * [vfunc`Gtk`.Widget.size_allocate] will be silently ignored.
             *
             * This function is only for use in widget implementations.
             */
            queue_resize(): void;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            realize(): void;
            /**
             * Removes an event controller from the widget.
             *
             * The removed event controller will not receive any more events,
             * and should not be used again.
             *
             * Widgets will remove all event controllers automatically when they
             * are destroyed, there is normally no need to call this function.
             * @param controller an event controller
             */
            remove_controller(controller: EventController): void;
            /**
             * Removes a style from the widget.
             *
             * After this, the style of `widget` will stop matching for `css_class`.
             * @param css_class style class to remove from @widget, without the leading period
             */
            remove_css_class(css_class: string): void;
            /**
             * Removes a widget from the list of mnemonic labels for this widget.
             *
             * See [method`Gtk`.Widget.list_mnemonic_labels].
             *
             * The widget must have previously been added to the list with
             * [method`Gtk`.Widget.add_mnemonic_label].
             * @param label a widget that is a mnemonic label for @widget
             */
            remove_mnemonic_label(label: Widget): void;
            /**
             * Removes a tick callback previously registered with
             * [method`Gtk`.Widget.add_tick_callback].
             * @param id an ID returned by [method@Gtk.Widget.add_tick_callback]
             */
            remove_tick_callback(id: number): void;
            /**
             * Sets whether the input focus can enter the widget or
             * any of its children.
             *
             * Applications should set `can_focus` to false to mark a
             * widget as for pointer/touch use only.
             *
             * Note that having `can_focus` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and focusable and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param can_focus whether the input focus can enter   the widget or any of its children
             */
            set_can_focus(can_focus: boolean): void;
            /**
             * Sets whether the widget can be the target of pointer events.
             * @param can_target whether this widget should be able to   receive pointer events
             */
            set_can_target(can_target: boolean): void;
            /**
             * Sets whether the widget should be mapped along with its parent.
             *
             * The child visibility can be set for widget before it is added
             * to a container with [method`Gtk`.Widget.set_parent], to avoid
             * mapping children unnecessary before immediately unmapping them.
             * However it will be reset to its default state of true when the
             * widget is removed from a container.
             *
             * Note that changing the child visibility of a widget does not
             * queue a resize on the widget. Most of the time, the size of
             * a widget is computed from all visible children, whether or
             * not they are mapped. If this is not the case, the container
             * can queue a resize itself.
             *
             * This function is only useful for widget implementations
             * and should never be called by an application.
             * @param child_visible whether @widget should be mapped along   with its parent
             */
            set_child_visible(child_visible: boolean): void;
            /**
             * Replaces the current style classes of the widget with `classes`.
             * @param classes `NULL`-terminated list of style classes
             */
            set_css_classes(classes: string[]): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * If the `cursor` is `NULL`, `widget` will use the cursor
             * inherited from its parent.
             * @param cursor the new cursor
             */
            set_cursor(cursor?: Gdk.Cursor | null): void;
            /**
             * Sets the cursor to be shown when the pointer hovers over
             * the widget.
             *
             * This is a utility function that creates a cursor via
             * [ctor`Gdk`.Cursor.new_from_name] and then sets it on `widget`
             * with [method`Gtk`.Widget.set_cursor]. See those functions for
             * details.
             *
             * On top of that, this function allows `name` to be `NULL`, which
             * will do the same as calling [method`Gtk`.Widget.set_cursor]
             * with a `NULL` cursor.
             * @param name the name of the cursor
             */
            set_cursor_from_name(name?: string | null): void;
            /**
             * Sets the reading direction on the widget.
             *
             * This direction controls the primary direction for widgets
             * containing text, and also the direction in which the children
             * of a container are packed. The ability to set the direction is
             * present in order so that correct localization into languages with
             * right-to-left reading directions can be done.
             *
             * Generally, applications will let the default reading direction
             * prevail, except for widgets where the children are arranged in
             * an order that is explicitly visual rather than logical (such as
             * buttons for text justification).
             *
             * If the direction is set to [enum`Gtk`.TextDirection.none], then
             * the value set by [func`Gtk`.Widget.set_default_direction] will be used.
             * @param dir the new direction
             */
            set_direction(dir: TextDirection | null): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            set_focus_child(child?: Widget | null): void;
            /**
             * Sets whether the widget should grab focus when it is clicked
             * with the mouse.
             *
             * Making mouse clicks not grab focus is useful in places like
             * toolbars where you don’t want the keyboard focus removed from
             * the main area of the application.
             * @param focus_on_click whether the widget should grab focus when clicked   with the mouse
             */
            set_focus_on_click(focus_on_click: boolean): void;
            /**
             * Sets whether the widget can own the input focus.
             *
             * Widget implementations should set `focusable` to true in
             * their init() function if they want to receive keyboard input.
             *
             * Note that having `focusable` be true is only one of the
             * necessary conditions for being focusable. A widget must
             * also be sensitive and can-focus and not have an ancestor
             * that is marked as not can-focus in order to receive input
             * focus.
             *
             * See [method`Gtk`.Widget.grab_focus] for actually setting
             * the input focus on a widget.
             * @param focusable whether or not @widget can own the input focus
             */
            set_focusable(focusable: boolean): void;
            /**
             * Sets the font map to use for text rendering in the widget.
             *
             * The font map is the object that is used to look up fonts.
             * Setting a custom font map can be useful in special situations,
             * e.g. when you need to add application-specific fonts to the set
             * of available fonts.
             *
             * When not set, the widget will inherit the font map from its parent.
             * @param font_map a `PangoFontMap`
             */
            set_font_map(font_map?: Pango.FontMap | null): void;
            /**
             * Sets the `cairo_font_options_t` used for text rendering
             * in the widget.
             *
             * When not set, the default font options for the `GdkDisplay`
             * will be used.
             * @param options a `cairo_font_options_t` struct   to unset any previously set default font options
             */
            set_font_options(options?: cairo.FontOptions | null): void;
            /**
             * Sets the horizontal alignment of the widget.
             * @param align the horizontal alignment
             */
            set_halign(align: Align | null): void;
            /**
             * Sets the `has-tooltip` property on the widget.
             * @param has_tooltip whether or not @widget has a tooltip
             */
            set_has_tooltip(has_tooltip: boolean): void;
            /**
             * Sets whether the widget would like any available extra horizontal
             * space.
             *
             * When a user resizes a window, widgets with expand set to true generally
             * receive the extra space. For example, a list or scrollable area
             * or document in your window would often be set to expand.
             *
             * Call this function to set the expand flag if you would like your
             * widget to become larger horizontally when the window has extra
             * room.
             *
             * By default, widgets automatically expand if any of their children
             * want to expand. (To see if a widget will automatically expand given
             * its current children and state, call [method`Gtk`.Widget.compute_expand].
             * A widget can decide how the expandability of children affects its
             * own expansion by overriding the `compute_expand` virtual method on
             * `GtkWidget`.).
             *
             * Setting hexpand explicitly with this function will override the
             * automatic expand behavior.
             *
             * This function forces the widget to expand or not to expand,
             * regardless of children. The override occurs because
             * [method`Gtk`.Widget.set_hexpand] sets the hexpand-set property (see
             * [method`Gtk`.Widget.set_hexpand_set]) which causes the widget’s hexpand
             * value to be used, rather than looking at children and widget state.
             * @param expand whether to expand
             */
            set_hexpand(expand: boolean): void;
            /**
             * Sets whether the hexpand flag will be used.
             *
             * The [property`Gtk`.Widget:hexpand-set] property will be set
             * automatically when you call [method`Gtk`.Widget.set_hexpand]
             * to set hexpand, so the most likely reason to use this function
             * would be to unset an explicit expand flag.
             *
             * If hexpand is set, then it overrides any computed
             * expand value based on child widgets. If hexpand is not
             * set, then the expand value depends on whether any
             * children of the widget would like to expand.
             *
             * There are few reasons to use this function, but it’s here
             * for completeness and consistency.
             * @param set value for hexpand-set property
             */
            set_hexpand_set(set: boolean): void;
            /**
             * Sets the layout manager to use for measuring and allocating children
             * of the widget.
             * @param layout_manager a layout manager
             */
            set_layout_manager(layout_manager?: LayoutManager | null): void;
            /**
             * Sets whether the widget acts like a modal dialog,
             * with respect to event delivery.
             * @param limit_events whether to limit events
             */
            set_limit_events(limit_events: boolean): void;
            /**
             * Sets the bottom margin of the widget.
             * @param margin the bottom margin
             */
            set_margin_bottom(margin: number): void;
            /**
             * Sets the end margin of the widget.
             * @param margin the end margin
             */
            set_margin_end(margin: number): void;
            /**
             * Sets the start margin of the widget.
             * @param margin the start margin
             */
            set_margin_start(margin: number): void;
            /**
             * Sets the top margin of the widget.
             * @param margin the top margin
             */
            set_margin_top(margin: number): void;
            /**
             * Sets a widgets name.
             *
             * Setting a name allows you to refer to the widget from a
             * CSS file. You can apply a style to widgets with a particular name
             * in the CSS file. See the documentation for the CSS syntax (on the
             * same page as the docs for [class`Gtk`.StyleContext].
             *
             * Note that the CSS syntax has certain special characters to delimit
             * and represent elements in a selector (period, #, >, *...), so using
             * these will make your widget impossible to match by name. Any combination
             * of alphanumeric symbols, dashes and underscores will suffice.
             * @param name name for the widget
             */
            set_name(name: string): void;
            /**
             * Requests the widget to be rendered partially transparent.
             *
             * An opacity of 0 is fully transparent and an opacity of 1
             * is fully opaque.
             *
             * Opacity works on both toplevel widgets and child widgets, although
             * there are some limitations: For toplevel widgets, applying opacity
             * depends on the capabilities of the windowing system. On X11, this
             * has any effect only on X displays with a compositing manager, see
             * [method`Gdk`.Display.is_composited]. On Windows and Wayland it will
             * always work, although setting a window’s opacity after the window
             * has been shown may cause some flicker.
             *
             * Note that the opacity is inherited through inclusion — if you set
             * a toplevel to be partially translucent, all of its content will
             * appear translucent, since it is ultimatively rendered on that
             * toplevel. The opacity value itself is not inherited by child
             * widgets (since that would make widgets deeper in the hierarchy
             * progressively more translucent). As a consequence, [class`Gtk`.Popover]
             * instances and other [iface`Gtk`.Native] widgets with their own surface
             * will use their own opacity value, and thus by default appear
             * non-translucent, even if they are attached to a toplevel that
             * is translucent.
             * @param opacity desired opacity, between 0 and 1
             */
            set_opacity(opacity: number): void;
            /**
             * Sets how the widget treats content that is drawn outside the
             * it's content area.
             *
             * See the definition of [enum`Gtk`.Overflow] for details.
             *
             * This setting is provided for widget implementations and
             * should not be used by application code.
             *
             * The default value is [enum`Gtk`.Overflow.visible].
             * @param overflow desired overflow value
             */
            set_overflow(overflow: Overflow | null): void;
            /**
             * Sets the parent widget of the widget.
             *
             * This takes care of details such as updating the state and style
             * of the child to reflect its new location and resizing the parent.
             * The opposite function is [method`Gtk`.Widget.unparent].
             *
             * This function is useful only when implementing subclasses of
             * `GtkWidget`.
             * @param parent parent widget
             */
            set_parent(parent: Widget): void;
            /**
             * Sets whether the widget will be treated as the default
             * widget within its toplevel when it has the focus, even if
             * another widget is the default.
             * @param receives_default whether or not @widget can be a default widget
             */
            set_receives_default(receives_default: boolean): void;
            /**
             * Sets the sensitivity of the widget.
             *
             * A widget is sensitive if the user can interact with it.
             * Insensitive widgets are “grayed out” and the user can’t
             * interact with them. Insensitive widgets are known as
             * “inactive”, “disabled”, or “ghosted” in some other toolkits.
             * @param sensitive true to make the widget sensitive
             */
            set_sensitive(sensitive: boolean): void;
            /**
             * Sets the minimum size of the widget.
             *
             * That is, the widget’s size request will be at least `width`
             * by `height`. You can use this function to force a widget to
             * be larger than it normally would be.
             *
             * In most cases, [method`Gtk`.Window.set_default_size] is a better
             * choice for toplevel windows than this function; setting the default
             * size will still allow users to shrink the window. Setting the size
             * request will force them to leave the window at least as large as
             * the size request.
             *
             * Note the inherent danger of setting any fixed size - themes,
             * translations into other languages, different fonts, and user action
             * can all change the appropriate size for a given widget. So, it is
             * basically impossible to hardcode a size that will always work.
             *
             * The size request of a widget is the smallest size a widget can
             * accept while still functioning well and drawing itself correctly.
             * However in some strange cases a widget may be allocated less than
             * its requested size, and in many cases a widget may be allocated more
             * space than it requested.
             *
             * If the size request in a given direction is -1 (unset), then
             * the “natural” size request of the widget will be used instead.
             *
             * The size request set here does not include any margin from the
             * properties
             * [property`Gtk`.Widget:margin-start],
             * [property`Gtk`.Widget:margin-end],
             * [property`Gtk`.Widget:margin-top], and
             * [property`Gtk`.Widget:margin-bottom], but it does include pretty
             * much all other padding or border properties set by any subclass
             * of `GtkWidget`.
             * @param width width @widget should request, or -1 to unset
             * @param height height @widget should request, or -1 to unset
             */
            set_size_request(width: number, height: number): void;
            /**
             * Turns on flag values in the current widget state.
             *
             * Typical widget states are insensitive, prelighted, etc.
             *
             * This function accepts the values [flags`Gtk`.StateFlags.dir-ltr] and
             * [flags`Gtk`.StateFlags.dir-rtl] but ignores them. If you want to set
             * the widget's direction, use [method`Gtk`.Widget.set_direction].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn on
             * @param clear whether to clear state before turning on @flags
             */
            set_state_flags(flags: StateFlags | null, clear: boolean): void;
            /**
             * Sets the contents of the tooltip for widget.
             *
             * `markup` must contain Pango markup.
             *
             * This function will take care of setting the
             * [property`Gtk`.Widget:has-tooltip] as a side effect, and of the
             * default handler for the [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_markup].
             * @param markup the contents of the tooltip for @widget
             */
            set_tooltip_markup(markup?: string | null): void;
            /**
             * Sets the contents of the tooltip for the widget.
             *
             * If `text` contains any markup, it will be escaped.
             *
             * This function will take care of setting
             * [property`Gtk`.Widget:has-tooltip] as a side effect,
             * and of the default handler for the
             * [signal`Gtk`.Widget::query-tooltip] signal.
             *
             * See also [method`Gtk`.Tooltip.set_text].
             * @param text the contents of the tooltip for @widget
             */
            set_tooltip_text(text?: string | null): void;
            /**
             * Sets the vertical alignment of the widget.
             * @param align the vertical alignment
             */
            set_valign(align: Align | null): void;
            /**
             * Sets whether the widget would like any available extra vertical
             * space.
             *
             * See [method`Gtk`.Widget.set_hexpand] for more detail.
             * @param expand whether to expand
             */
            set_vexpand(expand: boolean): void;
            /**
             * Sets whether the vexpand flag will be used.
             *
             * See [method`Gtk`.Widget.set_hexpand_set] for more detail.
             * @param set value for vexpand-set property
             */
            set_vexpand_set(set: boolean): void;
            /**
             * Sets the visibility state of `widget`.
             *
             * Note that setting this to true doesn’t mean the widget is
             * actually viewable, see [method`Gtk`.Widget.get_visible].
             * @param visible whether the widget should be shown or not
             */
            set_visible(visible: boolean): void;
            /**
             * Returns whether the widget should contribute to
             * the measuring and allocation of its parent.
             *
             * This is false for invisible children, but also
             * for children that have their own surface, such
             * as [class`Gtk`.Popover] instances.
             * @returns true if child should be included in   measuring and allocating
             */
            should_layout(): boolean;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            show(): void;
            /**
             * Allocates widget with a transformation that translates
             * the origin to the position in `allocation`.
             *
             * This is a simple form of [method`Gtk`.Widget.allocate].
             * @param allocation position and size to be allocated to @widget
             * @param baseline the baseline of the child, or -1
             */
            size_allocate(allocation: Allocation, baseline: number): void;
            /**
             * Snapshots a child of the widget.
             *
             * When a widget receives a call to the snapshot function,
             * it must send synthetic [vfunc`Gtk`.Widget.snapshot] calls
             * to all children. This function provides a convenient way
             * of doing this. A widget, when it receives a call to its
             * [vfunc`Gtk`.Widget.snapshot] function, calls
             * gtk_widget_snapshot_child() once for each child, passing in
             * the `snapshot` the widget received.
             *
             * This function takes care of translating the origin of `snapshot,`
             * and deciding whether the child needs to be snapshot.
             *
             * It does nothing for children that implement `GtkNative`.
             * @param child a child of @widget
             * @param snapshot snapshot as passed to the widget. In particular, no   calls to [method@Gtk.Snapshot.translate] or other transform calls   should have been made
             */
            snapshot_child(child: Widget, snapshot: Snapshot): void;
            /**
             * Translates coordinates relative to `src_widget’`s allocation
             * to coordinates relative to `dest_widget’`s allocations.
             *
             * In order to perform this operation, both widget must share
             * a common ancestor. If that is not the case, `dest_x` and `dest_y`
             * are set to 0 and false is returned.
             * @param dest_widget another widget
             * @param src_x X position in widget coordinates of @src_widget
             * @param src_y Y position in widget coordinates of @src_widget
             * @returns true if @src_widget and @dest_widget have a common   ancestor, false otherwise
             */
            translate_coordinates(dest_widget: Widget, src_x: number, src_y: number): [boolean, number, number];
            /**
             * Triggers a tooltip query on the display of the widget.
             */
            trigger_tooltip_query(): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            unmap(): void;
            /**
             * Removes `widget` from its parent.
             *
             * This function is only for use in widget implementations,
             * typically in dispose.
             */
            unparent(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            unrealize(): void;
            /**
             * Turns off flag values for the current widget state.
             *
             * See [method`Gtk`.Widget.set_state_flags].
             *
             * This function is for use in widget implementations.
             * @param flags state flags to turn off
             */
            unset_state_flags(flags: StateFlags | null): void;
            /**
             * Computes whether a container should give this
             *   widget extra space when possible.
             * @param hexpand_p
             * @param vexpand_p
             */
            vfunc_compute_expand(hexpand_p: boolean, vexpand_p: boolean): void;
            /**
             * Tests if a given point is contained in the widget.
             *
             * The coordinates for (x, y) must be in widget coordinates, so
             * (0, 0) is assumed to be the top left of `widget'`s content area.
             * @param x X coordinate to test, relative to @widget's origin
             * @param y Y coordinate to test, relative to @widget's origin
             */
            vfunc_contains(x: number, y: number): boolean;
            /**
             * Vfunc called when the CSS used by widget was changed. Widgets
             *   should then discard their caches that depend on CSS and queue resizes or
             *   redraws accordingly. The default implementation will take care of this for
             *   all the default CSS properties, so implementations must chain up.
             * @param change
             */
            vfunc_css_changed(change: CssStyleChange): void;
            /**
             * Signal emitted when the text direction of a
             *   widget changes.
             * @param previous_direction
             */
            vfunc_direction_changed(previous_direction: TextDirection): void;
            /**
             * Vfunc for gtk_widget_child_focus()
             * @param direction
             */
            vfunc_focus(direction: DirectionType): boolean;
            /**
             * Gets whether the widget prefers a height-for-width layout
             * or a width-for-height layout.
             *
             * Single-child widgets generally propagate the preference of
             * their child, more complex widgets need to request something
             * either in context of their children or in context of their
             * allocation capabilities.
             */
            vfunc_get_request_mode(): SizeRequestMode;
            /**
             * Causes `widget` to have the keyboard focus for the window
             * that it belongs to.
             *
             * If `widget` is not focusable, or its [vfunc`Gtk`.Widget.grab_focus]
             * implementation cannot transfer the focus to a descendant of `widget`
             * that is focusable, it will not take focus and false will be returned.
             *
             * Calling [method`Gtk`.Widget.grab_focus] on an already focused widget
             * is allowed, should not have an effect, and return true.
             */
            vfunc_grab_focus(): boolean;
            /**
             * Reverses the effects of [method.Gtk.Widget.show].
             *
             * This is causing the widget to be hidden (invisible to the user).
             */
            vfunc_hide(): void;
            /**
             * Emits the [signal`Gtk`.Widget::keynav-failed] signal on the widget.
             *
             * This function should be called whenever keyboard navigation
             * within a single widget hits a boundary.
             *
             * The return value of this function should be interpreted
             * in a way similar to the return value of
             * [method`Gtk`.Widget.child_focus]. When true is returned,
             * stay in the widget, the failed keyboard navigation is ok
             * and/or there is nowhere we can/should move the focus to.
             * When false is returned, the caller should continue with
             * keyboard navigation outside the widget, e.g. by calling
             * [method`Gtk`.Widget.child_focus] on the widget’s toplevel.
             *
             * The default [signal`Gtk`.Widget::keynav-failed] handler returns
             * false for [enum`Gtk`.DirectionType.tab-forward] and
             * [enum`Gtk`.DirectionType.tab-backward]. For the other values
             * of [enum`Gtk`.DirectionType] it returns true.
             *
             * Whenever the default handler returns true, it also calls
             * [method`Gtk`.Widget.error_bell] to notify the user of the
             * failed keyboard navigation.
             *
             * A use case for providing an own implementation of `::keynav-failed`
             * (either by connecting to it or by overriding it) would be a row of
             * [class`Gtk`.Entry] widgets where the user should be able to navigate
             * the entire row with the cursor keys, as e.g. known from user
             * interfaces that require entering license keys.
             * @param direction direction of focus movement
             */
            vfunc_keynav_failed(direction: DirectionType): boolean;
            /**
             * Causes a widget to be mapped if it isn’t already.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_map(): void;
            /**
             * Measures `widget` in the orientation `orientation` and for the given `for_size`.
             *
             * As an example, if `orientation` is %GTK_ORIENTATION_HORIZONTAL and `for_size`
             * is 300, this functions will compute the minimum and natural width of `widget`
             * if it is allocated at a height of 300 pixels.
             *
             * See [GtkWidget’s geometry management section](class.Widget.html#height-for-width-geometry-management) for
             * a more details on implementing `GtkWidgetClass.measure()`.
             * @param orientation the orientation to measure
             * @param for_size Size for the opposite of @orientation, i.e.   if @orientation is %GTK_ORIENTATION_HORIZONTAL, this is   the height the widget should be measured with. The %GTK_ORIENTATION_VERTICAL   case is analogous. This way, both height-for-width and width-for-height   requests can be implemented. If no size is known, -1 can be passed.
             */
            vfunc_measure(orientation: Orientation, for_size: number): [number, number, number, number];
            /**
             * Emits the [signal`Gtk`.Widget::mnemonic-activate] signal.
             * @param group_cycling true if there are other widgets with the same mnemonic
             */
            vfunc_mnemonic_activate(group_cycling: boolean): boolean;
            /**
             * Signal emitted when a change of focus is requested
             * @param direction
             */
            vfunc_move_focus(direction: DirectionType): void;
            /**
             * Signal emitted when “has-tooltip” is %TRUE and the
             *   hover timeout has expired with the cursor hovering “above”
             *   widget; or emitted when widget got focus in keyboard mode.
             * @param x
             * @param y
             * @param keyboard_tooltip
             * @param tooltip
             */
            vfunc_query_tooltip(x: number, y: number, keyboard_tooltip: boolean, tooltip: Tooltip): boolean;
            /**
             * Creates the GDK resources associated with a widget.
             *
             * Normally realization happens implicitly; if you show a widget
             * and all its parent containers, then the widget will be realized
             * and mapped automatically.
             *
             * Realizing a widget requires all the widget’s parent widgets to be
             * realized; calling this function realizes the widget’s parents
             * in addition to `widget` itself. If a widget is not yet inside a
             * toplevel window when you realize it, bad things will happen.
             *
             * This function is primarily used in widget implementations, and
             * isn’t very useful otherwise. Many times when you think you might
             * need it, a better approach is to connect to a signal that will be
             * called after the widget is realized automatically, such as
             * [signal`Gtk`.Widget::realize].
             */
            vfunc_realize(): void;
            /**
             * Called when the widget gets added to a `GtkRoot` widget. Must
             *   chain up
             */
            vfunc_root(): void;
            /**
             * Set the focus child of the widget.
             *
             * This function is only suitable for widget implementations.
             * If you want a certain widget to get the input focus, call
             * [method`Gtk`.Widget.grab_focus] on it.
             * @param child a direct child widget of @widget   or `NULL` to unset the focus child
             */
            vfunc_set_focus_child(child?: Widget | null): void;
            /**
             * Flags a widget to be displayed.
             *
             * Any widget that isn’t shown will not appear on the screen.
             *
             * Remember that you have to show the containers containing a widget,
             * in addition to the widget itself, before it will appear onscreen.
             *
             * When a toplevel widget is shown, it is immediately realized and
             * mapped; other shown widgets are realized and mapped when their
             * toplevel widget is realized and mapped.
             */
            vfunc_show(): void;
            /**
             * Called to set the allocation, if the widget does
             *   not have a layout manager.
             * @param width
             * @param height
             * @param baseline
             */
            vfunc_size_allocate(width: number, height: number, baseline: number): void;
            /**
             * Vfunc called when a new snapshot of the widget has to be taken.
             * @param snapshot
             */
            vfunc_snapshot(snapshot: Snapshot): void;
            /**
             * Signal emitted when the widget state changes,
             *   see gtk_widget_get_state_flags().
             * @param previous_state_flags
             */
            vfunc_state_flags_changed(previous_state_flags: StateFlags): void;
            /**
             * Emitted when a system setting was changed. Must chain up.
             * @param settings
             */
            vfunc_system_setting_changed(settings: SystemSetting): void;
            /**
             * Causes a widget to be unmapped if it’s currently mapped.
             *
             * This function is only for use in widget implementations.
             */
            vfunc_unmap(): void;
            /**
             * Causes a widget to be unrealized.
             *
             * This frees all GDK resources associated with the widget.
             *
             * This function is only useful in widget implementations.
             */
            vfunc_unrealize(): void;
            /**
             * Called when the widget is about to be removed from its
             *   `GtkRoot` widget. Must chain up
             */
            vfunc_unroot(): void;
        }

        namespace Application {
            // Signal callback interfaces

            interface QueryEnd {
                (): void;
            }

            interface WindowAdded {
                (window: Window): void;
            }

            interface WindowRemoved {
                (window: Window): void;
            }

            // Constructor properties interface

            interface ConstructorProps
                extends Gio.Application.ConstructorProps,
                    Gio.ActionGroup.ConstructorProps,
                    Gio.ActionMap.ConstructorProps {
                active_window: Window;
                activeWindow: Window;
                menubar: Gio.MenuModel;
                register_session: boolean;
                registerSession: boolean;
                screensaver_active: boolean;
                screensaverActive: boolean;
            }
        }

        /**
         * A high-level API for writing applications.
         *
         * `GtkApplication` supports many aspects of writing a GTK application
         * in a convenient fashion, without enforcing a one-size-fits-all model.
         *
         * Currently, it handles GTK initialization, application uniqueness, session
         * management, provides some basic scriptability and desktop shell integration
         * by exporting actions and menus and manages a list of toplevel windows whose
         * life-cycle is automatically tied to the life-cycle of your application.
         *
         * While `GtkApplication` works fine with plain [class`Gtk`.Window]s,
         * it is recommended to use it together with [class`Gtk`.ApplicationWindow].
         *
         * ## Automatic resources
         *
         * `GtkApplication` will automatically load menus from the `GtkBuilder`
         * resource located at "gtk/menus.ui", relative to the application's
         * resource base path (see [method`Gio`.Application.set_resource_base_path]).
         * The menu with the ID "menubar" is taken as the application's
         * menubar. Additional menus (most interesting submenus) can be named
         * and accessed via [method`Gtk`.Application.get_menu_by_id] which allows for
         * dynamic population of a part of the menu structure.
         *
         * Note that automatic resource loading uses the resource base path
         * that is set at construction time and will not work if the resource
         * base path is changed at a later time.
         *
         * It is also possible to provide the menubar manually using
         * [method`Gtk`.Application.set_menubar].
         *
         * `GtkApplication` will also automatically setup an icon search path for
         * the default icon theme by appending "icons" to the resource base
         * path. This allows your application to easily store its icons as
         * resources. See [method`Gtk`.IconTheme.add_resource_path] for more
         * information.
         *
         * If there is a resource located at `gtk/help-overlay.ui` which
         * defines a [class`Gtk`.ShortcutsWindow] with ID `help_overlay` then
         * `GtkApplication` associates an instance of this shortcuts window with
         * each [class`Gtk`.ApplicationWindow] and sets up the keyboard accelerator
         * <kbd>Control</kbd>+<kbd>?</kbd> to open it. To create a menu item that
         * displays the shortcuts window, associate the item with the action
         * `win.show-help-overlay`.
         *
         * `GtkApplication` will also automatically set the application id as the
         * default window icon. Use [func`Gtk`.Window.set_default_icon_name] or
         * [property`Gtk`.Window:icon-name] to override that behavior.
         *
         * ## A simple application
         *
         * [A simple example](https://gitlab.gnome.org/GNOME/gtk/tree/main/examples/bp/bloatpad.c)
         * is available in the GTK source code repository
         *
         * `GtkApplication` optionally registers with a session manager of the
         * users session (if you set the [property`Gtk`.Application:register-session]
         * property) and offers various functionality related to the session
         * life-cycle.
         *
         * An application can block various ways to end the session with
         * the [method`Gtk`.Application.inhibit] function. Typical use cases for
         * this kind of inhibiting are long-running, uninterruptible operations,
         * such as burning a CD or performing a disk backup. The session
         * manager may not honor the inhibitor, but it can be expected to
         * inform the user about the negative consequences of ending the
         * session while inhibitors are present.
         *
         * ## See Also
         *
         * - [Using GtkApplication](https://developer.gnome.org/documentation/tutorials/application.html)
         * - [Getting Started with GTK: Basics](getting_started.html#basics)
         */
        class Application extends Gio.Application implements Gio.ActionGroup, Gio.ActionMap {
            static $gtype: GObject.GType<Application>;

            // Properties

            /**
             * The currently focused window of the application.
             */
            get active_window(): Window;
            /**
             * The currently focused window of the application.
             */
            get activeWindow(): Window;
            /**
             * The menu model to be used for the application's menu bar.
             */
            get menubar(): Gio.MenuModel;
            set menubar(val: Gio.MenuModel);
            /**
             * Set this property to true to register with the session manager.
             *
             * This will make GTK track the session state (such as the
             * [property`