# Datadog Tracer for Go

This package provides the Datadog APM tracer for Go.

## API Stability

The public API of this package is tracked in `api.txt`. This file is automatically generated and checked in CI to ensure API stability. If you make changes to the public API, you must update this file by running:

```bash
go run ./scripts/apiextractor/api_extractor.go ./ddtrace/tracer > ./ddtrace/tracer/api.txt
```

The CI will fail if you make changes to the public API without updating `api.txt`. This helps us:

1. Track API changes explicitly
2. Maintain backward compatibility
3. Make intentional API changes with clear visibility

### What constitutes an API change?

- Adding or removing exported functions, types, methods, or fields
- Changing function signatures
- Changing type definitions
- Changing interface definitions

### Checking API changes locally

You can check if your changes affect the public API by running:

```bash
go run ./scripts/apiextractor/api_extractor.go ./ddtrace/tracer > current_api.txt
diff -u ./ddtrace/tracer/api.txt current_api.txt
```
