# glossaries-accsupp package
# Matthew Bertucci 2025/10/17 for v4.8

#include:glossaries
#include:accsupp

#keyvals:\usepackage/glossaries-accsupp#c
nowarn
nolangwarn
noredefwarn
translate=#true,false,babel
notranslate
languages=%<language%>
nolong
nosuper
nolist
notree
nostyles
makeindex
xindy
xindy={%<options%>}
xindygloss
xindynoglsnumbers
acronym#true,false
acronyms
debug=#false,true,showtargets,showaccsupp
savewrites#true,false
hyperfirst#true,false
writeglslabels
writeglslabelnames
toc#true,false
numberline#true,false
section=%<section unit%>
ucmark#true,false
numberedsection=#false,nolabel,autolabel
savenumberlist#true,false
entrycounter#true,false
counterwithin=%<counter%>
subentrycounter#true,false
style=%<style-name%>
nonumberlist
seeautonumberlist
counter=%<counter%>
nopostdot#true,false
nogroupskip#true,false
seenoindex=#error,warn,ignore
esclocations#true,false
indexonlyfirst#true,false
sanitizesort#true,false
sort=#none,clear,def,use,standard
order=#word,letter
automake=#false,delayed,immediate,makegloss,lite
automakegloss
automakeglosslite
disablemakegloss
restoremakegloss
nohypertypes={%<list%>}
symbols
numbers
index
noglossaryindex
acronymlists={%<label-list%>}
shortcuts#true,false
mfirstuc=#expanded,unexpanded
kernelglossredefs=#false,true,nowarn
#endkeyvals

## need same options as glossaries
#ifOption:translate
#include:translator
#include:tracklang
#endif
#ifOption:translate=true
#include:translator
#include:tracklang
#endif
#ifOption:translate=babel
#include:glossaries-babel
#endif

#ifOption:symbols
\printsymbols
\printsymbols[options%keyvals]
#endif

#ifOption:numbers
\printnumbers
\printnumbers[options%keyvals]
#endif

#ifOption:index
\newterm{gls-label%specialDef}#s#%gls-label
\newterm[options%keyvals]{gls-label%specialDef}#s#%gls-label
\printindex
\printindex[options%keyvals]
#endif

#ifOption:acronym
\printacronyms
\printacronyms[options%keyvals]
#endif
#ifOption:acronym=true
\printacronyms
\printacronyms[options%keyvals]
#endif
#ifOption:acronyms
\printacronyms
\printacronyms[options%keyvals]
#endif

#ifOption:shortcuts
\acs{gls-label%special}
\acs[options%keyvals]{gls-label%special}
\acs{gls-label%special}[insert]#*
\acs[options%keyvals]{gls-label%special}[insert]#*
\acs*{gls-label%special}#S
\acs*[options%keyvals]{gls-label%special}#S
\acs*{gls-label%special}[insert]#S
\acs*[options%keyvals]{gls-label%special}[insert]#S
\acs+{gls-label%special}#S
\acs+[options%keyvals]{gls-label%special}#S
\acs+{gls-label%special}[insert]#S
\acs+[options%keyvals]{gls-label%special}[insert]#S
\Acs{gls-label%special}
\Acs[options%keyvals]{gls-label%special}
\Acs{gls-label%special}[insert]#*
\Acs[options%keyvals]{gls-label%special}[insert]#*
\Acs*{gls-label%special}#S
\Acs*[options%keyvals]{gls-label%special}#S
\Acs*{gls-label%special}[insert]#S
\Acs*[options%keyvals]{gls-label%special}[insert]#S
\Acs+{gls-label%special}#S
\Acs+[options%keyvals]{gls-label%special}#S
\Acs+{gls-label%special}[insert]#S
\Acs+[options%keyvals]{gls-label%special}[insert]#S
\acsp{gls-label%special}#*
\acsp[options%keyvals]{gls-label%special}#*
\acsp{gls-label%special}[insert]#*
\acsp[options%keyvals]{gls-label%special}[insert]#*
\acsp*{gls-label%special}#S
\acsp*[options%keyvals]{gls-label%special}#S
\acsp*{gls-label%special}[insert]#S
\acsp*[options%keyvals]{gls-label%special}[insert]#S
\acsp+{gls-label%special}#S
\acsp+[options%keyvals]{gls-label%special}#S
\acsp+{gls-label%special}[insert]#S
\acsp+[options%keyvals]{gls-label%special}[insert]#S
\Acsp{gls-label%special}#*
\Acsp[options%keyvals]{gls-label%special}#*
\Acsp{gls-label%special}[insert]#*
\Acsp[options%keyvals]{gls-label%special}[insert]#*
\Acsp*{gls-label%special}#S
\Acsp*[options%keyvals]{gls-label%special}#S
\Acsp*{gls-label%special}[insert]#S
\Acsp*[options%keyvals]{gls-label%special}[insert]#S
\Acsp+{gls-label%special}#S
\Acsp+[options%keyvals]{gls-label%special}#S
\Acsp+{gls-label%special}[insert]#S
\Acsp+[options%keyvals]{gls-label%special}[insert]#S
\acl{gls-label%special}
\acl[options%keyvals]{gls-label%special}
\acl{gls-label%special}[insert]#*
\acl[options%keyvals]{gls-label%special}[insert]#*
\acl*{gls-label%special}#S
\acl*[options%keyvals]{gls-label%special}#S
\acl*{gls-label%special}[insert]#S
\acl*[options%keyvals]{gls-label%special}[insert]#S
\acl+{gls-label%special}#S
\acl+[options%keyvals]{gls-label%special}#S
\acl+{gls-label%special}[insert]#S
\acl+[options%keyvals]{gls-label%special}[insert]#S
\Acl{gls-label%special}
\Acl[options%keyvals]{gls-label%special}
\Acl{gls-label%special}[insert]#*
\Acl[options%keyvals]{gls-label%special}[insert]#*
\Acl*{gls-label%special}#S
\Acl*[options%keyvals]{gls-label%special}#S
\Acl*{gls-label%special}[insert]#S
\Acl*[options%keyvals]{gls-label%special}[insert]#S
\Acl+{gls-label%special}#S
\Acl+[options%keyvals]{gls-label%special}#S
\Acl+{gls-label%special}[insert]#S
\Acl+[options%keyvals]{gls-label%special}[insert]#S
\aclp{gls-label%special}#*
\aclp[options%keyvals]{gls-label%special}#*
\aclp{gls-label%special}[insert]#*
\aclp[options%keyvals]{gls-label%special}[insert]#*
\aclp*{gls-label%special}#S
\aclp*[options%keyvals]{gls-label%special}#S
\aclp*{gls-label%special}[insert]#S
\aclp*[options%keyvals]{gls-label%special}[insert]#S
\aclp+{gls-label%special}#S
\aclp+[options%keyvals]{gls-label%special}#S
\aclp+{gls-label%special}[insert]#S
\aclp+[options%keyvals]{gls-label%special}[insert]#S
\Aclp{gls-label%special}#*
\Aclp[options%keyvals]{gls-label%special}#*
\Aclp{gls-label%special}[insert]#*
\Aclp[options%keyvals]{gls-label%special}[insert]#*
\Aclp*{gls-label%special}#S
\Aclp*[options%keyvals]{gls-label%special}#S
\Aclp*{gls-label%special}[insert]#S
\Aclp*[options%keyvals]{gls-label%special}[insert]#S
\Aclp+{gls-label%special}#S
\Aclp+[options%keyvals]{gls-label%special}#S
\Aclp+{gls-label%special}[insert]#S
\Aclp+[options%keyvals]{gls-label%special}[insert]#S
\acf{gls-label%special}
\acf[options%keyvals]{gls-label%special}
\acf{gls-label%special}[insert]#*
\acf[options%keyvals]{gls-label%special}[insert]#*
\acf*{gls-label%special}#S
\acf*[options%keyvals]{gls-label%special}#S
\acf*{gls-label%special}[insert]#S
\acf*[options%keyvals]{gls-label%special}[insert]#S
\acf+{gls-label%special}#S
\acf+[options%keyvals]{gls-label%special}#S
\acf+{gls-label%special}[insert]#S
\acf+[options%keyvals]{gls-label%special}[insert]#S
\Acf{gls-label%special}
\Acf[options%keyvals]{gls-label%special}
\Acf{gls-label%special}[insert]#*
\Acf[options%keyvals]{gls-label%special}[insert]#*
\Acf*{gls-label%special}#S
\Acf*[options%keyvals]{gls-label%special}#S
\Acf*{gls-label%special}[insert]#S
\Acf*[options%keyvals]{gls-label%special}[insert]#S
\Acf+{gls-label%special}#S
\Acf+[options%keyvals]{gls-label%special}#S
\Acf+{gls-label%special}[insert]#S
\Acf+[options%keyvals]{gls-label%special}[insert]#S
\acfp{gls-label%special}#*
\acfp[options%keyvals]{gls-label%special}#*
\acfp{gls-label%special}[insert]#*
\acfp[options%keyvals]{gls-label%special}[insert]#*
\acfp*{gls-label%special}#S
\acfp*[options%keyvals]{gls-label%special}#S
\acfp*{gls-label%special}[insert]#S
\acfp*[options%keyvals]{gls-label%special}[insert]#S
\acfp+{gls-label%special}#S
\acfp+[options%keyvals]{gls-label%special}#S
\acfp+{gls-label%special}[insert]#S
\acfp+[options%keyvals]{gls-label%special}[insert]#S
\Acfp{gls-label%special}#*
\Acfp[options%keyvals]{gls-label%special}#*
\Acfp{gls-label%special}[insert]#*
\Acfp[options%keyvals]{gls-label%special}[insert]#*
\Acfp*{gls-label%special}#S
\Acfp*[options%keyvals]{gls-label%special}#S
\Acfp*{gls-label%special}[insert]#S
\Acfp*[options%keyvals]{gls-label%special}[insert]#S
\Acfp+{gls-label%special}#S
\Acfp+[options%keyvals]{gls-label%special}#S
\Acfp+{gls-label%special}[insert]#S
\Acfp+[options%keyvals]{gls-label%special}[insert]#S
\ac{gls-label%special}
\ac[options%keyvals]{gls-label%special}
\ac{gls-label%special}[insert]#*
\ac[options%keyvals]{gls-label%special}[insert]#*
\Ac{gls-label%special}
\Ac[options%keyvals]{gls-label%special}
\Ac{gls-label%special}[insert]#*
\Ac[options%keyvals]{gls-label%special}[insert]#*
\ac*{gls-label%special}#S
\ac*[options%keyvals]{gls-label%special}#S
\ac*{gls-label%special}[insert]#S
\ac*[options%keyvals]{gls-label%special}[insert]#S
\Ac*{gls-label%special}#S
\Ac*[options%keyvals]{gls-label%special}#S
\Ac*{gls-label%special}[insert]#S
\Ac*[options%keyvals]{gls-label%special}[insert]#S
\ac+{gls-label%special}#S
\ac+[options%keyvals]{gls-label%special}#S
\ac+{gls-label%special}[insert]#S
\ac+[options%keyvals]{gls-label%special}[insert]#S
\Ac+{gls-label%special}#S
\Ac+[options%keyvals]{gls-label%special}#S
\Ac+{gls-label%special}[insert]#S
\Ac+[options%keyvals]{gls-label%special}[insert]#S
\acp{gls-label%special}
\acp[options%keyvals]{gls-label%special}
\acp{gls-label%special}[insert]#*
\acp[options%keyvals]{gls-label%special}[insert]#*
\Acp{gls-label%special}
\Acp[options%keyvals]{gls-label%special}
\Acp{gls-label%special}[insert]#*
\Acp[options%keyvals]{gls-label%special}[insert]#*
\acp*{gls-label%special}#S
\acp*[options%keyvals]{gls-label%special}#S
\acp*{gls-label%special}[insert]#S
\acp*[options%keyvals]{gls-label%special}[insert]#S
\Acp*{gls-label%special}#S
\Acp*[options%keyvals]{gls-label%special}#S
\Acp*{gls-label%special}[insert]#S
\Acp*[options%keyvals]{gls-label%special}[insert]#S
\acp+{gls-label%special}#S
\acp+[options%keyvals]{gls-label%special}#S
\acp+{gls-label%special}[insert]#S
\acp+[options%keyvals]{gls-label%special}[insert]#S
\Acp+{gls-label%special}#S
\Acp+[options%keyvals]{gls-label%special}#S
\Acp+{gls-label%special}[insert]#S
\Acp+[options%keyvals]{gls-label%special}[insert]#S
#endif

#ifOption:xindy
## Required Styles ##
\GlsAddXdyStyle{style-name}
\GlsSetXdyStyles{style name list}
## Language and Encodings ##
\GlsSetXdyLanguage{language}
\GlsSetXdyLanguage[glossary-type]{language}
\GlsSetXdyCodePage{codepage}
## Locations and Number lists ##
\GlsAddXdyCounters{counter list}
\GlsAddXdyAttribute{name}
\GlsAddXdyLocation{name}{definition}
\GlsAddXdyLocation[H-prefix]{name}{definition}
\GlsSetXdyLocationClassOrder{location names}
\GlsSetXdyMinRangeLength{integer}
## Glossary Groups ##
\GlsSetXdyFirstLetterAfterDigits{letter}
\GlsSetXdyNumberGroupOrder{relative location}
## other
\GlsAddLetterGroup{name}{xindy code}#*
\GlsAddSortRule{arg1}{arg2}#*
\GlsAddXdyAlphabet{name}{definition}#*
#endif

#keyvals:\newglossaryentry#c,\longnewglossaryentry#c,\provideglossaryentry#c,\longprovideglossaryentry#c,\newacronym#c,\newterm#c,\longnewglossaryentry*#c,\newentry#c,\newabbr#c,\newsym#c,\newnum#c,\glsxtrnewsymbol#c,\glsxtrnewnumber#c,\newabbreviation#c
access=%<text%>
textaccess=%<text%>
firstaccess=%<text%>
pluralaccess=%<text%>
firstpluralaccess=%<text%>
symbolaccess=%<text%>
symbolpluralaccess=%<text%>
descriptionaccess=%<text%>
descriptionpluralaccess=%<text%>
longaccess=%<text%>
shortaccess=%<text%>
longpluralaccess=%<text%>
shortpluralaccess=%<text%>
user1access=%<text%>
user2access=%<text%>
user3access=%<text%>
user4access=%<text%>
user5access=%<text%>
user6access=%<text%>
#endkeyvals

\glsdefaultshortaccess{long}{short}
\glsaccsupp{replacement}{content}
\xglsaccsupp{replacement}{content}#*
\glsfieldaccsupp{replacement}{content}{field}{gls-label%special}
\xglsfieldaccsupp{replacement}{content}{field}{gls-label%special}#*
\glsshortaccsupp{replacement}{content}
\glsshortplaccsupp{replacement}{content}
\glsaccessibility{tag}{value}{content}
\glsaccessibility[options]{tag}{value}{content}

\glsentryaccess{gls-label%special}#*
\glsentrytextaccess{gls-label%special}#*
\glsentryfirstaccess{gls-label%special}#*
\glsentrypluralaccess{gls-label%special}#*
\glsentryfirstpluralaccess{gls-label%special}#*
\glsentrysymbolaccess{gls-label%special}#*
\glsentrysymbolpluralaccess{gls-label%special}#*
\glsentrydescaccess{gls-label%special}#*
\glsentrydescpluralaccess{gls-label%special}#*
\glsentryshortaccess{gls-label%special}#*
\glsentryshortpluralaccess{gls-label%special}#*
\glsentrylongaccess{gls-label%special}#*
\glsentrylongpluralaccess{gls-label%special}#*
\glsentryuseriaccess{gls-label%special}#*
\glsentryuseriiaccess{gls-label%special}#*
\glsentryuseriiiaccess{gls-label%special}#*
\glsentryuserivaccess{gls-label%special}#*
\glsentryuservaccess{gls-label%special}#*
\glsentryuserviaccess{gls-label%special}#*

\glsnameaccessdisplay{text}{gls-label%special}#*
\glstextaccessdisplay{text}{gls-label%special}#*
\glspluralaccessdisplay{text}{gls-label%special}#*
\glsfirstaccessdisplay{text}{gls-label%special}#*
\glsfirstpluralaccessdisplay{text}{gls-label%special}#*
\glssymbolaccessdisplay{text}{gls-label%special}#*
\glssymbolpluralaccessdisplay{text}{gls-label%special}#*
\glsdescriptionaccessdisplay{text}{gls-label%special}#*
\glsdescriptionpluralaccessdisplay{text}{gls-label%special}#*
\glsshortaccessdisplay{text}{gls-label%special}#*
\glsshortpluralaccessdisplay{text}{gls-label%special}#*
\glslongaccessdisplay{text}{gls-label%special}#*
\glslongaccessdisplay{text}{gls-label%special}#*
\glslongpluralaccessdisplay{text}{gls-label%special}#*
\glsuseriaccessdisplay{text}{gls-label%special}#*
\glsuseriiaccessdisplay{text}{gls-label%special}#*
\glsuseriiiaccessdisplay{text}{gls-label%special}#*
\glsuserivaccessdisplay{text}{gls-label%special}#*
\glsuservaccessdisplay{text}{gls-label%special}#*
\glsuserviaccessdisplay{text}{gls-label%special}#*
\glsaccessdisplay{text}{gls-label%special}#*

\accsuppglossaryentryfield{gls-label%special}{name}{description}{symbol}{page-list}#*
\accsuppglossarysubentryfield{level}{gls-label%special}{name}{description}{symbol}{page-list}#*
\showglonameaccess{gls-label%special}#S
\showglotextaccess{gls-label%special}#S
\showglopluralaccess{gls-label%special}#S
\showglofirstaccess{gls-label%special}#S
\showglofirstaccess{gls-label%special}#S
\showglosymbolaccess{gls-label%special}#S
\showglosymbolpluralaccess{gls-label%special}#S
\showglodescaccess{gls-label%special}#S
\showglodescpluralaccess{gls-label%special}#S
\showgloshortaccess{gls-label%special}#S
\showgloshortpluralaccess{gls-label%special}#S
\showglolongaccess{gls-label%special}#S
\showglolongpluralaccess{gls-label%special}#S
