/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.regex;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"byteOffsetByCharOffset", "", "charSequence", "", "startOffset", "targetOffset", "utf8Size", "codePoint", "high", "", "low", "intellij.textmate.core"})
public final class RegexUtilKt {
    public static final int byteOffsetByCharOffset(@NotNull CharSequence charSequence, int startOffset, int targetOffset) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        if (targetOffset <= 0) {
            return 0;
        }
        int result = 0;
        for (int i = startOffset; i < targetOffset; ++i) {
            char c = charSequence.charAt(i);
            if (Character.isHighSurrogate(c) && i + 1 < charSequence.length() && Character.isLowSurrogate(charSequence.charAt(i + 1))) {
                result += RegexUtilKt.utf8Size(RegexUtilKt.codePoint(c, charSequence.charAt(i + 1)));
                ++i;
                continue;
            }
            result += RegexUtilKt.utf8Size(c);
        }
        return result;
    }

    private static final int utf8Size(int codePoint) {
        return codePoint <= 127 ? 1 : (codePoint <= 2047 ? 2 : (codePoint <= 65535 ? 3 : 4));
    }

    private static final int codePoint(char high, char low) {
        return (high - 55296 << 10 | low - 56320) + 65536;
    }
}

