/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.cli;

import com.intellij.execution.filters.Filter;
import com.intellij.javascript.CreateRunConfigurationUtil;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.VuejsIcons;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J+\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a2\u0006\u0002\u0010\u0019J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010\u001aJ#\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0005H\u0014J\b\u0010\u001f\u001a\u00020\u0005H\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010$\u001a\u00020\u0005H\u0014J\u0018\u0010%\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/vuejs/cli/NuxtProjectGenerator;", "Lcom/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator;", "<init>", "()V", "NUXT_CLI_PACKAGE_NAME", "", "CREATE_COMMAND", "getId", "getName", "getDescription", "getIcon", "Ljavax/swing/Icon;", "customizeModule", "", "baseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "entry", "Lcom/intellij/openapi/roots/ContentEntry;", "generatorArgs", "", "project", "Lcom/intellij/openapi/project/Project;", "dir", "settings", "Lcom/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings;)[Ljava/lang/String;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)[Ljava/lang/String;", "filters", "Lcom/intellij/execution/filters/Filter;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)[Lcom/intellij/execution/filters/Filter;", "packageName", "presentablePackageName", "getNpxCommands", "", "Lcom/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxCommand;", "validateProjectPath", "path", "onGettingSmartAfterProjectGeneration", "intellij.vuejs"})
public final class NuxtProjectGenerator
extends NpmPackageProjectGenerator {
    @NotNull
    private final String NUXT_CLI_PACKAGE_NAME;
    @NotNull
    private final String CREATE_COMMAND;

    public NuxtProjectGenerator() {
        this.NUXT_CLI_PACKAGE_NAME = "nuxi@latest";
        this.CREATE_COMMAND = "init";
    }

    @NotNull
    public String getId() {
        return VueBundle.message("vue.project.generator.nuxt.name", new Object[0]);
    }

    @NotNull
    public String getName() {
        return VueBundle.message("vue.project.generator.nuxt.name", new Object[0]);
    }

    @NotNull
    public String getDescription() {
        return VueBundle.message("vue.project.generator.nuxt.description", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = VuejsIcons.Nuxt;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Nuxt");
        return icon;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, @Nullable ContentEntry entry) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile dir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String[] stringArray = new String[]{this.CREATE_COMMAND, "--force", "--gitInit", "--packageManager=npm"};
        return stringArray;
    }

    @NotNull
    protected String[] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        return new String[0];
    }

    @NotNull
    protected Filter[] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        return new Filter[0];
    }

    @NotNull
    protected String packageName() {
        return this.NUXT_CLI_PACKAGE_NAME;
    }

    @NotNull
    protected String presentablePackageName() {
        return VueBundle.message("vue.project.generator.nuxt.presentable.package.name", new Object[0]);
    }

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        return CollectionsKt.listOf((Object)new NpxPackageDescriptor.NpxCommand(this.NUXT_CLI_PACKAGE_NAME, this.NUXT_CLI_PACKAGE_NAME));
    }

    @Nullable
    protected String validateProjectPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String error = NodePackageUtil.validateNpmPackageName((String)PathUtil.getFileName((String)path));
        String string = error;
        if (string == null) {
            string = super.validateProjectPath(path);
        }
        return string;
    }

    protected void onGettingSmartAfterProjectGeneration(@NotNull Project project, @NotNull VirtualFile baseDir) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        super.onGettingSmartAfterProjectGeneration(project, baseDir);
        CreateRunConfigurationUtil.debugConfiguration((Project)project, (int)3000);
        CreateRunConfigurationUtil.npmConfiguration((Project)project, (String)"dev");
    }
}

