/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ModalityUiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AuthProviderValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @Override
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    @Override
    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        if (project == null) {
            AuthProviderValidator.$$$reportNull$$$0(0);
        }
        if (target == null) {
            AuthProviderValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            AuthProviderValidator.$$$reportNull$$$0(2);
        }
        if (target.getAuthProviderId().equals("no-auth")) {
            return;
        }
        DatabaseAuthProvider current = DatabaseAuthProvider.get((DatabaseConnectionPoint)target);
        if (DatabaseAuthProvider.isPreferred((DatabaseAuthProvider)current, (DatabaseConnectionPoint)target)) {
            return;
        }
        DatabaseAuthProvider preferred = DatabaseAuthProvider.getPreferred((DatabaseConnectionPoint)target);
        if (preferred == null) {
            return;
        }
        DatabaseAuthProvider noAuth = Objects.requireNonNull(DatabaseAuthProvider.get((String)"no-auth"));
        FixWithProgress setPreferred = AuthProviderValidator.getQuickFix(project, target, preferred);
        FixWithProgress setNoAuth = AuthProviderValidator.getQuickFix(project, target, noAuth);
        DataSourceProblem.HyperText text = new DataSourceProblem.HyperText(DatabaseBundle.message((String)"notification.title.authentication", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.href.action0.preferred.or.use.href.action1", (Object[])new Object[]{preferred.getDisplayName(), noAuth.getDisplayName()}), DatabaseBundle.message((String)"notification.content.preferred", (Object[])new Object[]{preferred.getDisplayName()}), setPreferred, setNoAuth);
        DataSourceProblem problem = new DataSourceProblem(target, null, DataSourceProblem.Level.HINT, text, setPreferred);
        problems.consume((Object)problem);
    }

    @Nullable
    private static FixWithProgress getQuickFix(final @NotNull Project project, @NotNull LocalDataSource target, DatabaseAuthProvider preferred) {
        if (project == null) {
            AuthProviderValidator.$$$reportNull$$$0(3);
        }
        if (target == null) {
            AuthProviderValidator.$$$reportNull$$$0(4);
        }
        String providerId = preferred.getId();
        DatabaseFixFactory fixFactory = DatabaseFixFactory.getInstance();
        final ErrorInfo.Fix fix = fixFactory == null ? null : fixFactory.setAuthProvider(target, DatabaseBundle.message((String)"use.0.auth", (Object[])new Object[]{preferred.getDisplayName()}), providerId);
        return fix == null ? null : new FixWithProgress(fix.getName()){

            @Override
            public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor2) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> DataSourceUiUtil.applyFix(project, fix, editor2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/validation/AuthProviderValidator$1", "run"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/validation/AuthProviderValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuickFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

