/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J:\u0010\u0006\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b\"\u0006\b\u0000\u0010\t\u0018\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0014\b\u0004\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\t0\rH\u0086\b\u00f8\u0001\u0000J.\u0010\u0006\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b\"\u0006\b\u0000\u0010\t\u0018\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u0002H\tH\u0086\b\u00a2\u0006\u0002\u0010\u000fJ@\u0010\u0010\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b\"\u0006\b\u0000\u0010\t\u0018\u00012\u0006\u0010\n\u001a\u00020\u000b2\u001a\b\u0004\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\t0\u0011H\u0086\b\u00f8\u0001\u0000J7\u0010\u0012\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b\"\u0006\b\u0000\u0010\t\u0018\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0014\b\u0004\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\t0\rH\u0082\bJ8\u0010\u0013\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b\"\u0006\b\u0000\u0010\u0014\u0018\u00012\u001a\b\u0004\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u00160\rH\u0086\n\u00f8\u0001\u0000J.\u0010\u0013\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0018\"\u0004\u0018\u00010\u0001H\u0086\u0002\u00a2\u0006\u0002\u0010\u0019J:\u0010\u0013\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\"\u0010\u001a\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u00030\u001bj\u0002`\u001c0\u0018\"\n\u0012\u0002\b\u00030\u001bj\u0002`\u001cH\u0086\u0002\u00a2\u0006\u0002\u0010\u001dJ'\u0010\u0013\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0014\u0010\u001a\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u001bj\u0002`\u001c0\u0016H\u0086\u0002J!\u0010\u0013\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001fH\u0086\u0002J!\u0010 \u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b\"\u0006\b\u0000\u0010\t\u0018\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0086\bJ\u0016\u0010!\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\"\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\"\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u0016\u0010&\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010'\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010'\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020(J\u0016\u0010)\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010)\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020*0$J*\u0010+\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u001a\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u00030\u001bj\u0002`\u001c0\rJ%\u0010-\u001a\n\u0012\u0002\b\u00030\u0007j\u0002`\b2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016H\u0001\u00a2\u0006\u0002\b.R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlinx/dataframe/api/DataFrameBuilder;", "", "header", "", "", "(Ljava/util/List;)V", "fill", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "C", "nrow", "", "init", "Lkotlin/Function1;", "value", "(ILjava/lang/Object;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "fillIndexed", "Lkotlin/Function2;", "fillNotNull", "invoke", "T", "valuesBuilder", "", "values", "", "([Ljava/lang/Object;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "columns", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "([Lorg/jetbrains/kotlinx/dataframe/DataColumn;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "args", "Lkotlin/sequences/Sequence;", "nulls", "randomBoolean", "randomDouble", "range", "Lkotlin/ranges/ClosedRange;", "", "randomFloat", "randomInt", "Lkotlin/ranges/IntRange;", "randomLong", "", "withColumns", "columnBuilder", "withValues", "invoke1", "core"})
@SourceDebugExtension(value={"SMAP\nconstructors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 constructors.kt\norg/jetbrains/kotlinx/dataframe/api/DataFrameBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,440:1\n344#1,7:461\n369#1,7:468\n369#1,7:475\n369#1,7:482\n369#1,7:489\n369#1,7:496\n369#1,7:503\n369#1,7:510\n369#1,7:517\n1#2:441\n1559#3:442\n1590#3,4:443\n1549#3:447\n1620#3,2:448\n1549#3:450\n1620#3,3:451\n1622#3:454\n1549#3:457\n1620#3,3:458\n37#4,2:455\n*S KotlinDebug\n*F\n+ 1 constructors.kt\norg/jetbrains/kotlinx/dataframe/api/DataFrameBuilder\n*L\n352#1:461,7\n377#1:468,7\n379#1:475,7\n381#1:482,7\n384#1:489,7\n386#1:496,7\n388#1:503,7\n391#1:510,7\n393#1:517,7\n303#1:442\n303#1:443,4\n322#1:447\n322#1:448,2\n323#1:450\n323#1:451,3\n322#1:454\n332#1:457\n332#1:458,3\n330#1:455,2\n*E\n"})
public final class DataFrameBuilder {
    @NotNull
    private final List<String> header;

    public DataFrameBuilder(@NotNull List<String> header) {
        Intrinsics.checkNotNullParameter(header, (String)"header");
        this.header = header;
    }

    @NotNull
    public final DataFrame<?> invoke(DataColumn<?> ... columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return this.invoke(ArraysKt.asIterable((Object[])columns2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame<?> invoke(@NotNull Iterable<? extends DataColumn<?>> columns2) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        List<DataColumn<?>> cols2 = UtilsKt.asList(columns2);
        if (!(cols2.size() == this.header.size())) {
            boolean $i$a$-require-DataFrameBuilder$invoke$22 = false;
            String $i$a$-require-DataFrameBuilder$invoke$22 = "Number of columns differs from number of column names";
            throw new IllegalArgumentException($i$a$-require-DataFrameBuilder$invoke$22.toString());
        }
        Iterable $this$mapIndexed$iv = cols2;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void col2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(col2.rename(this.header.get((int)i)));
        }
        return ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
    }

    @NotNull
    public final DataFrame<?> invoke(Object ... values2) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        return this.invoke1(ArraysKt.asIterable((Object[])values2));
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="invoke1")
    @NotNull
    public final DataFrame<?> invoke1(@NotNull Iterable<? extends Object> values2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        List<? extends Object> list = UtilsKt.asList(values2);
        int ncol = this.header.size();
        if (!(!((Collection)this.header).isEmpty() && list.size() % ncol == 0)) {
            boolean $i$a$-require-DataFrameBuilder$withValues$22 = false;
            String $i$a$-require-DataFrameBuilder$withValues$22 = "Number of values " + list.size() + " is not divisible by number of columns " + ncol;
            throw new IllegalArgumentException($i$a$-require-DataFrameBuilder$withValues$22.toString());
        }
        int nrow = list.size() / ncol;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)ncol);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void col2;
            void $this$mapTo$iv$iv2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)RangesKt.until((int)0, (int)nrow);
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator3 = $this$mapTo$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                void row;
                int item$iv$iv2;
                int n2 = item$iv$iv2 = ((IntIterator)iterator3).nextInt();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(list.get((int)(row * ncol + col2)));
            }
            List colValues = (List)destination$iv$iv2;
            collection.add(DataColumn.Companion.createWithTypeInference$default(DataColumn.Companion, this.header.get((int)col2), colValues, null, 4, null));
        }
        return ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
    }

    @NotNull
    public final DataFrame<?> invoke(@NotNull Sequence<? extends Object> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Collection $this$toTypedArray$iv = SequencesKt.toList(args);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        return this.invoke(Arrays.copyOf(objectArray, objectArray.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame<?> withColumns(@NotNull Function1<? super String, ? extends DataColumn<?>> columnBuilder) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(columnBuilder, (String)"columnBuilder");
        Iterable $this$map$iv = this.header;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(columnBuilder.invoke(item$iv$iv));
        }
        return ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
    }

    public final /* synthetic */ <T> DataFrame<?> invoke(Function1<? super String, ? extends Iterable<? extends T>> valuesBuilder) {
        Intrinsics.checkNotNullParameter(valuesBuilder, (String)"valuesBuilder");
        boolean $i$f$invoke = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(valuesBuilder){
            final /* synthetic */ Function1<String, Iterable<T>> $valuesBuilder;
            {
                this.$valuesBuilder = $valuesBuilder;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                void values$iv;
                void $this$iv;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Iterable it = (Iterable)this.$valuesBuilder.invoke((Object)name);
                boolean bl = false;
                DataColumn.Companion companion = DataColumn.Companion;
                List<T> list = UtilsKt.asList(it);
                Infer infer$iv = Infer.None;
                boolean $i$f$create = false;
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                return $this$iv.create(name, values$iv, (KType)null, infer$iv);
            }
        });
    }

    public final /* synthetic */ <C> DataFrame<?> fill(int nrow, C value) {
        boolean $i$f$fill = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, value){
            final /* synthetic */ int $nrow;
            final /* synthetic */ C $value;
            {
                this.$nrow = $nrow;
                this.$value = $value;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                ArrayList<C> arrayList;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                C c = this.$value;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<C> arrayList2 = new ArrayList<C>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl = false;
                    arrayList.add(c);
                }
                arrayList = arrayList2;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C");
                return DataColumn.Companion.createValueColumn$default(companion, string, arrayList, KTypes.withNullability(null, (this.$value == null ? 1 : 0) != 0), null, null, 24, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <C> DataFrame<?> nulls(int nrow) {
        void this_$iv;
        boolean $i$f$nulls = false;
        DataFrameBuilder dataFrameBuilder = this;
        Object value$iv = null;
        boolean $i$f$fill = false;
        Intrinsics.needClassReification();
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, value$iv){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Object $value;
            {
                this.$nrow = $nrow;
                this.$value = $value;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                ArrayList<Object> arrayList;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Object object = this.$value;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl = false;
                    arrayList.add(object);
                }
                arrayList = arrayList2;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C?");
                return DataColumn.Companion.createValueColumn$default(companion, string, arrayList, KTypes.withNullability(null, (this.$value == null ? 1 : 0) != 0), null, null, 24, null);
            }
        });
    }

    public final /* synthetic */ <C> DataFrame<?> fillIndexed(int nrow, Function2<? super Integer, ? super String, ? extends C> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$fillIndexed = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, init){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Function2<Integer, String, C> $init;
            {
                this.$nrow = $nrow;
                this.$init = $init;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                void $this$iv;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                DataColumn.Companion companion = DataColumn.Companion;
                int n = this.$nrow;
                Function2<Integer, String, C> function2 = this.$init;
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Object> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(function2.invoke((Object)((int)it), (Object)name));
                }
                List values$iv = arrayList;
                Infer infer$iv = Infer.None;
                boolean $i$f$create = false;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C");
                return $this$iv.create(name, values$iv, null, infer$iv);
            }
        });
    }

    public final /* synthetic */ <C> DataFrame<?> fill(int nrow, Function1<? super Integer, ? extends C> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$fill = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, init){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Function1<Integer, C> $init;
            {
                this.$nrow = $nrow;
                this.$init = $init;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                void $this$iv;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                DataColumn.Companion companion = DataColumn.Companion;
                int n = this.$nrow;
                Function1<Integer, C> function1 = this.$init;
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2++;
                    arrayList.add(function1.invoke((Object)n3));
                }
                List values$iv = arrayList;
                Infer infer$iv = Infer.None;
                boolean $i$f$create = false;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C");
                return $this$iv.create(name, values$iv, null, infer$iv);
            }
        });
    }

    private final /* synthetic */ <C> DataFrame<?> fillNotNull(int nrow, Function1<? super Integer, ? extends C> init) {
        boolean $i$f$fillNotNull = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, init){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Function1<Integer, C> $init;
            {
                this.$nrow = $nrow;
                this.$init = $init;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Function1<Integer, C> function1 = this.$init;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2++;
                    arrayList.add(function1.invoke((Object)n3));
                }
                List list = arrayList;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C");
                return DataColumn.Companion.createValueColumn$default(companion, string, list, null, null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomInt(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Integer> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextInt());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Integer.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomInt(int nrow, @NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, range){
            final /* synthetic */ int $nrow;
            final /* synthetic */ IntRange $range$inlined;
            {
                this.$nrow = $nrow;
                this.$range$inlined = intRange;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Integer> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)this.$range$inlined));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Integer.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomDouble(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Double> arrayList = new ArrayList<Double>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Double> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextDouble());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Double.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomDouble(int nrow, @NotNull ClosedRange<Double> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, range){
            final /* synthetic */ int $nrow;
            final /* synthetic */ ClosedRange $range$inlined;
            {
                this.$nrow = $nrow;
                this.$range$inlined = closedRange;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Double> arrayList = new ArrayList<Double>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Double> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextDouble(((Number)((Object)this.$range$inlined.getStart())).doubleValue(), ((Number)((Object)this.$range$inlined.getEndInclusive())).doubleValue()));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Double.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomFloat(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Float> arrayList = new ArrayList<Float>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Float> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Float.valueOf(Random.Default.nextFloat()));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Float.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomLong(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Long> arrayList = new ArrayList<Long>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Long> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextLong());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Long.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomLong(int nrow, @NotNull ClosedRange<Long> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, range){
            final /* synthetic */ int $nrow;
            final /* synthetic */ ClosedRange $range$inlined;
            {
                this.$nrow = $nrow;
                this.$range$inlined = closedRange;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Long> arrayList = new ArrayList<Long>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Long> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextLong(((Number)((Object)this.$range$inlined.getStart())).longValue(), ((Number)((Object)this.$range$inlined.getEndInclusive())).longValue()));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Long.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomBoolean(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
                super(1);
            }

            @NotNull
            public final DataColumn<?> invoke(@NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Boolean> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextBoolean());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Boolean.TYPE), null, null, 24, null);
            }
        });
    }
}

