/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasDefinedTypeClass;
import com.intellij.database.util.DasUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0014\u0010\u0007\u001a\u000e\u0018\u00010\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0014\u0010\u000b\u001a\u000e\u0018\u00010\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0012\u0010\f\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/types/DasDefinedTypeClassImpl;", "Lcom/intellij/database/types/DasDefinedTypeClass;", "definition", "Lcom/intellij/database/model/DasUserDefinedType;", "<init>", "(Lcom/intellij/database/model/DasUserDefinedType;)V", "getDefinition", "getSchemaName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getPackageName", "getName", "equals", "", "other", "", "hashCode", "", "intellij.database.core.impl"})
public final class DasDefinedTypeClassImpl
implements DasDefinedTypeClass {
    @NotNull
    private final DasUserDefinedType definition;

    public DasDefinedTypeClassImpl(@NotNull DasUserDefinedType definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        this.definition = definition;
    }

    @Override
    @NotNull
    public DasUserDefinedType getDefinition() {
        return this.definition;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        DasObject dasObject = DasUtil.getSchemaObject(this.definition);
        return dasObject != null ? dasObject.getName() : null;
    }

    @Override
    @Nullable
    public String getPackageName() {
        DasObject dasObject = DasUtil.getParentOfKind(this.definition, ObjectKind.PACKAGE, true);
        return dasObject != null ? dasObject.getName() : null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.definition.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DasDefinedTypeClassImpl)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.definition, (Object)((DasDefinedTypeClassImpl)other).definition);
    }

    public int hashCode() {
        return this.definition.hashCode();
    }
}

