/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicReferenceInfoImpl<S extends BasicElement, T extends BasicElement>
implements BasicReferenceInfo<T> {
    private final S mySource;
    private final BasicResolveAssistant myResolveAssistant;
    private Object myRefDesc;
    private final BasicReference myReference;
    private Object myTargetCache;

    public BasicReferenceInfoImpl(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> desc, @NotNull BasicReference reference, @NotNull BasicResolveAssistant resolveAssistant) {
        if (source == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(0);
        }
        if (desc == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(2);
        }
        if (resolveAssistant == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(3);
        }
        this.mySource = source;
        this.myRefDesc = desc;
        this.myReference = reference;
        this.myResolveAssistant = resolveAssistant;
    }

    public BasicReferenceInfoImpl(@NotNull S source, @NotNull BasicMetaReferenceId<T> metaRefId, @NotNull BasicReference reference, @NotNull BasicResolveAssistant resolveAssistant) {
        if (source == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(4);
        }
        if (metaRefId == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(5);
        }
        if (reference == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(6);
        }
        if (resolveAssistant == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(7);
        }
        this.mySource = source;
        this.myRefDesc = metaRefId;
        this.myReference = reference;
        this.myResolveAssistant = resolveAssistant;
    }

    @NotNull
    public S getSource() {
        S s = this.mySource;
        if (s == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(8);
        }
        return s;
    }

    @Override
    @NotNull
    public JBIterable<T> getTargets() {
        JBIterable<T> jBIterable = this.myReference.multiResolve(this.mySource, this.getReferenceDesc(), this.myResolveAssistant);
        if (jBIterable == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @Override
    @Nullable
    public T getTarget() {
        if (this.myTargetCache == null) {
            return this.resolve();
        }
        return this.getCachedTarget();
    }

    @Override
    @Nullable
    public T getInlineData() {
        return this.myReference.getInlineData(this.getReferenceDesc());
    }

    @Override
    @Nullable
    public T getTargetOrInlineData() {
        T data = this.getInlineData();
        return data == null ? this.getTarget() : data;
    }

    @Nullable
    private T getCachedTarget() {
        if (this.myTargetCache == ObjectUtils.NULL) {
            return null;
        }
        return (T)((BasicElement)this.myTargetCache);
    }

    @Override
    @Nullable
    public T resolve() {
        T res = BasicMetaUtils.resolve(this.mySource, this.getReferenceDesc(), this.myReference, this.myResolveAssistant);
        this.myTargetCache = res == null ? ObjectUtils.NULL : res;
        return res;
    }

    @Override
    @NotNull
    public BasicMetaReferenceDesc<S, T> getReferenceDesc() {
        if (this.myRefDesc instanceof BasicMetaReferenceId) {
            BasicMetaReference<S, T> metaRef = this.asMetaRefId().find(this.mySource);
            this.myRefDesc = metaRef == null ? null : metaRef.getReferenceDesc();
        }
        return this.asRefDesc();
    }

    @NotNull
    private BasicMetaReferenceId<T> asMetaRefId() {
        BasicMetaReferenceId basicMetaReferenceId = (BasicMetaReferenceId)this.myRefDesc;
        if (basicMetaReferenceId == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(10);
        }
        return basicMetaReferenceId;
    }

    @NotNull
    private BasicMetaReferenceDesc<S, T> asRefDesc() {
        BasicMetaReferenceDesc basicMetaReferenceDesc = (BasicMetaReferenceDesc)this.myRefDesc;
        if (basicMetaReferenceDesc == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(11);
        }
        return basicMetaReferenceDesc;
    }

    @Override
    @NotNull
    public BasicReference getReference() {
        BasicReference basicReference = this.myReference;
        if (basicReference == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(12);
        }
        return basicReference;
    }

    @Override
    @Nullable
    public String getName() {
        return this.myReference.getName((BasicElement)this.getTarget());
    }

    @Override
    @Nullable
    public String getNameLighter() {
        String name2 = this.myReference.getName();
        if (name2 != null) {
            return name2;
        }
        return this.getName();
    }

    @Override
    @Nullable
    public String getParentName(int d) {
        T target2 = this.getTarget();
        if (target2 == null) {
            return this.myReference.getParentName(d);
        }
        Object tmp = target2;
        for (int i2 = 0; i2 < d && tmp != null; tmp = tmp.getParent(), ++i2) {
        }
        return tmp == null ? null : tmp.getName();
    }

    @Override
    public boolean isEquivalent(@Nullable BasicReferenceInfo<?> other) {
        return this.isEquivalent((BasicReferenceInfoImpl)other);
    }

    @Override
    public boolean matches(@NotNull BasicElement target2) {
        BasicMetaReferenceDesc<S, T> desc;
        T casted;
        if (target2 == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(13);
        }
        return (casted = (desc = this.getReferenceDesc()).tryCast(target2)) != null && this.myReference.matches(this.mySource, desc, casted);
    }

    @Override
    @NotNull
    public BasicReferenceInfo<T> with(@NotNull BasicReference ref) {
        if (ref == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(14);
        }
        return new BasicReferenceInfoImpl<S, T>(this.mySource, this.getReferenceDesc(), ref, this.myResolveAssistant);
    }

    @Override
    @NotNull
    public BasicReferenceInfo<T> withAssistant(@NotNull BasicResolveAssistant resolveAssistant) {
        if (resolveAssistant == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(15);
        }
        return new BasicReferenceInfoImpl<S, T>(this.mySource, this.getReferenceDesc(), this.myReference, resolveAssistant);
    }

    @Override
    @NotNull
    public <T2 extends BasicElement> BasicReferenceInfo<T2> dummyJoin(@NotNull BasicMetaReferenceDesc<T, T2> desc, @NotNull BasicReference ref) {
        if (desc == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(16);
        }
        if (ref == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(17);
        }
        return new BasicReferenceInfoImpl<S, T2>(this.getSource(), this.getReferenceDesc().dummyJoin(desc), ref, this.myResolveAssistant);
    }

    @Override
    public <T2 extends BasicElement> BasicReferenceInfo<T2> tryCast(@NotNull Class<T2> clazz) {
        if (clazz == null) {
            BasicReferenceInfoImpl.$$$reportNull$$$0(18);
        }
        return this.getReferenceDesc().tryCast(clazz) == null ? null : this;
    }

    private <S2 extends BasicElement, T2 extends BasicElement> boolean isEquivalent(@Nullable BasicReferenceInfoImpl<S2, T2> other) {
        if (other == null) {
            return false;
        }
        return BasicMetaUtils.isEquivalent(this.getSource(), this.getReferenceDesc(), this.getReference(), other.getSource(), other.getReferenceDesc(), other.getReference());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveAssistant";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaRefId";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicReferenceInfoImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicReferenceInfoImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "asMetaRefId";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asRefDesc";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withAssistant";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "dummyJoin";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

