/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.LengthUnit;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class DataType
implements Serializable {
    public static final int MAX_SIZE = Integer.MAX_VALUE;
    public static final int STAR_SIZE = 0x7FFFFFFE;
    public static final int NO_SIZE = -1;
    public static final int NO_SCALE = 0;
    public static final DataType UNKNOWN = new DataType(null, null, "unknown", -1, 0, LengthUnit.NONE, false, null, null, null, false, 0);
    @Nullable
    public final String schemaName;
    @Nullable
    public final String packageName;
    @NlsSafe
    @NotNull
    public final String typeName;
    public final int size;
    public final int scale;
    @NotNull
    public final LengthUnit sizeUnit;
    public final String vagueArg;
    @Nullable
    public final String suffix;
    public final boolean sizeUnitExplicit;
    public final boolean custom;
    @Nullable
    public final List<String> enumValues;
    private final int hashCode;
    @Deprecated(forRemoval=true)
    public final int jdbcType;

    private DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, boolean sizeUnitExplicit, @Nullable String vagueArg, @Nullable String suffix, boolean custom, @Nullable List<String> enumValues, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(0);
        }
        this.schemaName = DbUtil.intern2(schemaName);
        this.packageName = DbUtil.intern2(packageName);
        this.typeName = DbUtil.intern2(typeName);
        boolean notASize = size == -1 || size == 0x7FFFFFFE || size == Integer.MAX_VALUE;
        this.size = size;
        this.scale = notASize ? 0 : scale;
        this.sizeUnit = sizeUnit != null && !notASize ? sizeUnit : LengthUnit.NONE;
        this.vagueArg = DbUtil.intern2(StringUtil.nullize((String)vagueArg));
        this.suffix = DbUtil.intern2(StringUtil.nullize((String)suffix));
        this.custom = custom;
        this.sizeUnitExplicit = sizeUnitExplicit && this.sizeUnit != LengthUnit.NONE;
        this.jdbcType = jdbcType;
        this.enumValues = enumValues == null || enumValues.isEmpty() ? null : List.copyOf(enumValues);
        this.hashCode = this.calculateHashCode();
    }

    public DataType(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, boolean sizeUnitExplicit, @Nullable String suffix, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(1);
        }
        this(schemaName, null, typeName, size, scale, sizeUnit, sizeUnitExplicit, null, suffix, custom, null, jdbcType);
    }

    public DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, boolean sizeUnitExplicit, @Nullable String vagueArg, @Nullable @Unmodifiable List<String> enumValues, @Nullable String suffix, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(2);
        }
        this(schemaName, packageName, typeName, size, scale, sizeUnit, sizeUnitExplicit, vagueArg, suffix, custom, enumValues, jdbcType);
    }

    public DataType(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(3);
        }
        this(schemaName, null, typeName, -1, 0, null, false, vagueArg, null, custom, null, jdbcType);
    }

    public DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @Nullable String vagueArg, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(4);
        }
        this(schemaName, packageName, typeName, -1, 0, null, false, vagueArg, null, custom, null, jdbcType);
    }

    public DataType(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, boolean custom, @Nullable List<String> enumValues, int jdbcType) {
        if (typeName == null) {
            DataType.$$$reportNull$$$0(5);
        }
        this(schemaName, packageName, typeName, -1, 0, null, false, null, null, custom, enumValues, jdbcType);
    }

    @NlsSafe
    @NotNull
    public String getSpecification() {
        String string = this.getSpecification(false, false);
        if (string == null) {
            DataType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getSpecification(boolean forceDefaults, boolean onlyNumbers) {
        String string = this.getSpecification(forceDefaults, onlyNumbers, true);
        if (string == null) {
            DataType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getSpecification(boolean forceDefaults, boolean onlyNumbers, boolean withSchema) {
        boolean nothingSpecial;
        boolean bl = nothingSpecial = this.vagueArg == null && this.enumValues == null && this.size < 0 && this.suffix == null;
        if (this.schemaName == null && this.packageName == null && nothingSpecial) {
            String string = this.typeName;
            if (string == null) {
                DataType.$$$reportNull$$$0(8);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder(12);
        if (withSchema && this.schemaName != null) {
            sb.append(this.schemaName).append('.');
        }
        if (this.packageName != null) {
            sb.append(this.packageName).append('.');
        }
        sb.append(this.typeName);
        if (nothingSpecial) {
            String string = sb.toString();
            if (string == null) {
                DataType.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (this.vagueArg != null) {
            sb.append('(').append(this.vagueArg).append(')');
        } else if (this.enumValues != null) {
            sb.append('(');
            StringUtil.join(this.enumValues, (String)", ", (StringBuilder)sb);
            sb.append(')');
        } else if (this.size >= 0) {
            sb.append('(');
            if (!onlyNumbers && this.size == 0x7FFFFFFE) {
                sb.append('*');
            } else if (!onlyNumbers && this.size == Integer.MAX_VALUE) {
                sb.append("max");
            } else {
                sb.append(this.size);
            }
            if (this.scale != 0) {
                sb.append(',').append(this.scale);
            }
            if (this.sizeUnit != LengthUnit.NONE && (this.sizeUnit != LengthUnit.DIGIT && this.sizeUnitExplicit || forceDefaults)) {
                sb.append(' ').append(StringUtil.toLowerCase((String)this.sizeUnit.suffix));
            }
            sb.append(')');
        } else if (forceDefaults) {
            sb.append("()");
        }
        if (this.suffix != null) {
            sb.append(' ').append(this.suffix);
        }
        String string = sb.toString();
        if (string == null) {
            DataType.$$$reportNull$$$0(10);
        }
        return string;
    }

    public int getLength() {
        return this.size;
    }

    public int getPrecision() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        return this.equals((DataType)that);
    }

    public boolean equals(@NotNull DataType that) {
        if (that == null) {
            DataType.$$$reportNull$$$0(11);
        }
        return this.hashCode == that.hashCode && this.equalsWithoutJdbc(that) && this.jdbcType == that.jdbcType;
    }

    private boolean equalsWithoutJdbc(@NotNull DataType that) {
        if (that == null) {
            DataType.$$$reportNull$$$0(12);
        }
        if (this == that) {
            return true;
        }
        if (this.size != that.size) {
            return false;
        }
        if (this.scale != that.scale) {
            return false;
        }
        if (this.sizeUnit != that.sizeUnit) {
            return false;
        }
        if (this.custom != that.custom) {
            return false;
        }
        if (this.sizeUnitExplicit != that.sizeUnitExplicit) {
            return false;
        }
        if (!Objects.equals(this.schemaName, that.schemaName)) {
            return false;
        }
        if (!Objects.equals(this.packageName, that.packageName)) {
            return false;
        }
        if (!Objects.equals(this.vagueArg, that.vagueArg)) {
            return false;
        }
        if (!Objects.equals(this.typeName, that.typeName)) {
            return false;
        }
        if (!Objects.equals(this.suffix, that.suffix)) {
            return false;
        }
        return Comparing.equal(this.enumValues, that.enumValues);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result2 = this.schemaName != null ? this.schemaName.hashCode() : 0;
        result2 = this.packageName != null ? 31 * result2 + this.packageName.hashCode() : result2;
        result2 = 31 * result2 + this.typeName.hashCode();
        result2 = 31 * result2 + this.size;
        result2 = 31 * result2 + this.scale;
        result2 = 31 * result2 + this.sizeUnit.hashCode();
        result2 = 31 * result2 + (this.vagueArg != null ? this.vagueArg.hashCode() : 0);
        result2 = 31 * result2 + (this.suffix != null ? this.suffix.hashCode() : 0);
        result2 = 31 * result2 + (this.sizeUnitExplicit ? 1 : 0);
        result2 = 31 * result2 + (this.custom ? 1 : 0);
        result2 = 31 * result2 + (this.enumValues != null ? this.enumValues.hashCode() : 0);
        result2 = 31 * result2 + this.jdbcType;
        return result2;
    }

    public String toString() {
        return this.getSpecification();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/DataType";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/DataType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithoutJdbc";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

