/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactLoader;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqliteTempDirParamProvider
implements ConsoleConfigurationParamProvider {
    @Override
    public void populate(@NotNull LocalDataSource dataSource, @NotNull ParametersList params, @NotNull Map<String, String> env) {
        if (dataSource == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(0);
        }
        if (params == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(1);
        }
        if (env == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(2);
        }
        if (dataSource.getDbms() != Dbms.SQLITE) {
            return;
        }
        if (Boolean.FALSE.equals(DbOptionProvider.getOptionValue(dataSource, Option.class))) {
            return;
        }
        DatabaseArtifactList.ArtifactVersion artifact = SqliteTempDirParamProvider.getSqliteArtifact(dataSource);
        String jarPath = artifact == null ? null : SqliteTempDirParamProvider.getSqliteJarPath(dataSource);
        File jarFile = jarPath == null ? new File("xerial") : new File(URLUtil.urlToPath((String)jarPath));
        File path = new File(DatabaseArtifactLoader.getInstance().getUnpackedPath(jarFile, artifact), "libs");
        FileUtil.createDirectory((File)path);
        params.addProperty("org.sqlite.tmpdir", path.getAbsolutePath());
    }

    @Nullable
    private static String getSqliteJarPath(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(3);
        }
        return (String)JBIterable.from(dataSource.getClasspathElements()).flatten(e -> e.getClassesRootUrls()).find(p2 -> {
            String name2 = PathUtil.getFileName((String)p2);
            return StringUtil.containsIgnoreCase((String)name2, (String)"sqlite") || StringUtil.containsIgnoreCase((String)name2, (String)"xerial");
        });
    }

    @Nullable
    private static DatabaseArtifactList.ArtifactVersion getSqliteArtifact(@NotNull LocalDataSource dataSource) {
        DatabaseDriver driver;
        DatabaseDriver.ArtifactRef ar;
        if (dataSource == null) {
            SqliteTempDirParamProvider.$$$reportNull$$$0(4);
        }
        DatabaseDriver.ArtifactRef artifactRef = ar = (driver = dataSource.getDatabaseDriver()) == null ? null : (DatabaseDriver.ArtifactRef)ContainerUtil.find(driver.getArtifacts(), a -> a.getId().equals("Xerial SQLiteJDBC"));
        if (ar == null || ar.getArtifactVersion() == null) {
            return null;
        }
        DatabaseArtifactList.Artifact artifact = new DatabaseArtifactList.Artifact(ar.getId(), ar.getId());
        return new DatabaseArtifactList.ArtifactVersion(artifact, ar.getArtifactVersion(), Collections.emptyList(), Collections.emptyMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/sqlite/SqliteTempDirParamProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSqliteJarPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSqliteArtifact";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Option
    extends DbOptionProvider.LocalDataSourceOptionProvider<Boolean> {
        private static final String KEY = "sqlite.override.lib.location";

        @Override
        public boolean isApplicable(@NotNull LocalDataSource dataSource) {
            if (dataSource == null) {
                Option.$$$reportNull$$$0(0);
            }
            return dataSource.getDbms() == Dbms.SQLITE;
        }

        @Override
        @Nls
        public String getDisplayName() {
            return "Override native lib location";
        }

        @Override
        @Nls
        public String getDescription() {
            return "Use IDE system folder to unpack native library instead of temp";
        }

        @Override
        public Boolean load(@Nullable LocalDataSource dataSource) {
            String v;
            String string = v = dataSource == null ? null : dataSource.getAdditionalProperty(KEY);
            if (v == null) {
                return Option.getDefault();
            }
            return !"false".equals(v);
        }

        @Override
        public void store(@NotNull LocalDataSource dataSource, Boolean value) {
            if (dataSource == null) {
                Option.$$$reportNull$$$0(1);
            }
            dataSource.setAdditionalProperty(KEY, Boolean.valueOf(!Option.getDefault()).equals(value) ? value.toString() : null);
        }

        @Override
        @NotNull
        public DbOptionProvider.UiLocation getLocation() {
            DbOptionProvider.UiLocation uiLocation = DbOptionProvider.UiLocation.EXPERT;
            if (uiLocation == null) {
                Option.$$$reportNull$$$0(2);
            }
            return uiLocation;
        }

        private static boolean getDefault() {
            return true;
        }

        @Override
        public DbOptionProvider.EditorDesc<Boolean> getEditor(LocalDataSource target2, @NotNull DataContext dataContext) {
            if (dataContext == null) {
                Option.$$$reportNull$$$0(3);
            }
            return DbOptionProvider.getCheckBox(Option.getDefault());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/sqlite/SqliteTempDirParamProvider$Option";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/sqlite/SqliteTempDirParamProvider$Option";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "store";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditor";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

