/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.WarningInfo;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataAuditor {
    default public void print(@NotNull DataRequest.Context context, @NlsContexts.NotificationContent @Nullable String message) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(0);
        }
    }

    default public void print(@NotNull DataRequest.Context context, @NlsContexts.NotificationContent @Nullable String message, @Nullable String messageId) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(1);
        }
        this.print(context, message);
    }

    default public void warn(@NotNull DataRequest.Context context, @NotNull WarningInfo warningInfo) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(2);
        }
        if (warningInfo == null) {
            DataAuditor.$$$reportNull$$$0(3);
        }
    }

    default public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(4);
        }
        if (errorInfo == null) {
            DataAuditor.$$$reportNull$$$0(5);
        }
    }

    default public void beforeStatement(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(6);
        }
    }

    default public void afterStatement(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(7);
        }
    }

    default public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(8);
        }
    }

    default public void fetchStarted(@NotNull DataRequest.Context context, int index) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(9);
        }
    }

    default public void fetchFinished(@NotNull DataRequest.Context context, int index, int rowCount) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(10);
        }
    }

    default public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(11);
        }
    }

    default public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(12);
        }
    }

    default public void txCompleted(@NotNull DataRequest.Context context, @NotNull TxEvent event) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(13);
        }
        if (event == null) {
            DataAuditor.$$$reportNull$$$0(14);
        }
    }

    default public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            DataAuditor.$$$reportNull$$$0(15);
        }
        if (producer == null) {
            DataAuditor.$$$reportNull$$$0(16);
        }
    }

    default public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
        if (request == null) {
            DataAuditor.$$$reportNull$$$0(17);
        }
        if (producer == null) {
            DataAuditor.$$$reportNull$$$0(18);
        }
    }

    default public void requestCancelStarted(@NotNull DataRequest.Context context, @Nullable DataRequest.Cancel cancelRequest) {
        if (context == null) {
            DataAuditor.$$$reportNull$$$0(19);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/datagrid/DataAuditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "print";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "warn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "afterStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCountReceived";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchStarted";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "fetchFinished";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "requestStarted";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "requestFinished";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "txCompleted";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "jobSubmitted";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "jobFinished";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "requestCancelStarted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Wrapper
    implements DataAuditor {
        public final DataAuditor delegate;

        public Wrapper(DataAuditor delegate) {
            this.delegate = delegate;
        }

        public boolean accepts(DataRequest.Owner owner) {
            return true;
        }

        protected boolean accepts(DataRequest.Context context) {
            return this.accepts(context.request.owner);
        }

        @Override
        public void print(@NotNull DataRequest.Context context, @Nullable String message) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            if (this.accepts(context)) {
                this.delegate.print(context, message);
            }
        }

        @Override
        public void warn(@NotNull DataRequest.Context context, @NotNull WarningInfo warningInfo) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(1);
            }
            if (warningInfo == null) {
                Wrapper.$$$reportNull$$$0(2);
            }
            if (this.accepts(context)) {
                this.delegate.warn(context, warningInfo);
            }
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(3);
            }
            if (errorInfo == null) {
                Wrapper.$$$reportNull$$$0(4);
            }
            if (this.accepts(context)) {
                this.delegate.error(context, errorInfo);
            }
        }

        @Override
        public void beforeStatement(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(5);
            }
            if (this.accepts(context)) {
                this.delegate.beforeStatement(context);
            }
        }

        @Override
        public void afterStatement(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(6);
            }
            if (this.accepts(context)) {
                this.delegate.afterStatement(context);
            }
        }

        @Override
        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(7);
            }
            if (this.accepts(context)) {
                this.delegate.requestStarted(context);
            }
        }

        @Override
        public void updateCountReceived(@NotNull DataRequest.Context context, int updateCount2) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(8);
            }
            if (this.accepts(context)) {
                this.delegate.updateCountReceived(context, updateCount2);
            }
        }

        @Override
        public void fetchStarted(@NotNull DataRequest.Context context, int index) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(9);
            }
            if (this.accepts(context)) {
                this.delegate.fetchStarted(context, index);
            }
        }

        @Override
        public void fetchFinished(@NotNull DataRequest.Context context, int index, int rowCount) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(10);
            }
            if (this.accepts(context)) {
                this.delegate.fetchFinished(context, index, rowCount);
            }
        }

        @Override
        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(11);
            }
            if (this.accepts(context)) {
                this.delegate.requestFinished(context);
            }
        }

        @Override
        public void txCompleted(@NotNull DataRequest.Context context, @NotNull TxEvent event) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(12);
            }
            if (event == null) {
                Wrapper.$$$reportNull$$$0(13);
            }
            if (this.accepts(context)) {
                this.delegate.txCompleted(context, event);
            }
        }

        @Override
        public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                Wrapper.$$$reportNull$$$0(14);
            }
            if (producer == null) {
                Wrapper.$$$reportNull$$$0(15);
            }
            if (this.accepts(request.getOwner())) {
                this.delegate.jobSubmitted(request, producer);
            }
        }

        @Override
        public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
            if (request == null) {
                Wrapper.$$$reportNull$$$0(16);
            }
            if (producer == null) {
                Wrapper.$$$reportNull$$$0(17);
            }
            if (this.accepts(request.getOwner())) {
                this.delegate.jobFinished(request, producer);
            }
        }

        @Override
        public void requestCancelStarted(@NotNull DataRequest.Context context, @Nullable DataRequest.Cancel cancelRequest) {
            if (context == null) {
                Wrapper.$$$reportNull$$$0(18);
            }
            if (this.accepts(context)) {
                this.delegate.requestCancelStarted(context, cancelRequest);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "warningInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/datagrid/DataAuditor$Wrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warn";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCountReceived";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchStarted";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchFinished";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "txCompleted";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobSubmitted";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jobFinished";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestCancelStarted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum TxEvent {
        COMPLETED(true, false),
        REVERTED(false, true),
        OWNER_DISPOSAL(false, false);

        public final boolean completed;
        public final boolean reverted;

        private TxEvent(boolean completed, boolean reverted) {
            this.completed = completed;
            this.reverted = reverted;
        }
    }
}

