/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSEvaluationRecursionGuard {
    private static final JSComplexityAwareRecursionGuard<JSEvaluationKey> ourRecursionGuard = new JSComplexityAwareRecursionGuard("js.type.evaluator");

    @NotNull
    public static JSComplexityAwareRecursionGuard<JSEvaluationKey> getGuard() {
        JSComplexityAwareRecursionGuard<JSEvaluationKey> jSComplexityAwareRecursionGuard = ourRecursionGuard;
        if (jSComplexityAwareRecursionGuard == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(0);
        }
        return jSComplexityAwareRecursionGuard;
    }

    @Nullable
    public static <T> T evaluateWithGuard(@NotNull JSType type2, @NotNull JSEvaluateContext context2, @NotNull Computable<T> runnable) {
        if (type2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(3);
        }
        JSEvaluationKey node = new JSEvaluationKey(type2.getResolvedTypeId(), context2, runnable.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, false, runnable);
    }

    @Nullable
    public static <T> T compute(@NotNull JSType type2, @NotNull JSEvaluateContext context2, @NotNull Computable<T> supplier) {
        if (type2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(5);
        }
        if (supplier == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(6);
        }
        JSEvaluationKey node = new JSEvaluationKey(type2.getResolvedTypeId(), context2, supplier.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, true, supplier);
    }

    @Nullable
    public static <T> T compute(@NotNull PsiElement element2, @NotNull JSEvaluateContext context2, @NotNull Computable<T> supplier) {
        if (element2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(8);
        }
        if (supplier == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(9);
        }
        JSEvaluationKey node = new JSEvaluationKey(element2, context2, supplier.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, true, supplier);
    }

    @Nullable
    public static <T> T processWithEvaluationGuard(@NotNull PsiElement element2, @NotNull JSEvaluateContext context2, @NotNull Computable<T> runnable) {
        if (element2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(10);
        }
        if (context2 == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(11);
        }
        if (runnable == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(12);
        }
        JSEvaluationKey node = new JSEvaluationKey(element2, context2, runnable.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, false, runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuard";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateWithGuard";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processWithEvaluationGuard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }

    public static final class JSEvaluationKey {
        @NotNull
        public final Object myElement;
        @NotNull
        public final JSEvaluateContext myContext;
        @NotNull
        public final Class<?> myProviderClass;

        public JSEvaluationKey(@NotNull PsiElement element2, @NotNull JSEvaluateContext context2, @NotNull Class<?> providerClass) {
            if (element2 == null) {
                JSEvaluationKey.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                JSEvaluationKey.$$$reportNull$$$0(1);
            }
            if (providerClass == null) {
                JSEvaluationKey.$$$reportNull$$$0(2);
            }
            this.myElement = element2;
            this.myContext = context2;
            this.myProviderClass = providerClass;
        }

        public JSEvaluationKey(@NotNull JSResolvedTypeId typeId, @NotNull JSEvaluateContext context2, @NotNull Class<?> providerClass) {
            if (typeId == null) {
                JSEvaluationKey.$$$reportNull$$$0(3);
            }
            if (context2 == null) {
                JSEvaluationKey.$$$reportNull$$$0(4);
            }
            if (providerClass == null) {
                JSEvaluationKey.$$$reportNull$$$0(5);
            }
            this.myElement = Pair.create((Object)typeId, (Object)new JSEvaluateContextObject(context2));
            this.myContext = context2;
            this.myProviderClass = providerClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSEvaluationKey key = (JSEvaluationKey)o;
            return this.myElement.equals(key.myElement) && this.myContext.equals(key.myContext) && this.myProviderClass.equals(key.myProviderClass);
        }

        public int hashCode() {
            int result2 = this.myElement.hashCode();
            result2 = 31 * result2 + this.myContext.hashCode();
            result2 = 31 * result2 + this.myProviderClass.hashCode();
            return result2;
        }

        public String toString() {
            String element2 = this.myElement instanceof PsiElement ? JSEvaluationLogger.toPresentable(this.myElement) : this.myElement.getClass().getSimpleName();
            return String.format("JSEvaluationKey(%s, %s)", element2, this.myProviderClass.getSimpleName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providerClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard$JSEvaluationKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class JSEvaluateContextObject {
            @Nullable
            private final JSReferenceExpression myExpression;
            @Nullable
            private final PsiElement mySource;

            private JSEvaluateContextObject(@NotNull JSEvaluateContext context2) {
                if (context2 == null) {
                    JSEvaluateContextObject.$$$reportNull$$$0(0);
                }
                this.myExpression = context2.getProcessedExpression();
                this.mySource = context2.getSource();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                JSEvaluateContextObject object = (JSEvaluateContextObject)o;
                return Objects.equals(this.myExpression, object.myExpression) && Objects.equals(this.mySource, object.mySource);
            }

            public int hashCode() {
                int result2 = Objects.hashCode(this.myExpression);
                result2 = 31 * result2 + Objects.hashCode(this.mySource);
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard$JSEvaluationKey$JSEvaluateContextObject", "<init>"));
            }
        }
    }
}

