/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSConvertLoopsUtils;
import com.intellij.lang.javascript.intentions.JSConvertIndexedToForEachIntention;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConvertToForEachIntention
extends JavaScriptIntention {
    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        JSStatement parent;
        if (project == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(1);
        }
        if (!((parent = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{JSForInStatement.class, JSBlockStatement.class})) instanceof JSForInStatement)) {
            return false;
        }
        JSForInStatement forInStatement = (JSForInStatement)parent;
        if (forInStatement.isForEach()) {
            return false;
        }
        PsiElement indexVariable = JSConvertToForEachIntention.resolveForInLoopIterationVariable(forInStatement);
        if (indexVariable == null) {
            return false;
        }
        JSExpression collectionExpression = forInStatement.getCollectionExpression();
        if (collectionExpression == null || !JSConvertLoopsUtils.isArrayType(collectionExpression)) {
            return false;
        }
        return JSConvertLoopsUtils.canExtractLoopBodyToFunction(forInStatement, collectionExpression, indexVariable);
    }

    @Nullable
    public static PsiElement resolveForInLoopIterationVariable(@NotNull JSForInStatement forInStatement) {
        JSVarStatement varStatement;
        if (forInStatement == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(2);
        }
        if ((varStatement = forInStatement.getVarDeclaration()) != null && varStatement.getVariables().length == 1 && varStatement.equals(varStatement.getVariables()[0].getParent())) {
            return varStatement.getVariables()[0];
        }
        return JSConvertLoopsUtils.resolveLoopInitializationVariable((PsiElement)forInStatement.getVariableExpression());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        JSStatement parent;
        if (project == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(4);
        }
        if (!((parent = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{JSForInStatement.class, JSBlockStatement.class})) instanceof JSForInStatement)) {
            return;
        }
        JSForInStatement forInStatement = (JSForInStatement)parent;
        JSExpression collectionExpression = forInStatement.getCollectionExpression();
        PsiElement indexVariable = JSConvertToForEachIntention.resolveForInLoopIterationVariable(forInStatement);
        JSConvertIndexedToForEachIntention.replaceWithForEach(project, editor, forInStatement, collectionExpression, indexVariable);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.to.foreach.intention.name", new Object[0]);
        if (string == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("js.convert.to.foreach.intention.name", new Object[0]);
        if (string == null) {
            JSConvertToForEachIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forInStatement";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSConvertToForEachIntention";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveForInLoopIterationVariable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

