/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JSAddTypeMembersByLiteralFix
extends PsiUpdateModCommandAction<JSObjectLiteralExpression> {
    private final List<String> myNamesToAdd;
    private final String myClassName;
    private final int myClassIndex;

    static List<JSClass> getJSClasses(JSVariable varDeclaration) {
        JSType valuableType = JSTypeUtils.getValuableType(varDeclaration.getJSType(), (PsiElement)varDeclaration);
        if (valuableType == null) {
            return List.of();
        }
        List<JSType> allTypes = valuableType instanceof JSUnionOrIntersectionType ? ((JSUnionOrIntersectionType)valuableType).getTypes() : List.of(valuableType);
        return allTypes.stream().map(type2 -> {
            JSClass clazz;
            Collection<JSClass> classes;
            if (type2 instanceof JSGenericTypeImpl) {
                type2 = ((JSGenericTypeImpl)type2).getType();
            }
            if (type2 instanceof JSResolvableType && (classes = ((JSResolvableType)type2).resolveType().getDeclarationsOfType(JSClass.class)).size() == 1 && !((clazz = classes.iterator().next()) instanceof TypeScriptTypeAlias) && clazz.getName() != null) {
                return clazz;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    JSAddTypeMembersByLiteralFix(JSObjectLiteralExpression initializerLiteral, List<String> namesToAdd, String className, int classIndex) {
        super((PsiElement)initializerLiteral);
        this.myNamesToAdd = namesToAdd;
        this.myClassName = className;
        this.myClassIndex = classIndex;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.add.members.to.type.desc", new Object[0]);
        if (string == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull JSObjectLiteralExpression element2) {
        if (context2 == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(1);
        }
        if (element2 == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(2);
        }
        return Presentation.of((String)JavaScriptBundle.message("js.add.members.to.type", StringUtil.join(this.myNamesToAdd, n -> "'" + n + "'", (String)", "), this.myClassName)).withPriority(PriorityAction.Priority.HIGH);
    }

    protected void invoke(@NotNull ActionContext context2, @NotNull JSObjectLiteralExpression initializerLiteral, @NotNull ModPsiUpdater updater) {
        PsiElement parent;
        if (context2 == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(3);
        }
        if (initializerLiteral == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            JSAddTypeMembersByLiteralFix.$$$reportNull$$$0(5);
        }
        if (!((parent = initializerLiteral.getParent()) instanceof JSVariable)) {
            return;
        }
        JSVariable jsVariable = (JSVariable)parent;
        List<JSClass> jsClasses = JSAddTypeMembersByLiteralFix.getJSClasses(jsVariable);
        if (this.myClassIndex >= jsClasses.size()) {
            return;
        }
        JSClass clazz = jsClasses.get(this.myClassIndex);
        if (!this.myClassName.equals(clazz.getName())) {
            return;
        }
        clazz = (JSClass)updater.getWritable((PsiElement)clazz);
        for (JSProperty property : initializerLiteral.getProperties()) {
            String name = property.getName();
            if (name == null || !this.myNamesToAdd.contains(name)) continue;
            TypeScriptMemberInfo info = new TypeScriptMemberInfo(null, property, TypeScriptMemberInfo.Kind.UNIMPLEMENTED);
            LeafPsiElement anchor = (LeafPsiElement)SyntaxTraverser.psiTraverser((PsiElement)clazz).filter(LeafPsiElement.class).filter(e -> e.getElementType() == JSTokenTypes.LBRACE).first();
            if (property instanceof JSFunction) {
                TypeScriptImplementMemberUtil.addDistinctFunctionToClass(info, name, clazz, (PsiElement)anchor, Collections.emptyMap(), false);
                continue;
            }
            TypeScriptImplementMemberUtil.addPropertyToClass(clazz, (PsiElement)anchor, name, Collections.singletonList(info), Collections.emptyMap(), false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSAddTypeMembersByLiteralFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerLiteral";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSAddTypeMembersByLiteralFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

