/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Language;
import com.intellij.lang.html.HtmlCompatibleFile;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editor.JSEditorOptions;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (!JSEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            return null;
        }
        if (!this.isSupportedFile(file) || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        Pair<@NotNull JSLiteralExpression, Boolean> pair = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd);
        if (pair == null || !this.isSupportedContext((PsiElement)pair.first)) {
            return null;
        }
        return (Boolean)pair.second != false ? JSStringUtil.unescapeSimpleStringChars(text) : text;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!this.isSupportedFile(file) || !JSEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        Pair<@NotNull JSLiteralExpression, Boolean> pair = JSStringLiteralCopyPasteProcessor.getSingleElementFromSelectionOrNull(file, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (pair == null || !((Boolean)pair.second).booleanValue()) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        JSLiteralExpression literalExpression = (JSLiteralExpression)pair.first;
        if (!this.isSupportedContext((PsiElement)literalExpression) || literalExpression.getTextOffset() == selectionStart) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        return this.getPastedText(text, literalExpression, rawText);
    }

    public boolean isSupportedFile(@NotNull PsiFile file) {
        if (file == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return (file instanceof JSFile || file instanceof HtmlCompatibleFile) && file.isPhysical();
    }

    protected boolean isSupportedContext(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        return DialectDetector.hasJSSyntax(contextElement);
    }

    @NotNull
    private String getPastedText(String text, @NotNull JSLiteralExpression literalExpression, RawText rawText) {
        if (literalExpression == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        String literalText = literalExpression.getText();
        boolean isStringTemplate = literalExpression instanceof JSStringTemplateExpression;
        boolean isSlashQuotedDestination = !isStringTemplate && literalText.contains("\\\n");
        boolean destinationAcceptsNewLines = this.isDestinationAcceptsNewLines(rawText, isStringTemplate, isSlashQuotedDestination);
        char quote = literalText.charAt(0);
        if (StringUtil.containsChar((String)text, (char)quote) && !isStringTemplate && JSStringLiteralCopyPasteProcessor.isValidStringConcatenation((PsiElement)literalExpression, quote + (isSlashQuotedDestination ? StringUtil.trimEnd((String)text, (String)"\\") : text) + quote)) {
            String string = text;
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (rawText != null && rawText.rawText != null) {
            if (isStringTemplate) {
                String string = JSStringUtil.escapeTemplateStringChars(rawText.rawText, false, false, false, (PsiElement)literalExpression);
                if (string == null) {
                    JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
                }
                return string;
            }
            String string = JSStringLiteralCopyPasteProcessor.escapeQuote(rawText.rawText, quote, !destinationAcceptsNewLines);
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (isStringTemplate) {
            String string = JSStringUtil.escapeTemplateStringChars(text, true, true, false, (PsiElement)literalExpression);
            if (string == null) {
                JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = this.escapeSimpleText(text, literalExpression, isSlashQuotedDestination, destinationAcceptsNewLines, quote);
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected boolean isDestinationAcceptsNewLines(RawText rawText, boolean isStringTemplate, boolean isSlashQuotedDestination) {
        return isStringTemplate || isSlashQuotedDestination || rawText != null && StringUtil.contains((CharSequence)rawText.rawText, (CharSequence)"\\\n");
    }

    @NotNull
    protected String escapeSimpleText(String text, @NotNull JSLiteralExpression literalExpression, boolean isSlashQuotedDestination, boolean destinationAcceptsNewlines, char quote) {
        if (literalExpression == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder(text.length());
        String lineTail = isSlashQuotedDestination ? "\\\n" : JSStringLiteralCopyPasteProcessor.getTail(quote, (PsiElement)literalExpression);
        String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            JSStringUtil.escapeSimpleStringChars(line, quote, !destinationAcceptsNewlines, true, false, buffer);
            if (i == lines.length - 1) continue;
            buffer.append(lineTail);
        }
        if (text.endsWith("\n")) {
            buffer.append("\\n");
        }
        String string = buffer.toString();
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static @Nullable Pair<@NotNull JSLiteralExpression, Boolean> getSingleElementFromSelectionOrNull(@NotNull PsiFile file, int start, int end) {
        if (file == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        JSLiteralExpression atStart = (JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(start), JSLiteralExpression.class);
        JSLiteralExpression atEnd = (JSLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(end), JSLiteralExpression.class);
        if (atStart == null || atStart != atEnd || !atStart.isQuotedLiteral() || !atStart.getTextRange().containsRange(start, end)) {
            return null;
        }
        boolean canEscape = !(atStart instanceof JSStringTemplateExpression) || JSStringLiteralCopyPasteProcessor.isInStringRange((JSStringTemplateExpression)atStart, new TextRange(start, end));
        return Pair.create((Object)atStart, (Object)canEscape);
    }

    private static boolean isValidStringConcatenation(@NotNull PsiElement context2, @NotNull String text) {
        TextRange range;
        JSExpression expression;
        JSElement file;
        if (context2 == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        if (text == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        try {
            file = JSChangeUtil.createJSContentFromText(context2.getProject(), text, DialectDetector.languageDialectOfElement(context2));
        }
        catch (Exception e) {
            return false;
        }
        PsiElement firstStatement = (PsiElement)ArrayUtil.getFirstElement((Object[])file.getChildren());
        return firstStatement instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)firstStatement).getExpression()) instanceof JSBinaryExpression && JSTokenTypes.PLUS == ((JSBinaryExpression)expression).getOperationSign() && (range = expression.getTextRange()).getStartOffset() == 0 && range.getEndOffset() == file.getTextLength() && PsiTreeUtil.getDeepestFirst((PsiElement)expression).getParent() instanceof JSLiteralExpression && PsiTreeUtil.getDeepestLast((PsiElement)expression).getParent() instanceof JSLiteralExpression;
    }

    @NotNull
    private static String getTail(char quote, @NotNull PsiElement context2) {
        if (context2 == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)context2.getContainingFile(), (Language)context2.getLanguage());
        String string = "\\n" + quote + (commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\n+" : "+\n") + quote;
        if (string == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static boolean isInStringRange(@NotNull JSStringTemplateExpression templateExpression, int offset) {
        if (templateExpression == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        return JSStringLiteralCopyPasteProcessor.isInStringRange(templateExpression, TextRange.from((int)offset, (int)0));
    }

    public static boolean isInStringRange(@NotNull JSStringTemplateExpression templateExpression, @NotNull TextRange range) {
        if (templateExpression == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(19);
        }
        if (range == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(20);
        }
        TextRange relativeRange = range.shiftLeft(templateExpression.getTextRange().getStartOffset());
        for (TextRange textRange : templateExpression.getStringRangesWithEmpty()) {
            if (!textRange.contains(relativeRange)) continue;
            return true;
        }
        return false;
    }

    private static String escapeQuote(String text, char quote, boolean escapeNewlines) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (escapeNewlines && c == '\n') {
                result2.append('\\').append('n');
                continue;
            }
            if (c == quote && (i == 0 || text.charAt(i - 1) != '\\')) {
                result2.append('\\').append(quote);
                continue;
            }
            result2.append(c);
        }
        return result2.toString();
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(21);
        }
        if (project == null) {
            JSStringLiteralCopyPasteProcessor.$$$reportNull$$$0(22);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 11, 13, 14, 15, 16, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/JSStringLiteralCopyPasteProcessor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPastedText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSimpleText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTail";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPastedText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeSimpleText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSingleElementFromSelectionOrNull";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidStringConcatenation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTail";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInStringRange";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 11, 13, 14, 15, 16, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }
}

