/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/testFramework/util/CypressDetectionUtils;", "", "<init>", "()V", "CYPRESS_GLOBAL_VAR_NAME", "", "CYPRESS_DEFAULT_TESTS_DIR_NAME", "mightHasCypressApiCall", "", "jsFile", "Lcom/intellij/lang/javascript/psi/JSFile;", "hasDefaultTestsDirInFilePath", "filePath", "intellij.javascript.testing"})
public final class CypressDetectionUtils {
    @NotNull
    public static final CypressDetectionUtils INSTANCE = new CypressDetectionUtils();
    @NotNull
    private static final String CYPRESS_GLOBAL_VAR_NAME = "cy";
    @NotNull
    private static final String CYPRESS_DEFAULT_TESTS_DIR_NAME = "e2e";

    private CypressDetectionUtils() {
    }

    @JvmStatic
    public static final boolean mightHasCypressApiCall(@NotNull JSFile jsFile) {
        Intrinsics.checkNotNullParameter((Object)jsFile, (String)"jsFile");
        return JsPsiUtils.mightContainGlobalsMethodCall(jsFile, CYPRESS_GLOBAL_VAR_NAME);
    }

    public final boolean hasDefaultTestsDirInFilePath(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return JSLibraryUtil.containsDirInPath(filePath, CYPRESS_DEFAULT_TESTS_DIR_NAME);
    }
}

