/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.prettierjs.ReformatWithPrettierAction;
import com.intellij.prettierjs.formatting.PrettierRangeKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import org.jetbrains.annotations.NotNull;

public final class PrettierPostFormatProcessor
implements PostFormatProcessor {
    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = source;
        if (psiElement == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile psiFile, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (psiFile == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(5);
        }
        if (Registry.get((String)"prettier.use.async.formatting.service").asBoolean()) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                PrettierPostFormatProcessor.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        if (PrettierPostFormatProcessor.isApplicable(psiFile)) {
            TextRange extendedRange = PrettierRangeKt.extendRange(psiFile, rangeToReformat);
            TextRange textRange = ReformatWithPrettierAction.processFileAsPostFormatProcessor(psiFile, extendedRange);
            if (textRange == null) {
                PrettierPostFormatProcessor.$$$reportNull$$$0(7);
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    static boolean isApplicable(@NotNull PsiFile psiFile) {
        Template template;
        VirtualFile file;
        if (psiFile == null) {
            PrettierPostFormatProcessor.$$$reportNull$$$0(9);
        }
        if ((file = psiFile.getVirtualFile()) == null) {
            return false;
        }
        Project project = psiFile.getProject();
        PrettierConfiguration configuration = PrettierConfiguration.getInstance(project);
        if (!configuration.isRunOnReformat()) {
            return false;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file);
        if (fileEditor instanceof TextEditor && (template = TemplateManager.getInstance((Project)psiFile.getProject()).getActiveTemplate(((TextEditor)fileEditor).getEditor())) != null) {
            return false;
        }
        return PrettierUtil.isFormattingAllowedForFile(project, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierPostFormatProcessor";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierPostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

