/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.endpoints;

import com.intellij.icons.AllIcons;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.ExternalEndpointsFilter;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.SearchScopeEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwEndpoint;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.remote.RemoteSpecificationModel;
import com.intellij.swagger.core.model.specification.SpecificationBasedModel;
import com.intellij.swagger.core.model.specification.SpecificationHttpOperation;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.providers.resolve.SwUrlTargetUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\u00182\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006'"}, d2={"Lcom/intellij/swagger/endpoints/SwEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/swagger/core/model/api/SwModelBase;", "Lcom/intellij/swagger/core/model/api/SwEndpoint;", "<init>", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "group", "endpoint", "getNavigationElement", "getUrlTargetInfo", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "isDeprecated", "", "getLocationString", "", "isValidEndpoint", "getEndpointGroups", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "intellij.swagger.endpoints"})
@SourceDebugExtension(value={"SMAP\nSwEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwEndpointsProvider.kt\ncom/intellij/swagger/endpoints/SwEndpointsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n19#3:84\n1563#4:85\n1634#4,3:86\n*S KotlinDebug\n*F\n+ 1 SwEndpointsProvider.kt\ncom/intellij/swagger/endpoints/SwEndpointsProvider\n*L\n57#1:84\n72#1:85\n72#1:86,3\n*E\n"})
public final class SwEndpointsProvider
implements EndpointsUrlTargetProvider<SwModelBase, SwEndpoint> {
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("OpenAPI", SwaggerBundle.message("openapi.specification", new Object[0]), AllIcons.Webreferences.Openapi);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.API_DEFINITION_TYPE;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return EndpointsProvider.Status.AVAILABLE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return null;
    }

    @Nullable
    public PsiElement getNavigationElement(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getSourcePsi();
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint instanceof SwHttpOperation ? (Iterable)SwUrlTargetUtilsKt.computeEndpointTargets(CollectionsKt.listOf((Object)endpoint), group2.isRemote()) : (Iterable)CollectionsKt.emptyList();
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        TextAttributesKey textAttributesKey;
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        TextAttributesKey textAttributesKey2 = textAttributesKey = CodeInsightColors.DEPRECATED_ATTRIBUTES;
        Icon icon = SwaggerCoreIcons.Endpoint;
        String string = this.getLocationString(group2);
        String string2 = endpoint.getHttpMethod().getValue();
        String string3 = endpoint.getUrl();
        boolean bl = false;
        boolean bl2 = this.isDeprecated(endpoint);
        TextAttributesKey textAttributesKey3 = bl2 ? textAttributesKey : null;
        Icon icon2 = icon;
        String string4 = string;
        String string5 = string2;
        String string6 = string3;
        return (ItemPresentation)new HttpMethodPresentation(string6, string5, string4, icon2, textAttributesKey3);
    }

    private final boolean isDeprecated(SwEndpoint endpoint) {
        SwModelElement swModelElement;
        SwEndpoint $this$asSafely$iv = endpoint;
        boolean $i$f$asSafely = false;
        SwEndpoint swEndpoint = $this$asSafely$iv;
        if (!(swEndpoint instanceof SpecificationHttpOperation)) {
            swEndpoint = null;
        }
        return (swModelElement = (SpecificationHttpOperation)swEndpoint) != null && (swModelElement = ((SpecificationHttpOperation)swModelElement).isDeprecated()) != null ? (Boolean)swModelElement.getValue() : false;
    }

    private final String getLocationString(SwModelBase group2) {
        String presentablePath;
        if (group2.isRemote() && group2 instanceof SwSpecificationFile && (presentablePath = SwaggerUtilsKt.suggestRemoteSpecificationUrl((SwSpecificationFile)group2)) != null) {
            return presentablePath;
        }
        PsiElement psiElement = group2.getSourcePsi();
        Object object = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
        if (object == null || (object = object.getName()) == null) {
            object = SwaggerBundle.message("unknown.specification", new Object[0]);
        }
        return object;
    }

    public boolean isValidEndpoint(@NotNull SwModelBase group2, @NotNull SwEndpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return SwaggerUtilsKt.isElementValid(endpoint);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<SwModelBase> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (filter instanceof ExternalEndpointsFilter) {
            void $this$mapTo$iv$iv;
            RemoteSpecificationModel remoteModel = RemoteSpecificationModel.Companion.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            Iterable $this$map$iv = remoteModel.getBaseModelElements(globalSearchScope);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwSpecificationFile swSpecificationFile = (SwSpecificationFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.substitute(project));
            }
            return (List)destination$iv$iv;
        }
        SearchScopeEndpointsFilter searchScopeEndpointsFilter = filter instanceof SearchScopeEndpointsFilter ? (SearchScopeEndpointsFilter)filter : null;
        if (searchScopeEndpointsFilter == null || (searchScopeEndpointsFilter = searchScopeEndpointsFilter.getContentSearchScope()) == null) {
            return CollectionsKt.emptyList();
        }
        SearchScopeEndpointsFilter searchScope = searchScopeEndpointsFilter;
        return SpecificationBasedModel.INSTANCE.getBaseModelElements((GlobalSearchScope)searchScope);
    }

    @NotNull
    public Iterable<SwEndpoint> getEndpoints(@NotNull SwModelBase group2) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        return group2.getEndpoints();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SwaggerUtilsKt.getYamlJsonModificationTracker(project);
    }
}

