/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramContainerUi;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.diagram.components.JBHiDPIVolatileImage;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiagramNodeContainer
extends CellRendererPanel {
    @NotNull
    @NonNls
    private static final String DO_USE_RENDER_CACHE_REGKEY = "diagrams.rendering.use.render.cache";
    @NotNull
    @NonNls
    private static final String DO_USE_VOLATILE_IMAGES_REGKEY = "diagrams.rendering.use.volatile.images.for.cache";
    @NotNull
    @NonNls
    private static final String MAX_NODE_SIZE_TO_CACHE_REGKEY = "diagrams.rendering.max.node.size.to.cache";
    @NotNull
    private static final Key<Boolean> RENDER_CACHE_INVALIDATION_MARK_KEY = Key.create((String)"com.intellij.diagram.components.DiagramNodeContainer.RENDER_CACHE_INVALIDATION_MARK_KEY");
    @NotNull
    private final CellRendererPanel myHeader;
    @NotNull
    private final CellRendererPanel myBody;
    @NotNull
    private final DiagramNodeBodyComponent myNodeBodyComponent;
    @NotNull
    private final DiagramNode<?> myNode;
    @NotNull
    private final DiagramBuilder myBuilder;
    @Nullable
    private final NodeRealizer myNodeRealizer;
    @NotNull
    private final MyRenderCacheHandler myRenderCacheHandler;
    @NotNull
    private final MyColorManager myColorManager;
    private boolean myIsSelected;

    public DiagramNodeContainer(@NotNull DiagramNode<?> node, @NotNull DiagramBuilder builder, @NotNull Point ignoredBasePointForPopup) {
        if (node == null) {
            DiagramNodeContainer.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DiagramNodeContainer.$$$reportNull$$$0(1);
        }
        if (ignoredBasePointForPopup == null) {
            DiagramNodeContainer.$$$reportNull$$$0(2);
        }
        this(node, builder, (NodeRealizer)null);
    }

    public DiagramNodeContainer(@NotNull DiagramNode<?> node, @NotNull DiagramBuilder builder, @Nullable NodeRealizer realizer) {
        if (node == null) {
            DiagramNodeContainer.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            DiagramNodeContainer.$$$reportNull$$$0(4);
        }
        DiagramColorManager colorManager = builder.getProvider().getColorManager();
        this.myBuilder = builder;
        this.myNode = node;
        this.myNodeRealizer = realizer;
        this.myHeader = new DiagramNodeHeaderComponent(builder, node);
        this.myHeader.setFont(colorManager.getNodeHeaderFont(builder));
        this.myNodeBodyComponent = new DiagramNodeBodyComponent(this.myNode, builder);
        this.myNodeBodyComponent.setFont(colorManager.getNodeBodyFont());
        this.myBody = new CellRendererPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myBody.setBorder((Border)JBUI.Borders.empty());
        this.myBody.setOpaque(true);
        this.myBody.add((Component)((Object)this.myNodeBodyComponent));
        this.myRenderCacheHandler = new MyRenderCacheHandler(this);
        this.myColorManager = new MyColorManager();
        this.setFocusable(false);
        this.setOpaque(true);
        this.switchHeaderSeparator(this.myNodeBodyComponent.getModel().getSize() > 0, false);
        this.setBorder(this.createBorder(false, 1.0));
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.myHeader, "North");
        if (this.myBody.getComponentCount() > 0) {
            this.add((Component)this.myBody, "Center");
        }
        for (JComponent c : UIUtil.uiTraverser((Component)((Object)this)).filter(JComponent.class)) {
            DiagramContainerUi.getInstance().paintNoBackground(c);
        }
    }

    public boolean isShowing() {
        return this.myBuilder.getGraph().getRealizer(this.myBuilder.getNode(this.myNode)).isVisible();
    }

    @NotNull
    public JPanel getHeader() {
        CellRendererPanel cellRendererPanel = this.myHeader;
        if (cellRendererPanel == null) {
            DiagramNodeContainer.$$$reportNull$$$0(5);
        }
        return cellRendererPanel;
    }

    @NotNull
    public JPanel getBody() {
        CellRendererPanel cellRendererPanel = this.myBody;
        if (cellRendererPanel == null) {
            DiagramNodeContainer.$$$reportNull$$$0(6);
        }
        return cellRendererPanel;
    }

    @NotNull
    public DiagramNodeBodyComponent getNodeBodyComponent() {
        DiagramNodeBodyComponent diagramNodeBodyComponent = this.myNodeBodyComponent;
        if (diagramNodeBodyComponent == null) {
            DiagramNodeContainer.$$$reportNull$$$0(7);
        }
        return diagramNodeBodyComponent;
    }

    @NotNull
    public DiagramNode<?> getNode() {
        DiagramNode<?> diagramNode = this.myNode;
        if (diagramNode == null) {
            DiagramNodeContainer.$$$reportNull$$$0(8);
        }
        return diagramNode;
    }

    public void switchHeaderSeparator(boolean on, boolean isSelected) {
        this.myHeader.setBorder((Border)(on ? new CustomLineBorder(this.myColorManager.getSeparatorColor(isSelected), 0, 0, 1, 0) : JBUI.Borders.empty()));
    }

    public Dimension getMinimumSize() {
        return this.myHeader.getMinimumSize();
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (this.isShadingNeeded()) {
            g2d.setComposite(this.myColorManager.getShadingComposite(this.myNode.getIdentifyingElement()));
        }
        this.updateIfSelectionChanged(((Graphics2D)g).getTransform().getScaleX());
        if (GraphExportService.getInstance().isPrintMode() || GraphExportService.getInstance().isExportMode() || this.isHotSpotModeActiveForThisNode() || GraphAnimationService.getInstance().isAnimationChangingZoomPerformingNow() || UIUtil.isPrinting((Graphics)g) || Boolean.TRUE.equals(this.getClientProperty("cell.editor")) || !Registry.is((String)DO_USE_RENDER_CACHE_REGKEY)) {
            this.doPaintComponent(g2d);
        } else {
            this.myRenderCacheHandler.paint(g2d);
        }
    }

    private boolean isHotSpotModeActiveForThisNode() {
        ViewMode hotSpotMode = this.myBuilder.getGraphBuilder().getEditMode().getHotSpotMode();
        return hotSpotMode.isActive() && DiagramSelectionService.getInstance().isSelected(this.myBuilder, this.myNode);
    }

    void invalidateRenderCacheForCurrentRealizer() {
        this.myRenderCacheHandler.invalidateRenderCache();
    }

    void invalidateRenderCacheForAllRealizersOfThisNode() {
        this.myNode.putUserData(RENDER_CACHE_INVALIDATION_MARK_KEY, Boolean.TRUE);
    }

    private void updateIfSelectionChanged(double viewportScale) {
        boolean isCurrentlySelected = this.myBuilder.getGraph().isSelected(this.myBuilder.getNode(this.myNode));
        if (this.myIsSelected != isCurrentlySelected) {
            this.myIsSelected = isCurrentlySelected;
            this.myRenderCacheHandler.invalidateRenderCache();
            this.setBorder(this.createBorder(isCurrentlySelected, viewportScale));
        }
    }

    private void beforeRenderingToCache(double viewportScale) {
        this.setBorder(this.createBorder(this.myIsSelected, viewportScale));
    }

    private void doPaintComponent(@NotNull Graphics2D g) {
        if (g == null) {
            DiagramNodeContainer.$$$reportNull$$$0(9);
        }
        Object element = this.myNode.getIdentifyingElement();
        this.myHeader.setForeground(this.myColorManager.getHeaderForegroundColor(element));
        this.myHeader.setForcedBackground(this.myColorManager.getHeaderForcedBackgroundColor(element));
        this.switchHeaderSeparator(this.myNodeBodyComponent.getModel().getSize() > 0, this.myIsSelected);
        this.myHeader.validate();
        this.myBody.setForcedBackground(this.myColorManager.getBodyBackgroundColor(element));
        this.myNodeBodyComponent.setBackground(this.myColorManager.getBodyBackgroundColor(element));
        super.paint((Graphics)g);
        this.paintBorder(g);
    }

    @NotNull
    private Border createBorder(boolean isSelected, double scale) {
        int baseThickness = GraphExportService.getInstance().isPrintMode() || DiagramSelectionService.getInstance().getPermanentHighlighting(this.myBuilder, this.myNode) != null ? JBUI.scale((int)2) : JBUI.scale((int)1);
        int thickness = Math.max((int)Math.ceil((double)baseThickness / (2.0 * scale)), baseThickness);
        Color borderColor = this.myColorManager.getSeparatorColor(isSelected);
        MyBorder border = new MyBorder(borderColor, GraphExportService.getInstance().isPrintMode() ? baseThickness : thickness);
        border.setInsets((Insets)(this.myNodeBodyComponent.getModel().getSize() > 0 ? JBUI.insets((int)1) : JBInsets.emptyInsets()));
        MyBorder myBorder = border;
        if (myBorder == null) {
            DiagramNodeContainer.$$$reportNull$$$0(10);
        }
        return myBorder;
    }

    private boolean isShadingNeeded() {
        return Boolean.FALSE.equals(this.myNode.getUserData(DiagramNode.SELECTED_NODE_KEY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredBasePointForPopup";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeContainer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeader";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeBodyComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doPaintComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }

    private static final class MyRenderCacheHandler {
        @NotNull
        private final DiagramNodeContainer myOwner;
        @NotNull
        private final ModificationTracker myViewModTracker;
        @NotNull
        private final ModificationTracker myZoomModTracker;
        @Nullable
        private GraphicsConfiguration myLastGraphicsConfiguration;
        private static final @NotNull Map<Object, PairObjLong<@Nullable Image>> OUR_CACHES = CollectionFactory.createWeakIdentityMap((int)20, (float)0.8f);

        MyRenderCacheHandler(@NotNull DiagramNodeContainer owner) {
            if (owner == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(0);
            }
            this.myOwner = owner;
            this.myViewModTracker = owner.myBuilder.getPresentationModel().getModificationTrackerOfViewUpdates();
            this.myZoomModTracker = Objects.requireNonNullElseGet(owner.myBuilder.getPresentationModel().getModificationTrackerOfZoomChanged(), () -> new SimpleModificationTracker());
        }

        private Object getRenderCacheKey() {
            NodeRealizer realizer = this.myOwner.myNodeRealizer != null ? this.myOwner.myNodeRealizer : this.myOwner.myBuilder.getGraph().getRealizer(this.myOwner.myBuilder.getNode(this.myOwner.myNode));
            return GraphManager.getGraphManager().unwrap((Object)realizer);
        }

        private void invalidateRenderCache() {
            OUR_CACHES.remove(this.getRenderCacheKey());
        }

        private void checkRenderCacheInvalidationMark() {
            if (this.myOwner.myNode.getUserData(RENDER_CACHE_INVALIDATION_MARK_KEY) == Boolean.TRUE) {
                this.invalidateRenderCache();
                this.myOwner.myNode.putUserData(RENDER_CACHE_INVALIDATION_MARK_KEY, null);
            }
        }

        @Nullable
        private Image getRenderCache(double currentViewportScale) {
            Image renderCache;
            long currentModStamp = this.myViewModTracker.getModificationCount() + this.myZoomModTracker.getModificationCount();
            Object renderCacheKey = this.getRenderCacheKey();
            this.checkRenderCacheInvalidationMark();
            PairObjLong cache = OUR_CACHES.computeIfAbsent(renderCacheKey, __ -> new PairObjLong<Image>(this.computeUpToDateCacheIfPossible(currentViewportScale), currentModStamp));
            if (cache.stamp != currentModStamp) {
                if (cache.data != null) {
                    ((Image)cache.data).flush();
                }
                renderCache = this.computeUpToDateCacheIfPossible(currentViewportScale);
                OUR_CACHES.put(renderCacheKey, new PairObjLong<Image>(renderCache, currentModStamp));
            } else {
                renderCache = (Image)cache.data;
            }
            return renderCache;
        }

        private static boolean areEqual(double a, double b) {
            return Math.abs(a - b) < 0.01;
        }

        private static int ceil(double value) {
            return PaintUtil.RoundingMode.CEIL.round(value) + 2;
        }

        public void paint(@NotNull Graphics2D g) {
            if (g == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(1);
            }
            this.myLastGraphicsConfiguration = g.getDeviceConfiguration();
            Rectangle oldClip = g.getClipBounds();
            g.setClip(oldClip.x, oldClip.y, MyRenderCacheHandler.ceil(oldClip.getWidth()), MyRenderCacheHandler.ceil(oldClip.getHeight()));
            AffineTransform currTransform = g.getTransform();
            assert (MyRenderCacheHandler.areEqual(currTransform.getScaleX(), currTransform.getScaleY()));
            double viewportScale = this.myOwner.myBuilder.getZoom();
            if (this.myOwner.myBuilder.getGraphBuilder().getActiveMode() instanceof MagnifierViewMode && !MyRenderCacheHandler.areEqual(currTransform.getScaleX(), viewportScale) && !MyRenderCacheHandler.areEqual(currTransform.getScaleX(), viewportScale * (double)JBUIScale.sysScale((GraphicsConfiguration)this.myLastGraphicsConfiguration))) {
                this.myOwner.doPaintComponent(g);
                return;
            }
            Image image = this.getRenderCache(viewportScale);
            do {
                int validateResult = image instanceof VolatileImage ? ((VolatileImage)image).validate(this.myLastGraphicsConfiguration) : -1;
                switch (validateResult) {
                    case 1: {
                        this.fillRenderCache(viewportScale, image);
                        break;
                    }
                    case 2: {
                        image.flush();
                        image = this.computeUpToDateCacheIfPossible(viewportScale);
                    }
                }
                if (image == null) {
                    this.myOwner.doPaintComponent(g);
                    return;
                }
                g.scale(1.0 / viewportScale, 1.0 / viewportScale);
                JBHiDPIVolatileImage.drawImage(g, image, 0, 0, null);
                g.setTransform(currTransform);
            } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost());
            g.setClip(oldClip);
        }

        @Nullable
        private Image computeUpToDateCacheIfPossible(double viewportScale) {
            this.myOwner.beforeRenderingToCache(viewportScale);
            this.myOwner.forceInvalidate();
            int widthScaled = MyRenderCacheHandler.ceil((double)this.myOwner.getWidth() * viewportScale);
            int heightScaled = MyRenderCacheHandler.ceil((double)this.myOwner.getHeight() * viewportScale);
            Image result = null;
            if (!MyRenderCacheHandler.isTooLargeToCache(widthScaled, heightScaled)) {
                result = MyRenderCacheHandler.createRenderCache(widthScaled, heightScaled, this.myLastGraphicsConfiguration);
                this.fillRenderCache(viewportScale, result);
            }
            return result;
        }

        private static boolean isTooLargeToCache(int width, int height) {
            return width * height > Registry.intValue((String)DiagramNodeContainer.MAX_NODE_SIZE_TO_CACHE_REGKEY);
        }

        @NotNull
        private static Image createRenderCache(int widthScaled, int heightScaled, @Nullable GraphicsConfiguration cfg) {
            if (cfg == null) {
                cfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            if (Registry.is((String)DiagramNodeContainer.DO_USE_VOLATILE_IMAGES_REGKEY)) {
                return new JBHiDPIVolatileImage(cfg, widthScaled, heightScaled, 1, 1.0f, PaintUtil.RoundingMode.CEIL);
            }
            BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)cfg, (int)widthScaled, (int)heightScaled, (int)1);
            if (bufferedImage == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(2);
            }
            return bufferedImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private void fillRenderCache(double viewportScale, @NotNull Image image) {
            void image2;
            if (image == null) {
                MyRenderCacheHandler.$$$reportNull$$$0(3);
            }
            if (image2 instanceof VolatileImage) {
                ((VolatileImage)image2).validate(this.myLastGraphicsConfiguration);
            }
            Graphics2D g = (Graphics2D)image2.getGraphics();
            try {
                g.setColor(this.myOwner.myBuilder.getColorScheme().getDefaultBackground());
                g.fillRect(0, 0, ImageUtil.getRealWidth((Image)image2), ImageUtil.getRealHeight((Image)image2));
                g.scale(viewportScale, viewportScale);
                this.myOwner.doPaintComponent(g);
            }
            finally {
                g.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeContainer$MyRenderCacheHandler";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer$MyRenderCacheHandler";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createRenderCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "fillRenderCache";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyColorManager {
        private MyColorManager() {
        }

        @Nullable
        private Color getHeaderForcedBackgroundColor(@NotNull Object element) {
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(0);
            }
            DiagramColorManager colorManager = DiagramNodeContainer.this.myBuilder.getProvider().getColorManager();
            return GraphExportService.getInstance().isPrintMode() ? null : colorManager.getNodeHeaderBackground(DiagramNodeContainer.this.myBuilder, DiagramNodeContainer.this.myNode, element);
        }

        @NotNull
        private Color getHeaderForegroundColor(@NotNull Object element) {
            Color defaultFgColor;
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(1);
            }
            Color headerFgOverrideColor = GraphExportService.getInstance().isPrintMode() ? null : DiagramNodeContainer.this.myNode.getFileTabForeground();
            Color headerFgColor = headerFgOverrideColor != null ? headerFgOverrideColor : DiagramNodeContainer.this.myBuilder.getColorScheme().getDefaultForeground();
            Color headerBgColor = this.getHeaderForcedBackgroundColor(element);
            if (headerBgColor != null && !ColorUtil.areContrasting((Color)headerBgColor, (Color)headerFgColor) && ColorUtil.areContrasting((Color)headerBgColor, (Color)(defaultFgColor = EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultForeground()))) {
                Color color = defaultFgColor;
                if (color == null) {
                    MyColorManager.$$$reportNull$$$0(2);
                }
                return color;
            }
            Color color = headerFgColor;
            if (color == null) {
                MyColorManager.$$$reportNull$$$0(3);
            }
            return color;
        }

        @Nullable
        private Color getBodyBackgroundColor(@NotNull Object element) {
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(4);
            }
            DiagramColorManager colorManager = DiagramNodeContainer.this.myBuilder.getProvider().getColorManager();
            return GraphExportService.getInstance().isPrintMode() ? null : colorManager.getNodeBackground(DiagramNodeContainer.this.myBuilder, DiagramNodeContainer.this.myNode, element, false);
        }

        @NotNull
        private Color getSeparatorColor(boolean isSelected) {
            Color color = DiagramNodeContainer.this.myBuilder.getProvider().getColorManager().getNodeBorderColor(DiagramNodeContainer.this.myBuilder, DiagramNodeContainer.this.myNode, isSelected);
            if (color == null) {
                MyColorManager.$$$reportNull$$$0(5);
            }
            return color;
        }

        @NotNull
        private AlphaComposite getShadingComposite(@NotNull Object element) {
            Color headerBgColor;
            if (element == null) {
                MyColorManager.$$$reportNull$$$0(6);
            }
            Color bg = (headerBgColor = this.getHeaderForcedBackgroundColor(element)) != null ? headerBgColor : DiagramNodeContainer.this.myBuilder.getColorScheme().getDefaultBackground();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, ColorUtil.isDark((Color)bg) ? 0.7f : 0.5f);
            if (alphaComposite == null) {
                MyColorManager.$$$reportNull$$$0(7);
            }
            return alphaComposite;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeContainer$MyColorManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer$MyColorManager";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeaderForegroundColor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeparatorColor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShadingComposite";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeaderForcedBackgroundColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getHeaderForegroundColor";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getBodyBackgroundColor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getShadingComposite";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyBorder
    implements Border {
        @NotNull
        private final Color myColor;
        @NotNull
        private Insets myInsets;
        private final int myThickness;

        MyBorder(@NotNull Color color, int thickness) {
            if (color == null) {
                MyBorder.$$$reportNull$$$0(0);
            }
            this.myInsets = JBInsets.emptyInsets();
            this.myColor = color;
            this.myThickness = thickness;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.myColor);
            for (int i = 0; i < this.myThickness; ++i) {
                g.drawRect(x + i, y + i, width - 2 * i, height - 2 * i);
            }
        }

        private void setInsets(@NotNull Insets insets) {
            if (insets == null) {
                MyBorder.$$$reportNull$$$0(1);
            }
            this.myInsets = insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.myInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer$MyBorder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setInsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PairObjLong<V> {
        V data;
        long stamp;

        private PairObjLong(V data, long stamp) {
            this.data = data;
            this.stamp = stamp;
        }
    }
}

