/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerDeploymentConfigurationUtilsKt;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"checkDockerFile", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "intellij.clouds.docker"})
public final class DockerFileDeploymentValidationKt {
    public static final void checkDockerFile(@NotNull Project project, @NotNull DockerDeploymentConfiguration config2) {
        block6: {
            Path file;
            String dockerFile;
            block5: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
                dockerFile = StringKt.nullize((String)config2.getSourceFilePath(), (boolean)true);
                if (dockerFile == null) {
                    throw new RuntimeConfigurationException(DockerBundle.message((String)"DockerFileDeploymentSourceType.error.path.required", (Object[])new Object[0]));
                }
                file = DockerDeploymentConfigurationUtilsKt.resolvePath(project, dockerFile);
                if (file == null) break block5;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block5;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (Files.isRegularFile(file, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) break block6;
            }
            Object[] objectArray = new Object[1];
            Object object = file;
            if (object == null || (object = ((Object)object.toAbsolutePath()).toString()) == null) {
                object = dockerFile;
            }
            objectArray[0] = object;
            throw new RuntimeConfigurationError(DockerBundle.message((String)"DockerFileDeploymentSourceType.error.dockerfile.does.not.exist", (Object[])objectArray));
        }
    }
}

