/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.actions;

import com.intellij.commandInterface.command.Command;
import com.intellij.commandInterface.command.CommandExecutor;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.python.django.commandInterfaceConsole.CommandLineConsoleApiKt;
import com.intellij.python.django.commandInterfaceConsole.CommandsInfo;
import com.intellij.python.django.manage.DjangoManageCommandsApi;
import com.intellij.python.django.manage.FailedToProvideCommandsException;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.remote.NewFilesProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunManageTaskAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RunManageTaskAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunManageTaskAction.$$$reportNull$$$0(1);
        }
        boolean djangoModuleExists = !RunManageTaskAction.findModulesWithDjango(e).isEmpty();
        e.getPresentation().setEnabledAndVisible(djangoModuleExists);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RunManageTaskAction.$$$reportNull$$$0(2);
        }
        this.launchManagePyConsole(e);
    }

    @Nullable
    protected LanguageConsoleView launchManagePyConsole(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Module module = RunManageTaskAction.getAppropriateModule(e);
        if (module == null) {
            return null;
        }
        return RunManageTaskAction.runManagePyOnModule(module);
    }

    @Nullable
    public static LanguageConsoleView runManagePyOnModule(@NotNull Module moduleWithDjango) {
        String consoleTitle;
        LanguageConsoleView existingConsole;
        if (moduleWithDjango == null) {
            RunManageTaskAction.$$$reportNull$$$0(3);
        }
        if ((existingConsole = CommandLineConsoleApiKt.findAndOpenExistingConsoleIfExists(moduleWithDjango, consoleTitle = DjangoBundle.message((String)"django.manage.console.name", (Object[])new Object[]{moduleWithDjango.getName()}), true)) != null) {
            return existingConsole;
        }
        StringBuilder errors = new StringBuilder();
        ArrayList<Command> commands = null;
        try {
            commands = new ArrayList<Command>(DjangoManageCommandsApi.getCommands(moduleWithDjango, e -> errors.append((String)e).append('\n')));
        }
        catch (FailedToProvideCommandsException exception) {
            Logger.getInstance(RunManageTaskAction.class).warn("Error obtaining real commands", (Throwable)exception);
            errors.append(exception.getMessage());
        }
        CommandExecutor defaultExecutor = DjangoManageCommandsApi.getDefaultExecutor();
        CommandsInfo commandsInfo = new CommandsInfo(commands, defaultExecutor, CommandLineConsoleApiKt.jbFilter((Function1<? super String, String>)((Function1)s -> NewFilesProcessor.processNewFiles((Module)moduleWithDjango, (String)s))));
        LanguageConsoleView console = CommandLineConsoleApiKt.createConsoleAndOpen(moduleWithDjango, consoleTitle, consoleTitle, commandsInfo, true);
        if (console == null) {
            return null;
        }
        if (!errors.isEmpty()) {
            console.print(errors.toString(), ConsoleViewContentType.ERROR_OUTPUT);
        }
        return console;
    }

    @Nullable
    private static Module getAppropriateModule(@NotNull AnActionEvent event) {
        Module module;
        Module moduleFromEvent;
        if (event == null) {
            RunManageTaskAction.$$$reportNull$$$0(4);
        }
        if ((moduleFromEvent = (Module)event.getData(PlatformCoreDataKeys.MODULE)) != null && DjangoModelApi.create((Module)moduleFromEvent).getSuccessOrNull() != null) {
            return moduleFromEvent;
        }
        PsiElement context = GotoActionBase.getPsiContext((AnActionEvent)event);
        if (context != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) != null && DjangoModelApi.create((Module)module).getSuccessOrNull() != null) {
            return module;
        }
        List<Module> modulesWithDjango = RunManageTaskAction.findModulesWithDjango(event);
        if (modulesWithDjango.isEmpty()) {
            return null;
        }
        if (modulesWithDjango.size() == 1) {
            return modulesWithDjango.get(0);
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new ModuleChooser(modulesWithDjango)).showInFocusCenter();
        return null;
    }

    @NotNull
    private static List<Module> findModulesWithDjango(@NotNull AnActionEvent event) {
        if (event == null) {
            RunManageTaskAction.$$$reportNull$$$0(5);
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        Project project = event.getProject();
        if (project != null) {
            for (Module module : ModuleUtil.getModulesOfType((Project)project, (ModuleType)PythonModuleTypeBase.getInstance())) {
                if (DjangoModelApi.create((Module)module).getSuccessOrNull() == null) continue;
                modules.add(module);
            }
        }
        ArrayList<Module> arrayList = modules;
        if (arrayList == null) {
            RunManageTaskAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/actions/RunManageTaskAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleWithDjango";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/actions/RunManageTaskAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findModulesWithDjango";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runManagePyOnModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAppropriateModule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithDjango";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    private static final class ModuleChooser
    extends BaseListPopupStep<String> {
        @NotNull
        private final Map<String, Module> myModulesMap;

        ModuleChooser(@NotNull Collection<Module> modulesWithDjango) {
            if (modulesWithDjango == null) {
                ModuleChooser.$$$reportNull$$$0(0);
            }
            super(DjangoBundle.message((String)"django.manage.several_modules", (Object[])new Object[0]), new ArrayList<String>(ModuleChooser.getModulesMap(modulesWithDjango).keySet()));
            this.myModulesMap = new HashMap<String, Module>();
            this.myModulesMap.putAll(ModuleChooser.getModulesMap(modulesWithDjango));
        }

        public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
            PopupStep chosen = super.onChosen((Object)selectedValue, finalChoice);
            Module module = this.myModulesMap.get(selectedValue);
            if (module != null) {
                RunManageTaskAction.runManagePyOnModule(module);
            }
            return chosen;
        }

        @NotNull
        private static Map<String, Module> getModulesMap(@NotNull Iterable<Module> modules) {
            if (modules == null) {
                ModuleChooser.$$$reportNull$$$0(1);
            }
            TreeMap<String, Module> result = new TreeMap<String, Module>();
            for (Module module : modules) {
                result.put(module.getName(), module);
            }
            TreeMap<String, Module> treeMap = result;
            if (treeMap == null) {
                ModuleChooser.$$$reportNull$$$0(2);
            }
            return treeMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modulesWithDjango";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/django/actions/RunManageTaskAction$ModuleChooser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/django/actions/RunManageTaskAction$ModuleChooser";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModulesMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getModulesMap";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

