/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator.path;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.PersistentMapImpl;
import com.intellij.util.io.externalizer.StringCollectionExternalizer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0013\u001a\u00020\u000eH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/indexing/shared/generator/path/ArchiveRelativePathIndex;", "Lcom/intellij/openapi/Disposable;", "path", "Ljava/nio/file/Path;", "readonly", "", "<init>", "(Ljava/nio/file/Path;Z)V", "map", "Lcom/intellij/util/io/PersistentMapImpl;", "", "", "", "putFilePath", "", "hashId", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRelativePath", "dispose", "intellij.indexing.shared.generator"})
public final class ArchiveRelativePathIndex
implements Disposable {
    private final boolean readonly;
    @NotNull
    private final PersistentMapImpl<Integer, List<String>> map;

    public ArchiveRelativePathIndex(@NotNull Path path, boolean readonly) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.readonly = readonly;
        this.map = new PersistentMapImpl(PersistentMapBuilder.newBuilder((Path)path, (KeyDescriptor)((KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE), (DataExternalizer)((DataExternalizer)StringCollectionExternalizer.STRING_LIST_EXTERNALIZER)).withReadonly(this.readonly).withCompactOnClose(!this.readonly));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putFilePath(int hashId, @NotNull VirtualFile file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String relativePath = this.getRelativePath(file);
        if (relativePath != null) {
            PersistentMapImpl<Integer, List<String>> persistentMapImpl = this.map;
            synchronized (persistentMapImpl) {
                boolean bl = false;
                List paths = (List)this.map.get((Object)hashId);
                List list = paths;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List newPaths = CollectionsKt.plus((Collection)list, (Object)relativePath);
                this.map.put((Object)hashId, (Object)newPaths);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    public final List<String> getRelativePath(int hashId) throws IOException {
        Object object = this.map.get((Object)hashId);
        Intrinsics.checkNotNull((Object)object);
        return (List)object;
    }

    public void dispose() throws IOException {
        this.map.close();
    }

    private final String getRelativePath(VirtualFile file) {
        VirtualFileSystem virtualFileSystem = file.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem fileSystem = virtualFileSystem;
        if (!(fileSystem instanceof ArchiveFileSystem)) {
            return null;
        }
        VirtualFile virtualFile = ((ArchiveFileSystem)fileSystem).getRootByEntry(file);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        return VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)root);
    }
}

