# Validation helpers [![Build Status](https://travis-ci.org/go-openapi/validate.svg?branch=master)](https://travis-ci.org/go-openapi/validate) [![codecov](https://codecov.io/gh/go-openapi/validate/branch/master/graph/badge.svg)](https://codecov.io/gh/go-openapi/validate) [![Slack Status](https://slackin.goswagger.io/badge.svg)](https://slackin.goswagger.io)

[![license](http://img.shields.io/badge/license-Apache%20v2-orange.svg)](https://raw.githubusercontent.com/go-openapi/validate/master/LICENSE)
[![GoDoc](https://godoc.org/github.com/go-openapi/validate?status.svg)](http://godoc.org/github.com/go-openapi/validate)
[![Go Report Card](https://goreportcard.com/badge/github.com/go-openapi/validate)](https://goreportcard.com/report/github.com/go-openapi/validate)

This package provides helpers to validate Swagger 2.0. specification (aka OpenAPI 2.0). 

Reference can be found here: https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md.

## What's inside?

* A validator for Swagger specifications
* A validator for JSON schemas draft4
* Helper functions to validate individual values (used by code generated by [go-swagger](https://github.com/go-swagger/go-swagger)).
  * Required, RequiredNumber, RequiredString
  * ReadOnly
  * UniqueItems, MaxItems, MinItems
  * Enum, EnumCase
  * Pattern, MinLength, MaxLength
  * Minimum, Maximum, MultipleOf
  * FormatOf

[Documentation](https://godoc.org/github.com/go-openapi/validate)

## FAQ

* Does this library support OpenAPI 3?

> No.
> This package currently only supports OpenAPI 2.0 (aka Swagger 2.0).
> There is no plan to make it evolve toward supporting OpenAPI 3.x.
> This [discussion thread](https://github.com/go-openapi/spec/issues/21) relates the full story.
>
> An early attempt to support Swagger 3 may be found at: https://github.com/go-openapi/spec3
