/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.update.FilePathChange;
import com.intellij.openapi.vcs.update.FilesCollector;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronouslyKt;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.Wrapper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0007J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011J\u0014\u0010\u0015\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0016\u0010\u0018\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0007J\u0016\u0010\u0019\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0007J\u0016\u0010\u001a\u001a\u00020\t2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0011H\u0007J\u0016\u0010#\u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0016H\u0007J\u001e\u0010$\u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020%0\u00162\b\b\u0002\u0010&\u001a\u00020\u001dJ*\u0010$\u001a\u00020\t\"\u0004\b\u0000\u0010'2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H'0\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/openapi/vcs/update/RefreshVFsSynchronously;", "", "<init>", "()V", "TRACE_LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TIME_LOG", "trace", "", "message", "", "Lorg/jetbrains/annotations/NonNls;", "updateAllChanged", "updatedFiles", "Lcom/intellij/openapi/vcs/update/UpdatedFiles;", "findVirtualFilesWithRefresh", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "Ljava/io/File;", "refreshFiles", "", "Ljava/nio/file/Path;", "refreshVirtualFiles", "refreshVirtualFilesRecursive", "refreshDeletedFiles", "markDirtyAndRefresh", "isRecursive", "", "findValidParent", "file", "updateChangesForRollback", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "updateChanges", "refresh", "Lcom/intellij/openapi/vcs/update/FilePathChange;", "isRollback", "T", "wrapper", "Lcom/intellij/openapi/vcs/update/Wrapper;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRefreshVFsSynchronously.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshVFsSynchronously.kt\ncom/intellij/openapi/vcs/update/RefreshVFsSynchronously\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Timing.kt\nkotlin/system/TimingKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,203:1\n61#2,5:204\n61#2,5:239\n1563#3:209\n1634#3,3:210\n1617#3,9:213\n1869#3:222\n1870#3:224\n1626#3:225\n1625#3:226\n1869#3:227\n1870#3:229\n1626#3:230\n1625#3:231\n1869#3:232\n1870#3:234\n1626#3:235\n1869#3,2:246\n1#4:223\n1#4:228\n1#4:233\n29#5,3:236\n183#6,2:244\n37#7:248\n36#7,3:249\n*S KotlinDebug\n*F\n+ 1 RefreshVFsSynchronously.kt\ncom/intellij/openapi/vcs/update/RefreshVFsSynchronously\n*L\n35#1:204,5\n95#1:239,5\n46#1:209\n46#1:210,3\n47#1:213,9\n47#1:222\n47#1:224\n47#1:225\n58#1:226\n58#1:227\n58#1:229\n58#1:230\n85#1:231\n85#1:232\n85#1:234\n85#1:235\n121#1:246,2\n47#1:223\n58#1:228\n85#1:233\n90#1:236,3\n101#1:244,2\n92#1:248\n92#1:249,3\n*E\n"})
public final class RefreshVFsSynchronously {
    @NotNull
    public static final RefreshVFsSynchronously INSTANCE = new RefreshVFsSynchronously();
    @NotNull
    private static final Logger TRACE_LOG;
    @NotNull
    private static final Logger TIME_LOG;

    private RefreshVFsSynchronously() {
    }

    @JvmStatic
    public static final void trace(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger $this$debug_u24default$iv = TRACE_LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("RefreshVFsSynchronously: " + message, e$iv);
        }
    }

    public final void updateAllChanged(@NotNull UpdatedFiles updatedFiles) {
        Intrinsics.checkNotNullParameter((Object)updatedFiles, (String)"updatedFiles");
        FilesCollector collector = new FilesCollector();
        UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(updatedFiles, collector);
        this.refreshDeletedFiles((Collection<? extends Path>)collector.deletedFiles);
        this.refreshFiles((Collection<? extends Path>)collector.files);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> findVirtualFilesWithRefresh(@NotNull List<? extends File> files) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable iterable = files;
        RefreshVFsSynchronously refreshVFsSynchronously = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toPath());
        }
        refreshVFsSynchronously.refreshFiles((List)destination$iv$iv);
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            File it = (File)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFileByIoFile((File)it, (boolean)false) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshFiles(@NotNull Collection<? extends Path> files) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshFiles: " + files, new Throwable());
        }
        Iterable iterable = files;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Path it = (Path)element$iv;
            boolean bl2 = false;
            if (INSTANCE.findValidParent(it) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        Set toRefresh = (Set)destination$iv;
        this.markDirtyAndRefresh(false, toRefresh);
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshVirtualFiles: " + files, new Throwable());
        }
        INSTANCE.markDirtyAndRefresh(false, files);
    }

    @JvmStatic
    public static final void refreshVirtualFilesRecursive(@NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshVirtualFilesRecursive: " + files, new Throwable());
        }
        INSTANCE.markDirtyAndRefresh(true, files);
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshDeletedFiles(Collection<? extends Path> files) {
        void $this$mapNotNullTo$iv;
        if (files.isEmpty()) {
            return;
        }
        if (TRACE_LOG.isDebugEnabled()) {
            TRACE_LOG.debug("RefreshVFsSynchronously#refreshDeletedFiles: " + files, new Throwable());
        }
        Iterable iterable = files;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Path it = (Path)element$iv;
            boolean bl2 = false;
            if (INSTANCE.findValidParent(it.getParent()) == null) continue;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        LinkedHashSet toRefresh = (LinkedHashSet)destination$iv;
        this.markDirtyAndRefresh(true, toRefresh);
    }

    private final void markDirtyAndRefresh(boolean isRecursive, Collection<? extends VirtualFile> files) {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        RefreshVFsSynchronouslyKt.access$runWithProgressText(() -> RefreshVFsSynchronously.markDirtyAndRefresh$lambda$6$lambda$5(isRecursive, files));
        long time = System.currentTimeMillis() - start$iv;
        Logger $this$debug_u24default$iv = TIME_LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl2 = false;
            logger.debug("VFS refresh took " + time + "ms, " + files.size() + " files, isRecursive=" + isRecursive, e$iv);
        }
    }

    private final VirtualFile findValidParent(Path file) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)file, RefreshVFsSynchronously::findValidParent$lambda$8), RefreshVFsSynchronously::findValidParent$lambda$9);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final void updateChangesForRollback(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh((Collection)changes, RefreshVFsSynchronouslyKt.access$getREVERSED_CHANGE_WRAPPER$p());
    }

    @JvmStatic
    public static final void updateChanges(@NotNull Collection<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        INSTANCE.refresh(changes, RefreshVFsSynchronouslyKt.access$getCHANGE_WRAPPER$p());
    }

    public final void refresh(@NotNull Collection<? extends FilePathChange> changes, boolean isRollback) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.refresh(changes, isRollback ? RefreshVFsSynchronouslyKt.access$getREVERSED_FILE_PATH_CHANGE_WRAPPER$p() : RefreshVFsSynchronouslyKt.access$getFILE_PATH_CHANGE_WRAPPER$p());
    }

    public static /* synthetic */ void refresh$default(RefreshVFsSynchronously refreshVFsSynchronously, Collection collection, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        refreshVFsSynchronously.refresh(collection, bl);
    }

    private final <T> void refresh(Collection<? extends T> changes, Wrapper<T> wrapper2) {
        LinkedHashSet<Path> files = new LinkedHashSet<Path>();
        LinkedHashSet<Path> deletedFiles = new LinkedHashSet<Path>();
        Iterable $this$forEach$iv = changes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            FilePath it;
            Object element$iv;
            Object change = element$iv = iterator.next();
            boolean bl = false;
            FilePath beforePath = wrapper2.getBeforePath(change);
            FilePath afterPath = wrapper2.getAfterPath(change);
            if (beforePath != null) {
                boolean bl2 = false;
                (wrapper2.isBeforePathDeleted(change) ? deletedFiles : files).add(it.getIOFile().toPath());
            }
            if (afterPath == null) continue;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it, (Object)beforePath)) continue;
            files.add(it.getIOFile().toPath());
        }
        this.refreshFiles((Collection<? extends Path>)files);
        this.refreshDeletedFiles((Collection<? extends Path>)deletedFiles);
    }

    private static final Unit markDirtyAndRefresh$lambda$6$lambda$5(boolean $isRecursive, Collection $files) {
        Collection $this$toTypedArray$iv = $files;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        VirtualFile[] virtualFileArray = thisCollection$iv.toArray(new VirtualFile[0]);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)$isRecursive, (boolean)false, (VirtualFile[])Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        return Unit.INSTANCE;
    }

    private static final Path findValidParent$lambda$8(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParent();
    }

    private static final VirtualFile findValidParent$lambda$9(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LocalFileSystem.getInstance().findFileByNioFile(it);
    }

    static {
        Logger logger = Logger.getInstance((String)"#trace.RefreshVFsSynchronously");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TRACE_LOG = logger;
        Logger logger2 = Logger.getInstance((String)"#time.RefreshVFsSynchronously");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        TIME_LOG = logger2;
    }
}

