/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.light.nodes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectBackedByJacksonBase;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectRenderingLanguage;
import com.jetbrains.jsonSchema.impl.light.nodes.JsonSchemaObjectStorageKt;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"renderSchemaNode", "", "schemaNode", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "language", "Lcom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaObjectRenderingLanguage;", "serializeJsonNodeSafe", "jsonNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "serializer", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "intellij.json.backend"})
@JvmName(name="JsonSchemaReader2")
@SourceDebugExtension(value={"SMAP\njsonSchemaObjectRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jsonSchemaObjectRendering.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaReader2\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,41:1\n58#2:42\n36#2,2:43\n58#2:45\n36#2,2:46\n*S KotlinDebug\n*F\n+ 1 jsonSchemaObjectRendering.kt\ncom/jetbrains/jsonSchema/impl/light/nodes/JsonSchemaReader2\n*L\n16#1:42\n16#1:43,2\n34#1:45\n34#1:46,2\n*E\n"})
public final class JsonSchemaReader2 {
    @NotNull
    public static final String renderSchemaNode(@NotNull JsonSchemaObject schemaNode, @NotNull JsonSchemaObjectRenderingLanguage language) {
        Intrinsics.checkNotNullParameter((Object)schemaNode, (String)"schemaNode");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        if (!(schemaNode instanceof JsonSchemaObjectBackedByJacksonBase)) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Unsupported JsonSchemaObject implementation provided: " + schemaNode.getClass().getSimpleName());
            return schemaNode.toString();
        }
        JsonNode mappedNode = ((JsonSchemaObjectBackedByJacksonBase)schemaNode).getRawSchemaNode();
        ObjectMapper mapper = switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
            case 1 -> JsonSchemaObjectStorageKt.getJson5ObjectMapper();
            case 2 -> JsonSchemaObjectStorageKt.getYamlObjectMapper();
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)mapper);
        return JsonSchemaReader2.serializeJsonNodeSafe(mappedNode, mapper);
    }

    private static final String serializeJsonNodeSafe(JsonNode jsonNode, ObjectMapper serializer) {
        Object object;
        try {
            String string = serializer.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            object = new char[]{' ', '\n'};
            object = StringsKt.trim((String)string, (char[])object);
        }
        catch (Exception exception) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Error during JsonSchemaObjectSerialization", (Throwable)exception);
            object = "";
        }
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonSchemaObjectRenderingLanguage.values().length];
            try {
                nArray[JsonSchemaObjectRenderingLanguage.JSON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonSchemaObjectRenderingLanguage.YAML.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

