/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.fasterxml.jackson.core.type.TypeReference;
import com.intellij.ide.actions.QualifiedNameProviderUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.impl.scopes.LibraryScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.packageChecker.java.JavaPackageUtilKt;
import com.intellij.packageChecker.model.CommonPathHolder;
import com.intellij.packageChecker.model.LibraryDependency;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.model.PreProcessedVulnerablePath;
import com.intellij.packageChecker.util.SerializationUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiShortNamesCacheImpl;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\nH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/packageChecker/java/JavaLibraryDependency;", "Lcom/intellij/packageChecker/model/LibraryDependency;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "<init>", "(Lcom/intellij/openapi/roots/libraries/Library;)V", "getLibrary", "()Lcom/intellij/openapi/roots/libraries/Library;", "getVulnerableElementQualifiedNames", "", "", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/packageChecker/model/PreProcessedVulnerablePath;", "createPackage", "Lcom/intellij/packageChecker/model/Package;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.packageChecker.java"})
@SourceDebugExtension(value={"SMAP\nJavaLibraryDependency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaLibraryDependency.kt\ncom/intellij/packageChecker/java/JavaLibraryDependency\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,67:1\n19#2:68\n13472#3,2:69\n*S KotlinDebug\n*F\n+ 1 JavaLibraryDependency.kt\ncom/intellij/packageChecker/java/JavaLibraryDependency\n*L\n23#1:68\n53#1:69,2\n*E\n"})
public final class JavaLibraryDependency
implements LibraryDependency {
    @NotNull
    private final Library library;

    public JavaLibraryDependency(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        this.library = library;
    }

    @NotNull
    public final Library getLibrary() {
        return this.library;
    }

    @Override
    @NotNull
    public Set<String> getVulnerableElementQualifiedNames(@NotNull Project project, @NotNull PreProcessedVulnerablePath path) {
        Set set;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                if (project.isDisposed()) break block13;
                Library $this$asSafely$iv = this.library;
                boolean $i$f$asSafely = false;
                Library library = $this$asSafely$iv;
                if (!(library instanceof LibraryEx)) {
                    library = null;
                }
                LibraryEx libraryEx = (LibraryEx)library;
                boolean bl = libraryEx != null ? libraryEx.isDisposed() : false;
                if (!bl) break block14;
            }
            return SetsKt.emptySet();
        }
        if (path.getPackageManager() != PackageType.maven || StringsKt.isBlank((CharSequence)path.getPathsHolders())) {
            return SetsKt.emptySet();
        }
        List vulnerablePaths2 = (List)SerializationUtils.INSTANCE.getOm().readValue(path.getPathsHolders(), (TypeReference)new TypeReference<List<? extends CommonPathHolder>>(){});
        if (vulnerablePaths2.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set $this$getVulnerableElementQualifiedNames_u24lambda_u244 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        for (CommonPathHolder pathHolder : vulnerablePaths2) {
            PsiClass psiClass;
            block12: {
                PsiClass[] matchedClassNames;
                String className = StringsKt.substringAfterLast$default((String)pathHolder.getParent(), (char)'.', null, (int)2, null);
                Object object = ReadAction.computeCancellable(() -> JavaLibraryDependency.getVulnerableElementQualifiedNames$lambda$4$lambda$0(project, className, this));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeCancellable(...)");
                for (PsiClass psiClass2 : matchedClassNames = (PsiClass[])object) {
                    String qualifiedName;
                    boolean bl2 = false;
                    if ((QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)psiClass2)) == null ? null : (psiClass = !Intrinsics.areEqual((Object)qualifiedName, (Object)pathHolder.getParent()) ? null : psiClass2)) == null) {
                        continue;
                    }
                    break block12;
                }
                psiClass = null;
            }
            if (psiClass == null) continue;
            PsiClass clazz = psiClass;
            for (String vulnerableMethod : pathHolder.getVulnerableMethods()) {
                PsiMethod[] methods;
                Object object = ReadAction.computeCancellable(() -> JavaLibraryDependency.getVulnerableElementQualifiedNames$lambda$4$lambda$2(clazz, vulnerableMethod));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeCancellable(...)");
                PsiMethod[] $this$forEach$iv = methods = (PsiMethod[])object;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String methodName;
                    PsiMethod element$iv;
                    PsiMethod method = element$iv = $this$forEach$iv[i];
                    boolean bl3 = false;
                    if (QualifiedNameProviderUtil.getQualifiedName((PsiElement)((PsiElement)method)) == null) continue;
                    $this$getVulnerableElementQualifiedNames_u24lambda_u244.add(methodName);
                }
            }
        }
        return SetsKt.build((Set)set);
    }

    @Override
    @Nullable
    public Package createPackage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Library library = this.library;
        LibraryEx libraryEx = library instanceof LibraryEx ? (LibraryEx)library : null;
        boolean bl = libraryEx != null ? libraryEx.isDisposed() : false;
        if (bl) {
            return null;
        }
        return JavaPackageUtilKt.createPackage(this.library, project);
    }

    @NotNull
    public final Library component1() {
        return this.library;
    }

    @NotNull
    public final JavaLibraryDependency copy(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return new JavaLibraryDependency(library);
    }

    public static /* synthetic */ JavaLibraryDependency copy$default(JavaLibraryDependency javaLibraryDependency, Library library, int n, Object object) {
        if ((n & 1) != 0) {
            library = javaLibraryDependency.library;
        }
        return javaLibraryDependency.copy(library);
    }

    @NotNull
    public String toString() {
        return "JavaLibraryDependency(library=" + this.library + ")";
    }

    public int hashCode() {
        return this.library.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JavaLibraryDependency)) {
            return false;
        }
        JavaLibraryDependency javaLibraryDependency = (JavaLibraryDependency)other;
        return Intrinsics.areEqual((Object)this.library, (Object)javaLibraryDependency.library);
    }

    private static final PsiClass[] getVulnerableElementQualifiedNames$lambda$4$lambda$0(Project $project, String $className, JavaLibraryDependency this$0) {
        return PsiShortNamesCacheImpl.getInstance((Project)$project).getClassesByName($className, (GlobalSearchScope)new LibraryScope($project, this$0.library));
    }

    private static final PsiMethod[] getVulnerableElementQualifiedNames$lambda$4$lambda$2(PsiClass $clazz, String $vulnerableMethod) {
        return $clazz.findMethodsByName($vulnerableMethod, false);
    }
}

