/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBAutoScroller;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableScrollPane
extends JBScrollPane {
    protected final TableResultView myResultView;
    private boolean myAddSpaceForHorizontalScrollbar;

    public TableScrollPane(final @NotNull TableResultView table2, final @NotNull DataGrid grid, @NotNull JComponent topLeftCornerComponent, @Nullable JBAutoScroller.AutoscrollLocker locker) {
        if (table2 == null) {
            TableScrollPane.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TableScrollPane.$$$reportNull$$$0(1);
        }
        if (topLeftCornerComponent == null) {
            TableScrollPane.$$$reportNull$$$0(2);
        }
        this.myResultView = table2;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportView((Component)((Object)this.myResultView));
        this.setColumnHeaderView(this.myResultView.getTableHeader());
        this.setCorner("UPPER_LEADING_CORNER", topLeftCornerComponent);
        this.setupColumnScroller(locker);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)grid.getProject()).requestFocus((Component)((Object)table2), true));
            }
        });
    }

    protected JViewport createViewport() {
        return new JBViewport(){

            public Color getBackground() {
                return TableScrollPane.this.myResultView != null ? TableScrollPane.this.myResultView.getComponent().getBackground() : super.getBackground();
            }
        };
    }

    public void addSpaceForHorizontalScrollbar(boolean v) {
        this.myAddSpaceForHorizontalScrollbar = v;
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int updatedHeight = size.height + this.myResultView.getRowHeight() * this.myResultView.getAdditionalRowsCount();
        JScrollBar hsb = this.getHorizontalScrollBar();
        if (this.myAddSpaceForHorizontalScrollbar && hsb != null && hsb.isOpaque()) {
            updatedHeight += hsb.getPreferredSize().height;
        }
        return new Dimension(size.width, updatedHeight);
    }

    public Insets getInsets() {
        return JBInsets.emptyInsets();
    }

    public void setFlipControls(boolean flip) {
        this.putClientProperty(JBScrollPane.Flip.class, flip ? JBScrollPane.Flip.HORIZONTAL : null);
    }

    protected void setupColumnScroller(@Nullable JBAutoScroller.AutoscrollLocker locker) {
        JComponent view;
        JBAutoScroller.installOn((JComponent)this.myResultView.getComponent(), (JBAutoScroller.AutoscrollLocker)locker);
        JViewport header = this.getRowHeader();
        JComponent jComponent = view = header == null ? null : (JComponent)header.getView();
        if (view != null) {
            JBAutoScroller.installOn((JComponent)view, (JBAutoScroller.ScrollDeltaProvider)new JBAutoScroller.DefaultScrollDeltaProvider(){

                public int getHorizontalScrollDelta(MouseEvent e) {
                    return 0;
                }
            });
        }
        JBAutoScroller.installOn((JComponent)this.myResultView.getTableHeader(), (JBAutoScroller.ScrollDeltaProvider)new JBAutoScroller.DefaultScrollDeltaProvider(){

            public int getVerticalScrollDelta(MouseEvent e) {
                return 0;
            }

            public int getHorizontalScrollDelta(MouseEvent e) {
                JTableHeader header = TableScrollPane.this.myResultView.getTableHeader();
                TableColumn draggedColumn = header.getDraggedColumn();
                if (draggedColumn != null) {
                    Rectangle visibleRect = header.getVisibleRect();
                    int leftmost = visibleRect.x;
                    int rightmost = visibleRect.x + visibleRect.width - 1;
                    Rectangle draggedRect = this.computeColumnHeaderRectangle(draggedColumn);
                    int left = draggedRect.x + header.getDraggedDistance();
                    int right = left + draggedRect.width - 1;
                    return right > rightmost ? right - rightmost : (left < leftmost ? left - leftmost : 0);
                }
                return super.getHorizontalScrollDelta(e);
            }

            private Rectangle computeColumnHeaderRectangle(TableColumn targetColumn) {
                TableColumn column;
                JTableHeader header = TableScrollPane.this.myResultView.getTableHeader();
                TableColumnModel columnModel = TableScrollPane.this.myResultView.getColumnModel();
                int targetColumnX = 0;
                for (int i = 0; i < TableScrollPane.this.myResultView.getColumnCount() && (column = columnModel.getColumn(i)) != targetColumn; ++i) {
                    targetColumnX += column.getWidth();
                }
                return new Rectangle(targetColumnX, 0, targetColumn.getWidth(), header.getHeight());
            }
        });
    }

    public void setComponentOrientation(ComponentOrientation co) {
        super.setComponentOrientation(co);
        this.flipCorners("UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER");
        this.flipCorners("LOWER_LEFT_CORNER", "LOWER_RIGHT_CORNER");
    }

    private void flipCorners(String corner1, String corner2) {
        Component c1 = this.getCorner(corner1);
        Component c2 = this.getCorner(corner2);
        this.setCorner(corner1, c2);
        this.setCorner(corner2, c1);
    }

    public boolean isFlipped() {
        Object property = this.getClientProperty(JBScrollPane.Flip.class);
        return property == JBScrollPane.Flip.HORIZONTAL || property == JBScrollPane.Flip.BOTH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "topLeftCornerComponent";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/table/TableScrollPane";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

